<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Register extends MY_Addon_QRAttendanceController
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('qrattendance/qrsetting_model');
        $this->load->model('student_model');
        $this->load->model('staff_model');
    }

    public function index()
    {
        if (!$this->rbac->hasPrivilege('face_attendance', 'can_view')) {
            access_denied();
        }

        $this->session->set_userdata('top_menu', 'faceattendance');
        $this->session->set_userdata('sub_menu', 'admin/faceattendance/register/index');

        $this->load->library('media_storage');
        $data = array();
        $setting = $this->qrsetting_model->get();
        $data['setting'] = json_encode($setting);
        $data['version'] = $this->config->item('version');
        $data['page_title'] = 'Face Registration';
        
        // Get all students
        $students = $this->student_model->get();
        $data['students'] = $students;
        
        // Get all staff
        $staff = $this->staff_model->get();
        $data['staff'] = $staff;
        
        // Direct HTML output approach as used in previous implementations
        $html = $this->getFaceRegistrationHTML($data);
        echo $html;
    }
    
    private function getFaceRegistrationHTML($data)
    {
        $html = $this->load->view('layout/header', '', true);
        
        $html .= '
        <script src="' . base_url() . 'backend/faceattendance/face-api.min.js"></script>
        <script src="' . base_url() . 'backend/faceattendance/camera-settings.js"></script>
        <script src="' . base_url() . 'backend/faceattendance/face-register.js"></script>
        <link rel="stylesheet" href="' . base_url() . 'backend/qrattendance/style.css">
        <style>
            .modern-card {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                border-radius: 20px;
                box-shadow: 0 20px 40px rgba(0,0,0,0.1);
                border: none;
                overflow: hidden;
            }
            .card-header-modern {
                background: rgba(255,255,255,0.1);
                backdrop-filter: blur(10px);
                border: none;
                padding: 18px;
            }
            .card-title-modern {
                color: white;
                font-size: 22px;
                font-weight: 600;
                text-align: center;
                margin: 0;
                text-shadow: 0 2px 4px rgba(0,0,0,0.3);
            }
            .card-body-modern {
                background: white;
                padding: 25px;
                border-radius: 0 0 20px 20px;
            }
            .form-group-modern {
                margin-bottom: 18px;
            }
            .form-label-modern {
                font-weight: 600;
                color: #333;
                margin-bottom: 8px;
                font-size: 14px;
                text-transform: uppercase;
                letter-spacing: 0.5px;
            }
            .form-control-modern {
                border: 2px solid #e1e5e9;
                border-radius: 10px;
                padding: 10px 15px;
                font-size: 14px;
                transition: all 0.3s ease;
                background: #f8f9fa;
            }
            .upload-button-hover:hover {
                transform: translateY(-2px);
                box-shadow: 0 8px 25px rgba(0,0,0,0.3);
                border-color: #333;
            }
            .form-control-modern:focus {
                border-color: #667eea;
                box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
                background: white;
                outline: none;
            }
            .radio-group-modern {
                display: flex;
                gap: 15px;
                margin-top: 8px;
            }
            .radio-item-modern {
                flex: 1;
                position: relative;
            }
            .radio-item-modern input[type="radio"] {
                display: none;
            }
            .radio-label-modern {
                display: block;
                padding: 10px 15px;
                background: #f8f9fa;
                border: 2px solid #e1e5e9;
                border-radius: 10px;
                text-align: center;
                cursor: pointer;
                transition: all 0.3s ease;
                font-weight: 500;
                font-size: 13px;
            }
            .radio-item-modern input[type="radio"]:checked + .radio-label-modern {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                color: white;
                border-color: #667eea;
                transform: translateY(-2px);
                box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
            }
            .btn-modern {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                border: none;
                border-radius: 10px;
                padding: 10px 20px;
                color: white;
                font-weight: 600;
                font-size: 14px;
                cursor: pointer;
                transition: all 0.3s ease;
                text-transform: uppercase;
                letter-spacing: 0.3px;
            }
            .btn-modern:hover {
                transform: translateY(-2px);
                box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4);
                color: white;
            }
            .btn-success-modern {
                background: linear-gradient(135deg, #56ab2f 0%, #a8e6cf 100%);
            }
            .btn-success-modern:hover {
                box-shadow: 0 10px 30px rgba(86, 171, 47, 0.4);
                color: white;
            }
            .preview-container-modern {
                border: 3px dashed #e1e5e9;
                border-radius: 20px;
                background: #f8f9fa;
                transition: all 0.3s ease;
                overflow: hidden;
            }
            .preview-container-modern.active {
                border-color: #667eea;
                background: white;
                box-shadow: 0 10px 30px rgba(102, 126, 234, 0.1);
            }
            .status-modern {
                border-radius: 12px;
                padding: 12px;
                margin-top: 15px;
                font-weight: 500;
                text-align: center;
                font-size: 14px;
            }
        </style>
        <div class="content-wrapper">
            <section class="content">
                <div class="row justify-content-center">
                    <div class="col-md-10">
                        <div class="modern-card">
                            <div class="card-header-modern">
                                <h3 class="card-title-modern">
                                    <i class="fa fa-user-plus" style="margin-right: 10px;"></i>
                                    Face Registration
                                </h3>
                                
                            </div>
                            <div class="card-body-modern">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group-modern">
                                            <label class="form-label-modern">Select Type</label>
                                            <select class="form-control-modern" id="user-type">
                                                <option value="student">Student</option>
                                                <option value="staff">Staff</option>
                                            </select>
                                        </div>
                                        
                                        <div id="student-selection">
                                            <div class="form-group-modern">
                                                <label class="form-label-modern">Select Student</label>
                                                <select class="form-control-modern" id="student-id">
                                                    <option value="">Choose a student...</option>';
                                                    
        // Add students to dropdown
        if (isset($data['students']) && !empty($data['students'])) {
            foreach ($data['students'] as $student) {
                $html .= '<option value="' . $student['id'] . '">' . $student['firstname'] . ' ' . $student['lastname'] . ' (' . $student['admission_no'] . ')</option>';
            }
        }
                                                    
        $html .= '                            </select>
                                            </div>
                                        </div>
                                        
                                        <div id="staff-selection" style="display:none;">
                                            <div class="form-group-modern">
                                                <label class="form-label-modern">Select Staff</label>
                                                <select class="form-control-modern" id="staff-id">
                                                    <option value="">Choose a staff member...</option>';
                                                    
        // Add staff to dropdown
        if (isset($data['staff']) && !empty($data['staff'])) {
            foreach ($data['staff'] as $staff) {
                $html .= '<option value="' . $staff['id'] . '">' . $staff['name'] . ' ' . $staff['surname'] . ' (' . $staff['employee_id'] . ')</option>';
            }
        }
                                                    
        $html .= '                            </select>
                                            </div>
                                        </div>
                                        
                                        <div class="form-group-modern">
                                            <label class="form-label-modern">Registration Method</label>
                                            <div class="radio-group-modern">
                                                <div class="radio-item-modern">
                                                    <input type="radio" name="registration_method" value="camera" id="method-camera" checked>
                                                    <label for="method-camera" class="radio-label-modern">
                                                        <i class="fa fa-camera" style="margin-right: 8px;"></i>
                                                        Use Camera
                                                    </label>
                                                </div>
                                                <div class="radio-item-modern">
                                                    <input type="radio" name="registration_method" value="upload" id="method-upload">
                                                    <label for="method-upload" class="radio-label-modern">
                                                        <i class="fa fa-upload" style="margin-right: 8px;"></i>
                                                        Upload Photo
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div id="camera-controls">
                                            <div class="form-group-modern">
                                                <button class="btn-modern" id="start-capture">
                                                    <i class="fa fa-video-camera" style="margin-right: 8px;"></i>
                                                    Start Camera
                                                </button>
                                                <button class="btn-success-modern" id="capture-face" style="display:none; margin-left: 10px;">
                                                    <i class="fa fa-camera" style="margin-right: 8px;"></i>
                                                    Capture Face
                                                </button>
                                                <button class="btn-modern" id="stop-capture" style="display:none; margin-left: 10px; background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);">
                                                    <i class="fa fa-stop" style="margin-right: 8px;"></i>
                                                    Stop Camera
                                                </button>
                                            </div>
                                        </div>
                                        
                                        <div id="upload-controls" style="display: none;">
                                            <div class="form-group-modern">
                                                <label class="form-label-modern">Select Photo</label>
                                                <div style="position: relative; display: inline-block; width: 100%;">
                                                    <input type="file" id="photo-upload" accept="image/*" style="position: absolute; opacity: 0; width: 100%; height: 100%; cursor: pointer; z-index: 2;">
                                                    <div style="border: 3px solid #000; border-radius: 10px; padding: 15px; background: linear-gradient(135deg, #ff6b6b 0%, #4ecdc4 25%, #45b7d1 50%, #96ceb4 75%, #feca57 100%); color: white; font-weight: bold; text-align: center; cursor: pointer; transition: all 0.3s ease; position: relative; z-index: 1;" id="upload-button" class="upload-button-hover">
                                                        <i class="fa fa-cloud-upload" style="font-size: 24px; margin-bottom: 8px; display: block;"></i>
                                                        <span style="font-size: 16px; display: block; margin-bottom: 5px;">Click Here to Upload Photo</span>
                                                        <span style="font-size: 12px; opacity: 0.9;">Choose a clear face image</span>
                                                    </div>
                                                </div>
                                                <small style="color: #333; font-size: 13px; margin-top: 8px; display: block; font-weight: 500; text-align: center;">
                                                    <i class="fa fa-camera" style="color: #667eea; margin-right: 5px;"></i> 
                                                    <span style="color: #ff6b6b;">Upload</span> 
                                                    <span style="color: #4ecdc4;">a</span> 
                                                    <span style="color: #45b7d1;">clear</span> 
                                                    <span style="color: #96ceb4;">photo</span> 
                                                    <span style="color: #feca57;">of</span> 
                                                    <span style="color: #667eea;">the</span> 
                                                    <span style="color: #e17055;">face</span> 
                                                    <span style="color: #6c5ce7;">(JPG, PNG, GIF)</span>
                                                </small>
                                            </div>
                                            <div class="form-group-modern">
                                                <button type="button" id="process-photo-btn" class="btn-success-modern" onclick="processPhoto()" style="display: none;">
                                                    <i class="fa fa-cog" style="margin-right: 8px;"></i> Process Photo
                                                </button>
                                                <div id="photo-loading" style="display: none; color: #667eea; font-weight: 500;">
                                                    <i class="fa fa-spinner fa-spin" style="margin-right: 8px;"></i> Processing photo...
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="status-modern alert alert-info" id="status-message">
                                            <i class="fa fa-info-circle" style="margin-right: 8px; color: #17a2b8;"></i>
                                            Select a user and click "Start Camera" to begin face registration.
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div id="face-capture-container" class="preview-container-modern" style="position: relative; width: 100%; height: 320px; display: none;">
                                            <video id="face-video" width="100%" height="320" style="position: absolute; top: 0; left: 0; z-index: 1; border-radius: 20px;" autoplay playsinline muted></video>
                                            <div style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; z-index: 2; text-align: center; padding-top: 140px; display: none; background: rgba(255,255,255,0.9); border-radius: 20px;" id="camera-loading">
                                                <i class="fa fa-spinner fa-pulse fa-3x fa-fw" style="color: #667eea;"></i>
                                                <p style="color: #333; font-weight: 500; margin-top: 15px;">Initializing camera...</p>
                                            </div>
                                        </div>
                                        
                                        <div id="photo-preview-container" class="preview-container-modern" style="position: relative; width: 100%; height: 320px; display: none;">
                                            <img id="photo-preview" style="width: 100%; height: 100%; object-fit: contain; border-radius: 20px;" />
                                            <div style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; z-index: 2; text-align: center; padding-top: 140px; display: none; background: rgba(255,255,255,0.9); border-radius: 20px;" id="photo-loading">
                                                <i class="fa fa-spinner fa-pulse fa-3x fa-fw" style="color: #667eea;"></i>
                                                <p style="color: #333; font-weight: 500; margin-top: 15px;">Processing photo...</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
        
        <script>
            $(document).ready(function() {
                // Toggle between student and staff selection
                $("#user-type").change(function() {
                    if ($(this).val() === "student") {
                        $("#student-selection").show();
                        $("#staff-selection").hide();
                    } else {
                        $("#student-selection").hide();
                        $("#staff-selection").show();
                    }
                });
                
                // Direct radio button handler with CSS manipulation
                $("input[name=\'registration_method\']").on("change click", function() {
                    var method = $(this).val();
                    console.log("Method changed to:", method);
                    
                    if (method === "camera") {
                        $("#camera-controls").css("display", "block");
                        $("#upload-controls").css("display", "none");
                        $("#face-capture-container").css("display", "block");
                        $("#photo-preview-container").css("display", "none");
                        $("#status-message").text("Select a user and click Start Camera to begin face registration.");
                    } else if (method === "upload") {
                        $("#camera-controls").css("display", "none");
                        $("#upload-controls").css("display", "block");
                        $("#face-capture-container").css("display", "none");
                        $("#photo-preview-container").css("display", "block");
                        $("#status-message").text("Select a user and upload a clear photo of their face.");
                    }
                });
                
                // Multiple initialization attempts
                function initializeUploadControls() {
                    var checkedMethod = $("input[name=\'registration_method\']:checked").val();
                    console.log("Initializing with method:", checkedMethod);
                    
                    if (checkedMethod === "upload") {
                        $("#camera-controls").css("display", "none");
                        $("#upload-controls").css("display", "block");
                        $("#face-capture-container").css("display", "none");
                        $("#photo-preview-container").css("display", "block");
                        $("#status-message").text("Select a user and upload a clear photo of their face.");
                    }
                }
                
                // Try multiple times
                setTimeout(initializeUploadControls, 50);
                setTimeout(initializeUploadControls, 200);
                setTimeout(initializeUploadControls, 500);
                
                // Define processPhoto function directly in PHP
                window.processPhoto = async function() {
                    console.log("processPhoto function called");
                    
                    const fileInput = document.getElementById("photo-upload");
                    if (!fileInput.files || fileInput.files.length === 0) {
                        $("#status-message").text("Please select a photo first.");
                        return;
                    }
                    
                    try {
                        // Get user ID and type
                        const userType = $("#user-type").val();
                        let userId;
                        
                        if (userType === "student") {
                            userId = $("#student-id").val();
                            if (!userId) {
                                $("#status-message").text("Please select a student.");
                                return;
                            }
                        } else {
                            userId = $("#staff-id").val();
                            if (!userId) {
                                $("#status-message").text("Please select a staff member.");
                                return;
                            }
                        }
                        
                        // Show loading
                        $("#photo-loading").show();
                        $("#status-message").text("Processing uploaded photo...");
                        
                        const file = fileInput.files[0];
                        
                        // Create image element
                        const img = new Image();
                        img.onload = async function() {
                            try {
                                // Check if face-api models are loaded
                                if (!window.faceapi || !faceapi.nets.tinyFaceDetector.isLoaded) {
                                    $("#photo-loading").hide();
                                    $("#status-message").text("Face detection models not loaded. Please refresh the page.");
                                    return;
                                }
                                
                                // Detect face and get descriptor from image
                                const detections = await faceapi.detectSingleFace(
                                    img, 
                                    new faceapi.TinyFaceDetectorOptions({
                                        inputSize: 416,
                                        scoreThreshold: 0.5
                                    })
                                ).withFaceLandmarks().withFaceDescriptor();
                                
                                $("#photo-loading").hide();
                                
                                if (!detections) {
                                    $("#status-message").text("No face detected in the uploaded photo. Please upload a clear photo with a visible face.");
                                    return;
                                }
                                
                                // Get face descriptor
                                const descriptor = Array.from(detections.descriptor);
                                
                                // Save face data to database
                                saveFaceDescriptor(userId, userType, descriptor);
                            } catch (error) {
                                $("#photo-loading").hide();
                                console.error("Error processing photo:", error);
                                $("#status-message").text("Error processing photo. Please try again.");
                            }
                        };
                        
                        img.onerror = function() {
                            $("#photo-loading").hide();
                            $("#status-message").text("Error loading image. Please select a valid image file.");
                        };
                        
                        // Load image
                        const reader = new FileReader();
                        reader.onload = function(e) {
                            img.src = e.target.result;
                            // Also show preview
                            $("#photo-preview").attr("src", e.target.result);
                        };
                        reader.readAsDataURL(file);
                        
                    } catch (error) {
                        $("#photo-loading").hide();
                        console.error("Error processing photo:", error);
                        $("#status-message").text("Error processing photo. Please try again.");
                    }
                };
                
                // Define saveFaceDescriptor function
                window.saveFaceDescriptor = function(userId, userType, descriptor) {
                    $.ajax({
                        url: "' . base_url() . 'admin/faceattendance/register/saveFaceData",
                        type: "POST",
                        data: {
                            userId: userId,
                            userType: userType,
                            faceDescriptor: JSON.stringify(descriptor)
                        },
                        dataType: "json",
                        success: function(response) {
                            if (response.status) {
                                // Modern success styling with animation
                                $("#status-message")
                                    .removeClass("alert-info alert-danger")
                                    .addClass("alert-success")
                                    .html("<i class=\"fa fa-check-circle\" style=\"color: #28a745; font-size: 18px;\"></i> <strong>Face registered successfully!</strong>")
                                    .css({
                                        "border": "2px solid #28a745",
                                        "background": "linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%)",
                                        "box-shadow": "0 4px 15px rgba(40, 167, 69, 0.3)",
                                        "animation": "pulse 0.6s ease-in-out"
                                    });
                                
                                // Keep photo visible but hide process button
                                $("#process-photo-btn").hide();
                                
                                // Add CSS animation keyframes if not exists
                                if (!$("style#success-animation").length) {
                                    $("head").append("<style id=\"success-animation\">@keyframes pulse { 0% { transform: scale(1); } 50% { transform: scale(1.05); } 100% { transform: scale(1); } }</style>");
                                }
                                
                                // Show completion message with modern styling
                                setTimeout(function() {
                                    $("#status-message")
                                        .removeClass("alert-success")
                                        .addClass("alert-info")
                                        .html("<i class=\"fa fa-info-circle\" style=\"color: #17a2b8;\"></i> Registration complete. You can upload another photo or switch to camera mode.")
                                        .css({
                                            "border": "2px solid #17a2b8",
                                            "background": "linear-gradient(135deg, #d1ecf1 0%, #bee5eb 100%)",
                                            "box-shadow": "0 2px 10px rgba(23, 162, 184, 0.2)",
                                            "animation": "none"
                                        });
                                }, 3000);
                            } else {
                                // Modern error styling
                                $("#status-message")
                                    .removeClass("alert-info alert-success")
                                    .addClass("alert-danger")
                                    .html("<i class=\"fa fa-exclamation-triangle\" style=\"color: #dc3545;\"></i> <strong>Error:</strong> " + response.msg)
                                    .css({
                                        "border": "2px solid #dc3545",
                                        "background": "linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%)",
                                        "box-shadow": "0 4px 15px rgba(220, 53, 69, 0.3)"
                                    });
                            }
                        },
                        error: function() {
                            // Modern error styling for network/server errors
                            $("#status-message")
                                .removeClass("alert-info alert-success")
                                .addClass("alert-danger")
                                .html("<i class=\"fa fa-exclamation-triangle\" style=\"color: #dc3545;\"></i> <strong>Network Error:</strong> Unable to save face data. Please check your connection and try again.")
                                .css({
                                    "border": "2px solid #dc3545",
                                    "background": "linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%)",
                                    "box-shadow": "0 4px 15px rgba(220, 53, 69, 0.3)"
                                });
                        }
                    });
                };
                
                // Photo upload event handler
                $("#photo-upload").change(function() {
                    var file = this.files[0];
                    if (file) {
                        // Show process button
                        $("#process-photo-btn").show();
                        
                        // Show preview
                        var reader = new FileReader();
                        reader.onload = function(e) {
                            $("#photo-preview").attr("src", e.target.result);
                        };
                        reader.readAsDataURL(file);
                        
                        $("#status-message").text("Photo selected. Click Process Photo to register the face.");
                    } else {
                        $("#process-photo-btn").hide();
                        $("#photo-preview").attr("src", "");
                        $("#status-message").text("Select a user and upload a clear photo of their face.");
                    }
                });
            });
        </script>';
        
        $html .= $this->load->view('layout/footer', '', true);
        
        return $html;
    }
    
    public function saveFaceData()
    {
        $userId = $this->input->post('userId');
        $userType = $this->input->post('userType');
        $faceDescriptor = $this->input->post('faceDescriptor');
        
        // Quick validation
        if (empty($userId) || empty($userType) || empty($faceDescriptor)) {
            echo json_encode(['status' => false, 'msg' => 'Missing required data']);
            return;
        }
        
        // Direct database update without extra checks for speed
        try {
            $table = ($userType === 'student') ? 'students' : 'staff';
            
            // Single query update
            $this->db->where('id', $userId);
            $result = $this->db->update($table, ['face_descriptor' => $faceDescriptor]);
            
            if ($result) {
                echo json_encode(['status' => true, 'msg' => 'Face registered successfully']);
            } else {
                echo json_encode(['status' => false, 'msg' => 'Failed to save face data']);
            }
        } catch (Exception $e) {
            error_log('Exception saving face data: ' . $e->getMessage());
            echo json_encode(['status' => false, 'msg' => 'Error: ' . $e->getMessage()]);
        }
    }
}
