<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Accounts Language Helper
 * Helper functions for loading and managing accounts language
 */

if (!function_exists('load_accounts_language')) {
    /**
     * Load accounts language file
     * @param string $language Language code (default: english)
     */
    function load_accounts_language($language = 'English') {
        $CI =& get_instance();
        $CI->lang->load('app_files/accounts_lang', $language);
    }
}

if (!function_exists('accounts_lang')) {
    /**
     * Get accounts language line
     * @param string $line Language key
     * @param string $default Default value if key not found
     * @return string Language value
     */
    function accounts_lang($line, $default = '') {
        $CI =& get_instance();
        $value = $CI->lang->line($line);
        return $value ? $value : ($default ? $default : $line);
    }
}

if (!function_exists('get_accounts_lang_array')) {
    /**
     * Get multiple accounts language lines as array
     * @param array $keys Array of language keys
     * @return array Array of language values
     */
    function get_accounts_lang_array($keys) {
        $CI =& get_instance();
        $result = array();
        foreach ($keys as $key) {
            $result[$key] = $CI->lang->line($key);
        }
        return $result;
    }
}

if (!function_exists('accounts_form_labels')) {
    /**
     * Get common form labels for accounts
     * @return array Array of form labels
     */
    function accounts_form_labels() {
        return get_accounts_lang_array([
            'account_number',
            'account_name', 
            'account_type',
            'opening_balance',
            'description',
            'add_account',
            'edit_account',
            'save_account',
            'cancel'
        ]);
    }
}

if (!function_exists('accounts_table_headers')) {
    /**
     * Get common table headers for accounts
     * @return array Array of table headers
     */
    function accounts_table_headers() {
        return get_accounts_lang_array([
            'sr_no',
            'account_number',
            'account_name',
            'account_type', 
            'opening_balance',
            'status',
            'actions'
        ]);
    }
}

if (!function_exists('accounts_messages')) {
    /**
     * Get common success/error messages for accounts
     * @return array Array of messages
     */
    function accounts_messages() {
        return get_accounts_lang_array([
            'account_created_successfully',
            'account_updated_successfully',
            'account_deleted_successfully',
            'account_not_found',
            'operation_successful',
            'operation_failed',
            'confirm_delete'
        ]);
    }
}
?>
