<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Whatsappapi {
    private $CI;
    private $api_url = 'https://boost.ai.singinn.in/api/whatsapp/send';
    private $api_status_url = 'https://boost.ai.singinn.in/api/get/whatsapp/';
    private $api_key;
    private $session_name;
    private $whatsapp_number;

    public function __construct($params) {
        $this->CI =& get_instance();
        $this->api_key = isset($params['authkey']) ? $params['authkey'] : '';
        $this->session_name = isset($params['senderid']) ? $params['senderid'] : '';
        $this->whatsapp_number = isset($params['name']) ? $params['name'] : '';
    }

    public function sendSMS($to_numbers, $message, $media = null, $media_url = null, $schedule_at = null) {
        if (!is_array($to_numbers)) {
            $to_numbers = array($to_numbers);
        }

        $contacts = array();
        foreach ($to_numbers as $number) {
            $contact = array(
                'number' => $number,
                'message' => $message,
                'session_name' => $this->session_name
            );

            if ($media && $media_url) {
                $contact['media'] = $media;
                $contact['url'] = $media_url;
            }

            if ($schedule_at) {
                $contact['schedule_at'] = $schedule_at;
            }

            $contacts[] = $contact;
        }

        $postdata = array(
            'contact' => $contacts
        );

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->api_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($postdata),
            CURLOPT_HTTPHEADER => array(
                'Api-key: ' . $this->api_key,
                'Content-Type: application/json',
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);

        if ($err) {
            return array('status' => false, 'msg' => $err);
        }

        $result = json_decode($response, true);
        return array('status' => $result['success'], 'msg' => $result['message'], 'data' => $result['data']);
    }

    public function getStatus($uid) {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->api_status_url . $uid,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'Api-key: ' . $this->api_key,
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);

        if ($err) {
            return array('status' => false, 'msg' => $err);
        }

        $result = json_decode($response, true);
        return array('status' => $result['success'], 'msg' => $result['message'], 'data' => $result['data']);
    }
}
