<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Student_certificate_history_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->current_session = $this->setting_model->getCurrentSession();
    }

    // Check if a certificate has been generated for a student before
    public function checkCertificateGenerated($student_id, $certificate_id)
    {
        $this->db->select('*');
        $this->db->from('student_certificate_history');
        $this->db->where('student_id', $student_id);
        $this->db->where('certificate_id', $certificate_id);
        $query = $this->db->get();
        return $query->num_rows();
    }

    // Add a record when a certificate is generated
    public function addCertificateGeneration($student_id, $certificate_id)
    {
        $data = array(
            'student_id' => $student_id,
            'certificate_id' => $certificate_id,
            'generated_date' => date('Y-m-d H:i:s')
        );
        $this->db->insert('student_certificate_history', $data);
        return $this->db->insert_id();
    }
}
