<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-bank"></i> Account Numbers Management
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url() ?>admin/dashboard"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="<?php echo base_url() ?>admin/accounts"><i class="fa fa-calculator"></i> Accounts</a></li>
            <li class="active">Account Numbers</li>
        </ol>
    </section>

    <section class="content">
        <div class="row">
            <!-- Add New Account Form -->
            <div class="col-md-4">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-plus"></i> Add New Account</h3>
                    </div>
                    
                    <?php echo form_open('admin/accounts/account_numbers', array('class' => 'form-horizontal', 'enctype' => 'multipart/form-data')); ?>
                    
                    <div class="box-body">
                        <?php
                        if ($this->session->flashdata('msg')) {
                            echo $this->session->flashdata('msg');
                        }
                        ?>
                        
                        <div class="form-group">
                            <label for="account_number" class="col-sm-12 control-label">Account Number <small class="req">*</small></label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control" name="account_number" id="account_number" 
                                       placeholder="e.g., 1001" value="<?php echo set_value('account_number'); ?>" required>
                                <span class="text-danger"><?php echo form_error('account_number'); ?></span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="account_name" class="col-sm-12 control-label">Account Name <small class="req">*</small></label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control" name="account_name" id="account_name" 
                                       placeholder="e.g., Cash in Hand" value="<?php echo set_value('account_name'); ?>" required>
                                <span class="text-danger"><?php echo form_error('account_name'); ?></span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="account_type" class="col-sm-12 control-label">Account Type <small class="req">*</small></label>
                            <div class="col-sm-12">
                                <select class="form-control" name="account_type" id="account_type" required>
                                    <option value="">Select Account Type</option>
                                    <?php foreach ($account_types as $key => $type) { ?>
                                        <option value="<?php echo $key; ?>" <?php echo set_select('account_type', $key); ?>>
                                            <?php echo $type; ?>
                                        </option>
                                    <?php } ?>
                                </select>
                                <span class="text-danger"><?php echo form_error('account_type'); ?></span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="opening_balance" class="col-sm-12 control-label">Opening Balance</label>
                            <div class="col-sm-12">
                                <input type="number" step="0.01" class="form-control" name="opening_balance" id="opening_balance" 
                                       placeholder="0.00" value="<?php echo set_value('opening_balance'); ?>">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="description" class="col-sm-12 control-label">Description</label>
                            <div class="col-sm-12">
                                <textarea class="form-control" name="description" id="description" rows="3" 
                                          placeholder="Account description"><?php echo set_value('description'); ?></textarea>
                            </div>
                        </div>
                    </div>
                    
                    <div class="box-footer">
                        <button type="submit" class="btn btn-primary btn-block">
                            <i class="fa fa-save"></i> Add Account
                        </button>
                    </div>
                    
                    <?php echo form_close(); ?>
                </div>
            </div>

            <!-- Accounts List -->
            <div class="col-md-8">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-list"></i> Existing Accounts</h3>
                    </div>
                    
                    <div class="box-body">
                        <?php if (!empty($accounts_list)) { ?>
                            <div class="table-responsive">
                                <table class="table table-striped table-hover" id="accountsTable">
                                    <thead>
                                        <tr>
                                            <th>Account #</th>
                                            <th>Account Name</th>
                                            <th>Type</th>
                                            <th>Opening Balance</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($accounts_list as $account) { ?>
                                            <tr>
                                                <td><strong><?php echo $account['account_number']; ?></strong></td>
                                                <td><?php echo $account['account_name']; ?></td>
                                                <td>
                                                    <span class="label label-<?php 
                                                        echo ($account['account_type'] == 'asset') ? 'success' : 
                                                             (($account['account_type'] == 'liability') ? 'danger' : 
                                                              (($account['account_type'] == 'equity') ? 'info' : 
                                                               (($account['account_type'] == 'revenue') ? 'primary' : 'warning'))); 
                                                    ?>">
                                                        <?php echo ucfirst($account['account_type']); ?>
                                                    </span>
                                                </td>
                                                <td class="text-right">
                                                    <?php echo $currency_symbol . amountFormat($account['opening_balance']); ?>
                                                </td>
                                                <td>
                                                    <div class="btn-group">
                                                        <a href="<?php echo base_url(); ?>admin/accounts/edit_account/<?php echo $account['id']; ?>" 
                                                           class="btn btn-primary btn-xs" title="Edit">
                                                            <i class="fa fa-edit"></i>
                                                        </a>
                                                        <a href="<?php echo base_url(); ?>admin/accounts/delete_account/<?php echo $account['id']; ?>" 
                                                           class="btn btn-danger btn-xs" title="Delete"
                                                           onclick="return confirm('Are you sure you want to delete this account?');">
                                                            <i class="fa fa-trash"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php } else { ?>
                            <div class="alert alert-info">
                                <i class="fa fa-info-circle"></i> No accounts found. Add your first account using the form on the left.
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Account Types Information -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-default collapsed-box">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-info-circle"></i> Account Types Information</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-plus"></i>
                            </button>
                        </div>
                    </div>
                    
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-2">
                                <div class="info-box bg-green">
                                    <span class="info-box-icon"><i class="fa fa-money"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Assets</span>
                                        <span class="info-box-number">Resources owned</span>
                                        <div class="progress">
                                            <div class="progress-bar" style="width: 100%"></div>
                                        </div>
                                        <span class="progress-description">Cash, Bank, Equipment</span>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-2">
                                <div class="info-box bg-red">
                                    <span class="info-box-icon"><i class="fa fa-credit-card"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Liabilities</span>
                                        <span class="info-box-number">Money owed</span>
                                        <div class="progress">
                                            <div class="progress-bar" style="width: 100%"></div>
                                        </div>
                                        <span class="progress-description">Loans, Payables</span>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-2">
                                <div class="info-box bg-blue">
                                    <span class="info-box-icon"><i class="fa fa-balance-scale"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Equity</span>
                                        <span class="info-box-number">Owner's share</span>
                                        <div class="progress">
                                            <div class="progress-bar" style="width: 100%"></div>
                                        </div>
                                        <span class="progress-description">Capital, Retained Earnings</span>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="info-box bg-aqua">
                                    <span class="info-box-icon"><i class="fa fa-arrow-up"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Revenue</span>
                                        <span class="info-box-number">Income earned</span>
                                        <div class="progress">
                                            <div class="progress-bar" style="width: 100%"></div>
                                        </div>
                                        <span class="progress-description">Fees, Sales, Services</span>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="info-box bg-yellow">
                                    <span class="info-box-icon"><i class="fa fa-arrow-down"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Expenses</span>
                                        <span class="info-box-number">Costs incurred</span>
                                        <div class="progress">
                                            <div class="progress-bar" style="width: 100%"></div>
                                        </div>
                                        <span class="progress-description">Salaries, Utilities, Rent</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
$(document).ready(function() {
    // Initialize DataTable
    $('#accountsTable').DataTable({
        "paging": true,
        "lengthChange": false,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "pageLength": 10,
        "order": [[ 0, "asc" ]]
    });

    // Auto-generate account number based on type
    $('#account_type').change(function() {
        var type = $(this).val();
        var prefix = '';
        
        switch(type) {
            case 'asset':
                prefix = '1';
                break;
            case 'liability':
                prefix = '2';
                break;
            case 'equity':
                prefix = '3';
                break;
            case 'revenue':
                prefix = '4';
                break;
            case 'expense':
                prefix = '5';
                break;
        }
        
        if (prefix && $('#account_number').val() === '') {
            // Generate next available number
            var nextNum = prefix + '001';
            $('#account_number').val(nextNum);
        }
    });
});
</script>
