<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-edit"></i> <?php echo $this->lang->line('edit_account'); ?>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url() ?>admin/dashboard"><i class="fa fa-dashboard"></i> <?php echo $this->lang->line('dashboard'); ?></a></li>
            <li><a href="<?php echo base_url() ?>admin/accounts"><i class="fa fa-calculator"></i> <?php echo $this->lang->line('accounts'); ?></a></li>
            <li><a href="<?php echo base_url() ?>admin/accounts/account_numbers"><i class="fa fa-bank"></i> <?php echo $this->lang->line('account_numbers'); ?></a></li>
            <li class="active"><?php echo $this->lang->line('edit_account'); ?></li>
        </ol>
    </section>

    <section class="content">
        <div class="row">
            <div class="col-md-8 col-md-offset-2">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-edit"></i> <?php echo $this->lang->line('edit_account'); ?></h3>
                    </div>
                    
                    <?php echo form_open('admin/accounts/edit_account/' . $account['id'], array('class' => 'form-horizontal', 'enctype' => 'multipart/form-data')); ?>
                    
                    <div class="box-body">
                        <?php
                        if ($this->session->flashdata('msg')) {
                            echo $this->session->flashdata('msg');
                        }
                        ?>
                        
                        <div class="form-group">
                            <label for="account_number" class="col-sm-3 control-label"><?php echo $this->lang->line('account_number'); ?> <small class="req">*</small></label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" name="account_number" id="account_number" 
                                       placeholder="<?php echo $this->lang->line('enter_account_number'); ?>" 
                                       value="<?php echo set_value('account_number', $account['account_number']); ?>" required>
                                <span class="text-danger"><?php echo form_error('account_number'); ?></span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="account_name" class="col-sm-3 control-label"><?php echo $this->lang->line('account_name'); ?> <small class="req">*</small></label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" name="account_name" id="account_name" 
                                       placeholder="<?php echo $this->lang->line('enter_account_name'); ?>" 
                                       value="<?php echo set_value('account_name', $account['account_name']); ?>" required>
                                <span class="text-danger"><?php echo form_error('account_name'); ?></span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="account_type" class="col-sm-3 control-label"><?php echo $this->lang->line('account_type'); ?> <small class="req">*</small></label>
                            <div class="col-sm-9">
                                <select class="form-control" name="account_type" id="account_type" required>
                                    <option value=""><?php echo $this->lang->line('select_account_type'); ?></option>
                                    <?php foreach ($account_types as $key => $type) { ?>
                                        <option value="<?php echo $key; ?>" 
                                                <?php echo set_select('account_type', $key, ($account['account_type'] == $key)); ?>>
                                            <?php echo $type; ?>
                                        </option>
                                    <?php } ?>
                                </select>
                                <span class="text-danger"><?php echo form_error('account_type'); ?></span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="opening_balance" class="col-sm-3 control-label"><?php echo $this->lang->line('opening_balance'); ?></label>
                            <div class="col-sm-9">
                                <input type="number" step="0.01" class="form-control" name="opening_balance" id="opening_balance" 
                                       placeholder="0.00" 
                                       value="<?php echo set_value('opening_balance', $account['opening_balance']); ?>">
                                <span class="text-danger"><?php echo form_error('opening_balance'); ?></span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="description" class="col-sm-3 control-label"><?php echo $this->lang->line('description'); ?></label>
                            <div class="col-sm-9">
                                <textarea class="form-control" name="description" id="description" rows="3" 
                                          placeholder="<?php echo $this->lang->line('account_description'); ?>"><?php echo set_value('description', $account['description']); ?></textarea>
                                <span class="text-danger"><?php echo form_error('description'); ?></span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="is_active" class="col-sm-3 control-label"><?php echo $this->lang->line('status'); ?></label>
                            <div class="col-sm-9">
                                <select class="form-control" name="is_active" id="is_active">
                                    <option value="yes" <?php echo set_select('is_active', 'yes', ($account['is_active'] == 'yes')); ?>>
                                        <?php echo $this->lang->line('active'); ?>
                                    </option>
                                    <option value="no" <?php echo set_select('is_active', 'no', ($account['is_active'] == 'no')); ?>>
                                        <?php echo $this->lang->line('inactive'); ?>
                                    </option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="box-footer">
                        <div class="row">
                            <div class="col-sm-3"></div>
                            <div class="col-sm-9">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-save"></i> <?php echo $this->lang->line('update_account'); ?>
                                </button>
                                <a href="<?php echo base_url(); ?>admin/accounts/account_numbers" class="btn btn-default">
                                    <i class="fa fa-arrow-left"></i> <?php echo $this->lang->line('back_to_accounts'); ?>
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>

        <!-- Account Information -->
        <div class="row">
            <div class="col-md-8 col-md-offset-2">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-info-circle"></i> <?php echo $this->lang->line('account_summary'); ?></h3>
                    </div>
                    
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-striped">
                                    <tr>
                                        <td><strong><?php echo $this->lang->line('account_number'); ?>:</strong></td>
                                        <td><?php echo $account['account_number']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php echo $this->lang->line('account_type'); ?>:</strong></td>
                                        <td>
                                            <span class="label label-<?php 
                                                echo ($account['account_type'] == 'asset') ? 'success' : 
                                                     (($account['account_type'] == 'liability') ? 'danger' : 
                                                      (($account['account_type'] == 'equity') ? 'info' : 
                                                       (($account['account_type'] == 'revenue') ? 'primary' : 'warning'))); 
                                            ?>">
                                                <?php echo ucfirst($account['account_type']); ?>
                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php echo $this->lang->line('current_balance'); ?>:</strong></td>
                                        <td><?php echo $currency_symbol . amountFormat($account['current_balance']); ?></td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-striped">
                                    <tr>
                                        <td><strong><?php echo $this->lang->line('status'); ?>:</strong></td>
                                        <td>
                                            <span class="label label-<?php echo ($account['is_active'] == 'yes') ? 'success' : 'danger'; ?>">
                                                <?php echo ($account['is_active'] == 'yes') ? $this->lang->line('active') : $this->lang->line('inactive'); ?>
                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php echo $this->lang->line('created_date'); ?>:</strong></td>
                                        <td><?php echo date('d M Y', strtotime($account['created_at'])); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php echo $this->lang->line('last_updated'); ?>:</strong></td>
                                        <td><?php echo date('d M Y H:i', strtotime($account['updated_at'])); ?></td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
$(document).ready(function() {
    // Auto-generate account number based on type
    $('#account_type').change(function() {
        var type = $(this).val();
        var currentNumber = $('#account_number').val();
        
        // Only suggest if current number doesn't match the type pattern
        if (type && currentNumber) {
            var prefix = '';
            switch(type) {
                case 'asset':
                    prefix = '1';
                    break;
                case 'liability':
                    prefix = '2';
                    break;
                case 'equity':
                    prefix = '3';
                    break;
                case 'revenue':
                    prefix = '4';
                    break;
                case 'expense':
                    prefix = '5';
                    break;
            }
            
            // Check if current number doesn't start with correct prefix
            if (prefix && !currentNumber.startsWith(prefix)) {
                if (confirm('Account number should start with ' + prefix + ' for ' + type + ' accounts. Update account number?')) {
                    // Keep the last 3 digits and change prefix
                    var lastThree = currentNumber.slice(-3);
                    $('#account_number').val(prefix + lastThree.padStart(3, '0'));
                }
            }
        }
    });

    // Form validation
    $('form').submit(function(e) {
        var accountNumber = $('#account_number').val();
        var accountName = $('#account_name').val();
        var accountType = $('#account_type').val();
        
        if (!accountNumber || !accountName || !accountType) {
            alert('Please fill all required fields');
            e.preventDefault();
            return false;
        }
        
        // Validate account number format
        if (!/^\d{4}$/.test(accountNumber)) {
            alert('Account number must be 4 digits');
            e.preventDefault();
            return false;
        }
        
        return true;
    });
});
</script>
