<script type="text/javascript">
    var base_url = "<?php echo base_url(); ?>";
</script>

<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-calendar-check-o"></i> Attendance Report
        </h1>
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-search"></i> <?php echo $title; ?></h3>
                        <div class="box-tools pull-right">
                            <form action="<?php echo site_url('admin/faceattendance/attendance/getAttendanceReport'); ?>" method="get" class="form-inline">
                                <div class="form-group">
                                    <label for="date" class="mr-2">Date:</label>
                                    <input type="date" id="date" name="date" class="form-control" value="<?php echo $date; ?>">
                                </div>
                                <button type="submit" class="btn btn-primary btn-sm ml-2"><i class="fa fa-search"></i> View Report</button>
                                <button type="button" id="delete-all-btn" class="btn btn-danger btn-sm ml-2"><i class="fa fa-trash"></i> Delete All</button>
                                <a href="<?php echo site_url('admin/faceattendance/attendance'); ?>" class="btn btn-default btn-sm ml-2"><i class="fa fa-arrow-left"></i> Back</a>
                            </form>
                        </div>
                    </div>
                    <div class="box-body">
                        <!-- Student Attendance -->
                        <div class="box box-info">
                            <div class="box-header with-border">
                                <h3 class="box-title"><i class="fa fa-users"></i> Student Attendance</h3>
                            </div>
                            <div class="box-body">
                                <?php if (!empty($student_attendance)): ?>
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped" id="student-attendance-table">
                                            <thead>
                                                <tr>
                                                    <th>Admission No</th>
                                                    <th>Name</th>
                                                    <th>Class</th>
                                                    <th>Section</th>
                                                    <th>In Time</th>
                                                    <th>Out Time</th>
                                                    <th>Method</th>
                                                    <th>Remarks</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($student_attendance as $attendance): ?>
                                                    <?php 
                                                    // Handle name formatting
                                                    $name = $attendance->firstname;
                                                    if (isset($attendance->middlename) && $attendance->middlename) $name .= ' ' . $attendance->middlename;
                                                    if (isset($attendance->lastname) && $attendance->lastname) $name .= ' ' . $attendance->lastname;
                                                    
                                                    // Handle different property names for biometric attendance
                                                    $method = 'Manual';
                                                    if (isset($attendance->biometric_attendence) && $attendance->biometric_attendence) {
                                                        $method = 'Face Recognition';
                                                    } elseif (isset($attendance->biometric_attendance) && $attendance->biometric_attendance) {
                                                        $method = 'Face Recognition';
                                                    }
                                                    
                                                    // Get in-time and out-time
                                                    // Make sure to use created_at for in-time and out_time for out-time
                                                    // Ensure we're not showing out_time in the in_time field
                                                    
                                                    // Debug the raw values
                                                    $raw_in_time = isset($attendance->created_at) ? $attendance->created_at : 'not set';
                                                    $raw_out_time = isset($attendance->out_time) ? $attendance->out_time : 'not set';
                                                    error_log("Student {$attendance->student_id} - Raw in_time: {$raw_in_time}, Raw out_time: {$raw_out_time}");
                                                    
                                                    // Format the times for display
                                                    $in_time = isset($attendance->created_at) && !empty($attendance->created_at) ? date('h:i A', strtotime($attendance->created_at)) : '-';
                                                    $out_time = isset($attendance->out_time) && !empty($attendance->out_time) ? date('h:i A', strtotime($attendance->out_time)) : '-';
                                                    
                                                    // Debug the formatted values
                                                    error_log("Student {$attendance->student_id} - Formatted in_time: {$in_time}, Formatted out_time: {$out_time}");
                                                    ?>
                                                    <tr>
                                                        <td><?php echo $attendance->admission_no; ?></td>
                                                        <td><?php echo $name; ?></td>
                                                        <td><?php echo $attendance->class; ?></td>
                                                        <td><?php echo $attendance->section; ?></td>
                                                        <td><?php echo $in_time; ?></td>
                                                        <td><?php echo $out_time; ?></td>
                                                        <td><?php echo $method; ?></td>
                                                        <td><?php echo isset($attendance->remark) ? $attendance->remark : '-'; ?></td>
                                                        <td>
                                                            <?php 
                                                            // Get student ID directly or from student_session table
                                                            $student_id = '';
                                                            if(isset($attendance->student_id)) {
                                                                // If student_id is directly available
                                                                $student_id = $attendance->student_id;
                                                            } elseif(isset($attendance->student_session_id)) {
                                                                // If we need to get it from student_session table
                                                                $this->db->select('student_id');
                                                                $this->db->from('student_session');
                                                                $this->db->where('id', $attendance->student_session_id);
                                                                $student_session = $this->db->get()->row();
                                                                if($student_session) {
                                                                    $student_id = $student_session->student_id;
                                                                }
                                                            }
                                                            
                                                            // Debug output
                                                            error_log("Student ID for {$name}: {$student_id}");
                                                            
                                                            // Check if SMS already sent
                                                            $sms_sent = false;
                                                            if(!empty($student_id)) {
                                                                $this->db->select('id');
                                                                $this->db->from('face_attendance_sms_log');
                                                                $this->db->where('user_id', $student_id);
                                                                $this->db->where('user_type', 'student');
                                                                $this->db->where('DATE(created_at)', date('Y-m-d', strtotime($date)));
                                                                $sms_log = $this->db->get()->row();
                                                                $sms_sent = !empty($sms_log);
                                                            }
                                                            
                                                            if($sms_sent) {
                                                                echo '<span class="label label-success"><i class="fa fa-check"></i> SMS Sent</span>';
                                                            } else {
                                                            ?>
                                                                <button type="button" class="btn btn-xs btn-primary send-sms-btn" data-id="<?php echo $student_id; ?>" data-type="student" data-name="<?php echo $name; ?>" data-time="<?php echo $time; ?>">
                                                                    <i class="fa fa-envelope"></i> Send SMS
                                                                </button>
                                                                <span class="sms-status-<?php echo $student_id; ?>"></span>
                                                            <?php } ?>
                                                            
                                                            <!-- Delete Button -->
                                                            <button type="button" class="btn btn-xs btn-danger delete-attendance-btn" data-id="<?php echo $attendance->id; ?>" data-type="student" data-name="<?php echo $name; ?>">
                                                                <i class="fa fa-trash"></i> Delete
                                                            </button>
                                                            <span class="delete-status-<?php echo $attendance->id; ?>"></span>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                <?php else: ?>
                                    <div class="alert alert-info">No student attendance records found for this date.</div>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <!-- Staff Attendance -->
                        <div class="box box-success">
                            <div class="box-header with-border">
                                <h3 class="box-title"><i class="fa fa-user-md"></i> Staff Attendance</h3>
                            </div>
                            <div class="box-body">
                                <?php if (!empty($staff_attendance)): ?>
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped" id="staff-attendance-table">
                                            <thead>
                                                <tr>
                                                    <th>Employee ID</th>
                                                    <th>Name</th>
                                                    <th>Designation</th>
                                                    <th>In Time</th>
                                                    <th>Out Time</th>
                                                    <th>Method</th>
                                                    <th>Remarks</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($staff_attendance as $attendance): ?>
                                                    <?php 
                                                    $name = $attendance->name;
                                                    if ($attendance->surname) $name .= ' ' . $attendance->surname;
                                                    
                                                    $method = $attendance->biometric_attendence ? 'Face Recognition' : 'Manual';
                                                    
                                                    // Ensure we're using the correct fields for in-time and out-time
                                                    $in_time = isset($attendance->created_at) ? date('h:i A', strtotime($attendance->created_at)) : '-';
                                                    $out_time = isset($attendance->out_time) && $attendance->out_time ? date('h:i A', strtotime($attendance->out_time)) : '-';
                                                    ?>
                                                    <tr>
                                                        <td><?php echo $attendance->employee_id; ?></td>
                                                        <td><?php echo $name; ?></td>
                                                        <td><?php echo $attendance->designation ?? '-'; ?></td>
                                                        <td><?php echo $in_time; ?></td>
                                                        <td><?php echo $out_time; ?></td>
                                                        <td><?php echo $method; ?></td>
                                                        <td><?php echo $attendance->remark ?? '-'; ?></td>
                                                        <td>
                                                            <?php
                                                            // Check if SMS already sent
                                                            $sms_sent = false;
                                                            if(!empty($attendance->staff_id)) {
                                                                $this->db->select('id');
                                                                $this->db->from('face_attendance_sms_log');
                                                                $this->db->where('user_id', $attendance->staff_id);
                                                                $this->db->where('user_type', 'staff');
                                                                $this->db->where('DATE(created_at)', date('Y-m-d', strtotime($date)));
                                                                $sms_log = $this->db->get()->row();
                                                                $sms_sent = !empty($sms_log);
                                                            }
                                                            
                                                            if($sms_sent) {
                                                                echo '<span class="label label-success"><i class="fa fa-check"></i> SMS Sent</span>';
                                                            } else {
                                                            ?>
                                                                <button type="button" class="btn btn-xs btn-primary send-sms-btn" data-id="<?php echo $attendance->staff_id; ?>" data-type="staff" data-name="<?php echo $name; ?>" data-time="<?php echo date('h:i A', strtotime($attendance->created_at)); ?>">
                                                                    <i class="fa fa-envelope"></i> Send SMS
                                                                </button>
                                                                <span class="sms-status-<?php echo $attendance->staff_id; ?>"></span>
                                                            <?php } ?>
                                                            
                                                            <!-- Delete Button -->
                                                            <button type="button" class="btn btn-xs btn-danger delete-attendance-btn" data-id="<?php echo $attendance->id; ?>" data-type="staff" data-name="<?php echo $name; ?>">
                                                                <i class="fa fa-trash"></i> Delete
                                                            </button>
                                                            <span class="delete-status-<?php echo $attendance->id; ?>"></span>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                <?php else: ?>
                                    <div class="alert alert-info">No staff attendance records found for this date.</div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script type="text/javascript">
    $(document).ready(function () {
        // Initialize DataTables
        
        // Delete attendance functionality
        $(document).on('click', '.delete-attendance-btn', function() {
            var id = $(this).data('id');
            var type = $(this).data('type');
            var name = $(this).data('name');
            
            console.log('Delete button clicked:', {id: id, type: type, name: name});
            
            // Confirm before deleting
            if (confirm('Are you sure you want to delete attendance record for ' + name + '?')) {
                // Show loading indicator
                $('.delete-status-' + id).html('<i class="fa fa-spinner fa-spin"></i> Deleting...');
                
                // Send AJAX request to delete attendance
                $.ajax({
                    url: base_url + 'admin/faceattendance/attendance/deleteAttendance',
                    type: 'POST',
                    data: {
                        id: id,
                        type: type
                    },
                    dataType: 'json',
                    beforeSend: function() {
                        console.log('Sending delete request for ID:', id, 'Type:', type);
                    },
                    success: function(response) {
                        console.log('Delete response:', response);
                        if (response.status) {
                            // Show success message
                            $('.delete-status-' + id).html('<span class="text-success"><i class="fa fa-check"></i> ' + response.msg + '</span>');
                            
                            // Remove row from table after a short delay
                            setTimeout(function() {
                                // Reload the page to refresh the data
                                location.reload();
                            }, 1500);
                        } else {
                            // Show error message
                            $('.delete-status-' + id).html('<span class="text-danger"><i class="fa fa-times"></i> ' + response.msg + '</span>');
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error('Delete AJAX error:', xhr, status, error);
                        console.error('Response text:', xhr.responseText);
                        // Show error message
                        $('.delete-status-' + id).html('<span class="text-danger"><i class="fa fa-times"></i> Error: ' + error + ' (Status: ' + xhr.status + ')</span>');
                    }
                });
            }
        });
        
        // Delete All attendance functionality
        $('#delete-all-btn').on('click', function() {
            var date = $('#date').val() || '<?php echo $date; ?>';
            
            if (confirm('Are you sure you want to delete ALL attendance records for ' + date + '? This action cannot be undone!')) {
                if (confirm('This will delete ALL student and staff attendance records for the selected date. Are you absolutely sure?')) {
                    // Show loading indicator
                    $(this).html('<i class="fa fa-spinner fa-spin"></i> Deleting All...');
                    $(this).prop('disabled', true);
                    
                    // Send AJAX request to delete all attendance
                    $.ajax({
                        url: base_url + 'admin/faceattendance/attendance/deleteAllAttendance',
                        type: 'POST',
                        data: {
                            date: date
                        },
                        dataType: 'json',
                        success: function(response) {
                            if (response.status) {
                                alert('Success: ' + response.msg);
                                // Reload the page to refresh the data
                                location.reload();
                            } else {
                                alert('Error: ' + response.msg);
                                $('#delete-all-btn').html('<i class="fa fa-trash"></i> Delete All');
                                $('#delete-all-btn').prop('disabled', false);
                            }
                        },
                        error: function(xhr, status, error) {
                            alert('Error: ' + error + ' (Status: ' + xhr.status + ')');
                            $('#delete-all-btn').html('<i class="fa fa-trash"></i> Delete All');
                            $('#delete-all-btn').prop('disabled', false);
                        }
                    });
                }
            }
        });
        
        $('#student-attendance-table, #staff-attendance-table').DataTable({
            dom: 'Bfrtip',
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ]
        });
        
        // SMS Modal
        $('body').append(`
            <div class="modal fade" id="smsModal" tabindex="-1" role="dialog" aria-labelledby="smsModalLabel">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title" id="smsModalLabel">Send Attendance SMS</h4>
                        </div>
                        <div class="modal-body">
                            <div id="sms-status"></div>
                            <div class="form-group">
                                <label>User:</label>
                                <p id="sms-user-name" class="form-control-static"></p>
                            </div>
                            <div class="form-group">
                                <label>Attendance Time:</label>
                                <p id="sms-time" class="form-control-static"></p>
                            </div>
                            <div class="form-group">
                                <label>Date:</label>
                                <p id="sms-date" class="form-control-static"><?php echo date('d-m-Y', strtotime($date)); ?></p>
                            </div>
                            <input type="hidden" id="sms-user-id">
                            <input type="hidden" id="sms-user-type">
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="button" class="btn btn-primary" id="send-sms-confirm">Send SMS</button>
                        </div>
                    </div>
                </div>
            </div>
        `);
        
        // Auto-send functionality removed as per user request
        // SMS will now be sent automatically only when attendance is marked
        
        // Handle manual SMS button click
        $('.send-sms-btn').on('click', function() {
            var userId = $(this).data('id');
            var userType = $(this).data('type');
            var userName = $(this).data('name');
            var time = $(this).data('time');
            
            $('#sms-user-id').val(userId);
            $('#sms-user-type').val(userType);
            $('#sms-user-name').text(userName);
            $('#sms-time').text(time);
            $('#sms-status').html('');
            
            $('#smsModal').modal('show');
        });
        
        // Handle send SMS confirmation
        $('#send-sms-confirm').on('click', function() {
            var userId = $('#sms-user-id').val();
            var userType = $('#sms-user-type').val();
            
            if (!userId || !userType) {
                $('#sms-status').html('<div class="alert alert-danger">Missing user information</div>');
                return;
            }
            
            // Show loading
            $('#sms-status').html('<div class="alert alert-info">Sending SMS...</div>');
            $('#send-sms-confirm').prop('disabled', true);
            
            // Call the SMS API
            $.ajax({
                url: '<?php echo site_url("admin/faceattendance/attendance/sendSmsFromReport"); ?>',
                type: 'POST',
                data: {
                    id: userId,
                    type: userType,
                    time: $('#sms-time').text(),
                    date: $('#sms-date').text()
                },
                dataType: 'json',
                success: function(response) {
                    if (response.status) {
                        $('#sms-status').html('<div class="alert alert-success">' + response.msg + '</div>');
                    } else {
                        $('#sms-status').html('<div class="alert alert-danger">' + response.msg + '</div>');
                    }
                    $('#send-sms-confirm').prop('disabled', false);
                },
                error: function(xhr, status, error) {
                    $('#sms-status').html('<div class="alert alert-danger">Error: ' + error + '</div>');
                    $('#send-sms-confirm').prop('disabled', false);
                }
            });
        });
    });
</script>

<script type="text/javascript">
    $(document).ready(function () {
        // Get sections based on class selection
        $('#class_id').on('change', function () {
            var class_id = $(this).val();
            getSections(class_id);
        });

        // Get sections function
        function getSections(class_id) {
            if (class_id != "") {
                $('#section_id').html("");
                var base_url = '<?php echo base_url() ?>';
                var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
                $.ajax({
                    type: "GET",
                    url: base_url + "sections/getByClass",
                    data: {'class_id': class_id},
                    dataType: "json",
                    success: function (data) {
                        $.each(data, function (i, obj) {
                            div_data += "<option value=" + obj.section_id + ">" + obj.section + "</option>";
                        });
                        $('#section_id').append(div_data);
                    }
                });
            }
        }

        // Form submission
        $('#attendance-report-form').on('submit', function (e) {
            e.preventDefault();
            var class_id = $('#class_id').val();
            var section_id = $('#section_id').val();
            var date = $('#date').val();

            if (class_id == "" || section_id == "" || date == "") {
                alert("<?php echo $this->lang->line('please_select_all_fields'); ?>");
                return false;
            }

            $.ajax({
                url: '<?php echo site_url("admin/faceattendance/attendance/getAttendanceReportData"); ?>',
                type: 'POST',
                data: {
                    class_id: class_id,
                    section_id: section_id,
                    date: date
                },
                dataType: 'json',
                beforeSend: function () {
                    $('#attendance-report-container').html('<div class="text-center"><i class="fa fa-spinner fa-spin fa-3x"></i><p>Loading...</p></div>');
                },
                success: function (response) {
                    if (response.status) {
                        var data = response.data;
                        var html = '';

                        if (data.length > 0) {
                            html += '<div class="table-responsive">';
                            html += '<table class="table table-bordered table-striped" id="attendance-report-table">';
                            html += '<thead>';
                            html += '<tr>';
                            html += '<th><?php echo $this->lang->line('admission_no'); ?></th>';
                            html += '<th><?php echo $this->lang->line('student'); ?> <?php echo $this->lang->line('name'); ?></th>';
                            html += '<th><?php echo $this->lang->line('status'); ?></th>';
                            html += '<th><?php echo $this->lang->line('time'); ?></th>';
                            html += '<th><?php echo $this->lang->line('method'); ?></th>';
                            html += '<th><?php echo $this->lang->line('remark'); ?></th>';
                            html += '</tr>';
                            html += '</thead>';
                            html += '<tbody>';

                            var totalPresent = 0;
                            var totalAbsent = 0;

                            for (var i = 0; i < data.length; i++) {
                                var statusClass = data[i].status === 'Present' ? 'success' : 'danger';
                                if (data[i].status === 'Present') totalPresent++;
                                else totalAbsent++;

                                html += '<tr>';
                                html += '<td>' + data[i].admission_no + '</td>';
                                html += '<td>' + data[i].name + '</td>';
                                html += '<td><span class="label label-' + statusClass + '">' + data[i].status + '</span></td>';
                                html += '<td>' + (data[i].time || '-') + '</td>';
                                html += '<td>' + (data[i].method || '-') + '</td>';
                                html += '<td>' + (data[i].remark || '-') + '</td>';
                                html += '</tr>';
                            }

                            html += '</tbody>';
                            html += '</table>';
                            html += '</div>';

                            // Summary
                            html += '<div class="row" style="margin-top: 20px;">';
                            html += '<div class="col-md-6">';
                            html += '<div class="info-box">';
                            html += '<span class="info-box-icon bg-green"><i class="fa fa-check"></i></span>';
                            html += '<div class="info-box-content">';
                            html += '<span class="info-box-text"><?php echo $this->lang->line('present'); ?></span>';
                            html += '<span class="info-box-number">' + totalPresent + '</span>';
                            html += '</div>';
                            html += '</div>';
                            html += '</div>';

                            html += '<div class="col-md-6">';
                            html += '<div class="info-box">';
                            html += '<span class="info-box-icon bg-red"><i class="fa fa-times"></i></span>';
                            html += '<div class="info-box-content">';
                            html += '<span class="info-box-text"><?php echo $this->lang->line('absent'); ?></span>';
                            html += '<span class="info-box-number">' + totalAbsent + '</span>';
                            html += '</div>';
                            html += '</div>';
                            html += '</div>';
                            html += '</div>';

                        } else {
                            html = '<div class="alert alert-info"><?php echo $this->lang->line('no_record_found'); ?></div>';
                        }

                        $('#attendance-report-container').html(html);

                        // Initialize DataTable
                        if (data.length > 0) {
                            $('#attendance-report-table').DataTable({
                                dom: 'Bfrtip',
                                buttons: [
                                    'copy', 'csv', 'excel', 'pdf', 'print'
                                ]
                            });
                        }
                    } else {
                        $('#attendance-report-container').html('<div class="alert alert-danger">' + response.msg + '</div>');
                    }
                },
                error: function (xhr) {
                    $('#attendance-report-container').html('<div class="alert alert-danger">Error: ' + xhr.statusText + '</div>');
                }
            });
        });

        // Export to Excel
        $('#export-btn').on('click', function () {
            var table = $('#attendance-report-table').DataTable();
            table.button('.buttons-excel').trigger();
        });
    });
</script>
