<!-- Load face-api.js library first -->
<script src="<?php echo base_url(); ?>backend/faceattendance/face-api.min.js"></script>
<script src="<?php echo base_url(); ?>backend/faceattendance/thank-you.js"></script>
<script src="<?php echo base_url(); ?>backend/faceattendance/camera-settings.js"></script>
<link rel="stylesheet" href="<?php echo base_url(); ?>backend/faceattendance/face-api.css">

<script type="text/javascript">
    var base_url = "<?php echo base_url(); ?>";
</script>

<!-- Modern UI Styles -->
<style>
.modern-card {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 20px;
    box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
    border: none;
    overflow: hidden;
    transition: all 0.3s ease;
}

.modern-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
}

.modern-header {
    background: linear-gradient(135deg, #ff6b6b, #ee5a24);
    color: white;
    padding: 25px;
    border-radius: 20px 20px 0 0;
    text-align: center;
}

.modern-body {
    background: white;
    padding: 30px;
    border-radius: 0 0 20px 20px;
}

.modern-btn {
    background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
    border: none;
    border-radius: 25px;
    padding: 12px 30px;
    color: white;
    font-weight: 600;
    transition: all 0.3s ease;
    box-shadow: 0 5px 15px rgba(79, 172, 254, 0.4);
}

.modern-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(79, 172, 254, 0.6);
    color: white;
}

.modern-btn-danger {
    background: linear-gradient(135deg, #ff6b6b 0%, #ee5a24 100%);
    box-shadow: 0 5px 15px rgba(255, 107, 107, 0.4);
}

.modern-btn-danger:hover {
    box-shadow: 0 8px 25px rgba(255, 107, 107, 0.6);
    color: white;
}

.floating-fullscreen-btn {
    position: absolute;
    top: 15px;
    right: 15px;
    width: 50px;
    height: 50px;
    background: rgba(116, 125, 232, 0.9);
    border: none;
    border-radius: 25px;
    color: white;
    font-size: 18px;
    cursor: pointer;
    transition: all 0.3s ease;
    z-index: 1000;
    display: flex;
    align-items: center;
    justify-content: center;
    backdrop-filter: blur(10px);
    box-shadow: 0 4px 15px rgba(116, 125, 232, 0.4);
}

.floating-fullscreen-btn:hover {
    background: rgba(116, 125, 232, 1);
    transform: scale(1.1);
    box-shadow: 0 6px 20px rgba(116, 125, 232, 0.6);
}

.floating-fullscreen-btn:active {
    transform: scale(0.95);
}

.camera-placeholder {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    color: white;
    z-index: 1;
}

.camera-placeholder i {
    font-size: 60px;
    margin-bottom: 15px;
    opacity: 0.8;
    animation: pulse 2s infinite;
}

.camera-placeholder p {
    font-size: 18px;
    font-weight: 600;
    margin: 0;
    opacity: 0.9;
}

@keyframes pulse {
    0% { transform: scale(1); opacity: 0.8; }
    50% { transform: scale(1.1); opacity: 1; }
    100% { transform: scale(1); opacity: 0.8; }
}

.modern-input {
    border: 2px solid #e1e8ed;
    border-radius: 15px;
    padding: 12px 20px;
    transition: all 0.3s ease;
    background: #f8f9fa;
}

.modern-input:focus {
    border-color: #4facfe;
    box-shadow: 0 0 0 3px rgba(79, 172, 254, 0.1);
    background: white;
}

.camera-container-modern {
    position: relative;
    width: 100%;
    height: 350px;
    border-radius: 20px;
    overflow: hidden;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
    margin-bottom: 20px;
}

.status-modern {
    border-radius: 15px;
    padding: 15px 20px;
    font-weight: 500;
    border: none;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
}

.time-display-modern {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 8px 15px;
    border-radius: 20px;
    font-weight: 600;
    box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
}

.checkout-window-modern {
    background: linear-gradient(135deg, #ff9500 0%, #ff5722 100%);
    color: white;
    padding: 8px 15px;
    border-radius: 20px;
    font-weight: 600;
    font-size: 12px;
    box-shadow: 0 5px 15px rgba(255, 149, 0, 0.3);
}

.page-header-modern {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 40px 0;
    text-align: center;
    margin-bottom: 30px;
    border-radius: 0 0 30px 30px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
}

.instructions-modern {
    background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    color: white;
    border-radius: 20px;
    padding: 25px;
    box-shadow: 0 10px 30px rgba(240, 147, 251, 0.3);
}

.instructions-modern ol {
    margin: 0;
    padding-left: 20px;
}

.instructions-modern li {
    margin-bottom: 8px;
    font-weight: 500;
}
</style>

<div class="content-wrapper">
   
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box-body" style="background: transparent; border: none; box-shadow: none;">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="modern-card">
                                    <div class="modern-header">
                                        <h3 style="margin: 0; font-size: 1.5em;">
                                            <i class="fa fa-camera" style="margin-right: 10px;"></i>Face Recognition Checkout
                                        </h3>
                                        <div style="margin-top: 15px;">
                                            <a href="<?php echo site_url('admin/faceattendance/attendance'); ?>" class="btn btn-success btn-sm modern-btn" style="padding: 6px 12px; font-size: 12px;">
                                                <i class="fa fa-sign-in"></i> Go to Check-in
                                            </a>
                                        </div>
                                    </div>
                                    <div class="modern-body">
                                        <div class="camera-container-modern">
                                            <div id="camera-placeholder" class="camera-placeholder">
                                                <i class="fa fa-video-camera"></i>
                                                <p>Camera Preview</p>
                                            </div>
                                            <video id="camera" style="width: 100%; height: 100%; object-fit: cover; display: none;" autoplay muted></video>
                                            <canvas id="face-overlay" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; pointer-events: none;"></canvas>
                                            <button id="fullscreen-btn" class="floating-fullscreen-btn" style="display: none;">
                                                <i class="fa fa-expand"></i>
                                            </button>
                                        </div>
                                        
                                        <button id="start-camera-btn" class="btn btn-block modern-btn">
                                            <i class="fa fa-video-camera" style="margin-right: 8px;"></i>Start Camera
                                        </button>
                                        <button id="stop-camera-btn" class="btn btn-block modern-btn-danger" style="display: none; margin-top: 15px;">
                                            <i class="fa fa-stop" style="margin-right: 8px;"></i>Stop Camera
                                        </button>
                                        
                                        <div id="camera-status" class="alert alert-info status-modern" style="margin-top: 20px; text-align: center;">
                                            <i class="fa fa-info-circle" style="margin-right: 8px;"></i>Click "Start Camera" to begin
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="modern-card" style="margin-top: 20px;">
                                    <div class="modern-header">
                                        <h3 style="margin: 0; font-size: 1.5em;">
                                            <i class="fa fa-id-card" style="margin-right: 10px;"></i>Mark Checkout by ID
                                        </h3>
                                    </div>
                                    <div class="modern-body">
                                        <div class="form-group">
                                            <label for="user-type" style="font-weight: 600; color: #333; margin-bottom: 8px;">Select User Type:</label>
                                            <select id="user-type" class="form-control modern-input">
                                                <option value="student">👨‍🎓 Student</option>
                                                <option value="staff">👨‍🏫 Staff</option>
                                            </select>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="user-id" style="font-weight: 600; color: #333; margin-bottom: 8px;">Enter ID:</label>
                                            <input type="text" id="user-id" class="form-control modern-input" placeholder="🆔 Enter student/staff ID">
                                        </div>
                                        
                                        <button id="mark-checkout-btn" class="btn btn-block modern-btn">
                                            <i class="fa fa-sign-out" style="margin-right: 8px;"></i>Mark Checkout
                                        </button>
                                        
                                        <div id="manual-status" class="alert alert-info status-modern" style="margin-top: 20px; text-align: center;">
                                            <i class="fa fa-info-circle" style="margin-right: 8px;"></i>Enter user ID and click "Mark Checkout"
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="modern-card">
                                    <div class="modern-header">
                                        <h3 style="margin: 0; font-size: 1.5em;">
                                            <i class="fa fa-history" style="margin-right: 10px;"></i>Recent Checkouts
                                        </h3>
                                    </div>
                                    <div class="modern-body">
                                        <div id="recent-attendance" style="max-height: 300px; overflow-y: auto;">
                                            <p style="text-align: center; color: #666; font-style: italic;">
                                                <i class="fa fa-clock-o" style="margin-right: 8px;"></i>No recent checkout records to display.
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="instructions-modern" style="margin-top: 20px;">
                                    <h3 style="margin: 0 0 15px 0; font-size: 1.3em;">
                                        <i class="fa fa-info-circle" style="margin-right: 10px;"></i>How to Use
                                    </h3>
                                    <ol>
                                        <li><i class="fa fa-camera" style="margin-right: 5px;"></i>Use face recognition by clicking "Start Camera"</li>
                                        <li><i class="fa fa-user-circle" style="margin-right: 5px;"></i>Position your face in front of the camera</li>
                                        <li><i class="fa fa-check-circle" style="margin-right: 5px;"></i>Wait for face recognition to complete</li>
                                        <li><i class="fa fa-user" style="margin-right: 5px;"></i>Or select user type (Student or Staff)</li>
                                        <li><i class="fa fa-keyboard-o" style="margin-right: 5px;"></i>Enter the user ID in the input field</li>
                                        <li><i class="fa fa-mouse-pointer" style="margin-right: 5px;"></i>Click "Mark Checkout" button</li>
                                    </ol>
                                </div>
                                <div class="alert alert-info" style="margin-top: 15px;">
                                    <i class="fa fa-info-circle"></i> View detailed attendance reports: 
                                    <a href="<?php echo site_url('admin/faceattendance/attendance/getAttendanceReport'); ?>" class="btn btn-primary btn-sm" style="margin-left: 10px;">
                                        <i class="fa fa-bar-chart"></i> View Attendance Reports
                                    </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
// Initialize face detection models
async function initFaceDetection() {
    try {
        const modelPath = '<?php echo base_url(); ?>backend/faceattendance/models';
        console.log('Loading face-api.js models from:', modelPath);
        
        await faceapi.nets.tinyFaceDetector.loadFromUri(modelPath);
        await faceapi.nets.faceLandmark68Net.loadFromUri(modelPath);
        await faceapi.nets.faceRecognitionNet.loadFromUri(modelPath);
        
        console.log('All face-api.js models loaded successfully');
        return true;
    } catch (error) {
        console.error('Error loading face-api.js models:', error);
        $('#camera-status').removeClass('alert-info alert-success alert-warning').addClass('alert-danger')
            .text('Error loading face detection models: ' + error.message);
        return false;
    }
}

// Thank You Message Function
function showThankYouMessage(userName, userType) {
    let notificationContainer = document.getElementById('attendance-notification');
    
    if (!notificationContainer) {
        notificationContainer = document.createElement('div');
        notificationContainer.id = 'attendance-notification';
        notificationContainer.style.cssText = `
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background-color: rgba(0, 0, 0, 0.8);
            color: white;
            padding: 30px;
            border-radius: 10px;
            text-align: center;
            z-index: 9999;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.5);
            display: none;
            font-family: Arial, sans-serif;
            min-width: 300px;
        `;
        document.body.appendChild(notificationContainer);
    }
    
    const greeting = userType === 'student' ? 'Goodbye, Student' : 'Goodbye, Staff Member';
    const message = `
        <h2 style="margin-top: 0; color: #ffc107;">${greeting}</h2>
        <h1 style="font-size: 24px; margin: 15px 0;">${userName}</h1>
        <p style="font-size: 18px; margin-bottom: 20px;">Your checkout has been marked successfully!</p>
        <p style="font-size: 16px;">Thank you for your time.</p>
        <div style="width: 100px; height: 100px; margin: 20px auto; background-color: #4CAF50; border-radius: 50%; display: flex; justify-content: center; align-items: center;">
            <div style="color: white; font-size: 50px;">âœ“</div>
        </div>
    `;
    
    notificationContainer.innerHTML = message;
    notificationContainer.style.display = 'block';
    
    setTimeout(() => {
        notificationContainer.style.display = 'none';
    }, 3000);
}

// Thank You Message Function for Checkout
function showCheckoutThankYouMessage(userName, userType) {
    // Create the notification container if it doesn't exist
    let notificationContainer = document.getElementById('checkout-notification');
    
    if (!notificationContainer) {
        notificationContainer = document.createElement('div');
        notificationContainer.id = 'checkout-notification';
        notificationContainer.style.cssText = `
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background-color: rgba(0, 0, 0, 0.8);
            color: white;
            padding: 30px;
            border-radius: 10px;
            text-align: center;
            z-index: 9999;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.5);
            display: none;
            font-family: Arial, sans-serif;
            min-width: 300px;
        `;
        document.body.appendChild(notificationContainer);
    }
    
    // Set the message based on user type
    const greeting = userType === 'student' ? 'Goodbye, Student' : 'Goodbye, Staff Member';
    const message = `
        <h2 style="margin-top: 0; color: #FF9800;">${greeting}</h2>
        <h1 style="font-size: 24px; margin: 15px 0;">${userName}</h1>
        <p style="font-size: 18px; margin-bottom: 20px;">Your checkout has been marked successfully!</p>
        <p style="font-size: 16px;">Thank you for your time. Have a great day!</p>
        <div style="width: 100px; height: 100px; margin: 20px auto; background-color: #FF9800; border-radius: 50%; display: flex; justify-content: center; align-items: center;">
            <div style="color: white; font-size: 50px;">👋</div>
        </div>
    `;
    
    // Set the message and show the notification
    notificationContainer.innerHTML = message;
    notificationContainer.style.display = 'block';
    
    // Hide the notification after 3 seconds
    setTimeout(() => {
        notificationContainer.style.display = 'none';
    }, 3000);
}

// Function to show checkout time alert popup
function showCheckoutTimeAlert(message) {
    // Create modal HTML if it doesn't exist
    if ($('#checkoutTimeAlertModal').length === 0) {
        const modalHtml = `
            <div class="modal fade" id="checkoutTimeAlertModal" tabindex="-1" role="dialog" aria-labelledby="checkoutTimeAlertModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                    <div class="modal-content" style="border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.3); border: none;">
                        <div class="modal-header" style="background: linear-gradient(135deg, #ff6b35, #f7931e); color: white; border-radius: 15px 15px 0 0; padding: 25px; border: none;">
                            <h3 class="modal-title" id="checkoutTimeAlertModalLabel" style="font-size: 28px; font-weight: bold; margin: 0;">
                                <i class="fa fa-sign-out" style="font-size: 32px; margin-right: 15px; animation: pulse 2s infinite;"></i> 
                                Checkout Time Alert
                            </h3>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="color: white; opacity: 0.8; font-size: 32px;">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body" style="padding: 30px; background: #f8f9fa; border-radius: 0 0 15px 15px;">
                            <div class="alert" style="background: linear-gradient(135deg, #fff3cd, #ffeaa7); border: 2px solid #ffc107; border-radius: 12px; padding: 25px; margin-bottom: 25px;">
                                <div style="text-align: center; margin-bottom: 15px;">
                                    <i class="fa fa-exclamation-triangle" style="font-size: 48px; color: #e17055; animation: bounce 1s infinite;"></i>
                                </div>
                                <div id="checkoutTimeAlertMessage" style="font-size: 20px; font-weight: 600; color: #2d3436; text-align: center; line-height: 1.4;"></div>
                            </div>
                            <div style="text-align: center; margin-bottom: 20px;">
                                <p style="font-size: 16px; color: #636e72; margin: 0;">
                                    Please check the current time and try again during the allowed checkout window.
                                </p>
                            </div>
                            <div class="text-center" style="background: #e8f4fd; padding: 15px; border-radius: 10px; border-left: 4px solid #0984e3; margin-bottom: 0;">
                                <div style="font-size: 18px; color: #2d3436; font-weight: 500;">
                                    <i class="fa fa-clock-o" style="color: #0984e3; margin-right: 8px; animation: tick 1s infinite;"></i> 
                                    Auto-closing in <span id="checkoutCountdown" style="font-size: 22px; font-weight: bold; color: #e17055;">5</span> seconds...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <style>
                @keyframes pulse {
                    0% { transform: scale(1); }
                    50% { transform: scale(1.1); }
                    100% { transform: scale(1); }
                }
                @keyframes bounce {
                    0%, 20%, 50%, 80%, 100% { transform: translateY(0); }
                    40% { transform: translateY(-10px); }
                    60% { transform: translateY(-5px); }
                }
                @keyframes tick {
                    0% { transform: rotate(0deg); }
                    25% { transform: rotate(-10deg); }
                    75% { transform: rotate(10deg); }
                    100% { transform: rotate(0deg); }
                }
                #checkoutTimeAlertModal .modal-dialog {
                    margin: 30px auto;
                }
                #checkoutTimeAlertModal .btn:hover {
                    transform: translateY(-2px);
                    box-shadow: 0 6px 20px rgba(116, 185, 255, 0.6);
                }
            </style>
        `;
        $('body').append(modalHtml);
    }
    
    // Set the message and show the modal
    $('#checkoutTimeAlertMessage').text(message);
    $('#checkoutTimeAlertModal').modal('show');
    
    // Auto-close countdown
    let countdown = 5;
    $('#checkoutCountdown').text(countdown);
    
    const countdownInterval = setInterval(function() {
        countdown--;
        $('#checkoutCountdown').text(countdown);
        
        if (countdown <= 0) {
            clearInterval(countdownInterval);
            $('#checkoutTimeAlertModal').modal('hide');
        }
    }, 1000);
    
    // Clear interval if modal is manually closed
    $('#checkoutTimeAlertModal').on('hidden.bs.modal', function() {
        clearInterval(countdownInterval);
    });
    
    // Play beep sound if available
    if (typeof playBeep === 'function') {
        playBeep();
    }
    
    console.log('Checkout Time Alert:', message);
}



$(document).ready(function() {
    initFaceDetection().then(success => {
        if (success) {
            console.log('Face detection initialized successfully');
        } else {
            console.error('Failed to initialize face detection');
        }
    });
    
    let attendanceRecords = JSON.parse(localStorage.getItem('checkoutRecords')) || [];
    
    displayAttendanceRecords();
    
    $('#mark-checkout-btn').on('click', async function() {
        const userId = $('#user-id').val().trim();
        const userType = $('#user-type').val();
        
        if (!userId) {
            $('#manual-status').removeClass('alert-info alert-success alert-warning').addClass('alert-danger').text('Please enter a valid ID');
            return;
        }
        
        // Check time validation from settings
        const cameraSettings = new CameraSettings();
        await cameraSettings.waitForSettings();
        
        if (!cameraSettings.isWithinCheckoutTime()) {
            const checkoutStart = cameraSettings.settings?.checkout_start_time || '15:00';
            const checkoutEnd = cameraSettings.settings?.checkout_end_time || '18:00';
            const message = `Checkout is not allowed at this time. Please checkout between ${checkoutStart} and ${checkoutEnd}`;
            
            $('#manual-status').removeClass('alert-info alert-success alert-warning').addClass('alert-danger')
                .text(message);
            
            // Show checkout time alert popup
            showCheckoutTimeAlert(message);
            return;
        }
        
        $('#manual-status').removeClass('alert-success alert-warning alert-danger').addClass('alert-info').text('Processing checkout for ' + userType + ' ID: ' + userId);
        
        $.ajax({
            url: base_url + 'admin/faceattendance/attendance/markOutTime',
            type: 'POST',
            data: {
                id: userId,
                type: userType
            },
            dataType: 'json',
            success: function(response) {
                console.log('Checkout API response:', response);
                
                if (response.status) {
                    let userName = response.name || 'User ' + userId;
                    
                    if (response.already_marked) {
                        $('#manual-status').removeClass('alert-info').addClass('alert-warning').text(response.msg);
                    } else {
                        $('#manual-status').removeClass('alert-info').addClass('alert-success').text(response.msg);
                        
                        // Show checkout notification popup for manual checkout
                        showCheckoutThankYouMessage(userName, userType);
                        
                        const today = new Date().toLocaleDateString();
                        const record = {
                            userId: userId,
                            userName: userName,
                            userType: userType,
                            date: today,
                            time: new Date().toLocaleTimeString(),
                            method: 'manual checkout'
                        };
                        
                        attendanceRecords.unshift(record);
                        localStorage.setItem('checkoutRecords', JSON.stringify(attendanceRecords));
                        displayAttendanceRecords();
                    }
                } else {
                    $('#manual-status').removeClass('alert-info').addClass('alert-danger').text(response.msg);
                }
            },
            error: function(xhr, status, error) {
                console.error('Error:', error);
                $('#manual-status').removeClass('alert-info').addClass('alert-danger').text('Error marking checkout. Please try again.');
            }
        });
    });
    
    let stream = null;
    
    $('#start-camera-btn').on('click', function() {
        startCamera();
        $(this).hide();
        $('#stop-camera-btn').show();
    });
    
    $('#stop-camera-btn').on('click', function() {
        stopCamera();
        $(this).hide();
        $('#start-camera-btn').show();
    });
    
    async function startCamera() {
        const video = document.getElementById('camera');
        
        // Hide placeholder and show video
        $('#camera-placeholder').hide();
        $('#camera').show();
        
        $('#camera-status').removeClass('alert-success alert-danger alert-warning').addClass('alert-info').text('Starting camera...');
        
        // Load camera settings
        const cameraSettings = new CameraSettings();
        await cameraSettings.loadSettings();
        const constraints = cameraSettings.getCameraConstraints();
        
        if (navigator.mediaDevices && navigator.mediaDevices.getUserMedia) {
            navigator.mediaDevices.getUserMedia(constraints)
                .then(function(mediaStream) {
                    stream = mediaStream;
                    video.srcObject = mediaStream;
                    video.play();
                    
                    $('#camera-status').removeClass('alert-info alert-danger alert-warning').addClass('alert-success').text('Camera started successfully');
                    
                    // Wait for video to be ready before starting detection
                    video.onloadedmetadata = function() {
                        console.log('Video metadata loaded, starting face detection...');
                        setTimeout(detectFacesForCheckout, 1000);
                    };
                })
                .catch(function(error) {
                    console.error('Error accessing camera:', error);
                    $('#camera-status').removeClass('alert-info alert-success alert-warning').addClass('alert-danger').text('Error accessing camera: ' + error.message);
                });
        } else {
            $('#camera-status').removeClass('alert-info alert-success alert-warning').addClass('alert-danger').text('Your browser does not support camera access');
        }
    }
    
    function stopCamera() {
        if (stream) {
            stream.getTracks().forEach(track => track.stop());
            document.getElementById('camera').srcObject = null;
            
            // Show placeholder and hide video
            $('#camera').hide();
            $('#camera-placeholder').show();
            $('#camera-status').removeClass('alert-success alert-danger alert-warning').addClass('alert-info').text('Camera stopped');
        }
    }
    
    let labeledFaceDescriptors = [];
    let faceMatcher = null;
    
    async function loadFaceData() {
        try {
            $('#camera-status').removeClass('alert-danger alert-warning alert-success').addClass('alert-info').text('Loading registered face data...');
            
            const response = await fetch(base_url + 'admin/faceattendance/attendance/getFaceData');
            const data = await response.json();
            
            if (!data.status || !data.faceData || data.faceData.length === 0) {
                $('#camera-status').removeClass('alert-info alert-success alert-warning').addClass('alert-danger')
                    .text('No registered faces found. Please register faces first.');
                return false;
            }
            
            const faceDescriptors = [];
            
            for (const faceData of data.faceData) {
                try {
                    const descriptorArray = JSON.parse(faceData.faceDescriptor);
                    const descriptor = new Float32Array(descriptorArray);
                    
                    const labeledDescriptor = new faceapi.LabeledFaceDescriptors(
                        faceData.id + '|' + faceData.type + '|' + faceData.name, 
                        [descriptor]
                    );
                    
                    faceDescriptors.push(labeledDescriptor);
                } catch (error) {
                    console.error('Error processing face descriptor:', error);
                }
            }
            
            labeledFaceDescriptors = faceDescriptors;
            faceMatcher = new faceapi.FaceMatcher(labeledFaceDescriptors, 0.4); // 0.4 is more strict threshold for better accuracy
            
            $('#camera-status').removeClass('alert-info alert-danger alert-warning').addClass('alert-success')
                .text('Loaded ' + labeledFaceDescriptors.length + ' registered faces');
                
            return true;
        } catch (error) {
            console.error('Error loading face data:', error);
            $('#camera-status').removeClass('alert-info alert-success alert-warning').addClass('alert-danger')
                .text('Error loading face data: ' + error.message);
            return false;
        }
    }
    
    async function detectFacesForCheckout() {
        if (!stream) return;
        
        // Check time validation from settings
        const cameraSettings = new CameraSettings();
        await cameraSettings.waitForSettings();
        
        if (!cameraSettings.isWithinCheckoutTime()) {
            const checkoutStart = cameraSettings.settings?.checkout_start_time || '15:00';
            const checkoutEnd = cameraSettings.settings?.checkout_end_time || '18:00';
            const message = `Checkout is not allowed at this time. Please checkout between ${checkoutStart} and ${checkoutEnd}`;
            
            $('#camera-status').removeClass('alert-info alert-success alert-warning').addClass('alert-danger')
                .text(message);
            
            // Show checkout time alert popup
            showCheckoutTimeAlert(message);
            setTimeout(detectFacesForCheckout, 5000);
            return;
        }
        
        if (!faceMatcher) {
            const success = await loadFaceData();
            if (!success) {
                setTimeout(detectFacesForCheckout, 5000);
                return;
            }
        }
        
        $('#camera-status').removeClass('alert-danger alert-warning alert-success').addClass('alert-info').text('Scanning for registered faces for checkout...');
        
        try {
            const video = document.getElementById('camera');
            const canvas = document.getElementById('face-overlay');
            const ctx = canvas.getContext('2d');
            
            // Set canvas dimensions to match video
            canvas.width = video.videoWidth;
            canvas.height = video.videoHeight;
            
            // Clear previous drawings
            ctx.clearRect(0, 0, canvas.width, canvas.height);
            
            // Detect all faces in the frame with optimized settings for better accuracy
            const detections = await faceapi.detectAllFaces(video, new faceapi.TinyFaceDetectorOptions({
                inputSize: 512,        // Higher for better quality and accuracy
                scoreThreshold: 0.7    // Higher for more precision to prevent wrong face detection
            }))
                .withFaceLandmarks()
                .withFaceDescriptors();
            
            if (detections.length === 0) {
                $('#camera-status').removeClass('alert-info alert-success alert-warning').addClass('alert-danger')
                    .text('No faces detected. Please position your face in front of the camera.');
                setTimeout(detectFacesForCheckout, 2000);
                return;
            }
            
            // Advanced face detection visualization
            detections.forEach((detection, index) => {
                const box = detection.detection.box;
                const confidence = detection.detection.score;
                
                // Scale coordinates to canvas size
                const scaleX = canvas.width / video.videoWidth;
                const scaleY = canvas.height / video.videoHeight;
                
                const x = box.x * scaleX;
                const y = box.y * scaleY;
                const width = box.width * scaleX;
                const height = box.height * scaleY;
                
                // Animated pulse effect
                const time = Date.now() / 1000;
                const pulseIntensity = Math.sin(time * 3 + index) * 0.3 + 0.7;
                
                // Draw outer glow effect
                ctx.shadowColor = '#00FF00';
                ctx.shadowBlur = 15 * pulseIntensity;
                ctx.strokeStyle = `rgba(0, 255, 0, ${pulseIntensity})`;
                ctx.lineWidth = 4;
                ctx.strokeRect(x - 2, y - 2, width + 4, height + 4);
                
                // Draw main detection box
                ctx.shadowBlur = 0;
                ctx.strokeStyle = '#00FF00';
                ctx.lineWidth = 2;
                ctx.strokeRect(x, y, width, height);
                
                // Draw corner brackets
                const cornerLength = 20;
                ctx.lineWidth = 3;
                // Top-left corner
                ctx.beginPath();
                ctx.moveTo(x, y + cornerLength);
                ctx.lineTo(x, y);
                ctx.lineTo(x + cornerLength, y);
                ctx.stroke();
                
                // Top-right corner
                ctx.beginPath();
                ctx.moveTo(x + width - cornerLength, y);
                ctx.lineTo(x + width, y);
                ctx.lineTo(x + width, y + cornerLength);
                ctx.stroke();
                
                // Bottom-left corner
                ctx.beginPath();
                ctx.moveTo(x, y + height - cornerLength);
                ctx.lineTo(x, y + height);
                ctx.lineTo(x + cornerLength, y + height);
                ctx.stroke();
                
                // Bottom-right corner
                ctx.beginPath();
                ctx.moveTo(x + width - cornerLength, y + height);
                ctx.lineTo(x + width, y + height);
                ctx.lineTo(x + width, y + height - cornerLength);
                ctx.stroke();
                
                // Draw confidence score background
                const confidenceText = `${Math.round(confidence * 100)}%`;
                ctx.font = 'bold 14px Arial';
                const textWidth = ctx.measureText(confidenceText).width;
                
                ctx.fillStyle = 'rgba(0, 255, 0, 0.8)';
                ctx.fillRect(x, y - 25, textWidth + 10, 20);
                
                // Draw confidence score text
                ctx.fillStyle = '#000000';
                ctx.fillText(confidenceText, x + 5, y - 10);
                
                // Draw face detection label
                ctx.fillStyle = '#00FF00';
                ctx.font = 'bold 16px Arial';
                ctx.fillText('👤 FACE DETECTED', x, y + height + 20);
                
                // Draw face landmarks if available
                if (detection.landmarks) {
                    const landmarks = detection.landmarks;
                    ctx.fillStyle = '#00FFFF';
                    
                    // Draw key facial points
                    const keyPoints = [
                        ...landmarks.getLeftEye(),
                        ...landmarks.getRightEye(),
                        ...landmarks.getNose(),
                        ...landmarks.getMouth()
                    ];
                    
                    keyPoints.forEach(point => {
                        const px = point.x * scaleX;
                        const py = point.y * scaleY;
                        
                        ctx.beginPath();
                        ctx.arc(px, py, 2, 0, 2 * Math.PI);
                        ctx.fill();
                    });
                }
            });
            
            let matchFound = false;
            
            for (let i = 0; i < detections.length; i++) {
                const detection = detections[i];
                const match = faceMatcher.findBestMatch(detection.descriptor);
                const box = detection.detection.box;
                
                // Scale coordinates to canvas size
                const scaleX = canvas.width / video.videoWidth;
                const scaleY = canvas.height / video.videoHeight;
                
                const x = box.x * scaleX;
                const y = box.y * scaleY;
                const width = box.width * scaleX;
                const height = box.height * scaleY;
                
                if (match.label !== 'unknown') {
                    matchFound = true;
                    
                    const [userId, userType, userName] = match.label.split('|');
                    const confidence = (1 - match.distance) * 100;
                    
                    // Advanced recognition visualization
                    const time = Date.now() / 1000;
                    const pulseIntensity = Math.sin(time * 4) * 0.2 + 0.8;
                    
                    // Draw outer success glow
                    ctx.shadowColor = '#00FF00';
                    ctx.shadowBlur = 25 * pulseIntensity;
                    ctx.strokeStyle = `rgba(0, 255, 0, ${pulseIntensity})`;
                    ctx.lineWidth = 6;
                    ctx.strokeRect(x - 5, y - 5, width + 10, height + 10);
                    
                    // Draw main recognition box with gradient effect
                    ctx.shadowBlur = 0;
                    const gradient = ctx.createLinearGradient(x, y, x + width, y + height);
                    gradient.addColorStop(0, '#00FF00');
                    gradient.addColorStop(1, '#00CC00');
                    ctx.strokeStyle = gradient;
                    ctx.lineWidth = 4;
                    ctx.strokeRect(x, y, width, height);
                    
                    // Draw advanced corner brackets with animation
                    const cornerLength = 25;
                    const animOffset = Math.sin(time * 5) * 3;
                    ctx.lineWidth = 4;
                    ctx.strokeStyle = '#00FFFF';
                    
                    // Animated corner brackets
                    // Top-left
                    ctx.beginPath();
                    ctx.moveTo(x, y + cornerLength + animOffset);
                    ctx.lineTo(x, y);
                    ctx.lineTo(x + cornerLength + animOffset, y);
                    ctx.stroke();
                    
                    // Top-right
                    ctx.beginPath();
                    ctx.moveTo(x + width - cornerLength - animOffset, y);
                    ctx.lineTo(x + width, y);
                    ctx.lineTo(x + width, y + cornerLength + animOffset);
                    ctx.stroke();
                    
                    // Bottom-left
                    ctx.beginPath();
                    ctx.moveTo(x, y + height - cornerLength - animOffset);
                    ctx.lineTo(x, y + height);
                    ctx.lineTo(x + cornerLength + animOffset, y + height);
                    ctx.stroke();
                    
                    // Bottom-right
                    ctx.beginPath();
                    ctx.moveTo(x + width - cornerLength - animOffset, y + height);
                    ctx.lineTo(x + width, y + height);
                    ctx.lineTo(x + width, y + height - cornerLength - animOffset);
                    ctx.stroke();
                    
                    // Draw user info background with gradient
                    const bgGradient = ctx.createLinearGradient(x, y - 60, x, y - 10);
                    bgGradient.addColorStop(0, 'rgba(0, 255, 0, 0.9)');
                    bgGradient.addColorStop(1, 'rgba(0, 200, 0, 0.7)');
                    ctx.fillStyle = bgGradient;
                    ctx.fillRect(x - 5, y - 60, width + 10, 50);
                    
                    // Draw border for info box
                    ctx.strokeStyle = '#00FF00';
                    ctx.lineWidth = 2;
                    ctx.strokeRect(x - 5, y - 60, width + 10, 50);
                    
                    // Draw success icon
                    ctx.fillStyle = '#FFFFFF';
                    ctx.font = 'bold 20px Arial';
                    ctx.fillText('✓', x + 5, y - 35);
                    
                    // Draw user name with shadow effect
                    ctx.shadowColor = '#000000';
                    ctx.shadowBlur = 2;
                    ctx.fillStyle = '#FFFFFF';
                    ctx.font = 'bold 16px Arial';
                    ctx.fillText(userName, x + 30, y - 35);
                    
                    // Draw user type and ID
                    ctx.shadowBlur = 1;
                    ctx.font = 'bold 12px Arial';
                    ctx.fillText(`${userType.toUpperCase()} ID: ${userId}`, x + 5, y - 18);
                    
                    // Draw confidence score
                    ctx.fillText(`Match: ${Math.round(confidence)}%`, x + 5, y - 5);
                    
                    // Reset shadow
                    ctx.shadowBlur = 0;
                    ctx.shadowColor = 'transparent';
                    
                    // Draw recognition status below
                    ctx.fillStyle = '#00FF00';
                    ctx.font = 'bold 18px Arial';
                    ctx.fillText('🎯 RECOGNIZED & VERIFIED', x, y + height + 25);
                    
                    $('#camera-status').removeClass('alert-info alert-danger alert-warning').addClass('alert-success')
                        .html(`<strong>Registered face detected!</strong><br>ID: ${userId}<br>Name: ${userName}<br>Type: ${userType}`);
                    
                    $.ajax({
                        url: base_url + 'admin/faceattendance/attendance/markOutTime',
                        type: 'POST',
                        data: {
                            id: userId,
                            type: userType
                        },
                        dataType: 'json',
                        success: function(response) {
                            console.log('Checkout response:', response);
                            
                            const today = new Date().toLocaleDateString();
                            const alreadyMarked = attendanceRecords.some(r => 
                                r.userId === userId && 
                                r.date === today
                            );
                            
                            if (response.status) {
                                if (response.already_marked) {
                                    $('#camera-status').removeClass('alert-info alert-danger alert-warning').addClass('alert-success')
                                        .html(`<strong>Checkout already marked!</strong><br>ID: ${userId}<br>Name: ${userName}<br>Type: ${userType}`);
                                } else {
                                    $('#camera-status').removeClass('alert-info alert-danger alert-warning').addClass('alert-success')
                                        .html(`<strong>Checkout marked successfully!</strong><br>ID: ${userId}<br>Name: ${userName}<br>Type: ${userType}`);
                                    
                                    // Show checkout notification popup
                                    showCheckoutThankYouMessage(userName, userType);
                                    
                                    if (!alreadyMarked) {
                                        updateRecentAttendance(userId, userType, 'face recognition');
                                    }
                                }
                            } else {
                                $('#camera-status').removeClass('alert-info alert-success alert-warning').addClass('alert-danger')
                                    .html(`<strong>Error marking checkout!</strong><br>${response.msg}`);
                            }
                        },
                        error: function(xhr, status, error) {
                            console.error('Error marking checkout:', error);
                            $('#camera-status').removeClass('alert-info alert-success alert-warning').addClass('alert-danger')
                                .html(`<strong>Error marking checkout!</strong><br>Please try again.`);
                        }
                    });
                    
                    break;
                }
            }
            
            if (!matchFound) {
                $('#camera-status').removeClass('alert-info alert-success alert-warning').addClass('alert-danger')
                    .text('Face detected, but not recognized. Only registered faces can mark checkout.');
            }
            
            setTimeout(detectFacesForCheckout, 3000);
        } catch (error) {
            console.error('Error in face detection:', error);
            $('#camera-status').removeClass('alert-info alert-success alert-warning').addClass('alert-danger')
                .text('Error in face detection: ' + error.message);
            setTimeout(detectFacesForCheckout, 5000);
        }
    }
    
    function updateRecentAttendance(userId, userType, method = 'ID entry') {
        const now = new Date();
        const timeString = now.toLocaleTimeString();
        const dateString = now.toLocaleDateString();
        
        $.ajax({
            url: '<?php echo site_url("admin/faceattendance/attendance/getUserName"); ?>',
            type: 'POST',
            data: {
                id: userId,
                type: userType
            },
            dataType: 'json',
            success: function(response) {
                let userName = 'Unknown';
                if (response.status && response.name) {
                    userName = response.name;
                }
                
                const record = {
                    userId: userId,
                    userType: userType,
                    userName: userName,
                    date: dateString,
                    time: timeString,
                    method: method
                };
                
                attendanceRecords.unshift(record);
                
                if (attendanceRecords.length > 10) {
                    attendanceRecords = attendanceRecords.slice(0, 10);
                }
                
                localStorage.setItem('checkoutRecords', JSON.stringify(attendanceRecords));
                
                displayAttendanceRecords();
            },
            error: function() {
                const record = {
                    userId: userId,
                    userType: userType,
                    userName: 'Unknown',
                    date: dateString,
                    time: timeString,
                    method: method
                };
                
                attendanceRecords.unshift(record);
                
                if (attendanceRecords.length > 10) {
                    attendanceRecords = attendanceRecords.slice(0, 10);
                }
                
                localStorage.setItem('checkoutRecords', JSON.stringify(attendanceRecords));
                
                displayAttendanceRecords();
            }
        });
    }
    
    function displayAttendanceRecords() {
        if (attendanceRecords.length === 0) {
            $('#recent-attendance').html('<p>No recent checkout records to display.</p>');
            return;
        }
        
        let html = '';
        
        const recordsToShow = attendanceRecords.slice(0, 5);
        
        recordsToShow.forEach(record => {
            const name = record.userName || 'Unknown';
            
            html += `
                <div style="border-bottom: 1px solid #eee; padding-bottom: 10px; margin-bottom: 10px;">
                    <p><strong>${record.userType.charAt(0).toUpperCase() + record.userType.slice(1)}:</strong> ${name}</p>
                    <p><strong>ID:</strong> ${record.userId}</p>
                    <p><strong>Date:</strong> ${record.date}</p>
                    <p><strong>Time:</strong> ${record.time}</p>
                    <p><strong>Method:</strong> ${record.method}</p>
                    <p><strong>Status:</strong> <span style="color: orange;">Checked Out</span></p>
                </div>
            `;
        });
        
        $('#recent-attendance').html(html);
    }
    
    $('#user-id').on('keypress', function(e) {
        if (e.which === 13) {
            $('#mark-checkout-btn').click();
        }
    });

    // Floating fullscreen functionality
    $('#fullscreen-btn').click(function() {
        const cameraContainer = document.querySelector('.camera-container-modern');
        
        if (!document.fullscreenElement) {
            // Enter fullscreen
            if (cameraContainer.requestFullscreen) {
                cameraContainer.requestFullscreen();
            } else if (cameraContainer.webkitRequestFullscreen) {
                cameraContainer.webkitRequestFullscreen();
            } else if (cameraContainer.msRequestFullscreen) {
                cameraContainer.msRequestFullscreen();
            }
            
            // Update button icon
            $(this).find('i').removeClass('fa-expand').addClass('fa-compress');
            
        } else {
            // Exit fullscreen
            if (document.exitFullscreen) {
                document.exitFullscreen();
            } else if (document.webkitExitFullscreen) {
                document.webkitExitFullscreen();
            } else if (document.msExitFullscreen) {
                document.msExitFullscreen();
            }
            
            // Update button icon
            $(this).find('i').removeClass('fa-compress').addClass('fa-expand');
        }
    });

    // Listen for fullscreen change events
    document.addEventListener('fullscreenchange', function() {
        if (!document.fullscreenElement) {
            // Exited fullscreen - reset icon
            $('#fullscreen-btn').find('i').removeClass('fa-compress').addClass('fa-expand');
        }
    });

    // Show floating fullscreen button when camera starts
    $('#start-camera-btn').click(function() {
        setTimeout(function() {
            $('#fullscreen-btn').show();
        }, 1000);
    });

    // Hide floating fullscreen button when camera stops
    $('#stop-camera-btn').click(function() {
        $('#fullscreen-btn').hide();
        
        // Exit fullscreen if active
        if (document.fullscreenElement) {
            if (document.exitFullscreen) {
                document.exitFullscreen();
            } else if (document.webkitExitFullscreen) {
                document.webkitExitFullscreen();
            } else if (document.msExitFullscreen) {
                document.msExitFullscreen();
            }
        }
    });
});
</script>
