<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-bell"></i> Stock Alerts
            <small>Monitor inventory alerts</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="<?php echo base_url(); ?>admin/inventory"><i class="fa fa-cubes"></i> Inventory</a></li>
            <li class="active">Stock Alerts</li>
        </ol>
    </section>

    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-exclamation-triangle"></i> Active Stock Alerts</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-warning btn-sm" onclick="acknowledgeAllAlerts()">
                                <i class="fa fa-check"></i> Acknowledge All
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-hover" id="alertsTable">
                                <thead>
                                    <tr>
                                        <th>Alert Date</th>
                                        <th>Item</th>
                                        <th>Alert Type</th>
                                        <th>Current Stock</th>
                                        <th>Threshold</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($alerts as $alert) { ?>
                                        <tr class="<?php echo $alert->is_acknowledged ? 'success' : ''; ?>">
                                            <td><?php echo date('d-m-Y', strtotime($alert->alert_date)); ?></td>
                                            <td>
                                                <strong><?php echo $alert->item_name; ?></strong>
                                                <br><small class="text-muted"><?php echo $alert->item_code; ?></small>
                                            </td>
                                            <td>
                                                <?php
                                                $class = '';
                                                $icon = '';
                                                switch ($alert->alert_type) {
                                                    case 'LOW_STOCK':
                                                        $class = 'label-warning';
                                                        $icon = 'fa-exclamation-triangle';
                                                        break;
                                                    case 'OUT_OF_STOCK':
                                                        $class = 'label-danger';
                                                        $icon = 'fa-times-circle';
                                                        break;
                                                    case 'OVERSTOCK':
                                                        $class = 'label-info';
                                                        $icon = 'fa-arrow-up';
                                                        break;
                                                    case 'EXPIRY':
                                                        $class = 'label-danger';
                                                        $icon = 'fa-calendar-times-o';
                                                        break;
                                                }
                                                ?>
                                                <span class="label <?php echo $class; ?>">
                                                    <i class="fa <?php echo $icon; ?>"></i> 
                                                    <?php echo str_replace('_', ' ', $alert->alert_type); ?>
                                                </span>
                                            </td>
                                            <td>
                                                <span class="badge <?php echo ($alert->current_stock <= 0) ? 'bg-red' : (($alert->alert_type == 'LOW_STOCK') ? 'bg-yellow' : 'bg-blue'); ?>">
                                                    <?php echo $alert->current_stock; ?>
                                                </span>
                                            </td>
                                            <td><?php echo $alert->threshold_value; ?></td>
                                            <td>
                                                <?php if ($alert->is_acknowledged) { ?>
                                                    <span class="label label-success">
                                                        <i class="fa fa-check"></i> Acknowledged
                                                    </span>
                                                    <br><small class="text-muted">
                                                        <?php echo date('d-m-Y H:i', strtotime($alert->acknowledged_at)); ?>
                                                    </small>
                                                <?php } else { ?>
                                                    <span class="label label-danger">
                                                        <i class="fa fa-exclamation"></i> Active
                                                    </span>
                                                <?php } ?>
                                            </td>
                                            <td>
                                                <div class="btn-group">
                                                    <?php if (!$alert->is_acknowledged && $this->rbac->hasPrivilege('inventory_alerts', 'can_edit')) { ?>
                                                        <button type="button" class="btn btn-success btn-xs" onclick="acknowledgeAlert(<?php echo $alert->id; ?>)" title="Acknowledge">
                                                            <i class="fa fa-check"></i>
                                                        </button>
                                                    <?php } ?>
                                                    <button type="button" class="btn btn-info btn-xs" onclick="viewItemDetails(<?php echo $alert->item_id; ?>)" title="View Item">
                                                        <i class="fa fa-eye"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-primary btn-xs" onclick="addStockMovement(<?php echo $alert->item_id; ?>)" title="Add Stock">
                                                        <i class="fa fa-plus"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Alert Summary Cards -->
        <div class="row">
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3><?php echo count(array_filter($alerts, function($a) { return $a->alert_type == 'OUT_OF_STOCK' && !$a->is_acknowledged; })); ?></h3>
                        <p>Out of Stock</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-times-circle"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3><?php echo count(array_filter($alerts, function($a) { return $a->alert_type == 'LOW_STOCK' && !$a->is_acknowledged; })); ?></h3>
                        <p>Low Stock</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-exclamation-triangle"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-blue">
                    <div class="inner">
                        <h3><?php echo count(array_filter($alerts, function($a) { return $a->alert_type == 'OVERSTOCK' && !$a->is_acknowledged; })); ?></h3>
                        <p>Overstock</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-arrow-up"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3><?php echo count(array_filter($alerts, function($a) { return $a->is_acknowledged; })); ?></h3>
                        <p>Acknowledged</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-check"></i>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Stock Movement Modal -->
<div class="modal fade" id="stockMovementModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title"><i class="fa fa-plus"></i> Add Stock Movement</h4>
            </div>
            <form id="stockMovementForm">
                <input type="hidden" id="movement_item_id" name="item_id">
                <div class="modal-body">
                    <div class="form-group">
                        <label>Item</label>
                        <input type="text" class="form-control" id="movement_item_name" readonly>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="movement_type">Movement Type <span class="text-danger">*</span></label>
                                <select class="form-control" id="movement_type" name="movement_type" required>
                                    <option value="">Select Type</option>
                                    <option value="IN">Stock In</option>
                                    <option value="OUT">Stock Out</option>
                                    <option value="ADJUSTMENT">Adjustment</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="movement_quantity">Quantity <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="movement_quantity" name="quantity" required min="1">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="movement_unit_price">Unit Price</label>
                                <input type="number" class="form-control" id="movement_unit_price" name="unit_price" step="0.01" min="0">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="movement_date">Movement Date</label>
                                <input type="date" class="form-control" id="movement_date" name="movement_date" value="<?php echo date('Y-m-d'); ?>">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="reference_type">Reference Type</label>
                        <select class="form-control" id="reference_type" name="reference_type">
                            <option value="">Select Reference</option>
                            <option value="PURCHASE">Purchase</option>
                            <option value="RESTOCK">Restock</option>
                            <option value="ADJUSTMENT">Stock Adjustment</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="movement_notes">Notes</label>
                        <textarea class="form-control" id="movement_notes" name="notes" rows="3" placeholder="Reason for stock movement..."></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Record Movement</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Initialize DataTable
    $('#alertsTable').DataTable({
        "paging": true,
        "lengthChange": true,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "responsive": true,
        "order": [[0, "desc"]]
    });

    // Stock Movement Form Submit
    $('#stockMovementForm').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
            url: '<?php echo base_url("admin/inventory/add_stock_movement"); ?>',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#stockMovementModal').modal('hide');
                    location.reload();
                } else {
                    alert('Error: ' + response.error);
                }
            },
            error: function() {
                alert('An error occurred while recording the movement.');
            }
        });
    });
});

function acknowledgeAlert(alertId) {
    if (confirm('Are you sure you want to acknowledge this alert?')) {
        $.ajax({
            url: '<?php echo base_url("admin/inventory/acknowledge_alert/"); ?>' + alertId,
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    location.reload();
                } else {
                    alert('Error: ' + response.error);
                }
            },
            error: function() {
                alert('An error occurred while acknowledging the alert.');
            }
        });
    }
}

function acknowledgeAllAlerts() {
    if (confirm('Are you sure you want to acknowledge all active alerts?')) {
        $.ajax({
            url: '<?php echo base_url("admin/inventory/acknowledge_all_alerts"); ?>',
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    location.reload();
                } else {
                    alert('Error: ' + response.error);
                }
            },
            error: function() {
                alert('An error occurred while acknowledging alerts.');
            }
        });
    }
}

function viewItemDetails(itemId) {
    window.open('<?php echo base_url("admin/inventory/view_item/"); ?>' + itemId, '_blank');
}

function addStockMovement(itemId) {
    // Get item details first
    $.ajax({
        url: '<?php echo base_url("admin/inventory/get_item/"); ?>' + itemId,
        type: 'GET',
        dataType: 'json',
        success: function(item) {
            $('#movement_item_id').val(item.id);
            $('#movement_item_name').val(item.name + ' (' + item.item_code + ') - Current Stock: ' + item.current_stock);
            $('#movement_unit_price').val(item.purchase_price);
            
            // Pre-select IN movement for low stock items
            $('#movement_type').val('IN');
            
            $('#stockMovementModal').modal('show');
        },
        error: function() {
            alert('Error loading item details.');
        }
    });
}
</script>

<style>
.small-box {
    border-radius: 2px;
    position: relative;
    display: block;
    margin-bottom: 20px;
    box-shadow: 0 1px 1px rgba(0,0,0,0.1);
}

.small-box > .inner {
    padding: 10px;
}

.small-box > .small-box-footer {
    position: relative;
    text-align: center;
    padding: 3px 0;
    color: #fff;
    color: rgba(255,255,255,0.8);
    display: block;
    z-index: 10;
    background: rgba(0,0,0,0.1);
    text-decoration: none;
}

.small-box > .small-box-footer:hover {
    color: #fff;
    background: rgba(0,0,0,0.15);
}

.small-box h3 {
    font-size: 38px;
    font-weight: bold;
    margin: 0 0 10px 0;
    white-space: nowrap;
    padding: 0;
}

.small-box p {
    font-size: 15px;
}

.small-box p > small {
    display: block;
    color: #f9f9f9;
    font-size: 13px;
    margin-top: 5px;
}

.small-box h3, .small-box p {
    z-index: 5;
}

.small-box .icon {
    transition: all .3s linear;
    position: absolute;
    top: -10px;
    right: 10px;
    z-index: 0;
    font-size: 90px;
    color: rgba(0,0,0,0.15);
}

.small-box:hover {
    text-decoration: none;
    color: #f9f9f9;
}

.small-box:hover .icon {
    font-size: 95px;
}

.bg-red {
    background-color: #dd4b39 !important;
    color: #fff !important;
}

.bg-yellow {
    background-color: #f39c12 !important;
    color: #fff !important;
}

.bg-blue {
    background-color: #3c8dbc !important;
    color: #fff !important;
}

.bg-green {
    background-color: #00a65a !important;
    color: #fff !important;
}
</style>
