<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-cubes"></i> Inventory Items
            <small>Manage inventory items</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="<?php echo base_url(); ?>admin/inventory"><i class="fa fa-cubes"></i> Inventory</a></li>
            <li class="active">Items</li>
        </ol>
    </section>

    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-list"></i> Items List</h3>
                        <div class="box-tools pull-right">
                            <?php if ($this->rbac->hasPrivilege('inventory_items', 'can_add')) { ?>
                                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#addItemModal">
                                    <i class="fa fa-plus"></i> Add New Item
                                </button>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-hover" id="itemsTable">
                                <thead>
                                    <tr>
                                        <th>Item Code</th>
                                        <th>Name</th>
                                        <th>Category</th>
                                        <th>Current Stock</th>
                                        <th>Unit</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($items as $item) { ?>
                                        <tr>
                                            <td><?php echo $item->item_code; ?></td>
                                            <td>
                                                <strong><?php echo $item->name; ?></strong>
                                                <?php if ($item->description) { ?>
                                                    <br><small class="text-muted"><?php echo substr($item->description, 0, 50) . (strlen($item->description) > 50 ? '...' : ''); ?></small>
                                                <?php } ?>
                                            </td>
                                            <td><?php echo $item->category_name ?: 'N/A'; ?></td>
                                            <td>
                                                <span class="badge <?php echo ($item->current_stock <= 0) ? 'bg-red' : (($item->current_stock <= $item->minimum_stock) ? 'bg-yellow' : 'bg-green'); ?>">
                                                    <?php echo $item->current_stock; ?>
                                                </span>
                                            </td>
                                            <td><?php echo $item->unit_of_measure; ?></td>
                                            <td>
                                                <?php if ($item->current_stock <= 0) { ?>
                                                    <span class="label label-danger">Out of Stock</span>
                                                <?php } elseif ($item->current_stock <= $item->minimum_stock) { ?>
                                                    <span class="label label-warning">Low Stock</span>
                                                <?php } else { ?>
                                                    <span class="label label-success">In Stock</span>
                                                <?php } ?>
                                            </td>
                                            <td>
                                                <div class="btn-group">
                                                    
                                                    <?php if ($this->rbac->hasPrivilege('inventory_items', 'can_edit')) { ?>
                                                        <button type="button" class="btn btn-primary btn-xs" onclick="editItem(<?php echo $item->id; ?>)" title="Edit">
                                                            <i class="fa fa-edit"></i>
                                                        </button>
                                                    <?php } ?>
                                                    <button type="button" class="btn btn-warning btn-xs" onclick="addStockMovement(<?php echo $item->id; ?>)" title="Stock Movement">
                                                        <i class="fa fa-exchange"></i>
                                                    </button>
                                                    <?php if ($this->rbac->hasPrivilege('inventory_items', 'can_delete')) { ?>
                                                        <button type="button" class="btn btn-danger btn-xs" onclick="deleteItem(<?php echo $item->id; ?>)" title="Delete">
                                                            <i class="fa fa-trash"></i>
                                                        </button>
                                                    <?php } ?>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Add Item Modal -->
<div class="modal fade" id="addItemModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title"><i class="fa fa-plus"></i> Add New Item</h4>
            </div>
            <form id="addItemForm">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="item_code">Item Code <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="item_code" name="item_code" required>
                                <button type="button" class="btn btn-xs btn-default" onclick="generateItemCode()">
                                    <i class="fa fa-refresh"></i> Generate
                                </button>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="barcode">Barcode</label>
                                <input type="text" class="form-control" id="barcode" name="barcode">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="name">Item Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="name" name="name" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="description">Description</label>
                                <textarea class="form-control" id="description" name="description" rows="3"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="category_id">Category <span class="text-danger">*</span></label>
                                <select class="form-control" id="category_id" name="category_id" required>
                                    <option value="">Select Category</option>
                                    <?php foreach ($categories as $category) { ?>
                                        <option value="<?php echo $category->id; ?>"><?php echo $category->name; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="supplier_id">Supplier</label>
                                <select class="form-control" id="supplier_id" name="supplier_id">
                                    <option value="">Select Supplier</option>
                                    <?php foreach ($suppliers as $supplier) { ?>
                                        <option value="<?php echo $supplier->id; ?>"><?php echo $supplier->name; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="unit_of_measure">Unit of Measure <span class="text-danger">*</span></label>
                                <select class="form-control" id="unit_of_measure" name="unit_of_measure" required>
                                    <option value="">Select Unit</option>
                                    <option value="PCS">Pieces</option>
                                    <option value="KG">Kilogram</option>
                                    <option value="LTR">Liter</option>
                                    <option value="BOX">Box</option>
                                    <option value="SET">Set</option>
                                    <option value="PACK">Pack</option>
                                    <option value="ROLL">Roll</option>
                                    <option value="METER">Meter</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="purchase_price">Purchase Price</label>
                                <input type="number" class="form-control" id="purchase_price" name="purchase_price" step="0.01" min="0">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="selling_price">Selling Price</label>
                                <input type="number" class="form-control" id="selling_price" name="selling_price" step="0.01" min="0">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="current_stock">Initial Stock</label>
                                <input type="number" class="form-control" id="current_stock" name="current_stock" min="0">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="minimum_stock">Minimum Stock</label>
                                <input type="number" class="form-control" id="minimum_stock" name="minimum_stock" min="0">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="maximum_stock">Maximum Stock</label>
                                <input type="number" class="form-control" id="maximum_stock" name="maximum_stock" min="0">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="reorder_level">Reorder Level</label>
                                <input type="number" class="form-control" id="reorder_level" name="reorder_level" min="0">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="location">Location</label>
                                <input type="text" class="form-control" id="location" name="location" placeholder="Storage location">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Save Item</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Item Modal -->
<div class="modal fade" id="editItemModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title"><i class="fa fa-edit"></i> Edit Item</h4>
            </div>
            <form id="editItemForm">
                <input type="hidden" id="edit_item_id" name="item_id">
                <div class="modal-body">
                    <!-- Same form fields as add modal -->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="edit_item_code">Item Code <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="edit_item_code" name="item_code" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="edit_barcode">Barcode</label>
                                <input type="text" class="form-control" id="edit_barcode" name="barcode">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="edit_name">Item Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="edit_name" name="name" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="edit_description">Description</label>
                                <textarea class="form-control" id="edit_description" name="description" rows="3"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="edit_category_id">Category <span class="text-danger">*</span></label>
                                <select class="form-control" id="edit_category_id" name="category_id" required>
                                    <option value="">Select Category</option>
                                    <?php foreach ($categories as $category) { ?>
                                        <option value="<?php echo $category->id; ?>"><?php echo $category->name; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="edit_supplier_id">Supplier</label>
                                <select class="form-control" id="edit_supplier_id" name="supplier_id">
                                    <option value="">Select Supplier</option>
                                    <?php foreach ($suppliers as $supplier) { ?>
                                        <option value="<?php echo $supplier->id; ?>"><?php echo $supplier->name; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="edit_unit_of_measure">Unit of Measure <span class="text-danger">*</span></label>
                                <select class="form-control" id="edit_unit_of_measure" name="unit_of_measure" required>
                                    <option value="">Select Unit</option>
                                    <option value="PCS">Pieces</option>
                                    <option value="KG">Kilogram</option>
                                    <option value="LTR">Liter</option>
                                    <option value="BOX">Box</option>
                                    <option value="SET">Set</option>
                                    <option value="PACK">Pack</option>
                                    <option value="ROLL">Roll</option>
                                    <option value="METER">Meter</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="edit_purchase_price">Purchase Price</label>
                                <input type="number" class="form-control" id="edit_purchase_price" name="purchase_price" step="0.01" min="0">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="edit_selling_price">Selling Price</label>
                                <input type="number" class="form-control" id="edit_selling_price" name="selling_price" step="0.01" min="0">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="edit_minimum_stock">Minimum Stock</label>
                                <input type="number" class="form-control" id="edit_minimum_stock" name="minimum_stock" min="0">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="edit_maximum_stock">Maximum Stock</label>
                                <input type="number" class="form-control" id="edit_maximum_stock" name="maximum_stock" min="0">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="edit_reorder_level">Reorder Level</label>
                                <input type="number" class="form-control" id="edit_reorder_level" name="reorder_level" min="0">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="edit_is_active">Status</label>
                                <select class="form-control" id="edit_is_active" name="is_active">
                                    <option value="1">Active</option>
                                    <option value="0">Inactive</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="edit_location">Location</label>
                                <input type="text" class="form-control" id="edit_location" name="location" placeholder="Storage location">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Update Item</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Stock Movement Modal -->
<div class="modal fade" id="stockMovementModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title"><i class="fa fa-exchange"></i> Stock Movement</h4>
            </div>
            <form id="stockMovementForm">
                <input type="hidden" id="movement_item_id" name="item_id">
                <div class="modal-body">
                    <div class="form-group">
                        <label>Item</label>
                        <input type="text" class="form-control" id="movement_item_name" readonly>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="movement_type">Movement Type <span class="text-danger">*</span></label>
                                <select class="form-control" id="movement_type" name="movement_type" required>
                                    <option value="">Select Type</option>
                                    <option value="IN">Stock In</option>
                                    <option value="OUT">Stock Out</option>
                                    <option value="ADJUSTMENT">Adjustment</option>
                                    <option value="TRANSFER">Transfer</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="movement_quantity">Quantity <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="movement_quantity" name="quantity" required min="1">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="movement_unit_price">Unit Price</label>
                                <input type="number" class="form-control" id="movement_unit_price" name="unit_price" step="0.01" min="0">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="movement_date">Movement Date</label>
                                <input type="date" class="form-control" id="movement_date" name="movement_date" value="<?php echo date('Y-m-d'); ?>">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="reference_type">Reference Type</label>
                        <select class="form-control" id="reference_type" name="reference_type">
                            <option value="">Select Reference</option>
                            <option value="PURCHASE">Purchase</option>
                            <option value="SALE">Sale</option>
                            <option value="RETURN">Return</option>
                            <option value="DAMAGE">Damage</option>
                            <option value="LOST">Lost</option>
                            <option value="MANUAL">Manual Adjustment</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="reference_number">Reference Number</label>
                        <input type="text" class="form-control" id="reference_number" name="reference_number">
                    </div>
                    <div class="form-group">
                        <label for="movement_notes">Notes</label>
                        <textarea class="form-control" id="movement_notes" name="notes" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Record Movement</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Initialize DataTable
    $('#itemsTable').DataTable({
        "paging": true,
        "lengthChange": true,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "responsive": true
    });

    // Add Item Form Submit
    $('#addItemForm').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
            url: '<?php echo base_url("admin/inventory/add_item"); ?>',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#addItemModal').modal('hide');
                    location.reload();
                } else {
                    alert('Error: ' + response.error);
                }
            },
            error: function() {
                alert('An error occurred while adding the item.');
            }
        });
    });

    // Edit Item Form Submit
    $('#editItemForm').on('submit', function(e) {
        e.preventDefault();
        var itemId = $('#edit_item_id').val();
        $.ajax({
            url: '<?php echo base_url("admin/inventory/edit_item/"); ?>' + itemId,
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#editItemModal').modal('hide');
                    location.reload();
                } else {
                    alert('Error: ' + response.error);
                }
            },
            error: function() {
                alert('An error occurred while updating the item.');
            }
        });
    });

    // Stock Movement Form Submit
    $('#stockMovementForm').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
            url: '<?php echo base_url("admin/inventory/add_stock_movement"); ?>',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#stockMovementModal').modal('hide');
                    location.reload();
                } else {
                    alert('Error: ' + response.error);
                }
            },
            error: function() {
                alert('An error occurred while recording the movement.');
            }
        });
    });
});

function generateItemCode() {
    $.ajax({
        url: '<?php echo base_url("admin/inventory/generate_item_code"); ?>',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.item_code) {
                $('#item_code').val(response.item_code);
            }
        }
    });
}

function editItem(id) {
    $.ajax({
        url: '<?php echo base_url("admin/inventory/get_item/"); ?>' + id,
        type: 'GET',
        dataType: 'json',
        success: function(item) {
            $('#edit_item_id').val(item.id);
            $('#edit_item_code').val(item.item_code);
            $('#edit_barcode').val(item.barcode);
            $('#edit_name').val(item.name);
            $('#edit_description').val(item.description);
            $('#edit_category_id').val(item.category_id);
            $('#edit_supplier_id').val(item.supplier_id);
            $('#edit_unit_of_measure').val(item.unit_of_measure);
            $('#edit_purchase_price').val(item.purchase_price);
            $('#edit_selling_price').val(item.selling_price);
            $('#edit_minimum_stock').val(item.minimum_stock);
            $('#edit_maximum_stock').val(item.maximum_stock);
            $('#edit_reorder_level').val(item.reorder_level);
            $('#edit_location').val(item.location);
            $('#edit_is_active').val(item.is_active);
            $('#editItemModal').modal('show');
        }
    });
}

function deleteItem(id) {
    if (confirm('Are you sure you want to delete this item?')) {
        $.ajax({
            url: '<?php echo base_url("admin/inventory/delete_item/"); ?>' + id,
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    location.reload();
                } else {
                    alert('Error: ' + response.error);
                }
            }
        });
    }
}

function addStockMovement(id) {
    $.ajax({
        url: '<?php echo base_url("admin/inventory/get_item/"); ?>' + id,
        type: 'GET',
        dataType: 'json',
        success: function(item) {
            $('#movement_item_id').val(item.id);
            $('#movement_item_name').val(item.name + ' (' + item.item_code + ')');
            $('#movement_unit_price').val(item.purchase_price);
            $('#stockMovementModal').modal('show');
        }
    });
}

function viewItem(id) {
    // Implement view item details functionality
    window.open('<?php echo base_url("admin/inventory/view_item/"); ?>' + id, '_blank');
}
</script>
