<?php $currency_symbol = $this->customlib->getSchoolCurrencyFormat(); ?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>QR Payment - <?php echo $sch_setting->name; ?></title>
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/font-awesome.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/AdminLTE.min.css">
    <style>
        body { 
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); 
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; 
            min-height: 100vh;
            margin: 0;
            padding: 20px;
        }
        .qr-container { 
            max-width: 450px; 
            margin: 0 auto; 
            background: white; 
            border-radius: 15px; 
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
            overflow: hidden;
        }
        .qr-header { 
            background: linear-gradient(45deg, #3c8dbc, #5cb3cc); 
            color: white; 
            padding: 25px; 
            text-align: center; 
        }
        .qr-header h3 { margin: 0; font-weight: 600; }
        .qr-header p { margin: 5px 0 0 0; opacity: 0.9; }
        .qr-body { 
            padding: 30px; 
            text-align: center; 
        }
        .qr-code { 
            margin: 25px 0; 
            padding: 20px;
            background: #f8f9fa;
            border-radius: 10px;
            border: 2px dashed #dee2e6;
        }
        .payment-details {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 10px;
            margin: 20px 0;
            text-align: left;
        }
        .payment-details h4 {
            color: #3c8dbc;
            margin-bottom: 15px;
            font-weight: 600;
        }
        .detail-row {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px solid #e9ecef;
        }
        .detail-row:last-child {
            border-bottom: none;
            font-weight: bold;
            color: #28a745;
            font-size: 1.1em;
        }
        .btn-custom {
            background: linear-gradient(45deg, #28a745, #20c997);
            border: none;
            color: white;
            padding: 12px 30px;
            border-radius: 25px;
            font-weight: 600;
            margin: 10px 5px;
            transition: all 0.3s ease;
        }
        .btn-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(40, 167, 69, 0.4);
            color: white;
        }
        .instructions {
            background: #e3f2fd;
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
            border-left: 4px solid #2196f3;
        }
        .instructions h5 {
            color: #1976d2;
            margin-bottom: 10px;
        }
        .instructions ol {
            margin: 0;
            padding-left: 20px;
        }
        .instructions li {
            margin: 5px 0;
            color: #424242;
        }
    </style>
</head>
<body>
    <div class="qr-container">
        <div class="qr-header">
            <h3><i class="fa fa-qrcode"></i> QR Payment</h3>
            <p><?php echo $sch_setting->name; ?></p>
        </div>
        
        <div class="qr-body">
            <?php if ($sale) { ?>
                <div class="payment-details">
                    <h4><i class="fa fa-info-circle"></i> Payment Details</h4>
                    <div class="detail-row">
                        <span>Sale ID:</span>
                        <strong><?php echo $sale['sale_id']; ?></strong>
                    </div>
                    <div class="detail-row">
                        <span>Student:</span>
                        <strong><?php echo $sale['student_name']; ?></strong>
                    </div>
                    <div class="detail-row">
                        <span>Class:</span>
                        <strong><?php echo $sale['class'] . ' - ' . $sale['section']; ?></strong>
                    </div>
                    <div class="detail-row">
                        <span>Amount to Pay:</span>
                        <strong>₹<?php 
                            // Show Total Amount directly (same as Total Amount field)
                            $total_amount = isset($sale['total_amount']) ? floatval($sale['total_amount']) : 0;
                            $paid_amount = isset($sale['paid_amount']) ? floatval($sale['paid_amount']) : 0;
                            
                            // Display Total Amount (not balance calculation)
                            echo number_format($total_amount, 2);
                            
                            // Debug output for troubleshooting
                            echo "<!-- TOTAL AMOUNT DEBUG: ";
                            echo "total_amount=" . $total_amount . " ";
                            echo "paid_amount=" . $paid_amount . " ";
                            echo "showing_total_amount=" . $total_amount . " ";
                            echo "sale_id=" . (isset($sale['id']) ? $sale['id'] : 'NULL') . " ";
                            echo "-->";
                        ?></strong>
                    </div>
                    <div class="detail-row">
                        <span>UPI ID:</span>
                        <strong><?php 
                            $upi_id = isset($sch_setting->upi_id) && !empty($sch_setting->upi_id) 
                                     ? $sch_setting->upi_id 
                                     : 'school@paytm';
                            echo $upi_id; 
                        ?></strong>
                    </div>
                </div>

                <div class="qr-code">
                    <h4 style="color: #3c8dbc; margin-bottom: 20px;">
                        <i class="fa fa-mobile"></i> Scan QR Code
                    </h4>
                    
                    <!-- QR Code using Google Charts API -->
                    <img src="https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=<?php echo urlencode($qr_string); ?>" 
                         alt="QR Code" 
                         style="max-width: 200px; height: auto; border: 2px solid #ddd; border-radius: 8px;">
                    
                    <p style="margin-top: 15px; color: #666; font-size: 14px;">
                        Scan this QR code with any UPI app
                    </p>
                </div>

                <div class="instructions">
                    <h5><i class="fa fa-lightbulb-o"></i> How to Pay</h5>
                    <ol>
                        <li>Open any UPI app (PhonePe, Google Pay, Paytm, etc.)</li>
                        <li>Tap on "Scan QR" or "Pay" option</li>
                        <li>Scan the QR code above</li>
                        <li>Verify payment details and complete payment</li>
                        <li>Take screenshot of payment confirmation</li>
                    </ol>
                </div>

                <div style="margin-top: 25px;">
                    <a href="<?php echo $qr_string; ?>" class="btn btn-custom">
                        <i class="fa fa-mobile"></i> Open UPI App
                    </a>
                    <button onclick="window.print()" class="btn btn-custom" style="background: linear-gradient(45deg, #6c757d, #868e96);">
                        <i class="fa fa-print"></i> Print QR
                    </button>
                </div>

                <!-- Payment Confirmation Form -->
                <div style="margin-top: 25px; padding: 20px; background: #e8f5e8; border-radius: 10px; border-left: 4px solid #28a745;">
                    <h5 style="color: #155724; margin-bottom: 15px;">
                        <i class="fa fa-check-circle"></i> Payment Completed?
                    </h5>
                    <p style="color: #155724; margin-bottom: 15px; font-size: 14px;">
                        After successful payment, enter your transaction reference number below to confirm payment:
                    </p>
                    
                    <form id="paymentConfirmForm" style="margin-bottom: 0;">
                        <input type="hidden" id="sale_id" value="<?php echo $sale['id']; ?>">
                        <div class="form-group" style="margin-bottom: 15px;">
                            <label for="transaction_ref" style="color: #155724; font-weight: 600;">Transaction Reference Number:</label>
                            <input type="text" 
                                   id="transaction_ref" 
                                   name="transaction_ref" 
                                   class="form-control" 
                                   placeholder="Enter UPI transaction ID (e.g., 123456789012)" 
                                   required
                                   style="margin-top: 5px;">
                        </div>
                        <!-- Hidden field for paid amount - automatically set to pending amount -->
                        <input type="hidden" 
                               id="paid_amount" 
                               name="paid_amount" 
                               value="<?php 
                                   $form_total = isset($sale['total_amount']) ? floatval($sale['total_amount']) : 0;
                                   $form_paid = isset($sale['paid_amount']) ? floatval($sale['paid_amount']) : 0;
                                   $form_pending = $form_total - $form_paid;
                                   // Ensure minimum amount is 1 if calculation results in 0 or negative
                                   if ($form_pending <= 0) {
                                       $form_pending = $form_total > 0 ? $form_total : 1;
                                   }
                                   echo number_format($form_pending, 2, '.', '');
                               ?>">
                        <button type="submit" class="btn btn-custom" style="background: linear-gradient(45deg, #28a745, #20c997); width: 100%;">
                            <i class="fa fa-check"></i> Confirm Payment
                        </button>
                    </form>
                    
                    <div id="payment_status" style="margin-top: 15px; display: none;"></div>
                </div>

            <?php } else { ?>
                <div class="alert alert-danger">
                    <i class="fa fa-exclamation-circle"></i> 
                    Sale not found or invalid sale ID.
                </div>
            <?php } ?>

            <div style="margin-top: 25px;">
                <button onclick="window.close()" class="btn btn-secondary">
                    <i class="fa fa-times"></i> Close
                </button>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        $(document).ready(function() {
            // Debug: Check if form elements exist
            console.log('QR Payment Form Debug:');
            console.log('Sale ID:', $('#sale_id').val());
            console.log('Paid Amount:', $('#paid_amount').val());
            console.log('Form exists:', $('#paymentConfirmForm').length > 0);
            
            // Payment confirmation form submission
            $('#paymentConfirmForm').on('submit', function(e) {
                e.preventDefault();
                console.log('Form submitted!');
                
                var saleId = $('#sale_id').val();
                var transactionRef = $('#transaction_ref').val().trim();
                var paidAmount = $('#paid_amount').val();
                
                console.log('Form values before validation:');
                console.log('Sale ID:', saleId);
                console.log('Transaction Ref:', transactionRef);
                console.log('Paid Amount:', paidAmount);
                
                // Validate inputs
                if (!transactionRef) {
                    console.log('Validation failed: No transaction reference');
                    $('#payment_status').html('<div class="alert alert-warning"><i class="fa fa-exclamation-triangle"></i> Please enter transaction reference number</div>').show();
                    $('#transaction_ref').focus();
                    return;
                }
                
                if (transactionRef.length < 8) {
                    console.log('Validation failed: Transaction reference too short');
                    $('#payment_status').html('<div class="alert alert-warning"><i class="fa fa-exclamation-triangle"></i> Transaction reference must be at least 8 characters</div>').show();
                    $('#transaction_ref').focus();
                    return;
                }
                
                if (!paidAmount || parseFloat(paidAmount) <= 0) {
                    console.log('Validation failed: Invalid paid amount');
                    $('#payment_status').html('<div class="alert alert-warning"><i class="fa fa-exclamation-triangle"></i> Invalid payment amount</div>').show();
                    return;
                }
                
                console.log('All validations passed, proceeding with AJAX...');
                
                // Disable submit button to prevent double submission
                var submitBtn = $(this).find('button[type="submit"]');
                submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Processing...');
                
                // Show loading
                $('#payment_status').html('<div class="alert alert-info"><i class="fa fa-spinner fa-spin"></i> Processing payment confirmation...</div>').show();
                
                // Debug form data
                var formData = {
                    sale_id: saleId,
                    transaction_ref: transactionRef,
                    paid_amount: paidAmount,
                    payment_method: 'upi'
                };
                console.log('Sending AJAX with data:', formData);
                
                // AJAX call to confirm payment
                $.ajax({
                    url: '<?php echo base_url(); ?>admin/inventory/confirm_qr_payment',
                    type: 'POST',
                    dataType: 'json',
                    timeout: 30000, // 30 second timeout
                    data: formData,
                    beforeSend: function() {
                        console.log('AJAX request starting...');
                    },
                    success: function(response) {
                        console.log('AJAX Success - Raw response:', response);
                        console.log('Response type:', typeof response);
                        console.log('Response status:', response ? response.status : 'undefined');
                        
                        if (response && response.status === 'success') {
                            console.log('Payment successful!');
                            $('#payment_status').html('<div class="alert alert-success"><i class="fa fa-check-circle"></i> ' + response.message + '</div>');
                            $('#paymentConfirmForm')[0].reset();
                            
                            // Show success animation
                            $('#payment_status .alert-success').hide().fadeIn(500);
                            
                            // Auto close after 4 seconds with countdown
                            var countdown = 4;
                            var countdownInterval = setInterval(function() {
                                countdown--;
                                if (countdown > 0) {
                                    $('#payment_status .alert-success').append('<br><small>Window will close in ' + countdown + ' seconds...</small>');
                                } else {
                                    clearInterval(countdownInterval);
                                    if (window.opener) {
                                        window.opener.location.reload();
                                    }
                                    window.close();
                                }
                            }, 1000);
                            
                        } else {
                            console.log('Payment failed or invalid response');
                            var errorMsg = response && response.message ? response.message : 'Unknown error occurred';
                            $('#payment_status').html('<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> ' + errorMsg + '</div>');
                            
                            // Re-enable submit button
                            submitBtn.prop('disabled', false).html('<i class="fa fa-check"></i> Confirm Payment');
                        }
                    },
                    error: function(xhr, status, error) {
                        console.log('AJAX Error occurred!');
                        console.log('Status:', status);
                        console.log('Error:', error);
                        console.log('Response Text:', xhr.responseText);
                        console.log('Status Code:', xhr.status);
                        console.log('Ready State:', xhr.readyState);
                        
                        var errorMessage = 'Connection error occurred';
                        
                        if (xhr.status === 0) {
                            errorMessage = 'Network connection failed. Please check your internet connection.';
                        } else if (xhr.status === 404) {
                            errorMessage = 'Payment processing endpoint not found.';
                        } else if (xhr.status === 500) {
                            errorMessage = 'Server error occurred. Please try again.';
                        } else if (status === 'timeout') {
                            errorMessage = 'Request timeout. Please try again.';
                        } else if (xhr.responseText) {
                            try {
                                var errorResponse = JSON.parse(xhr.responseText);
                                errorMessage = errorResponse.message || xhr.responseText;
                            } catch (e) {
                                errorMessage = 'Server response: ' + xhr.responseText.substring(0, 200);
                            }
                        }
                        
                        $('#payment_status').html('<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> ' + errorMessage + '</div>');
                        
                        // Re-enable submit button
                        submitBtn.prop('disabled', false).html('<i class="fa fa-check"></i> Confirm Payment');
                    },
                    complete: function() {
                        console.log('AJAX request completed');
                    }
                });
            });

            // Print functionality
            function printQR() {
                window.print();
            }

            // Copy UPI string to clipboard
            function copyUPIString() {
                var upiString = '<?php echo $qr_string; ?>';
                navigator.clipboard.writeText(upiString).then(function() {
                    alert('UPI payment string copied to clipboard!');
                });
            }
        });
    </script>
</body>
</html>
