<?php $currency_symbol = $this->customlib->getSchoolCurrencyFormat(); ?>
<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-money"></i> Record Payment
            <small>Record payment for student sale</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="<?php echo base_url(); ?>admin/inventory"><i class="fa fa-cubes"></i> Inventory</a></li>
            <li><a href="<?php echo base_url(); ?>admin/inventory/student_sales"><i class="fa fa-shopping-cart"></i> Student Sales</a></li>
            <li class="active">Record Payment</li>
        </ol>
    </section>

    <section class="content">
        <div class="row">
            <div class="col-md-8 col-md-offset-2">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-credit-card"></i> Payment Information</h3>
                    </div>
                    <div class="box-body">
                        <!-- Sale Summary -->
                        <div class="alert alert-info">
                            <h4><i class="fa fa-info-circle"></i> Sale Summary</h4>
                            <div class="row">
                                <div class="col-md-6">
                                    <strong>Sale ID:</strong> <?php echo $sale['sale_id']; ?><br>
                                    <strong>Student:</strong> <?php echo $sale['student_name']; ?><br>
                                    <strong>Class:</strong> <?php echo $sale['class'] . ' - ' . $sale['section']; ?>
                                </div>
                                <div class="col-md-6">
                                    <strong>Total Amount:</strong> <?php echo $currency_symbol . number_format($sale['total_amount'], 2); ?><br>
                                    <strong>Paid Amount:</strong> <?php echo $currency_symbol . number_format($sale['paid_amount'], 2); ?><br>
                                    <strong>Balance Due:</strong> <span class="text-danger"><?php echo $currency_symbol . number_format($sale['total_amount'] - $sale['paid_amount'], 2); ?></span>
                                </div>
                            </div>
                        </div>

                        <!-- Payment Form -->
                        <form method="post" action="<?php echo base_url(); ?>admin/inventory/record_student_payment/<?php echo $sale['id']; ?>">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="payment_amount">Payment Amount <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-addon"><?php echo $currency_symbol; ?></span>
                                            <input type="number" class="form-control" id="payment_amount" name="payment_amount" 
                                                   step="0.01" min="0.01" max="<?php echo $sale['total_amount'] - $sale['paid_amount']; ?>" 
                                                   value="<?php echo $sale['total_amount'] - $sale['paid_amount']; ?>" required>
                                        </div>
                                        <small class="text-muted">Maximum: <?php echo $currency_symbol . number_format($sale['total_amount'] - $sale['paid_amount'], 2); ?></small>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="payment_method">Payment Method <span class="text-danger">*</span></label>
                                        <select class="form-control" id="payment_method" name="payment_method" required>
                                            <option value="cash">Cash</option>
                                            <option value="card">Card</option>
                                            <option value="online">Online Transfer</option>
                                            <option value="cheque">Cheque</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="payment_notes">Payment Notes</label>
                                        <textarea class="form-control" id="payment_notes" name="payment_notes" rows="3" 
                                                  placeholder="Additional notes about this payment..."></textarea>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-success">
                                            <i class="fa fa-check"></i> Record Payment
                                        </button>
                                        <a href="<?php echo base_url(); ?>admin/inventory/student_sales" class="btn btn-default">
                                            <i class="fa fa-times"></i> Cancel
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
$(document).ready(function() {
    // Auto-calculate remaining balance
    $('#payment_amount').on('input', function() {
        var paymentAmount = parseFloat($(this).val()) || 0;
        var totalDue = <?php echo $sale['total_amount'] - $sale['paid_amount']; ?>;
        
        if (paymentAmount > totalDue) {
            $(this).val(totalDue.toFixed(2));
            alert('Payment amount cannot exceed the balance due.');
        }
    });
    
    // Form validation
    $('form').on('submit', function(e) {
        var paymentAmount = parseFloat($('#payment_amount').val()) || 0;
        var totalDue = <?php echo $sale['total_amount'] - $sale['paid_amount']; ?>;
        
        if (paymentAmount <= 0) {
            e.preventDefault();
            alert('Please enter a valid payment amount.');
            return false;
        }
        
        if (paymentAmount > totalDue) {
            e.preventDefault();
            alert('Payment amount cannot exceed the balance due.');
            return false;
        }
        
        return confirm('Are you sure you want to record this payment?');
    });
});
</script>
