<?php $currency_symbol = $this->customlib->getSchoolCurrencyFormat(); ?>
<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-eye"></i> Sale Details
            <small>View student sale information</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="<?php echo base_url(); ?>admin/inventory"><i class="fa fa-cubes"></i> Inventory</a></li>
            <li><a href="<?php echo base_url(); ?>admin/inventory/student_sales"><i class="fa fa-shopping-cart"></i> Student Sales</a></li>
            <li class="active">Sale Details</li>
        </ol>
    </section>

    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-info-circle"></i> Sale Information</h3>
                        <div class="box-tools pull-right">
                            <a href="<?php echo base_url(); ?>admin/inventory/print_student_sale_receipt/<?php echo $sale['id']; ?>" 
                               class="btn btn-success btn-sm" target="_blank">
                                <i class="fa fa-print"></i> Print Receipt
                            </a>
                            <a href="<?php echo base_url(); ?>admin/inventory/student_sales" class="btn btn-default btn-sm">
                                <i class="fa fa-arrow-left"></i> Back
                            </a>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-striped">
                                    <tr>
                                        <th width="30%">Sale ID:</th>
                                        <td><?php echo $sale['sale_id']; ?></td>
                                    </tr>
                                    <tr>
                                        <th>Date:</th>
                                        <td><?php echo date('d-m-Y', strtotime($sale['sale_date'])); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Student:</th>
                                        <td>
                                            <strong><?php echo $sale['student_name']; ?></strong><br>
                                            <small>Admission No: <?php echo $sale['admission_no']; ?></small>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Class:</th>
                                        <td><?php echo $sale['class'] . ' - ' . $sale['section']; ?></td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-striped">
                                    <tr>
                                        <th width="30%">Total Amount:</th>
                                        <td><strong><?php echo $currency_symbol . number_format($sale['total_amount'], 2); ?></strong></td>
                                    </tr>
                                    <tr>
                                        <th>Paid Amount:</th>
                                        <td><?php echo $currency_symbol . number_format($sale['paid_amount'], 2); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Balance:</th>
                                        <td><?php echo $currency_symbol . number_format($sale['total_amount'] - $sale['paid_amount'], 2); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Payment Status:</th>
                                        <td>
                                            <?php if ($sale['payment_status'] == 'paid') { ?>
                                                <span class="label label-success">Paid</span>
                                            <?php } elseif ($sale['payment_status'] == 'partial') { ?>
                                                <span class="label label-warning">Partial</span>
                                            <?php } else { ?>
                                                <span class="label label-danger">Pending</span>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Payment Method:</th>
                                        <td><?php echo ucfirst($sale['payment_method']); ?></td>
                                    </tr>
                                    <?php if (!empty($sale['transaction_ref'])) { ?>
                                    <tr>
                                        <th>Transaction Ref:</th>
                                        <td><code><?php echo $sale['transaction_ref']; ?></code></td>
                                    </tr>
                                    <?php } ?>
                                    <?php if (!empty($sale['payment_date'])) { ?>
                                    <tr>
                                        <th>Payment Date:</th>
                                        <td><?php echo date('d-m-Y H:i:s', strtotime($sale['payment_date'])); ?></td>
                                    </tr>
                                    <?php } ?>
                                </table>
                            </div>
                        </div>

                        <?php if (!empty($sale['notes'])) { ?>
                        <div class="row">
                            <div class="col-md-12">
                                <h4>Notes:</h4>
                                <p><?php echo nl2br(htmlspecialchars($sale['notes'])); ?></p>
                            </div>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-list"></i> Sale Items</h3>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>Item Code</th>
                                        <th>Item Name</th>
                                        <th>Quantity</th>
                                        <th>Unit Price</th>
                                        <th>Total Price</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                    $grand_total = 0;
                                    foreach ($sale_items as $item) { 
                                        $grand_total += $item['total_price'];
                                    ?>
                                        <tr>
                                            <td><?php echo $item['item_code']; ?></td>
                                            <td><?php echo $item['item_name']; ?></td>
                                            <td><?php echo $item['quantity']; ?></td>
                                            <td><?php echo $currency_symbol . number_format($item['unit_price'], 2); ?></td>
                                            <td><?php echo $currency_symbol . number_format($item['total_price'], 2); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="4" class="text-right">Grand Total:</th>
                                        <th><?php echo $currency_symbol . number_format($grand_total, 2); ?></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Payment History Section -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-history"></i> Payment History</h3>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>Date & Time</th>
                                        <th>Amount</th>
                                        <th>Method</th>
                                        <th>Transaction Ref</th>
                                        <th>Status</th>
                                        <th>Staff</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                    // Get payment logs for this sale
                                    $payment_logs_query = $this->db->select('spl.*, st.name as staff_name')
                                                                   ->from('student_payment_logs spl')
                                                                   ->join('staff st', 'st.id = spl.staff_id', 'left')
                                                                   ->where('spl.student_sale_id', $sale['id'])
                                                                   ->order_by('spl.payment_date', 'DESC')
                                                                   ->get();
                                    
                                    if ($payment_logs_query->num_rows() > 0) {
                                        $payment_logs = $payment_logs_query->result_array();
                                        foreach ($payment_logs as $log) { 
                                    ?>
                                        <tr>
                                            <td><?php echo date('d-m-Y H:i:s', strtotime($log['payment_date'])); ?></td>
                                            <td><strong><?php echo $currency_symbol . number_format($log['payment_amount'], 2); ?></strong></td>
                                            <td>
                                                <?php if ($log['payment_method'] == 'upi') { ?>
                                                    <span class="label label-info">UPI Payment</span>
                                                <?php } else { ?>
                                                    <?php echo ucfirst($log['payment_method']); ?>
                                                <?php } ?>
                                            </td>
                                            <td>
                                                <?php if (!empty($log['transaction_ref'])) { ?>
                                                    <code><?php echo $log['transaction_ref']; ?></code>
                                                <?php } else { ?>
                                                    <span class="text-muted">-</span>
                                                <?php } ?>
                                            </td>
                                            <td><span class="label label-success">Completed</span></td>
                                            <td><?php echo $log['staff_name'] ?: 'System'; ?></td>
                                        </tr>
                                    <?php 
                                        }
                                    } else { 
                                    ?>
                                        <tr>
                                            <td colspan="6" class="text-center text-muted">No payment transactions found</td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                        
                        <?php if ($sale['payment_status'] != 'paid') { ?>
                        <div class="alert alert-info" style="margin-top: 15px;">
                            <i class="fa fa-info-circle"></i> 
                            <strong>Pending Balance:</strong> <?php echo $currency_symbol . number_format($sale['total_amount'] - $sale['paid_amount'], 2); ?>
                            <div class="pull-right">
                                <a href="javascript:void(0)" onclick="showQRPayment(<?php echo $sale['id']; ?>)" class="btn btn-primary btn-xs">
                                    <i class="fa fa-qrcode"></i> Generate QR Payment
                                </a>
                            </div>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
function showQRPayment(saleId) {
    window.open('<?php echo base_url(); ?>admin/inventory/qr_payment/' + saleId, '_blank', 'width=600,height=700,scrollbars=yes');
}
</script>
