<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sale Receipt - <?php echo $sale['sale_id']; ?></title>
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <style>
        @page {
            size: A4;
            margin: 15mm;
        }
        body {
            font-family: Arial, sans-serif;
            font-size: 15px;
            margin: 0;
            padding: 0;
            background: white;
            color: #000;
        }
        .page-container {
            width: 100%;
            max-width: 180mm;
            margin: 0 auto;
        }
        .receipt-container {
            width: 100%;
            max-width: 180mm;
            margin: 20px auto 0;
            padding: 15px;
            box-sizing: border-box;
            background: white;
            border: 1px solid #000;
            position: relative;
        }
        .receipt-container::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            width: 350px;
            height: 350px;
            background-image: url('<?php echo base_url(); ?>uploads/school_content/logo/<?php echo $sch_setting->image; ?>');
            background-size: contain;
            background-repeat: no-repeat;
            background-position: center;
            opacity: 0.15;
            z-index: 0;
            pointer-events: none;
        }
        .receipt-container > * {
            position: relative;
            z-index: 1;
        }
        .receipt-header {
            border-bottom: 3px double #000;
            padding-bottom: 10px;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        .header-left {
            display: flex;
            align-items: center;
            gap: 12px;
        }
        .site-logo {
            width: 65px;
            height: 65px;
            border: 2px solid #000;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            font-weight: bold;
            color: #000;
            background: white;
            flex-shrink: 0;
        }
        .school-info {
            flex-grow: 1;
            margin-left: 8px;
        }
        .school-name {
            font-size: 28px;
            font-weight: bold;
            margin: 0;
            color: #000;
            text-transform: uppercase;
        }
        .school-address {
            font-size: 16px;
            color: #000;
            line-height: 1.1;
            margin-top: 1px;
        }
        .header-right {
            text-align: right;
            font-size: 14px;
            color: #000;
            max-width: 150px;
            word-wrap: break-word;
            overflow-wrap: break-word;
            line-height: 1.2;
        }
        .header-right div {
            margin-bottom: 2px;
        }
        .receipt-title {
            font-size: 18px;
            font-weight: bold;
            margin: 8px 0;
            text-align: center;
            color: #000;
            text-transform: uppercase;
            letter-spacing: 1px;
            border: 2px solid #000;
            padding: 6px;
        }
        .receipt-info {
            display: flex;
            justify-content: space-between;
            margin-bottom: 15px;
            gap: 10px;
        }
        .info-left, .info-right {
            width: 47%;
            font-size: 15px;
        }
        .info-row {
            margin-bottom: 8px;
        }
        .info-label {
            font-weight: bold;
            display: inline-block;
            width: 120px;
            font-size: 14px;
        }
        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin: 10px 0;
            border: 2px solid #000;
        }
        .items-table th,
        .items-table td {
            border: 1px solid #000;
            padding: 6px 9px;
            text-align: left;
            font-size: 14px;
        }
        .items-table th {
            background: #000;
            color: white;
            font-weight: bold;
            text-transform: uppercase;
            font-size: 12px;
            text-align: center;
        }
        .items-table .text-right {
            text-align: right;
        }
        .total-row {
            background-color: #f9f9f9;
            font-weight: bold;
        }
        .payment-info {
            margin-top: 15px;
            padding: 10px;
            border: 1px solid #000;
            background: #f9f9f9;
        }
        .qr-section {
            display: flex;
            align-items: flex-start;
            margin-top: 15px;
            border-top: 1px solid #000;
            padding-top: 10px;
        }
        .qr-code {
            width: 80px;
            height: 80px;
            border: 1px solid #000;
            margin-right: 15px;
            flex-shrink: 0;
        }
        .qr-info {
            flex-grow: 1;
            font-size: 10px;
            line-height: 1.3;
        }
        .qr-note {
            font-size: 9px;
            color: #666;
            margin-top: 5px;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 12px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 15px;
        }
        .receipt-copy {
            margin-bottom: 30px;
            page-break-after: always;
        }
        .receipt-copy:last-child {
            page-break-after: avoid;
        }
        .copy-label {
            text-align: center;
            font-weight: bold;
            font-size: 12px;
            margin: 15px 0 10px 0;
            text-transform: uppercase;
            letter-spacing: 1px;
            border: 1px solid #000;
            padding: 5px;
            background: #f0f0f0;
        }
        @media print {
            body {
                padding: 0;
                margin: 0;
            }
            .no-print {
                display: none;
            }
            .receipt-copy {
                page-break-inside: avoid;
            }
        }
    </style>
</head>
<body>
    <?php $currency_symbol = $this->customlib->getSchoolCurrencyFormat(); ?>
    
    <!-- ORIGINAL COPY -->
    <div class="receipt-copy">
        <div class="copy-label">ORIGINAL COPY</div>
        <div class="receipt-container">
            <div class="receipt-header">
                <div class="header-left">
                    <div class="site-logo">
                        <?php if (!empty($sch_setting->image)) { ?>
                            <img src="<?php echo base_url(); ?>uploads/school_content/logo/<?php echo $sch_setting->image; ?>" 
                                 alt="School Logo" style="width: 100%; height: 100%; object-fit: contain;" 
                                 onerror="this.style.display='none'; this.parentNode.innerHTML='<?php echo strtoupper(substr($sch_setting->name, 0, 1)); ?>';">
                        <?php } else { ?>
                            <?php echo strtoupper(substr($sch_setting->name, 0, 1)); ?>
                        <?php } ?>
                    </div>
                    <div class="school-info">
                        <div class="school-name"><?php echo $sch_setting->name; ?></div>
                        <div class="school-address">
                            <?php echo $sch_setting->address; ?>
                        </div>
                    </div>
                </div>
                <div class="header-right">
                    <div>Phone: <?php echo $sch_setting->phone; ?></div>
                    <div>Email: <?php echo $sch_setting->email; ?></div>
                </div>
            </div>

    <div class="receipt-title">STUDENT SALE RECEIPT</div>

    <div class="receipt-info">
        <div class="info-left">
            <div class="info-row">
                <span class="info-label">Receipt No:</span>
                <?php echo $sale['sale_id']; ?>
            </div>
            <div class="info-row">
                <span class="info-label">Date:</span>
                <?php echo date('d-m-Y', strtotime($sale['sale_date'])); ?>
            </div>
            <div class="info-row">
                <span class="info-label">Time:</span>
                <?php echo date('h:i A', strtotime($sale['created_at'])); ?>
            </div>
        </div>
        <div class="info-right">
            <div class="info-row">
                <span class="info-label">Student:</span>
                <?php echo $sale['student_name']; ?>
            </div>
            <div class="info-row">
                <span class="info-label">Admission No:</span>
                <?php echo $sale['admission_no']; ?>
            </div>
            <div class="info-row">
                <span class="info-label">Class:</span>
                <?php echo $sale['class'] . ' - ' . $sale['section']; ?>
            </div>
        </div>
    </div>

    <table class="items-table">
        <thead>
            <tr>
                <th>Item</th>
                <th>Qty</th>
                <th class="text-right">Unit Price</th>
                <th class="text-right">Total</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            $grand_total = 0;
            foreach ($sale_items as $item) { 
                $grand_total += $item['total_price'];
            ?>
                <tr>
                    <td>
                        <?php echo $item['item_name']; ?><br>
                        <small style="color: #666;"><?php echo $item['item_code']; ?></small>
                    </td>
                    <td><?php echo $item['quantity']; ?></td>
                    <td class="text-right"><?php echo $currency_symbol . number_format($item['unit_price'], 2); ?></td>
                    <td class="text-right"><?php echo $currency_symbol . number_format($item['total_price'], 2); ?></td>
                </tr>
            <?php } ?>
        </tbody>
        <tfoot>
            <tr class="total-row">
                <td colspan="3" class="text-right"><strong>Grand Total:</strong></td>
                <td class="text-right"><strong><?php echo $currency_symbol . number_format($grand_total, 2); ?></strong></td>
            </tr>
        </tfoot>
    </table>

    <div class="payment-info">
        <div class="info-row">
            <span class="info-label">Payment Method:</span>
            <?php echo ucfirst($sale['payment_method']); ?>
        </div>
        <div class="info-row">
            <span class="info-label">Payment Status:</span>
            <?php 
            if ($sale['payment_status'] == 'paid') {
                echo '<strong style="color: green;">PAID</strong>';
            } elseif ($sale['payment_status'] == 'partial') {
                echo '<strong style="color: orange;">PARTIAL PAYMENT</strong>';
            } else {
                echo '<strong style="color: red;">PENDING</strong>';
            }
            ?>
        </div>
        <div class="info-row">
            <span class="info-label">Amount Paid:</span>
            <?php echo $currency_symbol . number_format($sale['paid_amount'], 2); ?>
        </div>
        <?php if ($sale['total_amount'] > $sale['paid_amount']) { ?>
        <div class="info-row">
            <span class="info-label">Balance Due:</span>
            <strong><?php echo $currency_symbol . number_format($sale['total_amount'] - $sale['paid_amount'], 2); ?></strong>
        </div>
        <?php } ?>
    </div>

    <?php if (!empty($sale['notes'])) { ?>
    <div style="margin-top: 20px;">
        <strong>Notes:</strong><br>
        <?php echo nl2br(htmlspecialchars($sale['notes'])); ?>
    </div>
    <?php } ?>

            <!-- QR Code Section -->
            <div class="qr-section">
                <div class="qr-code">
                    <img src="https://api.qrserver.com/v1/create-qr-code/?size=80x80&data=<?php echo urlencode($sale['admission_no']); ?>" 
                         alt="QR Code" style="width: 100%; height: 100%;">
                </div>
                <div class="qr-info">
                    <div><strong>Note:</strong> <?php echo $sale['sale_id']; ?></div>
                    <div class="qr-note">This is a computer generated Receipt. Does not required signature.</div>
                </div>
            </div>

            <div class="footer" style="margin-top: 15px; text-align: center; font-size: 10px; border-top: 1px solid #000; padding-top: 8px;">
                <p style="margin: 2px 0;">Thank you for your purchase!</p>
                <p style="margin: 2px 0;">Generated on <?php echo date('d-m-Y h:i A'); ?></p>
            </div>
        </div>
    </div>

    <!-- DUPLICATE COPY -->
    <div class="receipt-copy">
        <div class="copy-label">DUPLICATE COPY</div>
        <div class="receipt-container">
            <div class="receipt-header">
                <div class="header-left">
                    <div class="site-logo">
                        <?php if (!empty($sch_setting->image)) { ?>
                            <img src="<?php echo base_url(); ?>uploads/school_content/logo/<?php echo $sch_setting->image; ?>" 
                                 alt="School Logo" style="width: 100%; height: 100%; object-fit: contain;" 
                                 onerror="this.style.display='none'; this.parentNode.innerHTML='<?php echo strtoupper(substr($sch_setting->name, 0, 1)); ?>';">
                        <?php } else { ?>
                            <?php echo strtoupper(substr($sch_setting->name, 0, 1)); ?>
                        <?php } ?>
                    </div>
                    <div class="school-info">
                        <div class="school-name"><?php echo $sch_setting->name; ?></div>
                        <div class="school-address">
                            <?php echo $sch_setting->address; ?>
                        </div>
                    </div>
                </div>
                <div class="header-right">
                    <div>Phone: <?php echo $sch_setting->phone; ?></div>
                    <div>Email: <?php echo $sch_setting->email; ?></div>
                </div>
            </div>

            <div class="receipt-title">STUDENT SALE RECEIPT</div>

            <div class="receipt-info">
                <div class="info-left">
                    <div class="info-row">
                        <span class="info-label">Receipt No:</span>
                        <?php echo $sale['sale_id']; ?>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Date:</span>
                        <?php echo date('d-m-Y', strtotime($sale['sale_date'])); ?>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Time:</span>
                        <?php echo date('h:i A', strtotime($sale['created_at'])); ?>
                    </div>
                </div>
                <div class="info-right">
                    <div class="info-row">
                        <span class="info-label">Student:</span>
                        <?php echo $sale['student_name']; ?>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Admission No:</span>
                        <?php echo $sale['admission_no']; ?>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Class:</span>
                        <?php echo $sale['class'] . ' - ' . $sale['section']; ?>
                    </div>
                </div>
            </div>

            <table class="items-table">
                <thead>
                    <tr>
                        <th>Item</th>
                        <th>Qty</th>
                        <th class="text-right">Unit Price</th>
                        <th class="text-right">Total</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $grand_total = 0;
                    foreach ($sale_items as $item) { 
                        $grand_total += $item['total_price'];
                    ?>
                        <tr>
                            <td>
                                <?php echo $item['item_name']; ?><br>
                                <small style="color: #666;"><?php echo $item['item_code']; ?></small>
                            </td>
                            <td><?php echo $item['quantity']; ?></td>
                            <td class="text-right"><?php echo $currency_symbol . number_format($item['unit_price'], 2); ?></td>
                            <td class="text-right"><?php echo $currency_symbol . number_format($item['total_price'], 2); ?></td>
                        </tr>
                    <?php } ?>
                </tbody>
                <tfoot>
                    <tr class="total-row">
                        <td colspan="3" class="text-right"><strong>Grand Total:</strong></td>
                        <td class="text-right"><strong><?php echo $currency_symbol . number_format($grand_total, 2); ?></strong></td>
                    </tr>
                </tfoot>
            </table>

            <div class="payment-info">
                <div class="info-row">
                    <span class="info-label">Payment Method:</span>
                    <?php echo ucfirst($sale['payment_method']); ?>
                </div>
                <div class="info-row">
                    <span class="info-label">Payment Status:</span>
                    <?php 
                    if ($sale['payment_status'] == 'paid') {
                        echo '<strong>PAID</strong>';
                    } elseif ($sale['payment_status'] == 'partial') {
                        echo '<strong>PARTIAL PAYMENT</strong>';
                    } else {
                        echo '<strong>PENDING</strong>';
                    }
                    ?>
                </div>
                <div class="info-row">
                    <span class="info-label">Amount Paid:</span>
                    <?php echo $currency_symbol . number_format($sale['paid_amount'], 2); ?>
                </div>
                <?php if ($sale['total_amount'] > $sale['paid_amount']) { ?>
                <div class="info-row">
                    <span class="info-label">Balance Due:</span>
                    <strong><?php echo $currency_symbol . number_format($sale['total_amount'] - $sale['paid_amount'], 2); ?></strong>
                </div>
                <?php } ?>
            </div>

            <?php if (!empty($sale['notes'])) { ?>
            <div style="margin-top: 10px; font-size: 10px;">
                <strong>Notes:</strong><br>
                <?php echo nl2br(htmlspecialchars($sale['notes'])); ?>
            </div>
            <?php } ?>

            <!-- QR Code Section -->
            <div class="qr-section">
                <div class="qr-code">
                    <img src="https://api.qrserver.com/v1/create-qr-code/?size=80x80&data=<?php echo urlencode($sale['admission_no']); ?>" 
                         alt="QR Code" style="width: 100%; height: 100%;">
                </div>
                <div class="qr-info">
                    <div><strong>Note:</strong> <?php echo $sale['sale_id']; ?></div>
                    <div class="qr-note">This is a computer generated Receipt. Does not required signature.</div>
                </div>
            </div>

            <div class="footer" style="margin-top: 15px; text-align: center; font-size: 10px; border-top: 1px solid #000; padding-top: 8px;">
                <p style="margin: 2px 0;">Thank you for your purchase!</p>
                <p style="margin: 2px 0;">Generated on <?php echo date('d-m-Y h:i A'); ?></p>
            </div>
        </div>
    </div>

    <div class="no-print" style="text-align: center; margin-top: 20px;">
        <button onclick="window.print()" style="padding: 10px 20px; font-size: 14px; background: #000; color: white; border: none; cursor: pointer; margin-right: 10px;">Print Receipt</button>
        <button onclick="window.close()" style="padding: 10px 20px; font-size: 14px; background: #666; color: white; border: none; cursor: pointer;">Close</button>
    </div>

    <script>
        // Auto print on load
        window.onload = function() {
            window.print();
        }
    </script>
</body>
</html>
