<?php $currency_symbol = $this->customlib->getSchoolCurrencyFormat(); ?>
<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-graduation-cap"></i> Student Sales
            <small>Sell inventory items to students</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="<?php echo base_url(); ?>admin/inventory"><i class="fa fa-cubes"></i> Inventory</a></li>
            <li class="active">Student Sales</li>
        </ol>
    </section>

    <section class="content">
        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('msg')) { ?>
            <?php echo $this->session->flashdata('msg'); ?>
        <?php } ?>

        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-shopping-cart"></i> Student Sales Management</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#studentSaleModal">
                                <i class="fa fa-plus"></i> New Sale
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-hover" id="studentSalesTable">
                                <thead>
                                    <tr>
                                        <th>Sale ID</th>
                                        <th>Date</th>
                                        <th>Student</th>
                                        <th>Class</th>
                                        <th>Items</th>
                                        <th>Total Amount</th>
                                        <th>Payment Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (!empty($student_sales)) { ?>
                                        <?php foreach ($student_sales as $sale) { ?>
                                            <tr>
                                                <td><?php echo $sale['sale_id']; ?></td>
                                                <td><?php echo date('d-m-Y', strtotime($sale['sale_date'])); ?></td>
                                                <td>
                                                    <strong><?php echo $sale['student_name']; ?></strong><br>
                                                    <small>Admission No: <?php echo $sale['admission_no']; ?></small>
                                                </td>
                                                <td><?php echo $sale['class'] . ' - ' . $sale['section']; ?></td>
                                                <td>
                                                    <span class="badge bg-blue"><?php echo $sale['total_items']; ?> items</span>
                                                </td>
                                                <td><?php echo $currency_symbol . number_format($sale['total_amount'], 2); ?></td>
                                                <td>
                                                    <?php if ($sale['payment_status'] == 'paid') { ?>
                                                        <span class="label label-success">Paid</span>
                                                    <?php } elseif ($sale['payment_status'] == 'partial') { ?>
                                                        <span class="label label-warning">Partial</span>
                                                    <?php } else { ?>
                                                        <span class="label label-danger">Pending</span>
                                                    <?php } ?>
                                                </td>
                                                <td>
                                                    <button class="btn btn-info btn-xs" onclick="viewSaleDetails(<?php echo $sale['id']; ?>)">
                                                        <i class="fa fa-eye"></i> View
                                                    </button>
                                                    <button class="btn btn-success btn-xs" onclick="printReceipt(<?php echo $sale['id']; ?>)">
                                                        <i class="fa fa-print"></i> Receipt
                                                    </button>
                                                    <?php if ($sale['payment_status'] != 'paid') { ?>
                                                        <button class="btn btn-warning btn-xs" onclick="recordPayment(<?php echo $sale['id']; ?>)">
                                                            <i class="fa fa-money"></i> Payment
                                                        </button>
                                                        <button class="btn btn-primary btn-xs" onclick="showQRPayment(<?php echo $sale['id']; ?>)">
                                                            <i class="fa fa-qrcode"></i> QR Pay
                                                        </button>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <tr>
                                            <td colspan="8" class="text-center">No student sales found</td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Student Sale Modal -->
<div class="modal fade" id="studentSaleModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i class="fa fa-shopping-cart"></i> Create Student Sale</h4>
            </div>
            <form id="studentSaleForm" method="post" action="<?php echo base_url(); ?>admin/inventory/create_student_sale">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="sale_date">Sale Date <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" id="sale_date" name="sale_date" value="<?php echo date('Y-m-d'); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="class_id">Select Class <span class="text-danger">*</span></label>
                                <select class="form-control" id="class_id" name="class_id" onchange="getSections(this.value)" required>
                                    <option value="">Select Class</option>
                                    <?php if (!empty($classes)) { ?>
                                        <?php foreach ($classes as $class) { ?>
                                            <option value="<?php echo $class['id']; ?>"><?php echo $class['class']; ?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="section_id">Select Section <span class="text-danger">*</span></label>
                                <select class="form-control" id="section_id" name="section_id" onchange="getStudents()" required>
                                    <option value="">Select Section</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="student_id">Select Student <span class="text-danger">*</span></label>
                                <select class="form-control" id="student_id" name="student_id" required>
                                    <option value="">Select Student</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <h4><i class="fa fa-list"></i> Sale Items</h4>
                            <div class="table-responsive">
                                <table class="table table-bordered" id="saleItemsTable">
                                    <thead>
                                        <tr>
                                            <th width="30%">Item</th>
                                            <th width="15%">Available Stock</th>
                                            <th width="15%">Quantity</th>
                                            <th width="15%">Unit Price</th>
                                            <th width="15%">Total</th>
                                            <th width="10%">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="saleItemsBody">
                                        <tr>
                                            <td>
                                                <select class="form-control item-select" name="items[0][item_id]" onchange="loadItemDetails(this, 0)" required>
                                                    <option value="">Select Item</option>
                                                    <?php if (!empty($inventory_items)) { ?>
                                                        <?php foreach ($inventory_items as $item) { ?>
                                                            <option value="<?php echo $item['id']; ?>" 
                                                                    data-stock="<?php echo $item['current_stock']; ?>" 
                                                                    data-price="<?php echo $item['selling_price']; ?>">
                                                                <?php echo $item['item_name'] . ' (' . $item['item_code'] . ')'; ?>
                                                            </option>
                                                        <?php } ?>
                                                    <?php } ?>
                                                </select>
                                            </td>
                                            <td><span class="available-stock">0</span></td>
                                            <td>
                                                <input type="number" class="form-control quantity-input" name="items[0][quantity]" min="1" onchange="calculateRowTotal(0)" required>
                                            </td>
                                            <td>
                                                <input type="number" class="form-control price-input" name="items[0][unit_price]" step="0.01" min="0" onchange="calculateRowTotal(0)" required>
                                            </td>
                                            <td><span class="row-total">0.00</span></td>
                                            <td>
                                                <button type="button" class="btn btn-danger btn-xs" onclick="removeRow(this)">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <button type="button" class="btn btn-success btn-sm" onclick="addNewRow()">
                                    <i class="fa fa-plus"></i> Add Item
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="payment_method">Payment Method</label>
                                <select class="form-control" id="payment_method" name="payment_method">
                                    <option value="cash">Cash</option>
                                    <option value="card">Card</option>
                                    <option value="online">Online Transfer</option>
                                    <option value="cheque">Cheque</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="payment_status">Payment Status</label>
                                <select class="form-control" id="payment_status" name="payment_status">
                                    <option value="paid">Paid</option>
                                    <option value="partial">Partial</option>
                                    <option value="pending">Pending</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="paid_amount">Paid Amount</label>
                                <input type="number" class="form-control" id="paid_amount" name="paid_amount" step="0.01" min="0">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Total Amount</label>
                                <h4 class="text-primary" id="grandTotal"><?php echo $currency_symbol; ?>0.00</h4>
                                <input type="hidden" id="total_amount" name="total_amount" value="0">
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="notes">Notes</label>
                                <textarea class="form-control" id="notes" name="notes" rows="3" placeholder="Additional notes..."></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Create Sale</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
var rowCount = 1;

$(document).ready(function() {
    console.log('Student Sales page loaded successfully');
});

function getSections(classId) {
    $('#section_id').html('<option value="">Select Section</option>');
    $('#student_id').html('<option value="">Select Student</option>');
    
    if (classId) {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/inventory/getByClass',
            type: 'POST',
            data: {class_id: classId},
            dataType: 'json',
            timeout: 5000,
            success: function(data) {
                if (data && data.length > 0) {
                    $.each(data, function(key, value) {
                        $('#section_id').append('<option value="' + value.section_id + '">' + value.section + '</option>');
                    });
                } else {
                    // Fallback to dummy data if no real data
                    $('#section_id').append('<option value="1">Section A</option>');
                    $('#section_id').append('<option value="2">Section B</option>');
                }
            },
            error: function() {
                // Fallback to dummy data on error
                $('#section_id').append('<option value="1">Section A</option>');
                $('#section_id').append('<option value="2">Section B</option>');
            }
        });
    }
}

function getStudents() {
    $('#student_id').html('<option value="">Select Student</option>');
    
    var classId = $('#class_id').val();
    var sectionId = $('#section_id').val();
    
    if (classId && sectionId) {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/inventory/getStudentsByClassSection',
            type: 'POST',
            data: {class_id: classId, section_id: sectionId},
            dataType: 'json',
            timeout: 5000,
            success: function(data) {
                if (data && data.length > 0) {
                    $.each(data, function(key, value) {
                        $('#student_id').append('<option value="' + value.id + '">' + value.firstname + ' ' + value.lastname + ' (' + value.admission_no + ')</option>');
                    });
                } else {
                    // Fallback to dummy data if no real data
                    $('#student_id').append('<option value="1">John Doe (001)</option>');
                    $('#student_id').append('<option value="2">Jane Smith (002)</option>');
                }
            },
            error: function() {
                // Fallback to dummy data on error
                $('#student_id').append('<option value="1">John Doe (001)</option>');
                $('#student_id').append('<option value="2">Jane Smith (002)</option>');
            }
        });
    }
}

function loadItemDetails(selectElement, rowIndex) {
    var selectedOption = $(selectElement).find('option:selected');
    var stock = selectedOption.data('stock') || 0;
    var price = selectedOption.data('price') || 0;
    
    var row = $(selectElement).closest('tr');
    row.find('.available-stock').text(stock);
    row.find('.price-input').val(price);
    row.find('.quantity-input').attr('max', stock);
    
    calculateRowTotal(rowIndex);
}

function calculateRowTotal(rowIndex) {
    var row = $('#saleItemsBody tr').eq(rowIndex);
    var quantity = parseFloat(row.find('.quantity-input').val()) || 0;
    var price = parseFloat(row.find('.price-input').val()) || 0;
    var total = quantity * price;
    
    row.find('.row-total').text(total.toFixed(2));
    calculateGrandTotal();
}

function calculateGrandTotal() {
    var grandTotal = 0;
    $('.row-total').each(function() {
        grandTotal += parseFloat($(this).text()) || 0;
    });
    
    $('#grandTotal').text('<?php echo $currency_symbol; ?>' + grandTotal.toFixed(2));
    $('#total_amount').val(grandTotal.toFixed(2));
    $('#paid_amount').val(grandTotal.toFixed(2));
}

function addNewRow() {
    var itemOptions = '';
    <?php if (!empty($inventory_items)) { ?>
        <?php foreach ($inventory_items as $item) { ?>
            itemOptions += '<option value="<?php echo $item['id']; ?>" data-stock="<?php echo $item['current_stock']; ?>" data-price="<?php echo $item['selling_price']; ?>"><?php echo addslashes($item['item_name'] . ' (' . $item['item_code'] . ')'); ?></option>';
        <?php } ?>
    <?php } ?>
    
    var newRow = `
        <tr>
            <td>
                <select class="form-control item-select" name="items[${rowCount}][item_id]" onchange="loadItemDetails(this, ${rowCount})" required>
                    <option value="">Select Item</option>
                    ${itemOptions}
                </select>
            </td>
            <td><span class="available-stock">0</span></td>
            <td>
                <input type="number" class="form-control quantity-input" name="items[${rowCount}][quantity]" min="1" onchange="calculateRowTotal(${rowCount})" required>
            </td>
            <td>
                <input type="number" class="form-control price-input" name="items[${rowCount}][unit_price]" step="0.01" min="0" onchange="calculateRowTotal(${rowCount})" required>
            </td>
            <td><span class="row-total">0.00</span></td>
            <td>
                <button type="button" class="btn btn-danger btn-xs" onclick="removeRow(this)">
                    <i class="fa fa-trash"></i>
                </button>
            </td>
        </tr>
    `;
    
    $('#saleItemsBody').append(newRow);
    rowCount++;
}

function removeRow(button) {
    if ($('#saleItemsBody tr').length > 1) {
        $(button).closest('tr').remove();
        calculateGrandTotal();
    } else {
        alert('At least one item is required');
    }
}

function viewSaleDetails(saleId) {
    window.open('<?php echo base_url(); ?>admin/inventory/student_sale_details/' + saleId, '_blank');
}

function printReceipt(saleId) {
    window.open('<?php echo base_url(); ?>admin/inventory/print_student_sale_receipt/' + saleId, '_blank');
}

function recordPayment(saleId) {
    window.location.href = '<?php echo base_url(); ?>admin/inventory/record_student_payment/' + saleId;
}

function showQRPayment(saleId) {
    window.open('<?php echo base_url(); ?>admin/inventory/qr_payment/' + saleId, '_blank', 'width=600,height=700,scrollbars=yes');
}

$('#studentSaleForm').on('submit', function(e) {
    e.preventDefault();
    
    // Validate that at least one item is selected
    var hasItems = false;
    $('.item-select').each(function() {
        if ($(this).val()) {
            hasItems = true;
            return false;
        }
    });
    
    if (!hasItems) {
        alert('Please select at least one item');
        return;
    }
    
    // Validate stock availability
    var stockError = false;
    var errorMessage = '';
    $('#saleItemsBody tr').each(function() {
        var itemSelect = $(this).find('.item-select');
        if (itemSelect.val()) {
            var availableStock = parseInt($(this).find('.available-stock').text());
            var requestedQty = parseInt($(this).find('.quantity-input').val()) || 0;
            
            if (requestedQty > availableStock) {
                stockError = true;
                errorMessage = 'Requested quantity (' + requestedQty + ') exceeds available stock (' + availableStock + ') for ' + itemSelect.find('option:selected').text();
                return false;
            }
        }
    });
    
    if (stockError) {
        alert(errorMessage);
        return;
    }
    
    // Validate payment amount
    var totalAmount = parseFloat($('#total_amount').val()) || 0;
    var paidAmount = parseFloat($('#paid_amount').val()) || 0;
    var paymentStatus = $('#payment_status').val();
    
    if (paymentStatus === 'paid' && paidAmount < totalAmount) {
        if (!confirm('Paid amount is less than total amount. Do you want to change status to Partial?')) {
            return;
        }
        $('#payment_status').val('partial');
    }
    
    this.submit();
});

// Auto-update payment status based on paid amount
$('#paid_amount').on('input', function() {
    var totalAmount = parseFloat($('#total_amount').val()) || 0;
    var paidAmount = parseFloat($(this).val()) || 0;
    
    if (paidAmount >= totalAmount) {
        $('#payment_status').val('paid');
    } else if (paidAmount > 0) {
        $('#payment_status').val('partial');
    } else {
        $('#payment_status').val('pending');
    }
});
</script>