<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-truck"></i> Inventory Suppliers
            <small>Manage inventory suppliers</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="<?php echo base_url(); ?>admin/inventory"><i class="fa fa-cubes"></i> Inventory</a></li>
            <li class="active">Suppliers</li>
        </ol>
    </section>

    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-list"></i> Suppliers List</h3>
                        <div class="box-tools pull-right">
                            <?php if ($this->rbac->hasPrivilege('inventory_suppliers', 'can_add')) { ?>
                                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#addSupplierModal">
                                    <i class="fa fa-plus"></i> Add New Supplier
                                </button>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-hover" id="suppliersTable">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Contact Person</th>
                                        <th>Email</th>
                                        <th>Phone</th>
                                        <th>City</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($suppliers as $supplier) { ?>
                                        <tr>
                                            <td><strong><?php echo $supplier->name; ?></strong></td>
                                            <td><?php echo $supplier->contact_person ?: 'N/A'; ?></td>
                                            <td><?php echo $supplier->email ?: 'N/A'; ?></td>
                                            <td><?php echo $supplier->phone ?: 'N/A'; ?></td>
                                            <td><?php echo $supplier->city ?: 'N/A'; ?></td>
                                            <td>
                                                <?php if ($supplier->is_active) { ?>
                                                    <span class="label label-success">Active</span>
                                                <?php } else { ?>
                                                    <span class="label label-danger">Inactive</span>
                                                <?php } ?>
                                            </td>
                                            <td>
                                                <div class="btn-group">
                                                    <button type="button" class="btn btn-info btn-xs" onclick="viewSupplier(<?php echo $supplier->id; ?>)" title="View Details">
                                                        <i class="fa fa-eye"></i>
                                                    </button>
                                                    <?php if ($this->rbac->hasPrivilege('inventory_suppliers', 'can_edit')) { ?>
                                                        <button type="button" class="btn btn-primary btn-xs" onclick="editSupplier(<?php echo $supplier->id; ?>)" title="Edit">
                                                            <i class="fa fa-edit"></i>
                                                        </button>
                                                    <?php } ?>
                                                    <?php if ($this->rbac->hasPrivilege('inventory_suppliers', 'can_delete')) { ?>
                                                        <button type="button" class="btn btn-danger btn-xs" onclick="deleteSupplier(<?php echo $supplier->id; ?>)" title="Delete">
                                                            <i class="fa fa-trash"></i>
                                                        </button>
                                                    <?php } ?>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Add Supplier Modal -->
<div class="modal fade" id="addSupplierModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title"><i class="fa fa-plus"></i> Add New Supplier</h4>
            </div>
            <form id="addSupplierForm">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name">Supplier Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="name" name="name" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="contact_person">Contact Person</label>
                                <input type="text" class="form-control" id="contact_person" name="contact_person">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="email">Email</label>
                                <input type="email" class="form-control" id="email" name="email">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="phone">Phone</label>
                                <input type="text" class="form-control" id="phone" name="phone">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="address">Address</label>
                                <textarea class="form-control" id="address" name="address" rows="3"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="city">City</label>
                                <input type="text" class="form-control" id="city" name="city">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="state">State</label>
                                <input type="text" class="form-control" id="state" name="state">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="country">Country</label>
                                <input type="text" class="form-control" id="country" name="country">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="postal_code">Postal Code</label>
                                <input type="text" class="form-control" id="postal_code" name="postal_code">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="tax_number">Tax Number</label>
                                <input type="text" class="form-control" id="tax_number" name="tax_number">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="payment_terms">Payment Terms</label>
                                <select class="form-control" id="payment_terms" name="payment_terms">
                                    <option value="">Select Terms</option>
                                    <option value="NET_30">Net 30 Days</option>
                                    <option value="NET_15">Net 15 Days</option>
                                    <option value="NET_7">Net 7 Days</option>
                                    <option value="COD">Cash on Delivery</option>
                                    <option value="ADVANCE">Advance Payment</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Save Supplier</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    $('#suppliersTable').DataTable({
        "paging": true,
        "lengthChange": true,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "responsive": true
    });

    $('#addSupplierForm').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
            url: '<?php echo base_url("admin/inventory/add_supplier"); ?>',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#addSupplierModal').modal('hide');
                    location.reload();
                } else {
                    alert('Error: ' + response.error);
                }
            },
            error: function() {
                alert('An error occurred while adding the supplier.');
            }
        });
    });
});

function viewSupplier(id) {
    $.ajax({
        url: '<?php echo base_url("admin/inventory/view_supplier/"); ?>' + id,
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                var supplier = response.data;
                var details = '<div class="row">' +
                    '<div class="col-md-6"><strong>Name:</strong> ' + supplier.name + '</div>' +
                    '<div class="col-md-6"><strong>Contact Person:</strong> ' + (supplier.contact_person || 'N/A') + '</div>' +
                    '<div class="col-md-6"><strong>Email:</strong> ' + (supplier.email || 'N/A') + '</div>' +
                    '<div class="col-md-6"><strong>Phone:</strong> ' + (supplier.phone || 'N/A') + '</div>' +
                    '<div class="col-md-12"><strong>Address:</strong> ' + (supplier.address || 'N/A') + '</div>' +
                    '<div class="col-md-4"><strong>City:</strong> ' + (supplier.city || 'N/A') + '</div>' +
                    '<div class="col-md-4"><strong>State:</strong> ' + (supplier.state || 'N/A') + '</div>' +
                    '<div class="col-md-4"><strong>Country:</strong> ' + (supplier.country || 'N/A') + '</div>' +
                    '<div class="col-md-6"><strong>Postal Code:</strong> ' + (supplier.postal_code || 'N/A') + '</div>' +
                    '<div class="col-md-6"><strong>Tax Number:</strong> ' + (supplier.tax_number || 'N/A') + '</div>' +
                    '<div class="col-md-6"><strong>Payment Terms:</strong> ' + (supplier.payment_terms || 'N/A') + '</div>' +
                    '<div class="col-md-6"><strong>Status:</strong> ' + (supplier.is_active ? 'Active' : 'Inactive') + '</div>' +
                    '</div>';
                
                // Create and show modal
                var modal = '<div class="modal fade" id="viewSupplierModal" tabindex="-1" role="dialog">' +
                    '<div class="modal-dialog modal-lg" role="document">' +
                    '<div class="modal-content">' +
                    '<div class="modal-header">' +
                    '<button type="button" class="close" data-dismiss="modal">&times;</button>' +
                    '<h4 class="modal-title"><i class="fa fa-eye"></i> Supplier Details</h4>' +
                    '</div>' +
                    '<div class="modal-body">' + details + '</div>' +
                    '<div class="modal-footer">' +
                    '<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>' +
                    '</div>' +
                    '</div></div></div>';
                
                $('body').append(modal);
                $('#viewSupplierModal').modal('show');
                $('#viewSupplierModal').on('hidden.bs.modal', function() {
                    $(this).remove();
                });
            } else {
                alert('Error: ' + response.error);
            }
        },
        error: function() {
            alert('An error occurred while fetching supplier details.');
        }
    });
}

function editSupplier(id) {
    $.ajax({
        url: '<?php echo base_url("admin/inventory/edit_supplier/"); ?>' + id,
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                var supplier = response.data;
                
                // Create edit modal
                var modal = '<div class="modal fade" id="editSupplierModal" tabindex="-1" role="dialog">' +
                    '<div class="modal-dialog modal-lg" role="document">' +
                    '<div class="modal-content">' +
                    '<div class="modal-header">' +
                    '<button type="button" class="close" data-dismiss="modal">&times;</button>' +
                    '<h4 class="modal-title"><i class="fa fa-edit"></i> Edit Supplier</h4>' +
                    '</div>' +
                    '<form id="editSupplierForm">' +
                    '<input type="hidden" name="supplier_id" value="' + supplier.id + '">' +
                    '<div class="modal-body">' +
                    '<div class="row">' +
                    '<div class="col-md-6">' +
                    '<div class="form-group">' +
                    '<label>Supplier Name <span class="text-danger">*</span></label>' +
                    '<input type="text" class="form-control" name="name" value="' + supplier.name + '" required>' +
                    '</div></div>' +
                    '<div class="col-md-6">' +
                    '<div class="form-group">' +
                    '<label>Contact Person</label>' +
                    '<input type="text" class="form-control" name="contact_person" value="' + (supplier.contact_person || '') + '">' +
                    '</div></div>' +
                    '<div class="col-md-6">' +
                    '<div class="form-group">' +
                    '<label>Email</label>' +
                    '<input type="email" class="form-control" name="email" value="' + (supplier.email || '') + '">' +
                    '</div></div>' +
                    '<div class="col-md-6">' +
                    '<div class="form-group">' +
                    '<label>Phone</label>' +
                    '<input type="text" class="form-control" name="phone" value="' + (supplier.phone || '') + '">' +
                    '</div></div>' +
                    '<div class="col-md-12">' +
                    '<div class="form-group">' +
                    '<label>Address</label>' +
                    '<textarea class="form-control" name="address" rows="3">' + (supplier.address || '') + '</textarea>' +
                    '</div></div>' +
                    '<div class="col-md-4">' +
                    '<div class="form-group">' +
                    '<label>City</label>' +
                    '<input type="text" class="form-control" name="city" value="' + (supplier.city || '') + '">' +
                    '</div></div>' +
                    '<div class="col-md-4">' +
                    '<div class="form-group">' +
                    '<label>State</label>' +
                    '<input type="text" class="form-control" name="state" value="' + (supplier.state || '') + '">' +
                    '</div></div>' +
                    '<div class="col-md-4">' +
                    '<div class="form-group">' +
                    '<label>Country</label>' +
                    '<input type="text" class="form-control" name="country" value="' + (supplier.country || '') + '">' +
                    '</div></div>' +
                    '<div class="col-md-4">' +
                    '<div class="form-group">' +
                    '<label>Postal Code</label>' +
                    '<input type="text" class="form-control" name="postal_code" value="' + (supplier.postal_code || '') + '">' +
                    '</div></div>' +
                    '<div class="col-md-4">' +
                    '<div class="form-group">' +
                    '<label>Tax Number</label>' +
                    '<input type="text" class="form-control" name="tax_number" value="' + (supplier.tax_number || '') + '">' +
                    '</div></div>' +
                    '<div class="col-md-4">' +
                    '<div class="form-group">' +
                    '<label>Payment Terms</label>' +
                    '<select class="form-control" name="payment_terms">' +
                    '<option value="">Select Terms</option>' +
                    '<option value="NET_30"' + (supplier.payment_terms === 'NET_30' ? ' selected' : '') + '>Net 30 Days</option>' +
                    '<option value="NET_15"' + (supplier.payment_terms === 'NET_15' ? ' selected' : '') + '>Net 15 Days</option>' +
                    '<option value="NET_7"' + (supplier.payment_terms === 'NET_7' ? ' selected' : '') + '>Net 7 Days</option>' +
                    '<option value="COD"' + (supplier.payment_terms === 'COD' ? ' selected' : '') + '>Cash on Delivery</option>' +
                    '<option value="ADVANCE"' + (supplier.payment_terms === 'ADVANCE' ? ' selected' : '') + '>Advance Payment</option>' +
                    '</select>' +
                    '</div></div>' +
                    '</div></div>' +
                    '<div class="modal-footer">' +
                    '<button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>' +
                    '<button type="submit" class="btn btn-primary">Update Supplier</button>' +
                    '</div>' +
                    '</form>' +
                    '</div></div></div>';
                
                $('body').append(modal);
                $('#editSupplierModal').modal('show');
                
                // Handle form submission
                $('#editSupplierForm').on('submit', function(e) {
                    e.preventDefault();
                    $.ajax({
                        url: '<?php echo base_url("admin/inventory/edit_supplier"); ?>',
                        type: 'POST',
                        data: $(this).serialize(),
                        dataType: 'json',
                        success: function(response) {
                            if (response.status === 'success') {
                                $('#editSupplierModal').modal('hide');
                                location.reload();
                            } else {
                                alert('Error: ' + response.error);
                            }
                        },
                        error: function() {
                            alert('An error occurred while updating the supplier.');
                        }
                    });
                });
                
                $('#editSupplierModal').on('hidden.bs.modal', function() {
                    $(this).remove();
                });
            } else {
                alert('Error: ' + response.error);
            }
        },
        error: function() {
            alert('An error occurred while fetching supplier data.');
        }
    });
}

function deleteSupplier(id) {
    if (confirm('Are you sure you want to delete this supplier?')) {
        $.ajax({
            url: '<?php echo base_url("admin/inventory/delete_supplier/"); ?>' + id,
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    location.reload();
                } else {
                    alert('Error: ' + response.error);
                }
            },
            error: function() {
                alert('An error occurred while deleting the supplier.');
            }
        });
    }
}
</script>
