<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-cube"></i> View Item Details
        </h1>
    </section>

    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-info-circle"></i> Item Information</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-default btn-sm" onclick="window.close()">
                                <i class="fa fa-times"></i> Close
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if (isset($item) && $item) { ?>
                            <div class="alert alert-success">
                                <i class="fa fa-check"></i> Item found successfully!
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <table class="table table-bordered table-striped">
                                        <tr>
                                            <th width="30%">Item Code:</th>
                                            <td><strong><?php echo isset($item->item_code) ? htmlspecialchars($item->item_code) : 'N/A'; ?></strong></td>
                                        </tr>
                                        <tr>
                                            <th>Item Name:</th>
                                            <td><strong><?php echo isset($item->name) ? htmlspecialchars($item->name) : 'N/A'; ?></strong></td>
                                        </tr>
                                        <tr>
                                            <th>Category:</th>
                                            <td><?php echo isset($item->category_name) ? htmlspecialchars($item->category_name) : 'N/A'; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Unit:</th>
                                            <td><?php echo isset($item->unit) ? htmlspecialchars($item->unit) : 'N/A'; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Current Stock:</th>
                                            <td>
                                                <?php 
                                                $current_stock = isset($item->current_stock) ? (int)$item->current_stock : 0;
                                                $min_stock = isset($item->minimum_stock) ? (int)$item->minimum_stock : 0;
                                                if ($current_stock <= 0) {
                                                    $badge_class = 'bg-red';
                                                    $status = 'Out of Stock';
                                                } elseif ($current_stock <= $min_stock) {
                                                    $badge_class = 'bg-yellow';
                                                    $status = 'Low Stock';
                                                } else {
                                                    $badge_class = 'bg-green';
                                                    $status = 'In Stock';
                                                }
                                                ?>
                                                <span class="badge <?php echo $badge_class; ?>">
                                                    <?php echo $current_stock; ?> (<?php echo $status; ?>)
                                                </span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>Minimum Stock Level:</th>
                                            <td><?php echo isset($item->minimum_stock) ? (int)$item->minimum_stock : 'N/A'; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Description:</th>
                                            <td><?php echo isset($item->description) ? htmlspecialchars($item->description) : 'N/A'; ?></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        <?php } else { ?>
                            <div class="alert alert-warning">
                                <i class="fa fa-exclamation-triangle"></i> Item not found or no data available.
                            </div>
                        <?php } ?>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <h4><i class="fa fa-history"></i> Recent Stock Movements</h4>
                                <?php if (isset($recent_movements) && !empty($recent_movements)) { ?>
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>Date</th>
                                                    <th>Type</th>
                                                    <th>Quantity</th>
                                                    <th>Reference</th>
                                                    <th>Staff</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($recent_movements as $movement) { ?>
                                                    <tr>
                                                        <td><?php echo isset($movement->movement_date) ? date('Y-m-d', strtotime($movement->movement_date)) : 'N/A'; ?></td>
                                                        <td>
                                                            <span class="label <?php echo ($movement->movement_type == 'IN') ? 'label-success' : 'label-danger'; ?>">
                                                                <?php echo isset($movement->movement_type) ? $movement->movement_type : 'N/A'; ?>
                                                            </span>
                                                        </td>
                                                        <td><?php echo isset($movement->quantity) ? $movement->quantity : 'N/A'; ?></td>
                                                        <td><?php echo isset($movement->reference_number) ? htmlspecialchars($movement->reference_number) : 'N/A'; ?></td>
                                                        <td><?php echo isset($movement->staff_name) ? htmlspecialchars($movement->staff_name) : 'N/A'; ?></td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                <?php } else { ?>
                                    <div class="alert alert-info">
                                        <i class="fa fa-info-circle"></i> No recent stock movements found.
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
