<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-file-text"></i> Receipt Templates
            <small>Manage receipt templates</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Receipt Templates</li>
        </ol>
    </section>

    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <?php if ($this->session->flashdata('msg')) { ?>
                    <?php echo $this->session->flashdata('msg'); ?>
                <?php } ?>

                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Receipt Templates</h3>
                        <div class="box-tools pull-right">
                            <a href="<?php echo base_url(); ?>admin/simple_receipt/create" class="btn btn-primary btn-sm">
                                <i class="fa fa-plus"></i> Add New Template
                            </a>
                        </div>
                    </div>

                    <div class="box-body">
                        <?php if (!empty($templates)) { ?>
                            <div class="table-responsive">
                                <table class="table table-striped table-bordered table-hover">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Template Name</th>
                                            <th>Template Code</th>
                                            <th>Status</th>
                                            <th>Created Date</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($templates as $template) { ?>
                                            <tr>
                                                <td><?php echo $template->id; ?></td>
                                                <td><?php echo $template->template_name; ?></td>
                                                <td><code><?php echo $template->template_code; ?></code></td>
                                                <td>
                                                    <?php if ($template->is_active) { ?>
                                                        <span class="label label-success">Active</span>
                                                    <?php } else { ?>
                                                        <span class="label label-danger">Inactive</span>
                                                    <?php } ?>
                                                </td>
                                                <td><?php echo date('d-m-Y H:i', strtotime($template->created_at)); ?></td>
                                                <td>
                                                    <a href="<?php echo base_url(); ?>admin/simple_receipt/preview/<?php echo $template->id; ?>" 
                                                       class="btn btn-info btn-xs" target="_blank" title="Preview">
                                                        <i class="fa fa-eye"></i>
                                                    </a>
                                                    <a href="<?php echo base_url(); ?>admin/simple_receipt/edit/<?php echo $template->id; ?>" 
                                                       class="btn btn-warning btn-xs" title="Edit">
                                                        <i class="fa fa-edit"></i>
                                                    </a>
                                                    <?php if ($template->is_active) { ?>
                                                        <a href="<?php echo base_url(); ?>admin/simple_receipt/toggle_status/<?php echo $template->id; ?>" 
                                                           class="btn btn-success btn-xs" title="Deactivate Template"
                                                           onclick="return confirm('Are you sure you want to deactivate this template?')">
                                                            <i class="fa fa-toggle-on"></i>
                                                        </a>
                                                    <?php } else { ?>
                                                        <a href="<?php echo base_url(); ?>admin/simple_receipt/toggle_status/<?php echo $template->id; ?>" 
                                                           class="btn btn-default btn-xs" title="Activate Template"
                                                           onclick="return confirm('Are you sure you want to activate this template?')">
                                                            <i class="fa fa-toggle-off"></i>
                                                        </a>
                                                    <?php } ?>
                                                    <a href="<?php echo base_url(); ?>admin/simple_receipt/delete/<?php echo $template->id; ?>" 
                                                       class="btn btn-danger btn-xs" title="Delete Template"
                                                       onclick="return confirm('Are you sure you want to delete this template? This action cannot be undone.')">
                                                        <i class="fa fa-trash"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php } else { ?>
                            <div class="alert alert-info">
                                <i class="fa fa-info-circle"></i> No receipt templates found. <a href="<?php echo base_url(); ?>admin/simple_receipt/create">Create your first template</a>.
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
