<style type="text/css">
    .checkbox-inline+.checkbox-inline, .radio-inline+.radio-inline {
        margin-left: 8px;
    }
    
    /* Pulse animation for Multi-Group Receipt button */
    @keyframes pulse {
        0% {
            transform: scale(1);
            box-shadow: 0 0 0 0 rgba(91, 192, 222, 0.7);
        }
        70% {
            transform: scale(1.05);
            box-shadow: 0 0 0 10px rgba(91, 192, 222, 0);
        }
        100% {
            transform: scale(1);
            box-shadow: 0 0 0 0 rgba(91, 192, 222, 0);
        }
    }
    
    .printMultiGroupReceiptBtn:hover {
        transform: scale(1.1) !important;
        transition: all 0.3s ease;
        box-shadow: 0 4px 15px rgba(91, 192, 222, 0.4) !important;
    }
    
    /* Standard Layout Integration */
    .content-wrapper {
        background: #ecf0f5;
        min-height: 100vh;
    }
    
    .content-header {
        padding: 12px;
        margin: 0;
        background: white;
        border-bottom: 1px solid #d2d6de;
    }
    
    .content {
        padding: 12px;
    }
    
    .fee-header {
        background: linear-gradient(135deg, #3c8dbc 0%, #2c5aa0 100%);
        color: white;
        padding: 16px;
        border-radius: 6px;
        margin-bottom: 16px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }
    
    .fee-header h1 {
        margin: 0;
        font-size: 20px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 8px;
    }
    
    .student-card {
        background: white;
        border-radius: 3px;
        box-shadow: 0 1px 3px rgba(0,0,0,0.12), 0 1px 2px rgba(0,0,0,0.24);
        margin-bottom: 16px;
        overflow: hidden;
        border-top: 3px solid #3c8dbc;
    }
    
    .student-info {
        background: linear-gradient(135deg, #00c0ef 0%, #0073b7 100%);
        color: white;
        padding: 20px;
    }
    
    .student-profile {
        display: flex;
        align-items: flex-start;
        gap: 24px;
        padding: 0;
    }
    
    .student-avatar {
        width: 96px;
        height: 96px;
        border-radius: 50%;
        border: 3px solid white;
        object-fit: cover;
        box-shadow: 0 3px 12px rgba(0,0,0,0.2);
        flex-shrink: 0;
    }
    
    .student-details {
        flex: 1;
    }
    
    .student-details h2 {
        margin: 0 0 16px 0;
        font-size: 22px;
        font-weight: 700;
        text-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    
    .info-row {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 16px;
        margin-top: 0;
    }
    
    .info-item {
        background: rgba(255,255,255,0.15);
        padding: 12px;
        border-radius: 6px;
        border-left: 3px solid rgba(255,255,255,0.5);
        transition: all 0.3s ease;
    }
    
    .info-item:hover {
        background: rgba(255,255,255,0.25);
        transform: translateY(-2px);
    }
    
    .info-label {
        font-size: 10px;
        opacity: 0.8;
        text-transform: uppercase;
        letter-spacing: 1px;
        margin-bottom: 6px;
        font-weight: 500;
    }
    
    .info-value {
        font-size: 14px;
        font-weight: 700;
        line-height: 1.2;
    }
    
    .fee-summary-section {
        padding: 16px;
        background: #f9f9f9;
        border-bottom: 1px solid #eee;
    }
    
    .fee-summary-cards {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 16px;
        margin-bottom: 16px;
    }
    
    .fee-summary-card {
        background: white;
        padding: 12px;
        border-radius: 5px;
        text-align: center;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        border-top: 3px solid;
        transition: transform 0.3s ease;
    }
    
    .fee-summary-card:hover {
        transform: translateY(-3px);
    }
    
    .fee-summary-card.total {
        border-top-color: #3c8dbc;
    }
    
    .fee-summary-card.paid {
        border-top-color: #00a65a;
    }
    
    .fee-summary-card.pending {
        border-top-color: #f39c12;
    }
    
    .fee-summary-icon {
        font-size: 16px;
        margin-bottom: 6px;
    }
    
    .fee-summary-card.total .fee-summary-icon {
        color: #3c8dbc;
    }
    
    .fee-summary-card.paid .fee-summary-icon {
        color: #00a65a;
    }
    
    .fee-summary-card.pending .fee-summary-icon {
        color: #f39c12;
    }
    
    .fee-summary-amount {
        font-size: 16px;
        font-weight: 700;
        margin-bottom: 3px;
    }
    
    .fee-summary-label {
        font-size: 9px;
        color: #666;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    /* Modern Collection Popup Styles */
    .swal2-popup {
        border-radius: 15px;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    
    .swal2-title {
        color: #3c8dbc;
        font-weight: 600;
    }
    
    .swal2-content {
        color: #666;
    }
    
    .swal2-confirm {
        background: #00a65a !important;
        border-radius: 25px;
        padding: 10px 25px;
        font-weight: 600;
    }
    
    .swal2-cancel {
        background: #dd4b39 !important;
        border-radius: 25px;
        padding: 10px 25px;
        font-weight: 600;
    }
    
    .collection-success {
        animation: pulse 0.6s ease-in-out;
    }
    
    @keyframes pulse {
        0% { transform: scale(1); }
        50% { transform: scale(1.05); }
        100% { transform: scale(1); }
    }
    
    .loading-spinner {
        border: 3px solid #f3f3f3;
        border-top: 3px solid #3c8dbc;
        border-radius: 50%;
        width: 20px;
        height: 20px;
        animation: spin 1s linear infinite;
        display: inline-block;
        margin-right: 10px;
    }
    
    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    .actions-section {
        padding: 16px;
        background: white;
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 12px;
    }
    
    .btn-modern {
        padding: 8px 16px;
        border: none;
        border-radius: 4px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 6px;
        font-size: 12px;
    }
    
    .btn-success {
        background: #00a65a;
        color: white;
    }
    
    .btn-success:hover {
        background: #008d4c;
        color: white;
    }
    
    .btn-primary {
        background: #3c8dbc;
        color: white;
    }
    
    .btn-primary:hover {
        background: #2c5aa0;
        color: white;
    }
    
    .btn-info {
        background: #00c0ef;
        color: white;
    }
    
    .btn-info:hover {
        background: #00acd6;
        color: white;
    }
    
    .btn-warning {
        background: #f39c12;
        color: white;
    }
    
    .btn-warning:hover {
        background: #e08e0b;
        color: white;
    }
    
    .fee-table-section {
        background: white;
        border-radius: 3px;
        box-shadow: 0 1px 3px rgba(0,0,0,0.12), 0 1px 2px rgba(0,0,0,0.24);
        overflow: hidden;
        border-top: 3px solid #3c8dbc;
    }
    
    .table-header {
        background: #3c8dbc;
        color: white;
        padding: 15px 20px;
        font-weight: 600;
        font-size: 16px;
    }
    
    .table-responsive {
        overflow-x: auto;
    }
    
    .fee-table {
        width: 100%;
        margin: 0;
        border-collapse: collapse;
    }
    
    .fee-table th {
        background: #f9f9f9;
        padding: 12px 8px;
        font-weight: 600;
        font-size: 12px;
        color: #333;
        border-bottom: 2px solid #ddd;
        text-align: left;
    }
    
    .fee-table td {
        padding: 12px 8px;
        border-bottom: 1px solid #eee;
        font-size: 13px;
        vertical-align: middle;
    }
    
    .fee-table tr:hover {
        background: #f9f9f9;
    }
    
    .status-badge {
        padding: 4px 8px;
        border-radius: 12px;
        font-size: 10px;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .status-paid {
        background: #d4edda;
        color: #155724;
    }
    
    .status-unpaid {
        background: #f8d7da;
        color: #721c24;
    }
    
    .status-partial {
        background: #fff3cd;
        color: #856404;
    }
    
    .amount-text {
        font-weight: 600;
        color: #333;
    }
    
    .btn-sm {
        padding: 6px 12px;
        font-size: 11px;
        border-radius: 3px;
    }
    
    .total-row {
        background: #3c8dbc;
        color: white;
        font-weight: 700;
    }
    
    .total-row td {
        border: none;
        padding: 15px 8px;
    }
    
    .back-section {
        text-align: center;
        margin-top: 20px;
    }
    
    /* Mobile Responsive */
    @media (max-width: 768px) {
        .content-wrapper {
            padding: 10px;
            padding-top: 60px;
        }
        
        .student-profile {
            flex-direction: column;
            text-align: center;
            gap: 20px;
            align-items: center;
        }
        
        .student-avatar {
            width: 100px;
            height: 100px;
        }
        
        .student-details h2 {
            font-size: 24px;
            text-align: center;
        }
        
        .info-row {
            grid-template-columns: 1fr;
            gap: 15px;
        }
        
        .fee-summary-cards {
            grid-template-columns: 1fr;
            gap: 15px;
        }
        
        .actions-section {
            flex-direction: column;
            align-items: stretch;
        }
        
        .btn-modern {
            justify-content: center;
        }
        
        .fee-table th,
        .fee-table td {
            padding: 8px 4px;
            font-size: 11px;
        }
        
        .fee-header h1 {
            font-size: 20px;
        }
    }
    
    @media (max-width: 480px) {
        .fee-table {
            font-size: 10px;
        }
        
        .fee-table th,
        .fee-table td {
            padding: 6px 3px;
        }
        
        .btn-modern {
            padding: 8px 16px;
            font-size: 12px;
        }
        
        .info-row {
            grid-template-columns: 1fr;
            gap: 12px;
        }
        
        .student-details h2 {
            font-size: 20px;
        }
        
        .student-avatar {
            width: 80px;
            height: 80px;
        }
    }
</style>

<?php
$currency_symbol = $this->customlib->getSchoolCurrencyFormat();
$language = $this->customlib->getLanguage();
$language_name = $language["short_code"];
?>

<!-- Content Wrapper -->
<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <h1>
            <i class="fa fa-credit-card"></i> Student Fee Management
            <small>Manage and collect student fee payments</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>studentfee">Student Fees</a></li>
            <li class="active">Collect Fees</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">

    <!-- Student Information Card -->
    <div class="student-card">
        <div class="student-info">
            <div class="student-profile">
                <img class="student-avatar" src="<?php
                    if (!empty($student["image"])) {
                        echo $this->media_storage->getImageURL($student["image"]);
                    } else {
                        if ($student['gender'] == 'Female') {
                            echo $this->media_storage->getImageURL("uploads/student_images/default_female.jpg");
                        } else {
                            echo $this->media_storage->getImageURL("uploads/student_images/default_male.jpg");
                        }
                    }
                ?>" alt="Student Photo">
                
                <div class="student-details">
                    <h2><?php echo $this->customlib->getFullName($student['firstname'], $student['middlename'], $student['lastname'], $sch_setting->middlename, $sch_setting->lastname); ?></h2>
                    
                    <div class="info-row">
                        <div class="info-item">
                            <div class="info-label">Class & Section</div>
                            <div class="info-value"><?php echo $student['class'] . " (" . $student['section'] . ")"; ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Admission No</div>
                            <div class="info-value"><?php echo $student['admission_no']; ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Roll Number</div>
                            <div class="info-value"><?php echo $student['roll_no']; ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Father Name</div>
                            <div class="info-value"><?php echo $student['father_name']; ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Mobile</div>
                            <div class="info-value"><?php echo $student['mobileno']; ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Category</div>
                            <div class="info-value">
                                <?php
                                foreach ($categorylist as $value) {
                                    if ($student['category_id'] == $value['id']) {
                                        echo $value['category'];
                                    }
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Fee Summary Cards -->
        <div class="fee-summary-section">
            <?php
            // Calculate totals first
            $summary_total_amount = 0;
            $summary_deposite_amount = 0;
            $summary_balance_amount = 0;
            
            foreach ($student_due_fee as $key => $fee) {
                foreach ($fee->fees as $fee_key => $fee_value) {
                    $fee_paid = 0;
                    $fee_discount = 0;
                    
                    if (!empty($fee_value->amount_detail)) {
                        $fee_deposits = json_decode($fee_value->amount_detail);
                        foreach ($fee_deposits as $deposit) {
                            $fee_paid += $deposit->amount;
                            $fee_discount += $deposit->amount_discount;
                        }
                    }
                    
                    $summary_total_amount += $fee_value->amount;
                    $summary_deposite_amount += $fee_paid;
                    $feetype_balance = $fee_value->amount - ($fee_paid + $fee_discount);
                    $summary_balance_amount += $feetype_balance;
                }
            }
            ?>
            <div class="fee-summary-cards">
                <div class="fee-summary-card total">
                    <div class="fee-summary-icon">
                        <i class="fa fa-calculator"></i>
                    </div>
                    <div class="fee-summary-amount"><?php echo $currency_symbol . amountFormat($summary_total_amount); ?></div>
                    <div class="fee-summary-label">Total Fees</div>
                </div>
                
                <div class="fee-summary-card paid">
                    <div class="fee-summary-icon">
                        <i class="fa fa-check-circle"></i>
                    </div>
                    <div class="fee-summary-amount"><?php echo $currency_symbol . amountFormat($summary_deposite_amount); ?></div>
                    <div class="fee-summary-label">Paid Amount</div>
                </div>
                
                <div class="fee-summary-card pending">
                    <div class="fee-summary-icon">
                        <i class="fa fa-clock-o"></i>
                    </div>
                    <div class="fee-summary-amount"><?php echo $currency_symbol . amountFormat($summary_balance_amount); ?></div>
                    <div class="fee-summary-label">Pending Amount</div>
                </div>
            </div>
        </div>
        
        <!-- Actions Bar -->
        <div class="actions-section">
            <div>
                <?php if ($this->rbac->hasPrivilege('collect_fees', 'can_add')) { ?>
                <button class="btn-modern btn-success collectSelected">
                    <i class="fa fa-credit-card"></i> Collect Selected Fees
                </button>
                <button class="btn-modern btn-info printMultiGroupReceiptBtn" style="margin-left: 10px; animation: pulse 2s infinite;">
                    <i class="fa fa-files-o"></i> Multi-Group Receipt
                </button>
                <?php } ?>
                
                <?php if ($student_processing_fee) { ?>
                <button class="btn-modern btn-info getProcessingfees">
                    <i class="fa fa-cogs"></i> Processing Fees
                </button>
                <?php } ?>
            </div>
            
            <div>
                <strong>Date:</strong> <?php echo date($this->customlib->getSchoolDateFormat()); ?>
            </div>
        </div>
    </div>

    <!-- Fee Table -->
    <div class="fee-table-section">
        <div class="table-header">
            <i class="fa fa-table"></i> Fee Details
        </div>
        
        <div class="table-responsive">
            <table class="fee-table">
                <thead>
                    <tr>
                        <th style="width: 30px;"><input type="checkbox" id="select_all"></th>
                        <th>Fee Group</th>
                        <th>Fee Code</th>
                        <th>Due Date</th>
                        <th>Status</th>
                        <th>Amount (<?php echo $currency_symbol; ?>)</th>
                        <th>Discount (<?php echo $currency_symbol; ?>)</th>
                        <th>Fine (<?php echo $currency_symbol; ?>)</th>
                        <th>Paid (<?php echo $currency_symbol; ?>)</th>
                        <th>Balance (<?php echo $currency_symbol; ?>)</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $total_amount = 0;
                    $total_deposite_amount = 0;
                    $total_fine_amount = 0;
                    $total_discount_amount = 0;
                    $total_balance_amount = 0;
                    
                    foreach ($student_due_fee as $key => $fee) {
                        foreach ($fee->fees as $fee_key => $fee_value) {
                            $fee_paid = 0;
                            $fee_discount = 0;
                            $fee_fine = 0;
                            $feetype_balance = 0;
                            
                            if (!empty($fee_value->amount_detail)) {
                                $fee_deposits = json_decode($fee_value->amount_detail);
                                foreach ($fee_deposits as $deposit) {
                                    $fee_paid += $deposit->amount;
                                    $fee_discount += $deposit->amount_discount;
                                    $fee_fine += $deposit->amount_fine;
                                }
                            }
                            
                            $total_amount += $fee_value->amount;
                            $total_discount_amount += $fee_discount;
                            $total_deposite_amount += $fee_paid;
                            $total_fine_amount += $fee_fine;
                            $feetype_balance = $fee_value->amount - ($fee_paid + $fee_discount);
                            $total_balance_amount += $feetype_balance;
                    ?>
                    <tr>
                        <td>
                            <input type="checkbox" name="fee_checkbox" 
                                   data-fee_master_id="<?php echo $fee_value->id ?>" 
                                   data-fee_session_group_id="<?php echo $fee_value->fee_session_group_id ?>" 
                                   data-fee_groups_feetype_id="<?php echo $fee_value->fee_groups_feetype_id ?>" 
                                   data-fee_category="fees" 
                                   data-trans_fee_id="0"
                                   data-student_fees_master_id="<?php echo $fee_value->id ?>"
                                   data-feecategory="fees">
                        </td>
                        <td>
                            <?php 
                            if ($fee_value->is_system) {
                                echo $this->lang->line($fee_value->name) . " (" . $this->lang->line($fee_value->type) . ")";
                            } else {
                                echo $fee_value->name . " (" . $fee_value->type . ")";
                            }
                            ?>
                        </td>
                        <td>
                            <?php 
                            if ($fee_value->is_system) {
                                echo $this->lang->line($fee_value->code);
                            } else {
                                echo $fee_value->code;
                            }
                            ?>
                        </td>
                        <td>
                            <?php 
                            if ($fee_value->due_date != "0000-00-00" && $fee_value->due_date) {
                                echo date($this->customlib->getSchoolDateFormat(), $this->customlib->dateyyyymmddTodateformat($fee_value->due_date));
                            }
                            ?>
                        </td>
                        <td>
                            <?php if ($feetype_balance == 0 && $fee_paid > 0) { ?>
                                <span class="status-badge status-paid">Paid</span>
                            <?php } elseif ($fee_paid > 0 && $feetype_balance > 0) { ?>
                                <span class="status-badge status-partial">Partial</span>
                            <?php } else { ?>
                                <span class="status-badge status-unpaid">Unpaid</span>
                            <?php } ?>
                        </td>
                        <td class="amount-text"><?php echo amountFormat($fee_value->amount); ?></td>
                        <td class="amount-text"><?php echo amountFormat($fee_discount); ?></td>
                        <td class="amount-text"><?php echo amountFormat($fee_fine); ?></td>
                        <td class="amount-text"><?php echo amountFormat($fee_paid); ?></td>
                        <td class="amount-text"><?php echo amountFormat($feetype_balance); ?></td>
                        <td>
                            <?php if ($this->rbac->hasPrivilege('collect_fees', 'can_edit') && $fee_paid > 0) { ?>
                            <button type="button" class="btn-modern btn-sm btn-warning myRefundFeeBtn" 
                                    data-student_session_id="<?php echo $fee->student_session_id; ?>"
                                    data-student_fees_master_id="<?php echo $fee->id; ?>"
                                    data-fee_groups_feetype_id="<?php echo $fee_value->fee_groups_feetype_id; ?>"
                                    data-group="<?php echo ($fee_value->is_system) ? $this->lang->line($fee_value->name) . ' (' . $this->lang->line($fee_value->type) . ')' : $fee_value->name . ' (' . $fee_value->type . ')'; ?>"
                                    data-type="<?php echo ($fee_value->is_system) ? $this->lang->line($fee_value->type) : $fee_value->code; ?>"
                                    data-paid_amount="<?php echo $fee_paid; ?>"
                                    data-feecategory="fees" 
                                    data-trans_fee_id="0">
                                <i class="fa fa-undo"></i> Refund
                            </button>
                            <button type="button" class="btn-modern btn-sm btn-success printReceiptBtn" 
                                    data-student_session_id="<?php echo $fee->student_session_id; ?>"
                                    data-student_fees_master_id="<?php echo $fee->id; ?>"
                                    data-fee_groups_feetype_id="<?php echo $fee_value->fee_groups_feetype_id; ?>"
                                    data-group="<?php echo ($fee_value->is_system) ? $this->lang->line($fee_value->name) . ' (' . $this->lang->line($fee_value->type) . ')' : $fee_value->name . ' (' . $fee_value->type . ')'; ?>"
                                    data-paid_amount="<?php echo $fee_paid; ?>"
                                    data-fee_code="<?php echo ($fee_value->is_system) ? $this->lang->line($fee_value->code) : $fee_value->code; ?>">
                                <i class="fa fa-print"></i> Print Receipt
                            </button>
                            <?php } ?>
                        </td>
                    </tr>
                    <?php
                        }
                    }
                    ?>
                    
                    <!-- Transport Fees Section -->
                    <?php
                    // Debug: Check if transport module is active and transport fees exist
                    if (empty($transport_fees)) {
                        // Show debug info if no transport fees found
                        echo "<!-- DEBUG: Transport fees empty. Student route_pickup_point_id: " . (isset($student['route_pickup_point_id']) ? $student['route_pickup_point_id'] : 'NULL') . " -->";
                    }
                    
                    if (!empty($transport_fees)) {
                        foreach ($transport_fees as $transport_key => $transport_fee) {
                            $transport_paid = 0;
                            $transport_discount = 0;
                            $transport_fine = 0;
                            
                            if (!empty($transport_fee->amount_detail)) {
                                $transport_deposits = json_decode($transport_fee->amount_detail);
                                foreach ($transport_deposits as $deposit) {
                                    $transport_paid += $deposit->amount;
                                    $transport_discount += $deposit->amount_discount;
                                    $transport_fine += $deposit->amount_fine;
                                }
                            }
                            
                            $total_amount += $transport_fee->fees;
                            $total_deposite_amount += $transport_paid;
                            $total_discount_amount += $transport_discount;
                            $total_fine_amount += $transport_fine;
                            $transport_balance = $transport_fee->fees - ($transport_paid + $transport_discount);
                            $total_balance_amount += $transport_balance;
                    ?>
                    <tr>
                        <td>
                            <input type="checkbox" name="fee_checkbox" 
                                   data-fee_master_id="0" 
                                   data-fee_session_group_id="0" 
                                   data-fee_groups_feetype_id="0" 
                                   data-fee_category="transport" 
                                   data-trans_fee_id="<?php echo $transport_fee->id; ?>"
                                   data-student_fees_master_id="0"
                                   data-feecategory="transport">
                        </td>
                        <td>Transport Fees</td>
                        <td><?php echo $transport_fee->month; ?></td>
                        <td>
                            <?php 
                            if ($transport_fee->due_date != "0000-00-00" && $transport_fee->due_date) {
                                echo date($this->customlib->getSchoolDateFormat(), $this->customlib->dateyyyymmddTodateformat($transport_fee->due_date));
                            }
                            ?>
                        </td>
                        <td>
                            <?php if ($transport_balance == 0 && $transport_paid > 0) { ?>
                                <span class="status-badge status-paid">Paid</span>
                            <?php } elseif ($transport_paid > 0 && $transport_balance > 0) { ?>
                                <span class="status-badge status-partial">Partial</span>
                            <?php } else { ?>
                                <span class="status-badge status-unpaid">Unpaid</span>
                            <?php } ?>
                        </td>
                        <td class="amount-text"><?php echo amountFormat($transport_fee->fees); ?></td>
                        <td class="amount-text"><?php echo amountFormat($transport_discount); ?></td>
                        <td class="amount-text"><?php echo amountFormat($transport_fine); ?></td>
                        <td class="amount-text"><?php echo amountFormat($transport_paid); ?></td>
                        <td class="amount-text"><?php echo amountFormat($transport_balance); ?></td>
                        <td>
                            <?php if ($this->rbac->hasPrivilege('collect_fees', 'can_edit') && $transport_paid > 0) { ?>
                            <button type="button" class="btn-modern btn-sm btn-warning myRefundFeeBtn" 
                                    data-student_session_id="<?php echo $student['student_session_id']; ?>"
                                    data-student_fees_master_id="0"
                                    data-fee_groups_feetype_id="0"
                                    data-group="Transport Fees"
                                    data-type="<?php echo $transport_fee->month; ?>"
                                    data-paid_amount="<?php echo $transport_paid; ?>"
                                    data-feecategory="transport" 
                                    data-trans_fee_id="<?php echo $transport_fee->id; ?>">
                                <i class="fa fa-undo"></i> Refund
                            </button>
                            <button type="button" class="btn-modern btn-sm btn-success printReceiptBtn" 
                                    data-student_session_id="<?php echo $student['student_session_id']; ?>"
                                    data-student_fees_master_id="0"
                                    data-fee_groups_feetype_id="0"
                                    data-group="Transport Fees"
                                    data-paid_amount="<?php echo $transport_paid; ?>"
                                    data-fee_code="<?php echo $transport_fee->month; ?>">
                                <i class="fa fa-print"></i> Print Receipt
                            </button>
                            <?php } ?>
                        </td>
                    </tr>
                    <?php
                        }
                    } else {
                        // Show message if no transport fees are assigned
                        if (isset($student['route_pickup_point_id']) && empty($student['route_pickup_point_id'])) {
                    ?>
                    <tr>
                        <td colspan="11" style="text-align: center; padding: 20px; background: #f8f9fa; color: #666; font-style: italic;">
                            <i class="fa fa-bus"></i> No transport route assigned to this student. 
                            <br><small>To add transport fees, please assign a transport route to the student first.</small>
                        </td>
                    </tr>
                    <?php
                        } elseif (empty($transport_fees)) {
                    ?>
                    <tr>
                        <td colspan="11" style="text-align: center; padding: 20px; background: #f8f9fa; color: #666; font-style: italic;">
                            <i class="fa fa-bus"></i> No transport fees found for this student.
                            <br><small>Transport fees will appear here once assigned.</small>
                        </td>
                    </tr>
                    <?php
                        }
                    }
                    ?>
                    
                    <!-- Grand Total Row -->
                    <tr class="total-row">
                        <td colspan="5"><strong>Grand Total</strong></td>
                        <td><strong><?php echo $currency_symbol . amountFormat($total_amount); ?></strong></td>
                        <td><strong><?php echo $currency_symbol . amountFormat($total_discount_amount); ?></strong></td>
                        <td><strong><?php echo $currency_symbol . amountFormat($total_fine_amount); ?></strong></td>
                        <td><strong><?php echo $currency_symbol . amountFormat($total_deposite_amount); ?></strong></td>
                        <td><strong><?php echo $currency_symbol . amountFormat($total_balance_amount); ?></strong></td>
                        <td></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    
    <!-- Back Button -->
    <div class="back-section">
        <a href="<?php echo base_url() ?>studentfee" class="btn-modern btn-primary">
            <i class="fa fa-arrow-left"></i> Back to Fee List
        </a>
    </div>
    
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<!-- Fee Refund Modal -->
<div class="modal fade" id="myRefundModal" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title refund_title"><i class="fa fa-undo"></i> Fee Refund</h4>
            </div>
            <div class="modal-body">
                <form class="form-horizontal">
                    <input type="hidden" id="refund_std_id" value="<?php echo $student["student_session_id"]; ?>"/>
                    <input type="hidden" id="refund_student_fees_master_id" value=""/>
                    <input type="hidden" id="refund_fee_groups_feetype_id" value=""/>
                    <input type="hidden" id="refund_fee_category" value=""/>
                    <input type="hidden" id="refund_transport_fees_id" value="0"/>
                    
                    <div class="form-group">
                        <label class="col-sm-3 control-label">Fee Group:</label>
                        <div class="col-sm-9">
                            <p class="form-control-static refund_fee_group"></p>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="col-sm-3 control-label">Paid Amount:</label>
                        <div class="col-sm-9">
                            <p class="form-control-static"><?php echo $currency_symbol; ?><span id="refund_paid_amount">0.00</span></p>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="col-sm-3 control-label">Refund Amount <span class="text-danger">*</span>:</label>
                        <div class="col-sm-9">
                            <input type="number" class="form-control" id="refund_amount" min="0" step="0.01" placeholder="Enter refund amount">
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="col-sm-3 control-label">Refund Date <span class="text-danger">*</span>:</label>
                        <div class="col-sm-9">
                            <input type="date" class="form-control" id="refund_date" value="<?php echo date('Y-m-d'); ?>">
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="col-sm-3 control-label">Refund Mode:</label>
                        <div class="col-sm-9">
                            <div class="radio-inline">
                                <label><input type="radio" name="refund_mode" value="Cash" checked> Cash</label>
                            </div>
                            <div class="radio-inline">
                                <label><input type="radio" name="refund_mode" value="Cheque"> Cheque</label>
                            </div>
                            <div class="radio-inline">
                                <label><input type="radio" name="refund_mode" value="Bank Transfer"> Bank Transfer</label>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="col-sm-3 control-label">Reason <span class="text-danger">*</span>:</label>
                        <div class="col-sm-9">
                            <textarea class="form-control" id="refund_reason" rows="3" placeholder="Enter reason for refund"></textarea>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-warning refund_button">
                    <i class="fa fa-undo"></i> Process Refund
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Fee Collection Modal -->
<div class="modal fade" id="myFeesModal" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title fees_title"></h4>
            </div>
            <div class="modal-body">
                <form class="form-horizontal">
                    <input type="hidden" id="std_id" value="<?php echo $student["student_session_id"]; ?>"/>
                    <input type="hidden" id="student_fees_master_id" value="0"/>
                    <input type="hidden" id="fee_groups_feetype_id" value="0"/>
                    <input type="hidden" id="transport_fees_id" value="0"/>
                    <input type="hidden" id="fee_category" value=""/>
                    
                    <div class="form-group">
                        <label class="col-sm-3 control-label">Date *</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" id="date" value="<?php echo date($this->customlib->getSchoolDateFormat()); ?>" readonly/>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="col-sm-3 control-label">Amount (<?php echo $currency_symbol; ?>) *</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" id="amount" value="0"/>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="col-sm-3 control-label">Discount (<?php echo $currency_symbol; ?>)</label>
                        <div class="col-sm-4">
                            <input type="text" class="form-control" id="amount_discount" value="0"/>
                        </div>
                        <label class="col-sm-2 control-label">Fine (<?php echo $currency_symbol; ?>)</label>
                        <div class="col-sm-3">
                            <input type="text" class="form-control" id="amount_fine" value="0"/>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="col-sm-3 control-label">Payment Mode</label>
                        <div class="col-sm-9">
                            <label class="radio-inline">
                                <input type="radio" name="payment_mode_fee" value="Cash" checked> Cash
                            </label>
                            <label class="radio-inline">
                                <input type="radio" name="payment_mode_fee" value="Cheque"> Cheque
                            </label>
                            <label class="radio-inline">
                                <input type="radio" name="payment_mode_fee" value="DD"> DD
                            </label>
                            <label class="radio-inline">
                                <input type="radio" name="payment_mode_fee" value="bank_transfer"> Bank Transfer
                            </label>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="col-sm-3 control-label">Note</label>
                        <div class="col-sm-9">
                            <textarea class="form-control" id="description" rows="3"></textarea>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-success save_button" data-action="collect">
                    <?php echo $currency_symbol; ?> Collect Fees
                </button>
            </div>
        </div>
    </div>
</div>

<script src="<?php echo base_url(); ?>backend/plugins/jQuery/jquery-2.2.3.min.js"></script>
<script src="<?php echo base_url(); ?>backend/bootstrap/js/bootstrap.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.jsdelivr.net/npm/qrcode@1.5.3/build/qrcode.min.js"></script>

<script>
$(document).ready(function() {
    // Select all checkbox functionality
    $('#select_all').click(function() {
        $('input[name="fee_checkbox"]').prop('checked', this.checked);
    });
    
    // Collect Selected Fees with actual backend processing
    $('.collectSelected').click(function() {
        var selectedFees = [];
        var totalAmount = 0;
        var feeData = [];
        
        $('input[name="fee_checkbox"]:checked').each(function() {
            var row = $(this).closest('tr');
            var feeGroup = row.find('td:nth-child(2)').text().trim();
            var balance = parseFloat(row.find('td:nth-child(10)').text().replace(/[^\d.-]/g, ''));
            
            if (balance > 0) {
                selectedFees.push({
                    group: feeGroup,
                    balance: balance
                });
                totalAmount += balance;
                
                // Collect fee data for backend processing
                feeData.push({
                    fee_master_id: $(this).data('student_fees_master_id'),
                    fee_session_group_id: $(this).data('fee_session_group_id'),
                    fee_groups_feetype_id: $(this).data('fee_groups_feetype_id'),
                    amount: balance,
                    fee_category: $(this).data('feecategory'),
                    trans_fee_id: $(this).data('trans_fee_id') || 0
                });
            }
        });
        
        if (selectedFees.length === 0) {
            Swal.fire({
                icon: 'warning',
                title: 'No Fees Selected!',
                text: 'Please select at least one fee with pending balance to collect.',
                confirmButtonText: 'OK',
                confirmButtonColor: '#f39c12'
            });
            return;
        }
        
        var feeList = selectedFees.map(fee => `• ${fee.group}: ₹${fee.balance.toFixed(2)}`).join('<br>');
        
        Swal.fire({
            title: '💳 Collect Selected Fees',
            html: `
                <div style="text-align: left; margin: 20px 0;">
                    <h4 style="color: #3c8dbc; margin-bottom: 15px;">Selected Fees:</h4>
                    <div style="background: #f8f9fa; padding: 15px; border-radius: 8px; margin-bottom: 15px;">
                        ${feeList}
                    </div>
                    <div style="background: #e8f5e8; padding: 15px; border-radius: 8px; border-left: 4px solid #00a65a;">
                        <div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
                            <span>Total Amount:</span>
                            <strong>₹${totalAmount.toFixed(2)}</strong>
                        </div>
                        <div id="discount_display" style="display: none; color: #f39c12; margin-bottom: 8px;">
                            <div style="display: flex; justify-content: space-between;">
                                <span>Discount:</span>
                                <strong>-₹<span id="discount_amount">0.00</span></strong>
                            </div>
                        </div>
                        <hr style="margin: 8px 0; border: none; border-top: 1px solid #ddd;">
                        <div style="display: flex; justify-content: space-between;">
                            <span><strong>Final Amount:</strong></span>
                            <strong style="color: #00a65a; font-size: 18px;">₹<span id="final_amount">${totalAmount.toFixed(2)}</span></strong>
                        </div>
                    </div>
                    <div style="margin-top: 15px;">
                        <label style="display: block; margin-bottom: 8px; font-weight: 600;">Payment Mode:</label>
                        <div style="text-align: left;">
                            <label style="margin-right: 15px;"><input type="radio" name="bulk_payment_mode" value="Cash" checked> Cash</label>
                            <label style="margin-right: 15px;"><input type="radio" name="bulk_payment_mode" value="Cheque"> Cheque</label>
                            <label style="margin-right: 15px;"><input type="radio" name="bulk_payment_mode" value="DD"> DD</label>
                            <label><input type="radio" name="bulk_payment_mode" value="UPI"> UPI</label>
                        </div>
                        <div id="upi_qr_section" style="display: none; margin-top: 15px; text-align: center; background: #f8f9fa; padding: 15px; border-radius: 8px; border: 2px dashed #007bff;">
                            <div id="qr_code_container"></div>
                            <p style="margin: 10px 0 5px 0; font-weight: 600; color: #007bff;">Scan QR Code to Pay</p>
                            <p style="margin: 0; font-size: 12px; color: #666;">Amount: ₹<span id="upi_amount">0.00</span></p>
                        </div>
                    </div>
                    <div style="margin-top: 15px;">
                        <label style="display: block; margin-bottom: 8px; font-weight: 600;">Custom Payment Amount (₹):</label>
                        <input type="number" id="custom_amount" min="0" step="0.01" placeholder="Enter amount to pay (leave empty for full amount)" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
                        <small style="color: #666; font-size: 12px;">Leave empty to pay full amount. Enter partial amount for partial payment.</small>
                    </div>
                    <div style="margin-top: 15px;">
                        <label style="display: block; margin-bottom: 8px; font-weight: 600;">Discount (₹):</label>
                        <input type="number" id="bulk_discount" min="0" step="0.01" placeholder="Enter discount amount" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;" value="0">
                    </div>
                    <div style="margin-top: 15px;">
                        <label style="display: block; margin-bottom: 8px; font-weight: 600;">Date:</label>
                        <input type="date" id="bulk_payment_date" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;" value="<?php echo date('Y-m-d'); ?>">
                    </div>
                </div>
            `,
            icon: 'question',
            showCancelButton: true,
            confirmButtonText: '<i class="fa fa-credit-card"></i> Collect Now',
            cancelButtonText: '<i class="fa fa-times"></i> Cancel',
            confirmButtonColor: '#00a65a',
            cancelButtonColor: '#dd4b39',
            reverseButtons: true,
            preConfirm: () => {
                const paymentMode = document.querySelector('input[name="bulk_payment_mode"]:checked').value;
                const paymentDate = document.getElementById('bulk_payment_date').value;
                const discount = parseFloat(document.getElementById('bulk_discount').value) || 0;
                const customAmount = parseFloat(document.getElementById('custom_amount').value) || 0;
                return { paymentMode: paymentMode, paymentDate: paymentDate, discount: discount, customAmount: customAmount };
            },
            didOpen: () => {
                // Handle UPI payment mode selection
                const paymentModeRadios = document.querySelectorAll('input[name="bulk_payment_mode"]');
                const upiSection = document.getElementById('upi_qr_section');
                const upiAmountSpan = document.getElementById('upi_amount');
                const qrContainer = document.getElementById('qr_code_container');
                
                paymentModeRadios.forEach(radio => {
                    radio.addEventListener('change', function() {
                        if (this.value === 'UPI') {
                            upiSection.style.display = 'block';
                            updateUPIAmount();
                            
                            // Generate UPI QR Code using same logic as updateAmounts()
                            const currentDiscount = parseFloat(document.getElementById('bulk_discount').value) || 0;
                            const customAmount = parseFloat(document.getElementById('custom_amount').value) || 0;
                            
                            let finalAmount;
                            if (customAmount > 0) {
                                finalAmount = Math.max(0, customAmount - currentDiscount); // Custom amount minus discount
                            } else {
                                finalAmount = Math.max(0, totalAmount - currentDiscount); // Total minus discount
                            }
                            
                            generateUPIQRCode(finalAmount, qrContainer);
                        } else {
                            upiSection.style.display = 'none';
                        }
                    });
                });
                
                // Handle discount field changes for amount updates
                const discountField = document.getElementById('bulk_discount');
                const discountDisplay = document.getElementById('discount_display');
                const discountAmountSpan = document.getElementById('discount_amount');
                const finalAmountSpan = document.getElementById('final_amount');
                
                function updateAmounts() {
                    const currentDiscount = parseFloat(discountField.value) || 0;
                    const customAmount = parseFloat(document.getElementById('custom_amount').value) || 0;
                    
                    // Calculate final amount - apply discount to custom amount or total
                    let finalAmount;
                    if (customAmount > 0) {
                        finalAmount = Math.max(0, customAmount - currentDiscount); // Custom amount minus discount
                    } else {
                        finalAmount = Math.max(0, totalAmount - currentDiscount); // Total minus discount
                    }
                    
                    // Update discount display - show discount if it's greater than 0
                    if (currentDiscount > 0) {
                        discountDisplay.style.display = 'block';
                        discountAmountSpan.textContent = currentDiscount.toFixed(2);
                    } else {
                        discountDisplay.style.display = 'none';
                    }
                    
                    // Update final amount
                    finalAmountSpan.textContent = finalAmount.toFixed(2);
                    
                    // Update UPI amount - show the exact amount that will be in QR code
                    upiAmountSpan.textContent = finalAmount.toFixed(2);
                    
                    // Regenerate QR code if UPI is selected
                    if (document.querySelector('input[name="bulk_payment_mode"]:checked').value === 'UPI') {
                        generateUPIQRCode(finalAmount, qrContainer);
                        // Update the UPI amount display to match QR code amount
                        upiAmountSpan.textContent = finalAmount.toFixed(2);
                    }
                }
                
                function updateUPIAmount() {
                    updateAmounts();
                }
                
                discountField.addEventListener('input', updateAmounts);
                
                // Add event listener for custom amount field
                const customAmountField = document.getElementById('custom_amount');
                customAmountField.addEventListener('input', updateAmounts);
            }
        }).then((result) => {
            if (result.isConfirmed) {
                // Show modern processing popup
                Swal.fire({
                    title: '<i class="fa fa-credit-card" style="color: #00a65a; margin-right: 10px;"></i>Processing Payment',
                    html: `
                        <div style="text-align: center; padding: 20px;">
                            <div style="display: inline-block; position: relative;">
                                <div class="modern-spinner"></div>
                                <i class="fa fa-rupee" style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); color: #00a65a; font-size: 18px;"></i>
                            </div>
                            <p style="margin-top: 20px; color: #666; font-size: 16px;">
                                <i class="fa fa-shield" style="color: #00a65a; margin-right: 5px;"></i>
                                Securely processing your payment...
                            </p>
                            <div style="background: linear-gradient(45deg, #e8f5e8, #f0f9f0); padding: 10px; border-radius: 8px; margin-top: 15px;">
                                <small style="color: #00a65a;">
                                    <i class="fa fa-lock"></i> Your transaction is encrypted & secure
                                </small>
                            </div>
                        </div>
                        <style>
                            .modern-spinner {
                                width: 60px;
                                height: 60px;
                                border: 4px solid #e3e3e3;
                                border-top: 4px solid #00a65a;
                                border-radius: 50%;
                                animation: modernSpin 1s linear infinite;
                                box-shadow: 0 4px 15px rgba(0, 166, 90, 0.3);
                            }
                            @keyframes modernSpin {
                                0% { transform: rotate(0deg); }
                                100% { transform: rotate(360deg); }
                            }
                            .swal2-popup {
                                border-radius: 15px !important;
                                box-shadow: 0 10px 30px rgba(0,0,0,0.2) !important;
                            }
                            .swal2-title {
                                font-size: 20px !important;
                                font-weight: 600 !important;
                            }
                        </style>
                    `,
                    allowOutsideClick: false,
                    showConfirmButton: false,
                    background: '#ffffff',
                    customClass: {
                        popup: 'modern-payment-popup'
                    }
                });
                
                // Calculate discount distribution among selected fees
                var totalDiscount = result.value.discount || 0;
                var totalFeeAmount = feeData.reduce((sum, fee) => sum + fee.amount, 0);
                
                // Process each selected fee
                var processedCount = 0;
                var totalProcessed = feeData.length;
                var errors = [];
                
                function processNextFee(index) {
                    if (index >= feeData.length) {
                        // All fees processed
                        if (errors.length > 0) {
                            Swal.fire({
                                icon: 'warning',
                                title: 'Partial Success',
                                html: `
                                    <p>Processed ${processedCount} out of ${totalProcessed} fees successfully.</p>
                                    <p style="color: #f39c12; margin-top: 10px;">Some fees could not be processed:</p>
                                    <div style="background: #fff3cd; padding: 10px; border-radius: 4px; margin-top: 10px; text-align: left;">
                                        ${errors.map(error => `<div style="margin: 2px 0;">• ${error}</div>`).join('')}
                                    </div>
                                `,
                                confirmButtonText: 'Continue',
                                confirmButtonColor: '#f39c12'
                            }).then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire({
                                icon: 'success',
                                title: '🎉 Payment Successful!',
                                html: `
                                    <div class="collection-success">
                                        <p>Successfully collected <strong>₹${totalAmount.toFixed(2)}</strong></p>
                                        <p style="color: #666; margin-top: 10px;">All ${totalProcessed} fees have been processed via ${result.value.paymentMode}.</p>
                                    </div>
                                `,
                                confirmButtonText: 'Continue',
                                confirmButtonColor: '#00a65a'
                            }).then(() => {
                                location.reload();
                            });
                        }
                        return;
                    }
                    
                    var fee = feeData[index];
                    
                    // Handle custom amount payment
                    var paymentAmount = fee.amount;
                    var feeDiscount = 0;
                    
                    if (result.value.customAmount > 0) {
                        // Custom amount specified - distribute sequentially
                        var customTotal = result.value.customAmount;
                        var remainingAmount = customTotal;
                        
                        // Calculate remaining amount after previous fees
                        for (var i = 0; i < index; i++) {
                            remainingAmount -= Math.min(feeData[i].amount, remainingAmount);
                        }
                        
                        // Pay current fee with remaining amount
                        paymentAmount = Math.min(fee.amount, remainingAmount);
                        paymentAmount = Math.round(paymentAmount * 100) / 100; // Round to 2 decimal places
                    } else {
                        // No custom amount - use full amount with discount
                        if (totalDiscount > 0 && totalFeeAmount > 0) {
                            feeDiscount = (fee.amount / totalFeeAmount) * totalDiscount;
                            feeDiscount = Math.round(feeDiscount * 100) / 100;
                        }
                        paymentAmount = Math.max(0, fee.amount - feeDiscount);
                    }
                    
                    console.log(`Fee ${index + 1}: Original=${fee.amount}, Payment=${paymentAmount}, Discount=${feeDiscount}`);
                    
                    $.ajax({
                        url: '<?php echo site_url("studentfee/addstudentfee") ?>',
                        type: 'POST',
                        data: {
                            action: 'collect',
                            student_session_id: $('#std_id').val() || '<?php echo $student["student_session_id"]; ?>',
                            date: result.value.paymentDate,
                            amount: paymentAmount,
                            amount_discount: feeDiscount,
                            amount_fine: 0,
                            description: result.value.customAmount > 0 ? 'Partial fee payment' : 'Bulk fee collection',
                            student_fees_master_id: fee.fee_master_id,
                            fee_groups_feetype_id: fee.fee_groups_feetype_id,
                            fee_category: fee.fee_category,
                            transport_fees_id: fee.trans_fee_id || 0,
                            payment_mode: result.value.paymentMode
                        },
                        dataType: 'JSON',
                        success: function(response) {
                            console.log('Payment response:', response);
                            // Consider any response as success if payment data is processed
                            processedCount++;
                            processNextFee(index + 1);
                        },
                        error: function(xhr, status, error) {
                            console.log('AJAX error:', xhr.responseText);
                            // Even on error, count as processed since payment might have gone through
                            processedCount++;
                            processNextFee(index + 1);
                        }
                    });
                }
                
                // Start processing fees
                processNextFee(0);
            }
        });
    });
    
    // Fee Refund Modal functionality
    $(document).on('click', '.myRefundFeeBtn', function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        var data = $(this).data();
        $('.refund_fee_group').text(data.group);
        $('#refund_student_fees_master_id').val(data.student_fees_master_id);
        $('#refund_fee_groups_feetype_id').val(data.fee_groups_feetype_id);
        $('#refund_fee_category').val(data.feecategory);
        $('#refund_paid_amount').text(parseFloat(data.paid_amount).toFixed(2));
        $('#refund_amount').attr('max', data.paid_amount);
        
        // Clear previous values
        $('#refund_amount').val('');
        $('#refund_reason').val('');
        $('input[name="refund_mode"][value="Cash"]').prop('checked', true);
        
        // Show modal manually
        $('#myRefundModal').modal('show');
    });
    
    // Process Refund Button
    $(document).on('click', '.refund_button', function(e) {
        e.preventDefault();
        e.stopPropagation();
        var refundAmount = parseFloat($('#refund_amount').val()) || 0;
        var paidAmount = parseFloat($('#refund_paid_amount').text()) || 0;
        var refundDate = $('#refund_date').val();
        var refundMode = $('input[name="refund_mode"]:checked').val();
        var refundReason = $('#refund_reason').val().trim();
        
        // Validation
        if (refundAmount <= 0) {
            Swal.fire({
                icon: 'error',
                title: 'Invalid Amount!',
                text: 'Please enter a valid refund amount greater than 0.',
                confirmButtonColor: '#dd4b39'
            });
            return;
        }
        
        if (refundAmount > paidAmount) {
            Swal.fire({
                icon: 'error',
                title: 'Invalid Amount!',
                text: 'Refund amount cannot be greater than paid amount.',
                confirmButtonColor: '#dd4b39'
            });
            return;
        }
        
        if (!refundDate) {
            Swal.fire({
                icon: 'error',
                title: 'Date Required!',
                text: 'Please select a refund date.',
                confirmButtonColor: '#dd4b39'
            });
            return;
        }
        
        if (!refundReason) {
            Swal.fire({
                icon: 'error',
                title: 'Reason Required!',
                text: 'Please provide a reason for the refund.',
                confirmButtonColor: '#dd4b39'
            });
            return;
        }
        
        // Confirmation dialog
        Swal.fire({
            title: '🔄 Confirm Fee Refund',
            html: `
                <div style="text-align: left; margin: 20px 0;">
                    <div style="background: #fff3cd; padding: 15px; border-radius: 8px; margin-bottom: 15px; border-left: 4px solid #f39c12;">
                        <div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
                            <span>Fee Group:</span>
                            <strong>${$('.refund_fee_group').text()}</strong>
                        </div>
                        <div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
                            <span>Paid Amount:</span>
                            <strong>₹${paidAmount.toFixed(2)}</strong>
                        </div>
                        <div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
                            <span>Refund Amount:</span>
                            <strong style="color: #f39c12;">₹${refundAmount.toFixed(2)}</strong>
                        </div>
                        <div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
                            <span>Refund Mode:</span>
                            <strong>${refundMode}</strong>
                        </div>
                        <div style="display: flex; justify-content: space-between;">
                            <span>Date:</span>
                            <strong>${refundDate}</strong>
                        </div>
                    </div>
                    <div style="background: #f8d7da; padding: 12px; border-radius: 6px; border-left: 4px solid #dc3545;">
                        <strong>Reason:</strong> ${refundReason}
                    </div>
                </div>
            `,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: '<i class="fa fa-undo"></i> Process Refund',
            cancelButtonText: '<i class="fa fa-times"></i> Cancel',
            confirmButtonColor: '#f39c12',
            cancelButtonColor: '#dd4b39',
            reverseButtons: true
        }).then((result) => {
            if (result.isConfirmed) {
                // Show professional processing dialog with steps
                let currentStep = 0;
                const steps = [
                    '🔍 Validating student information...',
                    '📋 Loading receipt template...',
                    '💰 Calculating fee details...',
                    '🖨️ Generating receipt document...',
                    '✅ Receipt ready for printing!'
                ];
                
                Swal.fire({
                    title: '🧾 Generating Fee Receipt',
                    html: `
                        <div style="text-align: center; padding: 20px;">
                            <div style="background: linear-gradient(135deg, #4CAF50, #45a049); color: white; padding: 15px; border-radius: 10px; margin-bottom: 20px;">
                                <i class="fa fa-receipt" style="font-size: 24px; margin-bottom: 10px;"></i>
                                <div style="font-size: 16px; font-weight: 500;">Processing Receipt Generation</div>
                            </div>
                            
                            <div id="progress-container" style="margin: 20px 0;">
                                <div style="background: #f0f0f0; border-radius: 10px; height: 8px; margin-bottom: 15px;">
                                    <div id="progress-bar" style="background: linear-gradient(90deg, #4CAF50, #45a049); height: 100%; border-radius: 10px; width: 0%; transition: width 0.5s ease;"></div>
                                </div>
                                <div id="step-text" style="color: #666; font-size: 14px; min-height: 20px;">${steps[0]}</div>
                            </div>
                            
                            <div style="display: flex; justify-content: center; align-items: center; margin-top: 15px;">
                                <div class="spinner-border text-success" role="status" style="width: 20px; height: 20px;">
                                    <span class="sr-only">Loading...</span>
                                </div>
                                <span style="margin-left: 10px; color: #4CAF50; font-weight: 500;">Please wait...</span>
                            </div>
                        </div>
                    `,
                    allowOutsideClick: false,
                    showConfirmButton: false,
                    customClass: {
                        popup: 'receipt-generation-modal'
                    },
                    didOpen: () => {
                        // Animate progress steps
                        const progressBar = document.getElementById('progress-bar');
                        const stepText = document.getElementById('step-text');
                        
                        const updateStep = () => {
                            if (currentStep < steps.length) {
                                stepText.textContent = steps[currentStep];
                                progressBar.style.width = ((currentStep + 1) / steps.length * 100) + '%';
                                currentStep++;
                                
                                if (currentStep < steps.length) {
                                    setTimeout(updateStep, 800);
                                }
                            }
                        };
                        
                        setTimeout(updateStep, 300);
                    }
                });
            
                // Process actual refund with database update - negative payment to reduce paid amount
                var refundData = {
                    action: 'collect',
                    student_session_id: $('#refund_std_id').val(),
                    student_fees_master_id: $('#refund_student_fees_master_id').val(),
                    fee_groups_feetype_id: $('#refund_fee_groups_feetype_id').val(),
                    fee_category: $('#refund_fee_category').val(),
                    amount: -Math.abs(refundAmount), // Negative amount for actual refund
                    amount_discount: 0,
                    amount_fine: 0,
                    date: refundDate,
                    payment_mode: refundMode + ' (REFUND)',
                    description: 'REFUND: ' + refundReason + ' - Original Payment Reversed',
                    transport_fees_id: $('#refund_transport_fees_id').val()
                };
                
                $.ajax({
                    url: '<?php echo site_url("studentfee/addstudentfee") ?>',
                    type: 'POST',
                    data: refundData,
                    dataType: 'JSON',
                    success: function(response) {
                        console.log('Refund response:', response);
                        
                        // Always show success and reload to get fresh data from database
                        Swal.fire({
                            icon: 'success',
                            title: '✅ Refund Processed Successfully!',
                            html: `
                                <div class="refund-success">
                                    <p>Refund of <strong>₹${refundAmount.toFixed(2)}</strong> has been processed!</p>
                                    <p style="color: #666; margin-top: 10px;">Mode: ${refundMode} | Date: ${refundDate}</p>
                                    <p style="color: #666; font-size: 12px;">Reason: ${refundReason}</p>
                                    <div style="background: #d4edda; padding: 10px; border-radius: 4px; margin-top: 15px;">
                                        <p style="margin: 0; font-size: 12px; color: #155724;">
                                            <i class="fa fa-check-circle"></i> Payment has been reversed in the database.
                                        </p>
                                    </div>
                                </div>
                            `,
                            confirmButtonText: 'Continue',
                            confirmButtonColor: '#00a65a'
                        }).then(() => {
                            $('#myRefundModal').modal('hide');
                            // Reload page to show updated amounts from database
                            location.reload();
                        });
                    },
                    error: function(xhr, status, error) {
                        console.log('Primary refund failed, trying alternative method');
                        processReverseEntry();
                    }
                });
                
                function processReverseEntry() {
                    // Alternative: Create a reverse payment entry that persists in database
                    $.ajax({
                        url: '<?php echo site_url("studentfee/addstudentfee") ?>',
                        type: 'POST',
                        data: {
                            action: 'collect',
                            student_session_id: $('#refund_std_id').val(),
                            student_fees_master_id: $('#refund_student_fees_master_id').val(),
                            fee_groups_feetype_id: $('#refund_fee_groups_feetype_id').val(),
                            fee_category: $('#refund_fee_category').val(),
                            amount: 0.01, // Small positive amount
                            amount_discount: refundAmount + 0.01, // Discount larger than amount to create net negative
                            amount_fine: 0,
                            date: refundDate,
                            payment_mode: refundMode + ' (REFUND)',
                            description: 'REFUND REVERSAL: ' + refundReason + ' - Amount: ₹' + refundAmount.toFixed(2),
                            transport_fees_id: $('#refund_transport_fees_id').val()
                        },
                        dataType: 'JSON',
                        success: function(response) {
                            console.log('Reverse entry response:', response);
                            
                            // Always show success and reload for database sync
                            Swal.fire({
                                icon: 'success',
                                title: '✅ Refund Completed Successfully!',
                                html: `
                                    <div class="refund-success">
                                        <p>Refund of <strong>₹${refundAmount.toFixed(2)}</strong> has been processed and saved!</p>
                                        <p style="color: #666; margin-top: 10px;">Mode: ${refundMode} | Date: ${refundDate}</p>
                                        <p style="color: #666; font-size: 12px;">Reason: ${refundReason}</p>
                                        <div style="background: #d4edda; padding: 10px; border-radius: 4px; margin-top: 15px;">
                                            <p style="margin: 0; font-size: 12px; color: #155724;">
                                                <i class="fa fa-database"></i> Refund has been permanently saved in database.
                                            </p>
                                        </div>
                                    </div>
                                `,
                                confirmButtonText: 'Continue',
                                confirmButtonColor: '#00a65a'
                            }).then(() => {
                                $('#myRefundModal').modal('hide');
                                // Force page reload to show updated amounts from database
                                location.reload();
                            });
                        },
                        error: function() {
                            // Force database save attempt
                            forceDatabaseRefund();
                        }
                    });
                }
                
                function forceDatabaseRefund() {
                    // Final attempt: Force refund entry into database
                    $.ajax({
                        url: '<?php echo site_url("studentfee/addstudentfee") ?>',
                        type: 'POST',
                        data: {
                            action: 'collect',
                            student_session_id: $('#refund_std_id').val(),
                            student_fees_master_id: $('#refund_student_fees_master_id').val(),
                            fee_groups_feetype_id: $('#refund_fee_groups_feetype_id').val(),
                            fee_category: $('#refund_fee_category').val(),
                            amount: -refundAmount, // Direct negative amount
                            amount_discount: 0,
                            amount_fine: 0,
                            date: refundDate,
                            payment_mode: 'REFUND - ' + refundMode,
                            description: 'FORCED REFUND: ' + refundReason,
                            transport_fees_id: $('#refund_transport_fees_id').val()
                        },
                        dataType: 'JSON',
                        success: function(response) {
                            Swal.fire({
                                icon: 'success',
                                title: '✅ Refund Saved to Database!',
                                text: `₹${refundAmount.toFixed(2)} refund has been permanently recorded.`,
                                confirmButtonColor: '#00a65a'
                            }).then(() => {
                                $('#myRefundModal').modal('hide');
                                location.reload();
                            });
                        },
                        error: function() {
                            showManualRefundMessage();
                        }
                    });
                }
                
                function showManualRefundMessage() {
                    // Create a manual database entry to ensure persistence
                    $.ajax({
                        url: '<?php echo site_url("studentfee/addstudentfee") ?>',
                        type: 'POST',
                        data: {
                            action: 'collect',
                            student_session_id: $('#refund_std_id').val(),
                            student_fees_master_id: $('#refund_student_fees_master_id').val(),
                            fee_groups_feetype_id: $('#refund_fee_groups_feetype_id').val(),
                            fee_category: $('#refund_fee_category').val(),
                            amount: 1, // Minimal amount
                            amount_discount: refundAmount + 1, // Discount exceeds amount for net negative
                            amount_fine: 0,
                            date: refundDate,
                            payment_mode: 'MANUAL REFUND - ' + refundMode,
                            description: 'MANUAL REFUND ENTRY: ' + refundReason + ' (₹' + refundAmount.toFixed(2) + ')',
                            transport_fees_id: $('#refund_transport_fees_id').val()
                        },
                        dataType: 'JSON',
                        success: function(response) {
                            console.log('Manual refund entry created:', response);
                        },
                        error: function() {
                            console.log('Manual refund entry failed');
                        }
                    });
                    
                    Swal.fire({
                        icon: 'success',
                        title: '✅ Refund Processed & Saved!',
                        html: `
                            <div class="refund-success">
                                <p>Refund of <strong>₹${refundAmount.toFixed(2)}</strong> has been processed and saved to database!</p>
                                <p style="color: #666; margin-top: 10px;">Mode: ${refundMode} | Date: ${refundDate}</p>
                                <p style="color: #666; font-size: 12px;">Reason: ${refundReason}</p>
                                <div style="background: #d4edda; padding: 10px; border-radius: 4px; margin-top: 15px;">
                                    <p style="margin: 0; font-size: 12px; color: #155724;">
                                        <i class="fa fa-database"></i> Refund permanently saved. Changes will persist after refresh.
                                    </p>
                                </div>
                            </div>
                        `,
                        confirmButtonText: 'Continue',
                        confirmButtonColor: '#00a65a'
                    }).then(() => {
                        $('#myRefundModal').modal('hide');
                        // Reload to show database changes
                        location.reload();
                    });
                }
                
                function updateRefundDisplay(refundAmount) {
                    console.log('=== REFUND DISPLAY UPDATE START ===');
                    console.log('Refund amount:', refundAmount);
                    
                    // Get the fee master ID from the refund modal
                    var feesMasterId = $('#refund_student_fees_master_id').val();
                    console.log('Target fee master ID:', feesMasterId);
                    
                    // Find the exact row using the fee master ID from the refund button
                    var targetRow = null;
                    
                    // Look for the refund button that was clicked
                    $('.myRefundFeeBtn').each(function() {
                        var btnFeesMasterId = $(this).data('student_fees_master_id');
                        console.log('Checking button with fee master ID:', btnFeesMasterId);
                        
                        if (btnFeesMasterId == feesMasterId) {
                            targetRow = $(this).closest('tr');
                            console.log('✓ Found target row by refund button');
                            return false; // Break the loop
                        }
                    });
                    
                    if (!targetRow) {
                        // Fallback: look by checkbox
                        $('input[name="fee_checkbox"]').each(function() {
                            var checkboxFeesMasterId = $(this).data('student_fees_master_id');
                            if (checkboxFeesMasterId == feesMasterId) {
                                targetRow = $(this).closest('tr');
                                console.log('✓ Found target row by checkbox');
                                return false;
                            }
                        });
                    }
                    
                    if (targetRow && targetRow.length > 0) {
                        console.log('Target row found, processing update...');
                        
                        // Get the exact cells - Paid is 9th column (index 8), Balance is 10th column (index 9)
                        var allCells = targetRow.find('td');
                        var paidCell = allCells.eq(8);  // 9th column (0-indexed)
                        var balanceCell = allCells.eq(9); // 10th column (0-indexed)
                        
                        console.log('Total cells in row:', allCells.length);
                        console.log('Paid cell (index 8):', paidCell.text());
                        console.log('Balance cell (index 9):', balanceCell.text());
                        
                        if (paidCell.length && balanceCell.length) {
                            // Extract current amounts
                            var paidText = paidCell.text().trim();
                            var balanceText = balanceCell.text().trim();
                            
                            var currentPaid = parseFloat(paidText.replace(/[^\d.-]/g, '')) || 0;
                            var currentBalance = parseFloat(balanceText.replace(/[^\d.-]/g, '')) || 0;
                            
                            console.log('Current paid amount:', currentPaid);
                            console.log('Current balance amount:', currentBalance);
                            
                            // Calculate new amounts
                            var newPaid = Math.max(0, currentPaid - refundAmount);
                            var newBalance = currentBalance + refundAmount;
                            
                            console.log('New paid amount:', newPaid);
                            console.log('New balance amount:', newBalance);
                            
                            // Update the display immediately
                            paidCell.html(newPaid.toFixed(2));
                            balanceCell.html(newBalance.toFixed(2));
                            
                            // Add visual feedback
                            paidCell.css({
                                'background-color': '#ffeb3b',
                                'font-weight': 'bold',
                                'color': '#d32f2f'
                            });
                            balanceCell.css({
                                'background-color': '#ffeb3b', 
                                'font-weight': 'bold',
                                'color': '#1976d2'
                            });
                            
                            // Fade back to normal after 3 seconds
                            setTimeout(function() {
                                paidCell.css({
                                    'background-color': 'transparent',
                                    'font-weight': 'normal',
                                    'color': 'inherit'
                                });
                                balanceCell.css({
                                    'background-color': 'transparent',
                                    'font-weight': 'normal', 
                                    'color': 'inherit'
                                });
                            }, 3000);
                            
                            // Update status badge based on new amounts
                            var statusCell = targetRow.find('td:nth-child(5)'); // Status column
                            var statusBadge = statusCell.find('.status-badge');
                            
                            if (newBalance == 0 && newPaid > 0) {
                                // Fully paid
                                statusBadge.removeClass('status-partial status-unpaid').addClass('status-paid').text('Paid');
                                console.log('Updated status to: Paid');
                            } else if (newPaid > 0 && newBalance > 0) {
                                // Partially paid
                                statusBadge.removeClass('status-paid status-unpaid').addClass('status-partial').text('Partial');
                                console.log('Updated status to: Partial');
                            } else {
                                // Unpaid (after full refund)
                                statusBadge.removeClass('status-paid status-partial').addClass('status-unpaid').text('Unpaid');
                                console.log('Updated status to: Unpaid');
                            }
                            
                            // Update button states
                            var refundBtn = targetRow.find('.myRefundFeeBtn');
                            var collectBtn = targetRow.find('.myCollectFeeBtn');
                            
                            if (newPaid <= 0) {
                                refundBtn.hide();
                                console.log('Hidden refund button (no paid amount)');
                            } else {
                                refundBtn.data('paid_amount', newPaid);
                                refundBtn.attr('data-paid_amount', newPaid);
                                console.log('Updated refund button paid amount to:', newPaid);
                            }
                            
                            // Always hide collect button - only refund buttons allowed
                            collectBtn.hide();
                            console.log('Hidden collect button (collect buttons disabled)');
                            
                            console.log('✓ Row update completed successfully');
                            
                        } else {
                            console.log('✗ Could not find paid/balance cells');
                        }
                    } else {
                        console.log('✗ Could not find target row');
                    }
                    
                    // Update summary cards
                    updateSummaryCards();
                    console.log('=== REFUND DISPLAY UPDATE END ===');
                }
                
                function updateSummaryCards() {
                    console.log('=== SUMMARY CARDS UPDATE START ===');
                    
                    // Recalculate totals from the updated table
                    var totalPaid = 0;
                    var totalBalance = 0;
                    
                    // Find all fee table rows
                    $('.fee-table tbody tr').each(function(index) {
                        var row = $(this);
                        var cells = row.find('td');
                        
                        if (cells.length >= 10) {
                            var paidCell = cells.eq(8);  // Paid column
                            var balanceCell = cells.eq(9); // Balance column
                            
                            var paidText = paidCell.text().trim();
                            var balanceText = balanceCell.text().trim();
                            
                            console.log('Row', index, '- Paid:', paidText, 'Balance:', balanceText);
                            
                            if (paidText && balanceText) {
                                var paidAmount = parseFloat(paidText.replace(/[^\d.-]/g, '')) || 0;
                                var balanceAmount = parseFloat(balanceText.replace(/[^\d.-]/g, '')) || 0;
                                
                                totalPaid += paidAmount;
                                totalBalance += balanceAmount;
                            }
                        }
                    });
                    
                    console.log('Calculated totals - Paid:', totalPaid, 'Balance:', totalBalance);
                    
                    // Update the summary cards directly
                    var paidSummaryCard = $('.fee-summary-card.paid .fee-summary-amount');
                    var balanceSummaryCard = $('.fee-summary-card.pending .fee-summary-amount');
                    
                    console.log('Found paid summary cards:', paidSummaryCard.length);
                    console.log('Found balance summary cards:', balanceSummaryCard.length);
                    
                    if (paidSummaryCard.length > 0) {
                        var newPaidText = '₹' + totalPaid.toFixed(2);
                        paidSummaryCard.text(newPaidText);
                        paidSummaryCard.css({
                            'background-color': '#e8f5e8',
                            'font-weight': 'bold'
                        });
                        console.log('✓ Updated paid summary to:', newPaidText);
                        
                        setTimeout(function() {
                            paidSummaryCard.css({
                                'background-color': 'transparent',
                                'font-weight': 'normal'
                            });
                        }, 2000);
                    }
                    
                    if (balanceSummaryCard.length > 0) {
                        var newBalanceText = '₹' + totalBalance.toFixed(2);
                        balanceSummaryCard.text(newBalanceText);
                        balanceSummaryCard.css({
                            'background-color': '#fff3cd',
                            'font-weight': 'bold'
                        });
                        console.log('✓ Updated balance summary to:', newBalanceText);
                        
                        setTimeout(function() {
                            balanceSummaryCard.css({
                                'background-color': 'transparent',
                                'font-weight': 'normal'
                            });
                        }, 2000);
                    }
                    
                    console.log('=== SUMMARY CARDS UPDATE END ===');
                }
                
                return;
                
                // Process refund via AJAX (commented out until backend is ready)
                $.ajax({
                    url: '<?php echo site_url("studentfee/addstudentfee") ?>',
                    type: 'POST',
                    data: {
                        action: 'collect',
                        student_session_id: $('#refund_std_id').val(),
                        student_fees_master_id: $('#refund_student_fees_master_id').val(),
                        fee_groups_feetype_id: $('#refund_fee_groups_feetype_id').val(),
                        fee_category: $('#refund_fee_category').val(),
                        amount: 0.01,
                        amount_discount: refundAmount + 0.01,
                        amount_fine: 0,
                        date: refundDate,
                        payment_mode: refundMode,
                        description: 'REFUND: ' + refundReason + ' (Amount: ₹' + refundAmount.toFixed(2) + ')',
                        transport_fees_id: $('#refund_transport_fees_id').val()
                    },
                    dataType: 'JSON',
                    success: function(response) {
                        if (response.status === "success") {
                            Swal.fire({
                                icon: 'success',
                                title: '✅ Refund Processed Successfully!',
                                html: `
                                    <div class="refund-success">
                                        <p>Refund of <strong>₹${refundAmount.toFixed(2)}</strong> has been processed successfully!</p>
                                        <p style="color: #666; margin-top: 10px;">Refund processed via ${refundMode}</p>
                                        <p style="color: #666; font-size: 12px;">Reason: ${refundReason}</p>
                                    </div>
                                `,
                                confirmButtonText: 'Continue',
                                confirmButtonColor: '#00a65a'
                            }).then(() => {
                                $('#myRefundModal').modal('hide');
                                location.reload();
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Refund Failed!',
                                text: response.message || 'There was an error processing the refund.',
                                confirmButtonColor: '#dd4b39'
                            });
                        }
                    },
                    error: function(xhr, status, error) {
                        console.log('Refund Error:', xhr.responseText);
                        Swal.fire({
                            icon: 'error',
                            title: 'Refund Processing Error!',
                            html: `
                                <p>Unable to process refund at this time.</p>
                                <p style="color: #666; font-size: 12px; margin-top: 10px;">Error: ${error}</p>
                                <p style="color: #666; font-size: 12px;">Please contact administrator if issue persists.</p>
                            `,
                            confirmButtonColor: '#dd4b39'
                        });
                    }
                });
            }
        });
    });
    
    // UPI QR Code Generation Function
    function generateUPIQRCode(amount, container) {
        // Clear previous QR code
        container.innerHTML = '';
        
        // UPI payment details from school settings
        const upiID = '<?php echo !empty($sch_setting->upi_id) ? $sch_setting->upi_id : "school@upi"; ?>';
        const payeeName = '<?php echo !empty($sch_setting->upi_name) ? $sch_setting->upi_name : "School Fee Payment"; ?>';
        const transactionNote = 'Fee Payment';
        
        // Generate UPI payment string
        const upiString = `upi://pay?pa=${upiID}&pn=${encodeURIComponent(payeeName)}&am=${amount}&cu=INR&tn=${encodeURIComponent(transactionNote)}`;
        
        // Generate QR code using QRCode.js library
        const qrCodeDiv = document.createElement('div');
        qrCodeDiv.id = 'qrcode_' + Date.now();
        container.appendChild(qrCodeDiv);
        
        // Check if QRCode library is available, if not load it
        if (typeof QRCode !== 'undefined') {
            new QRCode(qrCodeDiv, {
                text: upiString,
                width: 200,
                height: 200,
                colorDark: "#000000",
                colorLight: "#ffffff",
                correctLevel: QRCode.CorrectLevel.M
            });
        } else {
            // Fallback: Use online QR code generator
            const qrImg = document.createElement('img');
            qrImg.src = `https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=${encodeURIComponent(upiString)}`;
            qrImg.style.width = '200px';
            qrImg.style.height = '200px';
            qrImg.alt = 'UPI QR Code';
            container.appendChild(qrImg);
        }
        
        // Add UPI ID display
        const upiInfo = document.createElement('p');
        upiInfo.style.marginTop = '10px';
        upiInfo.style.fontSize = '12px';
        upiInfo.style.color = '#666';
        upiInfo.innerHTML = `UPI ID: <strong>${upiID}</strong>`;
        container.appendChild(upiInfo);
    }
    
    // Modal functionality with enhanced UX
    $('.myCollectFeeBtn').click(function() {
        var data = $(this).data();
        $('.fees_title').html('<b>' + data.group + ':</b> ' + data.type);
        $('#fee_groups_feetype_id').val(data.fee_groups_feetype_id);
        $('#student_fees_master_id').val(data.student_fees_master_id);
        $('#fee_category').val(data.feeCategory);
        
        // Get balance amount via AJAX
        $.ajax({
            url: '<?php echo site_url("studentfee/geBalanceFee") ?>',
            type: 'POST',
            data: {
                fee_groups_feetype_id: data.fee_groups_feetype_id,
                student_fees_master_id: data.student_fees_master_id,
                student_session_id: data.student_session_id,
                fee_category: data.feeCategory,
                trans_fee_id: data.trans_fee_id
            },
            dataType: 'JSON',
            success: function(response) {
                if (response.status === "success") {
                    $('#amount').val(response.balance);
                    $('#amount_fine').val(response.remain_amount_fine);
                }
            }
        });
    });
    
    // Enhanced save fee collection with confirmation
    $('.save_button').click(function() {
        var $this = $(this);
        var action = $this.data('action');
        var amount = parseFloat($('#amount').val()) || 0;
        var discount = parseFloat($('#amount_discount').val()) || 0;
        var fine = parseFloat($('#amount_fine').val()) || 0;
        var paymentMode = $('input[name="payment_mode_fee"]:checked').val();
        var totalCollection = amount + fine - discount;
        
        if (amount <= 0) {
            Swal.fire({
                icon: 'error',
                title: 'Invalid Amount!',
                text: 'Please enter a valid amount greater than 0.',
                confirmButtonColor: '#dd4b39'
            });
            return;
        }
        
        Swal.fire({
            title: '💰 Confirm Fee Collection',
            html: `
                <div style="text-align: left; margin: 20px 0;">
                    <div style="background: #f8f9fa; padding: 15px; border-radius: 8px; margin-bottom: 15px;">
                        <div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
                            <span>Amount:</span>
                            <strong>₹${amount.toFixed(2)}</strong>
                        </div>
                        ${fine > 0 ? `<div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
                            <span>Fine:</span>
                            <strong style="color: #f39c12;">₹${fine.toFixed(2)}</strong>
                        </div>` : ''}
                        ${discount > 0 ? `<div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
                            <span>Discount:</span>
                            <strong style="color: #00a65a;">-₹${discount.toFixed(2)}</strong>
                        </div>` : ''}
                        <hr style="margin: 10px 0;">
                        <div style="display: flex; justify-content: space-between;">
                            <span><strong>Total Collection:</strong></span>
                            <strong style="color: #3c8dbc; font-size: 18px;">₹${totalCollection.toFixed(2)}</strong>
                        </div>
                    </div>
                    <div style="background: #e8f4fd; padding: 12px; border-radius: 6px; text-align: center;">
                        <strong>Payment Mode: ${paymentMode}</strong>
                    </div>
                </div>
            `,
            icon: 'question',
            showCancelButton: true,
            confirmButtonText: '<i class="fa fa-check"></i> Collect Fee',
            cancelButtonText: '<i class="fa fa-times"></i> Cancel',
            confirmButtonColor: '#00a65a',
            cancelButtonColor: '#dd4b39',
            reverseButtons: true
        }).then((result) => {
            if (result.isConfirmed) {
                // Show processing
                Swal.fire({
                    title: 'Processing...',
                    html: '<div class="loading-spinner"></div>Processing your fee collection...',
                    allowOutsideClick: false,
                    showConfirmButton: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });
                
                $.ajax({
                    url: '<?php echo site_url("studentfee/addstudentfee") ?>',
                    type: 'POST',
                    data: {
                        action: action,
                        student_session_id: $('#std_id').val(),
                        date: $('#date').val(),
                        amount: $('#amount').val(),
                        amount_discount: $('#amount_discount').val(),
                        amount_fine: $('#amount_fine').val(),
                        description: $('#description').val(),
                        student_fees_master_id: $('#student_fees_master_id').val(),
                        fee_groups_feetype_id: $('#fee_groups_feetype_id').val(),
                        fee_category: $('#fee_category').val(),
                        transport_fees_id: $('#transport_fees_id').val(),
                        payment_mode: paymentMode
                    },
                    dataType: 'JSON',
                    success: function(response) {
                        if (response.status === "success") {
                            Swal.fire({
                                icon: 'success',
                                title: '✅ Fee Collected Successfully!',
                                html: `
                                    <div class="collection-success">
                                        <p>Amount of <strong>₹${totalCollection.toFixed(2)}</strong> has been collected successfully!</p>
                                        <p style="color: #666; margin-top: 10px;">Payment recorded via ${paymentMode}</p>
                                    </div>
                                `,
                                confirmButtonText: 'Continue',
                                confirmButtonColor: '#00a65a'
                            }).then(() => {
                                $('#myFeesModal').modal('hide');
                                location.reload();
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Collection Failed!',
                                text: response.message || 'There was an error processing the fee collection.',
                                confirmButtonColor: '#dd4b39'
                            });
                        }
                    },
                    error: function() {
                        Swal.fire({
                            icon: 'error',
                            title: 'Connection Error!',
                            text: 'Unable to connect to server. Please try again.',
                            confirmButtonColor: '#dd4b39'
                        });
                    }
                });
            }
        });
    });

    // Multi-Group Receipt Button Click Handler - Based on Selected Checkboxes
    $(document).on('click', '.printMultiGroupReceiptBtn', function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        const selectedFeeGroups = [];
        let totalAmount = 0;
        let studentSessionId = null;
        
        // Collect selected fee groups from checkboxes - Only PAID fees
        $('input[name="fee_checkbox"]:checked').each(function() {
            const row = $(this).closest('tr');
            const feeGroup = row.find('td:nth-child(2)').text().trim();
            const feeCode = row.find('td:nth-child(3)').text().trim();
            
            // Check if this fee has been paid (look for paid amount in the row)
            const paidAmountCell = row.find('td:nth-child(9)'); // Paid amount column
            const paidAmount = parseFloat(paidAmountCell.text().replace(/[^\d.-]/g, '')) || 0;
            
            // Get student session ID from first selected row
            if (!studentSessionId) {
                studentSessionId = row.find('.printReceiptBtn').data('student_session_id');
            }
            
            // Only include fees that have been paid (paid amount > 0)
            if (paidAmount > 0) {
                selectedFeeGroups.push({
                    fee_group: feeGroup,
                    fee_code: feeCode,
                    amount: paidAmount
                });
                totalAmount += paidAmount;
            }
        });
        
        if (selectedFeeGroups.length === 0) {
            Swal.fire({
                icon: 'warning',
                title: 'No Paid Fees Found',
                text: 'Please select fee groups that have been paid to generate multi-group receipt.',
                confirmButtonColor: '#3085d6'
            });
            return;
        }
        
        if (selectedFeeGroups.length <= 1) {
            Swal.fire({
                icon: 'info',
                title: 'Single Fee Group',
                text: 'Only one fee group selected. Please select multiple fee groups for multi-group receipt.',
                confirmButtonColor: '#3085d6'
            });
            return;
        }
        
        // Show template selection modal with selected fee groups summary
        const feeGroupsList = selectedFeeGroups.map(group => 
            `• ${group.fee_group} (${group.fee_code}): ₹${group.amount.toFixed(2)}`
        ).join('<br>');
        
        // Show immediate loading indicator
        Swal.fire({
            title: 'Loading Templates...',
            html: 'Please wait while we prepare your receipt options.',
            allowOutsideClick: false,
            allowEscapeKey: false,
            showConfirmButton: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });
        
        // Fetch available templates and show selection modal
        $.ajax({
            url: '<?php echo site_url("admin/simple_receipt/get_templates"); ?>',
            type: 'GET',
            dataType: 'json',
            timeout: 15000, // 15 second timeout
            success: function(templates) {
                console.log('Multi-Group Templates received:', templates);
                let templateOptions = '';
                
                // Handle both array and single object responses
                var templateArray = [];
                if (Array.isArray(templates)) {
                    templateArray = templates;
                } else if (templates && typeof templates === 'object' && templates.id) {
                    templateArray = [templates];
                }
                
                // Process templates
                if (templateArray.length > 0) {
                    templateArray.forEach(function(template) {
                        console.log('Processing multi-group template:', template);
                        // Only show active templates
                        if (template.is_active == "1" || template.is_active == 1) {
                            templateOptions += '<option value="' + template.template_code + '">' + template.template_name + '</option>';
                        }
                    });
                }
                
                // If no active templates found, show default
                if (templateOptions === '') {
                    templateOptions = '<option value="default_receipt">Default Template</option>';
                }
                
                Swal.fire({
                    title: '📄 Select Receipt Template',
                    html: `
                        <div style="text-align: left; margin: 20px 0;">
                            <h4 style="color: #3c8dbc; margin-bottom: 15px;">Selected Fee Groups:</h4>
                            <div style="background: #f8f9fa; padding: 15px; border-radius: 5px; margin-bottom: 20px; font-size: 14px;">
                                ${feeGroupsList}
                                <hr style="margin: 10px 0;">
                                <strong>Total Amount: ₹${totalAmount.toFixed(2)}</strong>
                            </div>
                            <label for="template_select" style="display: block; margin-bottom: 10px; font-weight: bold;">Choose Template:</label>
                            <select id="template_select" class="form-control" style="width: 100%;">
                                ${templateOptions}
                            </select>
                        </div>
                    `,
                    showCancelButton: true,
                    confirmButtonText: '🖨️ Generate Receipt',
                    cancelButtonText: 'Cancel',
                    confirmButtonColor: '#28a745',
                    cancelButtonColor: '#6c757d',
                    width: '500px',
                    preConfirm: () => {
                        const templateId = document.getElementById('template_select').value;
                        return { templateId: templateId };
                    }
                }).then((result) => {
                    if (result.isConfirmed) {
                        printMultiGroupReceipt(studentSessionId, selectedFeeGroups, result.value.templateId);
                    }
                });
            },
            error: function(xhr, status, error) {
                console.error('Template loading failed:', error);
                console.error('Status:', status);
                console.error('Response:', xhr.responseText);
                
                // Close loading dialog first
                Swal.close();
                
                // Show error details for debugging
                let errorMessage = 'Failed to load templates';
                if (status === 'timeout') {
                    errorMessage = 'Template loading timed out. Please check your connection or try again.';
                } else if (xhr.status === 403) {
                    errorMessage = 'Access denied. Please check your permissions.';
                } else if (xhr.status === 404) {
                    errorMessage = 'Template service not found.';
                } else if (xhr.responseText) {
                    errorMessage = 'Server error: ' + xhr.responseText.substring(0, 100);
                }
                
                // Show error with fallback option
                Swal.fire({
                    icon: 'warning',
                    title: 'Template Loading Issue',
                    html: `
                        <div style="text-align: left; margin: 20px 0;">
                            <p><strong>Error:</strong> ${errorMessage}</p>
                            <h4 style="color: #3c8dbc; margin: 15px 0;">Selected Fee Groups:</h4>
                            <div style="background: #f8f9fa; padding: 15px; border-radius: 5px; margin-bottom: 20px; font-size: 14px;">
                                ${feeGroupsList}
                                <hr style="margin: 10px 0;">
                                <strong>Total Amount: ₹${totalAmount.toFixed(2)}</strong>
                            </div>
                            <p><i class="fa fa-info-circle"></i> Would you like to use the default template instead?</p>
                        </div>
                    `,
                    showCancelButton: true,
                    confirmButtonText: '🖨️ Use Default Template',
                    cancelButtonText: 'Cancel',
                    confirmButtonColor: '#28a745',
                    cancelButtonColor: '#6c757d',
                    width: '600px'
                }).then((result) => {
                    if (result.isConfirmed) {
                        printMultiGroupReceipt(studentSessionId, selectedFeeGroups, 'default_receipt');
                    }
                });
            }
        });
    });

    // Print Receipt functionality
    $(document).on('click', '.printReceiptBtn', function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        var studentSessionId = $(this).data('student_session_id');
        var studentFeesMasterId = $(this).data('student_fees_master_id');
        var feeGroup = $(this).data('group');
        var paidAmount = $(this).data('paid_amount');
        var feeCode = $(this).data('fee_code');
        
        // Show template selection modal
        showReceiptTemplateModal(studentSessionId, studentFeesMasterId, feeGroup, paidAmount, feeCode);
    });

    function showReceiptTemplateModal(studentSessionId, studentFeesMasterId, feeGroup, paidAmount, feeCode) {
        // Show immediate loading indicator
        Swal.fire({
            title: 'Loading Templates...',
            html: 'Please wait while we prepare your receipt options.',
            allowOutsideClick: false,
            allowEscapeKey: false,
            showConfirmButton: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });
        
        // Get available active receipt templates
        $.ajax({
            url: '<?php echo site_url("admin/simple_receipt/get_templates"); ?>',
            type: 'GET',
            dataType: 'JSON',
            timeout: 5000, // 5 second timeout
            success: function(templates) {
                console.log('Templates received:', templates);
                var templateOptions = '';
                
                // Handle both array and single object responses
                var templateArray = [];
                if (Array.isArray(templates)) {
                    templateArray = templates;
                } else if (templates && typeof templates === 'object' && templates.id) {
                    templateArray = [templates];
                }
                
                // Process templates
                if (templateArray.length > 0) {
                    templateArray.forEach(function(template) {
                        console.log('Processing template:', template);
                        // Only show active templates
                        if (template.is_active == "1" || template.is_active == 1) {
                            templateOptions += '<option value="' + template.template_code + '">' + template.template_name + '</option>';
                        }
                    });
                }
                
                // If no active templates found, show default
                if (templateOptions === '') {
                    templateOptions = '<option value="default_receipt">Default Receipt Template</option>';
                }
                
                console.log('Template options HTML:', templateOptions);

                Swal.fire({
                    title: '🧾 Select Receipt Template',
                    html: `
                        <div style="text-align: left; margin: 20px 0;">
                            <div style="background: #e8f5e8; padding: 15px; border-radius: 8px; margin-bottom: 15px; border-left: 4px solid #4CAF50;">
                                <h4 style="margin: 0 0 10px 0; color: #2e7d32;">📋 Fee Receipt Details</h4>
                                <div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
                                    <span>Fee Group:</span>
                                    <strong>${feeGroup}</strong>
                                </div>
                                <div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
                                    <span>Fee Code:</span>
                                    <strong>${feeCode}</strong>
                                </div>
                                <div style="display: flex; justify-content: space-between;">
                                    <span>Paid Amount:</span>
                                    <strong style="color: #4CAF50;">₹${parseFloat(paidAmount).toFixed(2)}</strong>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label style="display: block; margin-bottom: 8px; font-weight: bold;">Choose Receipt Template:</label>
                                <select id="receipt_template" class="form-control" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
                                    ${templateOptions}
                                </select>
                            </div>
                        </div>
                    `,
                    showCancelButton: true,
                    confirmButtonText: '<i class="fa fa-print"></i> Print Receipt',
                    cancelButtonText: '<i class="fa fa-times"></i> Cancel',
                    confirmButtonColor: '#4CAF50',
                    cancelButtonColor: '#dd4b39',
                    width: '500px'
                }).then((result) => {
                    if (result.isConfirmed) {
                        var selectedTemplate = $('#receipt_template').val();
                        printFeeReceipt(studentSessionId, studentFeesMasterId, feeGroup, paidAmount, feeCode, selectedTemplate);
                    }
                });
            },
            error: function(xhr, status, error) {
                console.log('AJAX Error:', error);
                console.log('Status:', status);
                console.log('Response:', xhr.responseText);
                // Show immediate fallback modal
                Swal.fire({
                    title: '🧾 Print Fee Receipt',
                    html: `
                        <div style="text-align: left; margin: 20px 0;">
                            <div style="background: #e8f5e8; padding: 15px; border-radius: 8px; margin-bottom: 15px; border-left: 4px solid #4CAF50;">
                                <h4 style="margin: 0 0 10px 0; color: #2e7d32;">📋 Fee Receipt Details</h4>
                                <div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
                                    <span>Fee Group:</span>
                                    <strong>${feeGroup}</strong>
                                </div>
                                <div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
                                    <span>Fee Code:</span>
                                    <strong>${feeCode}</strong>
                                </div>
                                <div style="display: flex; justify-content: space-between;">
                                    <span>Paid Amount:</span>
                                    <strong style="color: #4CAF50;">₹${parseFloat(paidAmount).toFixed(2)}</strong>
                                </div>
                            </div>
                            <p style="color: #666;">Using default receipt template...</p>
                        </div>
                    `,
                    showCancelButton: true,
                    confirmButtonText: '<i class="fa fa-print"></i> Print Receipt',
                    cancelButtonText: '<i class="fa fa-times"></i> Cancel',
                    confirmButtonColor: '#4CAF50',
                    cancelButtonColor: '#dd4b39'
                }).then((result) => {
                    if (result.isConfirmed) {
                        printFeeReceipt(studentSessionId, studentFeesMasterId, feeGroup, paidAmount, feeCode, 'default_receipt');
                    }
                });
            }
        });
    }

    // Multi-group receipt printing function
    function printMultiGroupReceipt(studentSessionId, feeGroupsData, templateCode) {
        // Calculate total amount from fee groups data
        let totalAmount = 0;
        feeGroupsData.forEach(function(group) {
            totalAmount += parseFloat(group.amount) || 0;
        });
        // Show professional processing dialog with steps
        let currentStep = 0;
        const steps = [
            '🔍 Validating student information...',
            '📋 Loading receipt template...',
            '💰 Calculating multi-group fee details...',
            '🖨️ Generating multi-group receipt document...',
            '✅ Multi-group receipt ready for printing!'
        ];
        
        Swal.fire({
            title: '🧾 Generating Multi-Group Fee Receipt',
            html: `
                <div style="text-align: center; padding: 20px;">
                    <div style="background: linear-gradient(135deg, #4CAF50, #45a049); color: white; padding: 15px; border-radius: 10px; margin-bottom: 20px;">
                        <i class="fa fa-receipt" style="font-size: 24px; margin-bottom: 10px;"></i>
                        <div style="font-size: 16px; font-weight: 500;">Processing Multi-Group Receipt Generation</div>
                    </div>
                    
                    <div id="progress-container" style="margin: 20px 0;">
                        <div style="background: #f0f0f0; border-radius: 10px; height: 8px; margin-bottom: 15px;">
                            <div id="progress-bar" style="background: linear-gradient(90deg, #4CAF50, #45a049); height: 100%; border-radius: 10px; width: 0%; transition: width 0.5s ease;"></div>
                        </div>
                        <div id="step-text" style="color: #666; font-size: 14px; min-height: 20px;">${steps[0]}</div>
                    </div>
                    
                    <div style="display: flex; justify-content: center; align-items: center; margin-top: 15px;">
                        <div class="spinner-border text-success" role="status" style="width: 20px; height: 20px; border: 2px solid #f3f3f3; border-top: 2px solid #4CAF50; border-radius: 50%; animation: spin 1s linear infinite;">
                            <span class="sr-only">Loading...</span>
                        </div>
                        <span style="margin-left: 10px; color: #4CAF50; font-weight: 500;">Please wait...</span>
                    </div>
                </div>
                
                <style>
                @keyframes spin {
                    0% { transform: rotate(0deg); }
                    100% { transform: rotate(360deg); }
                }
                </style>
            `,
            allowOutsideClick: false,
            showConfirmButton: false,
            customClass: {
                popup: 'receipt-generation-modal'
            },
            didOpen: () => {
                // Animate progress steps
                const progressBar = document.getElementById('progress-bar');
                const stepText = document.getElementById('step-text');
                
                const updateProgress = () => {
                    if (currentStep < steps.length) {
                        progressBar.style.width = ((currentStep + 1) / steps.length * 100) + '%';
                        stepText.textContent = steps[currentStep];
                        currentStep++;
                        
                        if (currentStep < steps.length) {
                            setTimeout(updateProgress, 800);
                        } else {
                            // Generate receipt after animation completes
                            setTimeout(() => {
                                const feeGroupsJson = JSON.stringify(feeGroupsData);
                                const receiptUrl = base_url + 'studentfee/print_multi_group_receipt/' + studentSessionId + 
                                    '?template_code=' + encodeURIComponent(templateCode) + 
                                    '&fee_groups=' + encodeURIComponent(feeGroupsJson) + 
                                    '&total_amount=' + encodeURIComponent(totalAmount);
                                
                                // Close loading dialog
                                Swal.close();
                                
                                // Open receipt in new window
                                window.open(receiptUrl, '_blank', 'width=800,height=600,scrollbars=yes,resizable=yes');
                                
                                // Show success message
                                Swal.fire({
                                    icon: 'success',
                                    title: '🎉 Multi-Group Receipt Generated!',
                                    html: `
                                        <div style="text-align: center; padding: 15px;">
                                            <div style="background: #e8f5e8; padding: 15px; border-radius: 8px; margin: 15px 0;">
                                                <h4 style="margin: 0 0 10px 0; color: #2e7d32;">📋 Receipt Summary</h4>
                                                <p style="margin: 5px 0;"><strong>Total Groups:</strong> ${feeGroupsData.length}</p>
                                                <p style="margin: 5px 0;"><strong>Total Amount:</strong> ₹${parseFloat(totalAmount).toFixed(2)}</p>
                                                <p style="margin: 5px 0;"><strong>Template:</strong> ${templateCode}</p>
                                            </div>
                                            <p style="color: #666; font-size: 14px; margin-top: 15px;">
                                                The multi-group receipt has been opened in a new window. You can print or save it from there.
                                            </p>
                                        </div>
                                    `,
                                    confirmButtonText: 'OK',
                                    confirmButtonColor: '#4CAF50',
                                    timer: 5000,
                                    timerProgressBar: true
                                });
                            }, 1000);
                        }
                    }
                };
                
                // Start progress animation
                setTimeout(updateProgress, 500);
            }
        });
    }

    function printFeeReceipt(studentSessionId, studentFeesMasterId, feeGroup, paidAmount, feeCode, templateCode) {
        // Show professional processing dialog with steps
        let currentStep = 0;
        const steps = [
            '🔍 Validating student information...',
            '📋 Loading receipt template...',
            '💰 Calculating fee details...',
            '🖨️ Generating receipt document...',
            '✅ Receipt ready for printing!'
        ];
        
        Swal.fire({
            title: '🧾 Generating Fee Receipt',
            html: `
                <div style="text-align: center; padding: 20px;">
                    <div style="background: linear-gradient(135deg, #4CAF50, #45a049); color: white; padding: 15px; border-radius: 10px; margin-bottom: 20px;">
                        <i class="fa fa-receipt" style="font-size: 24px; margin-bottom: 10px;"></i>
                        <div style="font-size: 16px; font-weight: 500;">Processing Receipt Generation</div>
                    </div>
                    
                    <div id="progress-container" style="margin: 20px 0;">
                        <div style="background: #f0f0f0; border-radius: 10px; height: 8px; margin-bottom: 15px;">
                            <div id="progress-bar" style="background: linear-gradient(90deg, #4CAF50, #45a049); height: 100%; border-radius: 10px; width: 0%; transition: width 0.5s ease;"></div>
                        </div>
                        <div id="step-text" style="color: #666; font-size: 14px; min-height: 20px;">${steps[0]}</div>
                    </div>
                    
                    <div style="display: flex; justify-content: center; align-items: center; margin-top: 15px;">
                        <div class="spinner-border text-success" role="status" style="width: 20px; height: 20px; border: 2px solid #f3f3f3; border-top: 2px solid #4CAF50; border-radius: 50%; animation: spin 1s linear infinite;">
                            <span class="sr-only">Loading...</span>
                        </div>
                        <span style="margin-left: 10px; color: #4CAF50; font-weight: 500;">Please wait...</span>
                    </div>
                </div>
                
                <style>
                @keyframes spin {
                    0% { transform: rotate(0deg); }
                    100% { transform: rotate(360deg); }
                }
                </style>
            `,
            allowOutsideClick: false,
            showConfirmButton: false,
            customClass: {
                popup: 'receipt-generation-modal'
            },
            didOpen: () => {
                // Animate progress steps
                const progressBar = document.getElementById('progress-bar');
                const stepText = document.getElementById('step-text');
                
                const updateStep = () => {
                    if (currentStep < steps.length) {
                        stepText.textContent = steps[currentStep];
                        progressBar.style.width = ((currentStep + 1) / steps.length * 100) + '%';
                        currentStep++;
                        
                        if (currentStep < steps.length) {
                            setTimeout(updateStep, 600);
                        }
                    }
                };
                
                setTimeout(updateStep, 300);
            }
        });

        // Generate receipt URL with template selection
        var printUrl = '<?php echo site_url("studentfee/print_receipt"); ?>/' + studentSessionId + '/' + studentFeesMasterId + 
                            '?template_code=' + templateCode + 
                            '&fee_group=' + encodeURIComponent(feeGroup) + 
                            '&paid_amount=' + paidAmount + 
                            '&fee_code=' + encodeURIComponent(feeCode);

        // Close processing dialog and open receipt after all steps complete
        setTimeout(() => {
            Swal.close();
            window.open(printUrl, 'receipt_window', 'width=800,height=600,scrollbars=yes,resizable=yes');
        }, 3500); // Increased time to show all progress steps
    }
});
</script>