<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo isset($title) ? $title : 'Certificate Verification'; ?></title>
    <link href="https://fonts.googleapis.com/css?family=Roboto:400,500,700" rel="stylesheet">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <style type="text/css">
        *{padding: 0; margin:0;}
        body{ 
            font-family: 'arial';
            background: #f0f0f0;
            padding: 20px;
        }
        .certificate-container {
            width: 100%;
            max-width: 800px;
            margin: 0 auto;
            background-color: #fff;
            box-shadow: 0 0 15px rgba(0,0,0,0.2);
            position: relative;
        }
        .certificate-header {
            background-color: #6a329f;
            color: white;
            padding: 10px;
            text-align: center;
            position: relative;
        }
        .school-logo {
            position: absolute;
            left: 10px;
            top: 10px;
            width: 80px;
            height: 80px;
            background-color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .school-logo img {
            max-width: 70px;
            max-height: 70px;
        }
        .qr-code {
            position: absolute;
            right: 10px;
            top: 10px;
            width: 80px;
            height: 80px;
            background-color: white;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .qr-code img {
            max-width: 70px;
            max-height: 70px;
        }
        .school-details {
            text-align: center;
            padding: 10px 100px;
        }
        .school-name {
            font-size: 18px;
            font-weight: bold;
            margin: 0;
        }
        .school-address {
            font-size: 12px;
            margin: 5px 0;
        }
        .school-contact {
            font-size: 12px;
            margin: 0;
        }
        .certificate-title {
            text-align: center;
            padding: 10px;
            font-weight: bold;
            border-bottom: 1px solid #ddd;
            border-top: 1px solid #ddd;
            margin-top: 10px;
            background-color: #f9f9f9;
        }
        .certificate-body {
            padding: 0;
        }
        .verification-form {
            padding: 20px;
            background-color: #f9f9f9;
            border-bottom: 1px solid #ddd;
        }
        .student-table {
            width: 100%;
            border-collapse: collapse;
        }
        .student-table th, .student-table td {
            border: 1px solid #ddd;
            padding: 8px 15px;
        }
        .student-table th {
            width: 40%;
            text-align: left;
            background-color: #f2f2f2;
        }
        .student-table td {
            width: 60%;
        }
        .watermark {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            font-size: 100px;
            color: rgba(0,0,0,0.05);
            pointer-events: none;
            z-index: 1;
        }
        .certificate-footer {
            display: flex;
            justify-content: space-between;
            padding: 20px;
            border-top: 1px solid #ddd;
        }
        .signature {
            text-align: center;
            width: 30%;
        }
        .signature-line {
            border-top: 1px solid #000;
            margin-top: 40px;
            margin-bottom: 5px;
        }
        .btn-verify {
            background-color: #4CAF50;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
        }
        
        .btn-verify:hover {
            background-color: #45a049;
            color: white;
        }
        
        /* Hacker-style Loader Styles */
        .loader-container {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.9);
            z-index: 9999;
            justify-content: center;
            align-items: center;
            flex-direction: column;
            font-family: 'Courier New', monospace;
        }
        
        .loader {
            width: 80%;
            max-width: 600px;
            height: 300px;
            background-color: #000;
            border: 2px solid #0f0;
            box-shadow: 0 0 20px #0f0;
            padding: 20px;
            overflow: hidden;
            position: relative;
            margin-bottom: 20px;
        }
        
        .loader:before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 5px;
            background: linear-gradient(to right, transparent, #0f0, transparent);
            animation: scan 3s linear infinite;
        }
        
        @keyframes scan {
            0% { transform: translateY(0); }
            50% { transform: translateY(300px); }
            100% { transform: translateY(0); }
        }
        
        .code-text {
            color: #0f0;
            font-size: 14px;
            line-height: 1.4;
            white-space: pre;
            overflow: hidden;
            height: 100%;
            margin: 0;
            animation: typing 0.5s steps(40) infinite;
        }
        
        @keyframes typing {
            from { height: 0 }
            to { height: 100% }
        }
        
        .loader-text {
            font-size: 24px;
            font-weight: bold;
            color: #0f0;
            text-shadow: 0 0 10px #0f0;
            margin-top: 20px;
            text-transform: uppercase;
            letter-spacing: 2px;
            animation: blink 1s infinite;
        }
        
        @keyframes blink {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.5; }
        }
        
        .progress-bar {
            width: 80%;
            max-width: 600px;
            height: 20px;
            background-color: #000;
            border: 2px solid #0f0;
            margin-top: 20px;
            position: relative;
            overflow: hidden;
        }
        
        .progress {
            width: 0%;
            height: 100%;
            background-color: #0f0;
            animation: progress 3s linear forwards;
        }
        
        @keyframes progress {
            0% { width: 0%; }
            100% { width: 100%; }
        }
        
        /* Student Photo Styles */
        .student-photo-container {
            position: absolute;
            top: 50%;
            right: 20px;
            transform: translateY(-50%);
            text-align: center;
        }
        
        .student-photo-frame {
            width: 120px;
            height: 120px;
            border: 2px solid #0f0;
            box-shadow: 0 0 10px #0f0;
            overflow: hidden;
            margin-bottom: 10px;
            position: relative;
        }
        
        .student-photo {
            width: 100%;
            height: 100%;
            object-fit: cover;
            filter: grayscale(0.5) sepia(0.3) hue-rotate(60deg);
            animation: scan-photo 2s infinite;
        }
        
        @keyframes scan-photo {
            0%, 100% { filter: grayscale(0.5) sepia(0.3) hue-rotate(60deg); }
            50% { filter: grayscale(0.7) sepia(0.5) hue-rotate(90deg); }
        }
        
        .student-photo-label {
            color: #0f0;
            font-size: 12px;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 1px;
            animation: blink 1s infinite;
        }
        
        .photo-placeholder {
            display: flex;
            width: 100%;
            height: 100%;
            align-items: center;
            justify-content: center;
            color: #0f0;
            font-family: monospace;
            font-size: 14px;
            text-align: center;
            background-color: #000;
            text-shadow: 0 0 5px #0f0;
            animation: blink 1s infinite;
        }
        .result-container {
            margin: 10px 20px;
            padding: 10px;
            border-radius: 4px;
        }
        .result-success {
            background-color: #dff0d8;
            border: 1px solid #d6e9c6;
        }
        .result-error {
            background-color: #f2dede;
            border: 1px solid #ebccd1;
        }
        .copyright {
            text-align: center;
            font-size: 12px;
            color: #777;
            margin-top: 20px;
        }
    </style>
    <script>
        $(document).ready(function() {
            // Always show loader on page load first
            $(".loader-container").css("display", "flex");
            
            // Only hide loader after 5 seconds
            setTimeout(function() {
                $(".loader-container").hide();
            }, 5000);
            
            // Show loader when form is submitted
            $("#verification-form").submit(function() {
                $(".loader-container").css("display", "flex");
                
                // Add a minimum display time for the loader (5 seconds)
                setTimeout(function() {
                    // This code will run after form submission, but the page will
                    // likely have navigated away by then unless there's an error
                }, 5000);
                
                return true;
            });
        });
    </script>
</head>
<body>
    <!-- Hacker-style Loader Container -->
    <div class="loader-container">
        <div class="loader">
            <pre class="code-text">Initializing verification system...
Connecting to secure database...
Accessing student records...
Verifying admission number...
Verifying student name...
Cross-referencing with school records...
Decrypting student information...
Analyzing academic history...
Validating certificate authenticity...
Preparing verification report...
Security check: PASSED
Access granted to student records...</pre>
            
            <!-- Student Photo Container - Inside the loader -->
            <div class="student-photo-container">
                <div class="student-photo-frame">
                    <!-- Using a static image that will definitely work -->
                    <div class="photo-placeholder">STUDENT<br>PHOTO</div>
                </div>
                <div class="student-photo-label">IDENTITY VERIFIED</div>
            </div>
        </div>
        
        <div class="loader-text">VERIFYING STUDENT CREDENTIALS</div>
        <div class="progress-bar">
            <div class="progress"></div>
        </div>
    </div>
    
    <div class="certificate-container">
        <!-- School Header -->
        <div class="certificate-header">
            <div class="school-logo">
                <?php if(isset($sch_setting) && !empty($sch_setting->image)): ?>
                <img src="<?php echo base_url(); ?>uploads/school_content/logo/<?php echo $sch_setting->image; ?>" alt="School Logo">
                <?php else: ?>
                <img src="<?php echo base_url(); ?>uploads/school_content/logo/logo.png" alt="School Logo">
                <?php endif; ?>
            </div>
            <div class="school-details">
                <h1 class="school-name"><?php echo (isset($sch_setting) && !empty($sch_setting->name)) ? $sch_setting->name : 'School Name'; ?></h1>
                <p class="school-address"><?php echo (isset($sch_setting) && !empty($sch_setting->address)) ? $sch_setting->address : 'School Address'; ?></p>
                <p class="school-contact">
                    <?php if(isset($sch_setting) && !empty($sch_setting->phone)): ?>
                    <?php echo $sch_setting->phone; ?> | 
                    <?php endif; ?>
                    Email: <?php echo (isset($sch_setting) && !empty($sch_setting->email)) ? $sch_setting->email : 'school@example.com'; ?>
                </p>
            </div>
            <div class="" style="text-align: center;">
                <?php if(isset($qr_code_url)): ?>
                <!-- QR code for verification -->
                <img src="<?php echo $qr_code_url; ?>" alt="Verification QR Code" style="width: 100px; height: 100px; background: white; padding: 5px;">
                <p style="font-size: 12px; margin-top: 5px;">Scan to verify</p>
                
                <?php else: ?>
                <!-- Default QR code if none provided -->
               
                <p style="font-size: 12px; margin-top: 5px;">Scan to verify</p>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Certificate Title -->
        <div class="certificate-title">
            <?php if (!empty($success) && isset($student)): ?>
                TC VERIFICATION 
            <?php else: ?>
                TC VERIFICATION 
            <?php endif; ?>
        </div>
        
        <!-- Verification Form -->
        <?php if (empty($success) || !isset($student)): ?>
        <div class="verification-form">
            <?php echo form_open('verifycertificate/verify', array('class' => 'form-horizontal', 'id' => 'verification-form')); ?>
                <div class="form-group">
                    <label for="admission_no" class="col-sm-4 control-label">Admission Number:</label>
                    <div class="col-sm-6">
                        <input type="text" class="form-control" id="admission_no" name="admission_no" value="<?php echo isset($admission_no) ? $admission_no : ''; ?>" placeholder="Enter student admission number">
                    </div>
                </div>
                <div class="form-group">
                    <label for="student_name" class="col-sm-4 control-label">Student Name: <span class="text-danger">*</span></label>
                    <div class="col-sm-6">
                        <input type="text" class="form-control" id="student_name" name="student_name" value="<?php echo isset($student_name) ? $student_name : ''; ?>" placeholder="Enter student name" required>
                    </div>
                </div>
                <div class="form-group">
                    <div class="col-sm-offset-4 col-sm-6">
                        <button type="submit" class="btn btn-verify">Verify Student</button>
                    </div>
                </div>
            <?php echo form_close(); ?>
        </div>
        <?php endif; ?>
        
        <!-- Error Message -->
        <?php if (!empty($error)): ?>
            <div class="result-container result-error">
                <i class="fa fa-times-circle"></i> <?php echo $error; ?>
            </div>
        <?php endif; ?>
        
        <!-- Student Details -->
        <?php if (!empty($success) && isset($student)): ?>
            <?php if (!empty($success)): ?>
                <div class="watermark">VERIFIED</div>
            <?php endif; ?>
            
            <div class="certificate-body">
                <table class="student-table">
                    <tr>
                        <th>1. Admission Number</th>
                        <td><?php echo isset($student['admission_no']) ? $student['admission_no'] : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>2. Name of the Pupil</th>
                        <td><?php echo (isset($student['firstname']) && isset($student['lastname'])) ? strtoupper($student['firstname'] . ' ' . $student['lastname']) : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>3. Father's Name</th>
                        <td><?php echo isset($student['father_name']) ? $student['father_name'] : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>4. Mother's Name</th>
                        <td><?php echo isset($student['mother_name']) ? $student['mother_name'] : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>5. Date of Birth (In Christian Era)</th>
                        <td><?php echo isset($student['dob']) ? date('d/m/Y', strtotime($student['dob'])) : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>6. Gender</th>
                        <td><?php echo isset($student['gender']) ? ucfirst($student['gender']) : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>7. Nationality</th>
                        <td>INDIAN</td>
                    </tr>
                    <tr>
                        <th>8. Religion</th>
                        <td><?php echo isset($student['religion']) ? $student['religion'] : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>9. Cast</th>
                        <td><?php echo isset($student['cast']) ? $student['cast'] : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>10. Blood Group</th>
                        <td><?php echo isset($student['blood_group']) ? $student['blood_group'] : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>11. Date of first admission in school</th>
                        <td><?php echo isset($student['admission_date']) ? date('d/m/Y', strtotime($student['admission_date'])) : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>12. Class</th>
                        <td><?php echo isset($student['class']) ? $student['class'] : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>13. Section</th>
                        <td><?php echo isset($student['section']) ? $student['section'] : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>14. Mobile Number</th>
                        <td><?php echo isset($student['mobileno']) ? $student['mobileno'] : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>15. Email</th>
                        <td><?php echo isset($student['email']) ? $student['email'] : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>16. Current Address</th>
                        <td><?php echo isset($student['current_address']) ? $student['current_address'] : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>17. Permanent Address</th>
                        <td><?php echo isset($student['permanent_address']) ? $student['permanent_address'] : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>18. Guardian Name</th>
                        <td><?php echo isset($student['guardian_name']) ? $student['guardian_name'] : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>19. Guardian Occupation</th>
                        <td><?php echo isset($student['guardian_occupation']) ? $student['guardian_occupation'] : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>20. Guardian Phone</th>
                        <td><?php echo isset($student['guardian_phone']) ? $student['guardian_phone'] : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>21. Guardian Address</th>
                        <td><?php echo isset($student['guardian_address']) ? $student['guardian_address'] : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>22. Previous School</th>
                        <td><?php echo isset($student['previous_school']) ? $student['previous_school'] : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>23. Height</th>
                        <td><?php echo isset($student['height']) ? $student['height'] : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>24. Weight</th>
                        <td><?php echo isset($student['weight']) ? $student['weight'] : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>25. Subjects</th>
                        <td><?php echo isset($student['subjects']) ? $student['subjects'] : 'English, Hindi, Mathematics, Science'; ?></td>
                    </tr>
                    <tr>
                        <th>26. Class in which the pupil last studied</th>
                        <td><?php echo (isset($student['class'])) ? $student['class'] : 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <th>27. School / Board Annual examination last taken with result</th>
                        <td><?php echo isset($student['exam_result']) ? $student['exam_result'] : 'School Examination, Passed'; ?></td>
                    </tr>
                    <tr>
                        <th>28. Whether failed, if so once / twice in the same class</th>
                        <td>NO</td>
                    </tr>
                    <tr>
                        <th>29. General Conduct</th>
                        <td>GOOD</td>
                    </tr>
                    <tr>
                        <th>30. Date of verification</th>
                        <td><?php echo date('d/m/Y'); ?></td>
                    </tr>
                </table>
            </div>
            
            <div class="certificate-footer">
                <div class="signature">
                    <div class="signature-line"></div>
                    <span>Admin</span>
                </div>
                <div class="signature">
                    <div class="signature-line"></div>
                    <span>Class Teacher</span>
                </div>
                <div class="signature">
                    <div class="signature-line"></div>
                    <span>Principal</span>
                </div>
            </div>
        <?php endif; ?>
    </div>
    
    <div class="copyright">
        <p>© <?php echo date('Y'); ?> School Certificate Verification System</p>
        <p><a href="<?php echo site_url(); ?>">Back to Home</a></p>
    </div>
    
    <!-- jQuery and Bootstrap JS -->
    <script src="<?php echo base_url(); ?>backend/custom/jquery.min.js"></script>
    <script src="<?php echo base_url(); ?>backend/bootstrap/js/bootstrap.min.js"></script>
</body>
</html>
