// Simple function to play a beep sound
function playBeep() {
    console.log('Playing beep sound...');
    
    // Create a beep sound
    const context = new (window.AudioContext || window.webkitAudioContext)();
    const oscillator = context.createOscillator();
    const gainNode = context.createGain();
    
    oscillator.type = 'sine';
    oscillator.frequency.value = 800;
    oscillator.connect(gainNode);
    gainNode.connect(context.destination);
    
    oscillator.start(0);
    
    // Stop after 200ms
    setTimeout(function() {
        oscillator.stop(0);
        console.log('Beep finished');
    }, 200);
    
    return true;
}
