-- Create ID Card table
CREATE TABLE IF NOT EXISTS `id_card` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idcard_name` varchar(100) NOT NULL,
  `idcard_text` text NOT NULL,
  `left_header` varchar(100) DEFAULT NULL,
  `center_header` varchar(100) DEFAULT NULL,
  `right_header` varchar(100) DEFAULT NULL,
  `left_footer` varchar(100) DEFAULT NULL,
  `center_footer` varchar(100) DEFAULT NULL,
  `right_footer` varchar(100) DEFAULT NULL,
  `header_height` varchar(10) DEFAULT NULL,
  `footer_height` varchar(10) DEFAULT NULL,
  `content_height` varchar(10) DEFAULT NULL,
  `content_width` varchar(10) DEFAULT NULL,
  `enable_student_image` tinyint(1) DEFAULT '0',
  `enable_image_height` varchar(10) DEFAULT NULL,
  `background_image` varchar(255) DEFAULT NULL,
  `created_for` tinyint(1) DEFAULT '0' COMMENT '0=all, 1=admin, 2=student',
  `status` tinyint(1) DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `cards_per_page` int(11) DEFAULT '1',
  `card_width` varchar(10) DEFAULT NULL,
  `card_height` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Add permissions for ID Card in the Certificate group
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES
(NULL, (SELECT id FROM `permission_group` WHERE `short_code` = 'certificate'), 'Student ID Card', 'student_id_card', 1, 1, 1, 1, '2025-05-31 00:00:00');

-- Create directory for ID card uploads if it doesn't exist
-- Note: This needs to be done manually on the server
-- mkdir -p uploads/idcard
