<?php
$currency_symbol = $this->customlib->getSchoolCurrencyFormat();
?>
<!-- Include jQuery and Bootstrap -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<!-- Summernote CSS -->
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">
<!-- Summernote JS -->
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.js"></script>
<!-- Summernote plugins -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.41.0/codemirror.min.css" rel="stylesheet">
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.41.0/codemirror.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.41.0/mode/xml/xml.min.js"></script>
<style>
    .note-editor {
        margin: 0;
        border: 1px solid #ddd;
        border-radius: 4px;
    }
    .note-editor.note-frame .note-editing-area .note-editable {
        min-height: 250px;
        padding: 15px;
    }
    .card-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
        gap: 20px;
        margin-top: 20px;
    }
    .card-preview {
        border: 1px solid #ddd;
        padding: 10px;
        border-radius: 5px;
        background-color: #f9f9f9;
    }
    .card-preview img {
        max-width: 100%;
        height: auto;
    }
</style>
<div class="content-wrapper">
    <section class="content-header">
        <h1><i class="fa fa-id-card"></i> <?php echo $this->lang->line('student_id_card'); ?></h1>
    </section>
    <section class="content">
        <div class="row">
            <?php
            if ($this->rbac->hasPrivilege('student_id_card', 'can_add')) {
            ?>
                <div class="col-md-4">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">
                                <?php if(isset($edit_mode) && $edit_mode): ?>
                                    <?php echo $this->lang->line('edit_student_id_card'); ?>
                                <?php else: ?>
                                    <?php echo $this->lang->line('add_student_id_card'); ?>
                                <?php endif; ?>
                            </h3>
                        </div><!-- /.box-header -->
                        <form id="form1" enctype="multipart/form-data" action="<?php echo isset($edit_mode) && $edit_mode ? site_url('admin/idcard/edit/'.$id) : site_url('admin/idcard/index'); ?>"  id="idcardform" name="idcardform" method="post" accept-charset="utf-8">
                            <?php if(isset($edit_mode) && $edit_mode): ?>
                                <input type="hidden" name="id" value="<?php echo $editidcard[0]->id; ?>" />
                            <?php endif; ?>
                            <div class="box-body">
                                <?php if ($this->session->flashdata('msg')) {?>
                                    <?php 
                                        echo $this->session->flashdata('msg'); 
                                        $this->session->unset_userdata('msg'); 
                                    ?>
                                <?php }?>
                                <?php if ($this->session->flashdata('debug_info')) {?>
                                    <?php 
                                        echo $this->session->flashdata('debug_info'); 
                                        $this->session->unset_userdata('debug_info'); 
                                    ?>
                                <?php }?>
                                <?php
                                if (isset($error_message)) {
                                    echo "<div class='alert alert-danger'>" . $error_message . "</div>";
                                }
                                ?>
                                <div class="form-group">
                                    <label>ID Card Name</label><small class="req"> *</small>
                                    <input autofocus="" id="idcard_name" name="idcard_name" type="text" class="form-control" value="<?php echo isset($edit_mode) && $edit_mode ? $editidcard[0]->idcard_name : set_value('idcard_name'); ?>" />
                                    <span class="text-danger"><?php echo form_error('idcard_name'); ?></span>
                                </div>
                                <div class="form-group">
                                    <label>Header Left Text</label>
                                    <input id="left_header" name="left_header" type="text" class="form-control" value="<?php echo isset($edit_mode) && $edit_mode ? $editidcard[0]->left_header : set_value('left_header'); ?>" />
                                </div>
                                <div class="form-group">
                                    <label>Header Center Text</label>
                                    <input id="center_header" name="center_header" type="text" class="form-control" value="<?php echo isset($edit_mode) && $edit_mode ? $editidcard[0]->center_header : set_value('center_header'); ?>" />
                                </div>
                                <div class="form-group">
                                    <label>Header Right Text</label>
                                    <input id="right_header" name="right_header" type="text" class="form-control" value="<?php echo isset($edit_mode) && $edit_mode ? $editidcard[0]->right_header : set_value('right_header'); ?>" />
                                </div>
                                <div class="form-group">
                                    <label>ID Card Text</label><small class="req"> *</small>
                                    <textarea class="form-control summernote" id="idcard_text" name="idcard_text"><?php echo isset($edit_mode) && $edit_mode ? $editidcard[0]->idcard_text : set_value('idcard_text'); ?></textarea>
                                </div>
                                <div class="form-group">
                                    <div class="well well-sm" style="margin-top: 10px; background-color: #f5f5f5; border: 1px solid #e3e3e3; border-radius: 4px; padding: 10px;">
                                        <label style="display: block; margin-bottom: 5px; color: #3c8dbc;"><?php echo $this->lang->line('available_placeholders'); ?>:</label>
                                        <div class="placeholders-container" style="line-height: 2;">
                                            <h5 style="color: #3c8dbc; margin: 10px 0 5px 0;"><?php echo $this->lang->line('student_fields'); ?>:</h5>
                                            <?php foreach ($student_fields as $field): ?>
                                                <span class="label label-primary placeholder-item" style="display: inline-block; margin: 2px; padding: 5px; cursor: pointer;" data-placeholder="[<?php echo $field; ?>]" title="Click to copy">[<?php echo $field; ?>]</span>
                                            <?php endforeach; ?>
                                            
                                            <?php if (!empty($custom_fields)): ?>
                                                <h5 style="color: #3c8dbc; margin: 15px 0 5px 0;"><?php echo $this->lang->line('custom_fields'); ?>:</h5>
                                                <?php foreach ($custom_fields as $field): ?>
                                                    <span class="label label-success placeholder-item" style="display: inline-block; margin: 2px; padding: 5px; cursor: pointer;" data-placeholder="[<?php echo $field->name; ?>]" title="Click to copy">[<?php echo $field->name; ?>]</span>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </div>
                                        
                                        <script type="text/javascript">
                                        $(document).ready(function() {
                                            // Make placeholder items clickable to copy to clipboard
                                            $('.placeholder-item').on('click', function() {
                                                var placeholder = $(this).data('placeholder');
                                                var $temp = $("<input>");
                                                $("body").append($temp);
                                                $temp.val(placeholder).select();
                                                document.execCommand("copy");
                                                $temp.remove();
                                                
                                                // Show copied feedback
                                                var originalText = $(this).text();
                                                $(this).text('Copied!');
                                                $(this).addClass('label-info').removeClass('label-primary label-success');
                                                
                                                setTimeout(function() {
                                                    $(this).text(originalText);
                                                    if ($(this).hasClass('label-info')) {
                                                        $(this).removeClass('label-info');
                                                        $(this).addClass(originalText.indexOf('[') === 0 ? 'label-primary' : 'label-success');
                                                    }
                                                }.bind(this), 1000);
                                            });
                                        });
                                        </script>
                                        <p class="help-block" style="margin-top: 10px; font-size: 12px;">Click on placeholders to copy and paste into the ID card text</p>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Footer Left Text</label>
                                    <input id="left_footer" name="left_footer" type="text" class="form-control" value="<?php echo isset($edit_mode) && $edit_mode ? $editidcard[0]->left_footer : set_value('left_footer'); ?>" />
                                </div>
                                <div class="form-group">
                                    <label>Footer Center Text</label>
                                    <input id="center_footer" name="center_footer" type="text" class="form-control" value="<?php echo isset($edit_mode) && $edit_mode ? $editidcard[0]->center_footer : set_value('center_footer'); ?>" />
                                </div>
                                <div class="form-group">
                                    <label>Footer Right Text</label>
                                    <input id="right_footer" name="right_footer" type="text" class="form-control" value="<?php echo isset($edit_mode) && $edit_mode ? $editidcard[0]->right_footer : set_value('right_footer'); ?>" />
                                </div>
                                <div class="mediarow">
                                    <div class="row">
                                        <div class="img_div_modal"><label><?php echo $this->lang->line('id_card_design'); ?></label></div>
                                        <div class="col-md-6 col-sm-6 img_div_modal">
                                            <div class="form-group">
                                                <input id="header_height" name="header_height" placeholder="<?php echo $this->lang->line('header_height'); ?>" type="text" class="form-control" min="0" value="<?php echo isset($edit_mode) && $edit_mode ? $editidcard[0]->header_height : set_value('header_height'); ?>" />
                                            </div>
                                        </div><!--./col-md-6-->
                                        <div class="col-md-6 col-sm-6 img_div_modal">
                                            <div class="form-group">
                                                <input id="footer_height" name="footer_height" placeholder="<?php echo $this->lang->line('footer_height'); ?>" type="text" class="form-control" min="0" value="<?php echo isset($edit_mode) && $edit_mode ? $editidcard[0]->footer_height : set_value('footer_height'); ?>" />
                                            </div>
                                        </div><!--./col-md-6-->
                                        <div class="col-md-6 col-sm-6 img_div_modal">
                                            <div class="form-group">
                                                <input id="content_height" name="content_height" placeholder="<?php echo $this->lang->line('body_height'); ?>" type="text" class="form-control" min="0" value="<?php echo isset($edit_mode) && $edit_mode ? $editidcard[0]->content_height : set_value('content_height'); ?>" />
                                            </div>
                                        </div><!--./col-md-6-->
                                        <div class="col-md-6 col-sm-6 img_div_modal">
                                            <div class="form-group">
                                                <input id="content_width" name="content_width" placeholder="<?php echo $this->lang->line('body_width'); ?>" type="text" class="form-control" min="0" value="<?php echo isset($edit_mode) && $edit_mode ? $editidcard[0]->content_width : set_value('content_width'); ?>" />
                                            </div>
                                        </div><!--./col-md-6-->
                                        <div class="col-md-6 col-sm-6 img_div_modal">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <input id="card_width" name="card_width" placeholder="<?php echo $this->lang->line('id_card_width'); ?>" type="text" class="form-control" min="0" value="<?php echo isset($edit_mode) && $edit_mode ? $editidcard[0]->card_width : set_value('card_width'); ?>" data-toggle="tooltip" title="Enter the width of the ID card" />
                                                    <div class="input-group-btn">
                                                        <select class="form-control" name="card_width_unit" id="card_width_unit" style="width: auto;" data-toggle="tooltip" title="Select unit of measurement (px = pixels, mm = millimeters)">
                                                            <option value="px" <?php echo (isset($edit_mode) && $edit_mode && isset($editidcard[0]->card_width_unit) && $editidcard[0]->card_width_unit == 'px') ? 'selected' : ''; ?>>px</option>
                                                            <option value="mm" <?php echo (isset($edit_mode) && $edit_mode && isset($editidcard[0]->card_width_unit) && $editidcard[0]->card_width_unit == 'mm') ? 'selected' : ''; ?>>mm</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <small class="text-muted">You can set width in millimeters (mm) for physical printing</small>
                                            </div>
                                        </div><!--./col-md-6-->
                                        <div class="col-md-6 col-sm-6 img_div_modal">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <input id="card_height" name="card_height" placeholder="<?php echo $this->lang->line('id_card_height'); ?>" type="text" class="form-control" min="0" value="<?php echo isset($edit_mode) && $edit_mode ? $editidcard[0]->card_height : set_value('card_height'); ?>" data-toggle="tooltip" title="Enter the height of the ID card" />
                                                    <div class="input-group-btn">
                                                        <select class="form-control" name="card_height_unit" id="card_height_unit" style="width: auto;" data-toggle="tooltip" title="Select unit of measurement (px = pixels, mm = millimeters)">
                                                            <option value="px" <?php echo (isset($edit_mode) && $edit_mode && isset($editidcard[0]->card_height_unit) && $editidcard[0]->card_height_unit == 'px') ? 'selected' : ''; ?>>px</option>
                                                            <option value="mm" <?php echo (isset($edit_mode) && $edit_mode && isset($editidcard[0]->card_height_unit) && $editidcard[0]->card_height_unit == 'mm') ? 'selected' : ''; ?>>mm</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <small class="text-muted">You can set height in millimeters (mm) for physical printing</small>
                                            </div>
                                        </div><!--./col-md-6-->
                                        <div class="col-md-6 col-sm-6 img_div_modal">
                                            <div class="form-group">
                                                <select class="form-control" name="cards_per_page" id="cards_per_page">
                                                    <option value="1" <?php echo (isset($edit_mode) && $edit_mode && $editidcard[0]->cards_per_page == 1) ? 'selected' : ''; ?>>1 Card Per Page</option>
                                                    <option value="2" <?php echo (isset($edit_mode) && $edit_mode && $editidcard[0]->cards_per_page == 2) ? 'selected' : ''; ?>>2 Cards Per Page</option>
                                                    <option value="4" <?php echo (isset($edit_mode) && $edit_mode && $editidcard[0]->cards_per_page == 4) ? 'selected' : ''; ?>>4 Cards Per Page</option>
                                                    <option value="6" <?php echo (isset($edit_mode) && $edit_mode && $editidcard[0]->cards_per_page == 6) ? 'selected' : ''; ?>>6 Cards Per Page</option>
                                                    <option value="8" <?php echo (isset($edit_mode) && $edit_mode && $editidcard[0]->cards_per_page == 8) ? 'selected' : ''; ?>>8 Cards Per Page</option>
                                                    <option value="9" <?php echo (isset($edit_mode) && $edit_mode && $editidcard[0]->cards_per_page == 9) ? 'selected' : ''; ?>>9 Cards Per Page</option>
                                                    <option value="12" <?php echo (isset($edit_mode) && $edit_mode && $editidcard[0]->cards_per_page == 12) ? 'selected' : ''; ?>>12 Cards Per Page</option>
                                                </select>
                                            </div>
                                        </div><!--./col-md-6-->
                                        <div class="col-md-6 col-sm-6 img_div_modal minh45">
                                            <div class="form-group switch-inline">
                                                <label><?php echo $this->lang->line('student_photo'); ?></label>
                                                <div class="material-switch switchcheck">
                                                    <input id="enable_student_img" name="is_active_student_img" type="checkbox" class="chk" value="1" onclick="valueChanged()" <?php echo (isset($edit_mode) && $edit_mode && $editidcard[0]->is_active_student_img == 1) ? 'checked' : ''; ?>>
                                                    <label for="enable_student_img" class="label-success"></label>
                                                </div>
                                            </div>
                                        </div><!--./col-md-6-->
                                        <div class="col-md-6 col-sm-6 img_div_modal">
                                            <div class="form-group" id="enableImageDiv" <?php echo (isset($edit_mode) && $edit_mode && $editidcard[0]->is_active_student_img == 1) ? '' : 'hidden'; ?>>
                                                <div class="input-group">
                                                    <input id="image_height" name="image_height" placeholder="<?php echo $this->lang->line('photo_height'); ?>" type="text" class="form-control" min="0" value="<?php echo isset($edit_mode) && $edit_mode ? $editidcard[0]->image_height : set_value('image_height'); ?>" />
                                                    <span class="input-group-addon">px</span>
                                                </div>
                                                <div class="input-group" style="margin-top: 5px;">
                                                    <input id="image_width" name="image_width" placeholder="<?php echo $this->lang->line('photo_width'); ?>" type="text" class="form-control" min="0" value="<?php echo isset($edit_mode) && $edit_mode ? (isset($editidcard[0]->image_width) ? $editidcard[0]->image_width : '') : set_value('image_width'); ?>" />
                                                    <span class="input-group-addon">px</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-6 img_div_modal">
                                            <div class="form-group" id="imagePositionDiv" <?php echo (isset($edit_mode) && $edit_mode && $editidcard[0]->is_active_student_img == 1) ? '' : 'hidden'; ?>>
                                                <label>Image Position</label>
                                                <div class="row" style="margin-top: 5px;">
                                                    <div class="col-xs-4">
                                                        <div class="checkbox">
                                                            <label>
                                                                <input type="radio" name="image_position" value="top-left" <?php echo (isset($edit_mode) && $edit_mode && isset($editidcard[0]->image_position) && $editidcard[0]->image_position == 'top-left') ? 'checked' : 'checked'; ?>> Top Left
                                                            </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-xs-4">
                                                        <div class="checkbox">
                                                            <label>
                                                                <input type="radio" name="image_position" value="top-right" <?php echo (isset($edit_mode) && $edit_mode && isset($editidcard[0]->image_position) && $editidcard[0]->image_position == 'top-right') ? 'checked' : ''; ?>> Top Right
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row" style="margin-top: 5px;">
                                                    <div class="col-xs-4">
                                                        <div class="checkbox">
                                                            <label>
                                                                <input type="radio" name="image_position" value="bottom-left" <?php echo (isset($edit_mode) && $edit_mode && isset($editidcard[0]->image_position) && $editidcard[0]->image_position == 'bottom-left') ? 'checked' : ''; ?>> Bottom Left
                                                            </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-xs-4">
                                                        <div class="checkbox">
                                                            <label>
                                                                <input type="radio" name="image_position" value="bottom-right" <?php echo (isset($edit_mode) && $edit_mode && isset($editidcard[0]->image_position) && $editidcard[0]->image_position == 'bottom-right') ? 'checked' : ''; ?>> Bottom Right
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row" style="margin-top: 5px;">
                                                    <div class="col-xs-12">
                                                        <div class="form-group">
                                                            <label>Custom Position (from top)</label>
                                                            <div class="input-group">
                                                                <input type="number" class="form-control" name="image_top" placeholder="Top (px)" value="<?php echo isset($edit_mode) && $edit_mode && isset($editidcard[0]->image_top) ? $editidcard[0]->image_top : '20'; ?>">
                                                                <span class="input-group-addon">px</span>
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <label>Custom Position (from left/right)</label>
                                                            <div class="input-group">
                                                                <input type="number" class="form-control" name="image_side" placeholder="Side (px)" value="<?php echo isset($edit_mode) && $edit_mode && isset($editidcard[0]->image_side) ? $editidcard[0]->image_side : '20'; ?>">
                                                                <span class="input-group-addon">px</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <!-- QR Code Settings -->
                                        <div class="col-md-6 col-sm-6 img_div_modal minh45">
                                            <div class="form-group switch-inline">
                                                <label>QR Code for Admission Number</label>
                                                <div class="material-switch switchcheck">
                                                    <input id="enable_qr_code" name="enable_qr_code" type="checkbox" class="chk" value="1" onclick="qrCodeChanged()" <?php echo (isset($edit_mode) && $edit_mode && isset($editidcard[0]->enable_qr_code) && $editidcard[0]->enable_qr_code == 1) ? 'checked' : ''; ?>>
                                                    <label for="enable_qr_code" class="label-success"></label>
                                                </div>
                                            </div>
                                        </div><!--./col-md-6-->
                                        
                                        <div class="col-md-6 col-sm-6 img_div_modal">
                                            <div class="form-group" id="enableQrDiv" <?php echo (isset($edit_mode) && $edit_mode && isset($editidcard[0]->enable_qr_code) && $editidcard[0]->enable_qr_code == 1) ? '' : 'hidden'; ?>>
                                                <div class="input-group">
                                                    <input id="qr_size" name="qr_size" placeholder="QR Code Size" type="text" class="form-control" min="0" value="<?php echo isset($edit_mode) && $edit_mode && isset($editidcard[0]->qr_size) ? $editidcard[0]->qr_size : set_value('qr_size', '100'); ?>" />
                                                    <span class="input-group-addon">px</span>
                                                </div>
                                                <small class="text-muted">Size of the QR code in pixels</small>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-12 col-sm-12 img_div_modal">
                                            <div class="form-group" id="qrPositionDiv" <?php echo (isset($edit_mode) && $edit_mode && isset($editidcard[0]->enable_qr_code) && $editidcard[0]->enable_qr_code == 1) ? '' : 'hidden'; ?>>
                                                <label>QR Code Position</label>
                                                <div class="row" style="margin-top: 5px;">
                                                    <div class="col-xs-3">
                                                        <div class="checkbox">
                                                            <label>
                                                                <input type="radio" name="qr_position" value="top-left" <?php echo (isset($edit_mode) && $edit_mode && isset($editidcard[0]->qr_position) && $editidcard[0]->qr_position == 'top-left') ? 'checked' : 'checked'; ?>> Top Left
                                                            </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-xs-3">
                                                        <div class="checkbox">
                                                            <label>
                                                                <input type="radio" name="qr_position" value="top-right" <?php echo (isset($edit_mode) && $edit_mode && isset($editidcard[0]->qr_position) && $editidcard[0]->qr_position == 'top-right') ? 'checked' : ''; ?>> Top Right
                                                            </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-xs-3">
                                                        <div class="checkbox">
                                                            <label>
                                                                <input type="radio" name="qr_position" value="bottom-left" <?php echo (isset($edit_mode) && $edit_mode && isset($editidcard[0]->qr_position) && $editidcard[0]->qr_position == 'bottom-left') ? 'checked' : ''; ?>> Bottom Left
                                                            </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-xs-3">
                                                        <div class="checkbox">
                                                            <label>
                                                                <input type="radio" name="qr_position" value="bottom-right" <?php echo (isset($edit_mode) && $edit_mode && isset($editidcard[0]->qr_position) && $editidcard[0]->qr_position == 'bottom-right') ? 'checked' : ''; ?>> Bottom Right
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row" style="margin-top: 10px;">
                                                    <div class="col-xs-6">
                                                        <div class="form-group">
                                                            <label>Custom Position (from top)</label>
                                                            <div class="input-group">
                                                                <input type="number" class="form-control" name="qr_top" placeholder="Top (px)" value="<?php echo isset($edit_mode) && $edit_mode && isset($editidcard[0]->qr_top) ? $editidcard[0]->qr_top : '20'; ?>">
                                                                <span class="input-group-addon">px</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-xs-6">
                                                        <div class="form-group">
                                                            <label>Custom Position (from left/right)</label>
                                                            <div class="input-group">
                                                                <input type="number" class="form-control" name="qr_side" placeholder="Side (px)" value="<?php echo isset($edit_mode) && $edit_mode && isset($editidcard[0]->qr_side) ? $editidcard[0]->qr_side : '20'; ?>">
                                                                <span class="input-group-addon">px</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div><!--./row-->
                                </div><!--./mediarow-->
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('background_image'); ?></label>
                                    <input id="documents" type="file" class="filestyle form-control" data-height="40" name="background_image">
                                    <span class="text-danger"><?php echo form_error('background_image'); ?></span>
                                    <?php if(isset($edit_mode) && $edit_mode && !empty($editidcard[0]->background)): ?>
                                        <div class="existing-image-container" style="margin-top: 10px;">
                                            <label>Current Background Image:</label>
                                            <div>
                                                <img src="<?php echo base_url() . 'uploads/idcard/' . $editidcard[0]->background; ?>" style="max-width: 200px; border: 1px solid #ddd; padding: 5px;" />
                                                <p class="text-muted"><small>Upload a new image to replace the current one</small></p>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div><!-- /.box-body -->
                            <div class="box-footer">
                                <button type="submit" id="submitbtn" class="btn btn-info pull-right"><?php echo isset($edit_mode) && $edit_mode ? $this->lang->line('update') : $this->lang->line('save'); ?></button>
                            </div>
                        </form>
                    </div>
                </div><!--/.col (right) -->
                <!-- left column -->
            <?php }?>
            <div class="col-md-<?php
            if ($this->rbac->hasPrivilege('student_id_card', 'can_add')) {
                echo "8";
            } else {
                echo "12";
            }
            ?>">
                <!-- general form elements -->
                <div class="box box-primary" id="hroom">
                    <div class="box-header ptbnull">
                        <h3 class="box-title titlefix"><?php echo $this->lang->line('student_id_card_list'); ?></h3>
                    </div><!-- /.box-header -->
                    <div class="box-body">
                        <div class="table-responsive mailbox-messages overflow-visible">
                            <div class="download_label"><?php echo $this->lang->line('student_id_card_list'); ?></div>
                            <table class="table table-striped table-bordered table-hover idcard-table" id="idcard-datatable">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('id_card_name'); ?></th>
                                        <th><?php echo $this->lang->line('background_image'); ?></th>
                                        <th class="text-right noExport"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (empty($idcardList)) {
                                    ?>
                                        <?php
                                    } else {
                                        $count = 1;
                                        foreach ($idcardList as $idcard) {
                                            ?>
                                            <tr>
                                                <td class="mailbox-name">
                                                    <a style="cursor: pointer;" id="<?php echo $idcard->id ?>" data-toggle="popover" class="detail_popover view_data" ><?php echo $idcard->idcard_name; ?></a>
                                                </td>
                                                <td class="mailbox-name">
                                                    <?php if ($idcard->background_image != '' && !is_null($idcard->background_image)) {?>
                                                        <img src="<?php echo base_url('uploads/idcard/') . $idcard->background_image ?>" width="40">
                                                    <?php } else {?>
                                                        <i class="fa fa-picture-o fa-3x" aria-hidden="true"></i>
                                                    <?php }?>
                                                </td>
                                                <td class="mailbox-date text-right no-print">
                                                    <a id="<?php echo $idcard->id ?>" class="btn btn-default btn-xs view_data" title="<?php echo $this->lang->line('view'); ?>">
                                                        <i class="fa fa-reorder"></i>
                                                    </a>
                                                    <?php
                                                    if ($this->rbac->hasPrivilege('student_id_card', 'can_edit')) {
                                                        ?>
                                                        <a href="<?php echo base_url(); ?>admin/idcard/edit/<?php echo $idcard->id ?>" class="btn btn-default btn-xs"  data-toggle="tooltip" title="<?php echo $this->lang->line('edit'); ?>">
                                                            <i class="fa fa-pencil"></i>
                                                        </a>
                                                        <?php
                                                    }
                                                    if ($this->rbac->hasPrivilege('student_id_card', 'can_delete')) {
                                                        ?>
                                                        <a href="<?php echo base_url(); ?>admin/idcard/delete/<?php echo $idcard->id ?>" class="btn btn-default btn-xs"  data-toggle="tooltip" title="<?php echo $this->lang->line('delete'); ?>" onclick="return confirm('<?php echo $this->lang->line('delete_confirm') ?>');">
                                                            <i class="fa fa-remove"></i>
                                                        </a>
                                                        <?php
                                                    }
                                                    ?>
                                                </td>
                                            </tr>
                                            <?php
                                        }
                                        $count++;
                                    }
                                    ?>
                                </tbody>
                            </table><!-- /.table -->
                        </div><!-- /.mail-box-messages -->
                    </div><!-- /.box-body -->
                </div>
            </div><!--/.col (left) -->
            <!-- right column -->
        </div>
        <div class="row">
            <div class="col-md-12">
            </div><!--/.col (right) -->
        </div>   <!-- /.row -->
    </section><!-- /.content -->
</div><!-- /.content-wrapper -->
<script type="text/javascript">
    var base_url = '<?php echo base_url() ?>';
    
    function valueChanged() {
        if ($('#enable_student_img').is(":checked")) {
            $('#enableImageDiv').show();
            $('#imagePositionDiv').show();
        } else {
            $('#enableImageDiv').hide();
            $('#imagePositionDiv').hide();
        }
    }
    
    function qrCodeChanged() {
        if ($('#enable_qr_code').is(":checked")) {
            $('#enableQrDiv').show();
            $('#qrPositionDiv').show();
        } else {
            $('#enableQrDiv').hide();
            $('#qrPositionDiv').hide();
        }
    }
    
    $(document).ready(function() {
        // Initialize tooltips
        $('[data-toggle="tooltip"]').tooltip();
        
        // Initialize the student image div visibility based on checkbox state
        valueChanged();
        
        // Initialize the QR code div visibility based on checkbox state
        qrCodeChanged();
        
        // Initialize unit dropdowns based on saved values
        <?php if(isset($edit_mode) && $edit_mode && isset($editidcard[0]->card_height_mm)): ?>
        $('#card_height_unit').val('mm');
        $('#card_height').val('<?php echo $editidcard[0]->card_height_mm; ?>');
        <?php endif; ?>
        
        <?php if(isset($edit_mode) && $edit_mode && isset($editidcard[0]->card_width_mm)): ?>
        $('#card_width_unit').val('mm');
        $('#card_width').val('<?php echo $editidcard[0]->card_width_mm; ?>');
        <?php endif; ?>
        
        // Initialize Summernote editor
        $('.summernote').summernote({
            height: 300,
            minHeight: 300,
            maxHeight: 800,
            focus: true,
            toolbar: [
                ['style', ['style']],
                ['font', ['bold', 'italic', 'underline', 'clear', 'strikethrough', 'superscript', 'subscript']],
                ['fontname', ['fontname']],
                ['fontsize', ['fontsize']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']],
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video', 'hr']],
                ['view', ['fullscreen', 'codeview']],
                ['help', ['help']]
            ],
            fontNames: ['Arial', 'Arial Black', 'Comic Sans MS', 'Courier New', 'Helvetica', 'Impact', 'Tahoma', 'Times New Roman', 'Verdana'],
            fontSizes: ['8', '9', '10', '11', '12', '14', '16', '18', '20', '24', '30', '36', '48', '64'],
            lineHeights: ['0.1', '0.2', '0.5', '0.8', '1.0', '1.2', '1.5', '2.0', '3.0'],
            callbacks: {
                onPaste: function (e) {
                    var bufferText = ((e.originalEvent || e).clipboardData || window.clipboardData).getData('text/plain');
                    e.preventDefault();
                    document.execCommand('insertText', false, bufferText);
                },
                onInit: function() {
                    // Make placeholders clickable in the editor
                    $('.placeholder-item').on('click', function() {
                        var placeholder = $(this).data('placeholder');
                        $('.summernote').summernote('editor.saveRange');
                        $('.summernote').summernote('editor.restoreRange');
                        $('.summernote').summernote('editor.focus');
                        $('.summernote').summernote('editor.pasteHTML', placeholder);
                    });
                }
            },
            styleTags: [
                'p',
                { title: 'Blockquote', tag: 'blockquote', className: 'blockquote', value: 'blockquote' },
                'pre', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6'
            ],
            insertTableMaxSize: {
                col: 10,
                row: 10
            },
            shortcuts: true,
            dialogsInBody: true,
            disableDragAndDrop: false,
            spellCheck: true,
            placeholder: 'Type your ID card content here...',
            popover: {
                image: [
                    ['imagesize', ['imageSize100', 'imageSize50', 'imageSize25']],
                    ['float', ['floatLeft', 'floatRight', 'floatNone']],
                    ['remove', ['removeMedia']],
                    ['custom', ['imageAttributes', 'imageShape']],
                ],
            },
            codemirror: {
                theme: 'monokai',
                lineNumbers: true,
                tabMode: 'indent',
                mode: 'text/html',
                htmlMode: true,
                lineWrapping: true
            },
            colors: [
                ['#000000', '#434343', '#666666', '#999999', '#B7B7B7', '#CCCCCC', '#E0E0E0', '#F3F3F3', '#FFFFFF'],
                ['#980000', '#FF0000', '#FF9900', '#FFFF00', '#00FF00', '#00FFFF', '#4A86E8', '#0000FF', '#9900FF'],
                ['#E6B8AF', '#F4CCCC', '#FCE5CD', '#FFF2CC', '#D9EAD3', '#D0E0E3', '#C9DAF8', '#CFE2F3', '#D9D2E9']
            ]
        });
        
        // Handle unit conversion for card dimensions
        $('#form1').on('submit', function(e) {
            // Convert mm to px if needed
            if ($('#card_height_unit').val() === 'mm') {
                var heightInMm = parseFloat($('#card_height').val());
                if (!isNaN(heightInMm)) {
                    // Convert mm to px (approximately 3.779528 px = 1 mm at 96 DPI)
                    var heightInPx = Math.round(heightInMm * 3.779528);
                    // Create a hidden field to store the original mm value
                    $('<input>').attr({
                        type: 'hidden',
                        name: 'card_height_mm',
                        value: heightInMm
                    }).appendTo('#form1');
                    // Update the height field with px value
                    $('#card_height').val(heightInPx);
                }
            }
            
            if ($('#card_width_unit').val() === 'mm') {
                var widthInMm = parseFloat($('#card_width').val());
                if (!isNaN(widthInMm)) {
                    // Convert mm to px (approximately 3.779528 px = 1 mm at 96 DPI)
                    var widthInPx = Math.round(widthInMm * 3.779528);
                    // Create a hidden field to store the original mm value
                    $('<input>').attr({
                        type: 'hidden',
                        name: 'card_width_mm',
                        value: widthInMm
                    }).appendTo('#form1');
                    // Update the width field with px value
                    $('#card_width').val(widthInPx);
                }
            }
        });
        
        // Initialize the DataTable with a specific ID to avoid conflicts
        if ($.fn.DataTable.isDataTable('#idcard-datatable')) {
            $('#idcard-datatable').DataTable().destroy();
        }
        
        $('#idcard-datatable').DataTable({
            "paging": true,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "responsive": true,
            "language": {
                "emptyTable": "No ID card templates found"
            }
        });
        
        // Check if there's a success message and handle page refresh
        if ($('.alert-success').length > 0) {
            // Simply refresh the page after a short delay
            setTimeout(function() {
                window.location.reload();
            }, 1500);
        }
        
        $('.detail_popover').popover({
            placement: 'right',
            trigger: 'hover',
            container: 'body',
            html: true,
            content: function () {
                return $(this).closest('td').find('.fee_detail_popover').html();
            }
        });
        
        $(document).on('click', '.view_data', function () {
            var idcardid = $(this).attr("id");
            $.ajax({
                url: "<?php echo base_url('admin/idcard/view') ?>",
                method: "post",
                data: {idcardid: idcardid},
                success: function (data) {
                    $('#idcard_view').html(data);
                    $('#modal-idcardview').modal('show');
                }
            });
        });
    });
</script>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal for ID Card View -->
<div class="modal fade" id="modal-idcardview" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content modal-media-content">
            <div class="modal-header modal-media-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="box-title"><?php echo $this->lang->line('id_card_view'); ?></h4>
            </div>
            <div class="modal-body pt0 pb0">
                <div class="row">
                    <div class="col-md-12">
                        <div id="idcard_view"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
