<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $this->lang->line('student_id_card'); ?></title>
    <!-- Debug template size values -->
    <?php
    error_log('ID Card Template Size Values:');
    error_log('card_width: ' . (isset($idcard->card_width) ? $idcard->card_width : 'not set'));
    error_log('card_height: ' . (isset($idcard->card_height) ? $idcard->card_height : 'not set'));
    error_log('header_height: ' . (isset($idcard->header_height) ? $idcard->header_height : 'not set'));
    error_log('footer_height: ' . (isset($idcard->footer_height) ? $idcard->footer_height : 'not set'));
    error_log('content_height: ' . (isset($idcard->content_height) ? $idcard->content_height : 'not set'));
    error_log('content_width: ' . (isset($idcard->content_width) ? $idcard->content_width : 'not set'));
    error_log('enable_image_height: ' . (isset($idcard->enable_image_height) ? $idcard->enable_image_height : 'not set'));
    ?>
    <style type="text/css">
        @page {
            size: A4;
            margin: 0;
        }
        
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f4f4f4;
            width: 100%;
        }
        
        .id-card-container {
            width: 100%;
            max-width: 210mm; /* A4 width */
            min-height: 0;
            margin: 0 auto;
            padding: 10px;
            background-color: #fff;
            box-sizing: border-box;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            page-break-after: auto;
        }
        
        .action-buttons {
            text-align: center;
            margin: 20px 0;
            padding: 15px;
            background: #fff;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        
        .btn-print, .btn-close {
            padding: 10px 20px;
            margin: 0 10px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            font-weight: bold;
            transition: all 0.3s;
        }
        
        .btn-print {
            background: #4CAF50;
            color: white;
        }
        
        .btn-close {
            background: #f44336;
            color: white;
        }
        
        .btn-print:hover, .btn-close:hover {
            opacity: 0.9;
            transform: translateY(-2px);
        }
        
        .id-cards-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr); /* 3 columns for 9 cards per page */
            gap: 5px;
            justify-content: center;
            align-items: start;
            page-break-inside: avoid;
        }
        
        .id-card-page {
            page-break-after: always;
            page-break-inside: avoid;
        }
        
        /* Style for debug info */
        .debug-info {
            background: #ffffcc;
            padding: 10px;
            margin: 10px 0;
            border: 1px solid #ffcc00;
            font-family: monospace;
            font-size: 12px;
        }
        .id-card-header {
            text-align: center;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 1px solid #ddd;
        }
        .id-card-header h2 {
            margin: 0;
            color: #333;
        }
        .id-card-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(<?php echo $idcard->card_width + 20; ?>px, 1fr));
            gap: 15px;
            margin-bottom: 20px;
            align-items: start;
            justify-content: center;
        }
        .id-card {
            position: relative;
            width: <?php echo $idcard->card_width; ?>px !important;
            height: <?php echo $idcard->card_height; ?>px !important;
            margin: 0 auto;
            border: 1px solid #ddd;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
            overflow: hidden;
            background-color: #fff;
            /* Force size to be respected */
            min-width: <?php echo $idcard->card_width; ?>px !important;
            min-height: <?php echo $idcard->card_height; ?>px !important;
            max-width: <?php echo $idcard->card_width; ?>px !important;
            max-height: <?php echo $idcard->card_height; ?>px !important;
            box-sizing: border-box !important;
        }
        .id-card-background {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 1;
        }
        .id-card-header-section {
            position: relative;
            height: <?php echo isset($idcard->header_height) && !empty($idcard->header_height) ? $idcard->header_height : 40; ?>px !important;
            width: 100%;
            z-index: 2;
        }
        .id-card-content {
            position: relative;
            height: <?php echo isset($idcard->content_height) && !empty($idcard->content_height) ? $idcard->content_height : 120; ?>px !important;
            width: <?php echo isset($idcard->content_width) && !empty($idcard->content_width) ? $idcard->content_width : 300; ?>px !important;
            margin: 0 auto;
            z-index: 2;
        }
        .id-card-footer {
            position: relative;
            height: <?php echo isset($idcard->footer_height) && !empty($idcard->footer_height) ? $idcard->footer_height : 40; ?>px !important;
            width: 100%;
            z-index: 2;
        }
        .id-card-footer-left {
            position: absolute;
            bottom: 10px;
            left: 10px;
            font-size: 12px;
        }
        .id-card-footer-center {
            position: absolute;
            bottom: 10px;
            left: 50%;
            transform: translateX(-50%);
            font-size: 12px;
            text-align: center;
        }
        .id-card-footer-right {
            position: absolute;
            bottom: 10px;
            right: 10px;
            font-size: 12px;
            text-align: right;
        }
        .student-photo {
            position: absolute;
            <?php 
            // Set position based on the selected position
            $imageTop = !empty($idcard->image_top) ? $idcard->image_top . 'px' : '20px';
            $imageSide = !empty($idcard->image_side) ? $idcard->image_side . 'px' : '20px';
            $position = !empty($idcard->image_position) ? $idcard->image_position : 'top-left';
            
            switch($position) {
                case 'top-right':
                    echo 'top: ' . $imageTop . '; right: ' . $imageSide . '; left: auto;';
                    break;
                case 'bottom-left':
                    echo 'bottom: ' . $imageTop . '; left: ' . $imageSide . '; top: auto;';
                    break;
                case 'bottom-right':
                    echo 'bottom: ' . $imageTop . '; right: ' . $imageSide . '; left: auto; top: auto;';
                    break;
                default: // top-left
                    echo 'top: ' . $imageTop . '; left: ' . $imageSide . ';';
            }
            ?>
            width: <?php echo (!empty($idcard->image_width) ? $idcard->image_width . 'px' : 'auto'); ?> !important;
            height: <?php echo (!empty($idcard->enable_image_height) ? $idcard->enable_image_height . 'px' : '120px'); ?> !important;
            min-height: <?php echo (!empty($idcard->enable_image_height) ? $idcard->enable_image_height . 'px' : '120px'); ?> !important;
            max-height: <?php echo (!empty($idcard->enable_image_height) ? $idcard->enable_image_height . 'px' : '120px'); ?> !important;
            border: 1px solid #ddd;
            background-color: #f5f5f5;
            padding: 3px;
            border-radius: 3px;
            box-sizing: border-box !important;
            z-index: 3;
            object-fit: cover;
        }
        .id-card-text {
            padding: 10px;
            text-align: left;
            font-size: 14px;
            line-height: 1.5;
        }
        .print-button {
            display: block;
            width: 200px;
            margin: 20px auto;
            padding: 10px;
            background-color: #3c8dbc;
            color: #fff;
            text-align: center;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
        }
        .print-button:hover {
            background-color: #367fa9;
        }
        @media print {
            body {
                background-color: #fff;
            }
            .id-card-container {
                box-shadow: none;
                padding: 0;
                max-width: 100%;
                width: 100%;
                margin: 0;
            }
            .id-card-header, .debug-info {
                display: none;
            }
            .print-button {
                display: none;
            }
            .id-card-grid {
                display: grid;
                grid-template-columns: repeat(auto-fit, minmax(<?php echo $idcard->card_width + 10; ?>px, 1fr));
                gap: 5px;
                page-break-inside: avoid;
                margin: 0 auto;
            }
            .id-card {
                margin: 5px;
                transform: scale(0.95);
                transform-origin: center top;
            }
            @page {
                size: A4;
                margin: 5mm;
            }
            .page-break {
                page-break-before: always;
                margin-top: 5mm;
            }
        }
    </style>
</head>
<body>
    <div class="action-buttons">
        <h2 style="margin: 0 0 15px 0; padding: 0; color: #333;"><?php echo $this->lang->line('student_id_card'); ?></h2>
        <div>
            <button onclick="window.print()" class="btn-print">
                <i class="fa fa-print"></i> Print ID Cards
            </button>
            <button onclick="window.close()" class="btn-close">
                <i class="fa fa-times"></i> Close
            </button>
        </div>
    </div>
    
    <div class="id-card-container">
        
        <div class="id-cards-grid">
        
        <?php 
        if (isset($resultlist) && is_array($resultlist)) {
            $totalStudents = count($resultlist);
            // Calculate cards per page based on card size
            $pageWidth = 210; // A4 width in mm
            $pageHeight = 297; // A4 height in mm
            $cardWidthMM = ($idcard->card_width / 3.779528); // Convert px to mm (approximate)
            $cardHeightMM = ($idcard->card_height / 3.779528); // Convert px to mm
            
            // Calculate how many cards can fit horizontally and vertically (with margins)
            $cardsPerRow = floor(($pageWidth - 20) / ($cardWidthMM + 5));
            $cardsPerColumn = floor(($pageHeight - 20) / ($cardHeightMM + 5));
            
            // Ensure at least 1 card per row/column
            $cardsPerRow = max(1, $cardsPerRow);
            $cardsPerColumn = max(1, $cardsPerColumn);
            
            // Calculate total cards per page
            $cardsPerPage = $cardsPerRow * $cardsPerColumn;
            
            error_log("Card dimensions: {$cardWidthMM}mm x {$cardHeightMM}mm");
            error_log("Cards per page: {$cardsPerPage} ({$cardsPerRow} x {$cardsPerColumn})");
            $totalPages = ceil($totalStudents / $cardsPerPage);
            
            for ($page = 0; $page < $totalPages; $page++) {
                $startIndex = $page * $cardsPerPage;
                $endIndex = min($startIndex + $cardsPerPage, $totalStudents);
                
                if ($page > 0) {
                    echo '<div class="page-break"></div>';
                }
                
                echo '<div class="id-card-grid">';
                
                for ($i = $startIndex; $i < $endIndex; $i++) {
                    $student = $resultlist[$i];
                    // Debug information
                    error_log('Processing student: ' . $student->id . ' - ' . $student->firstname);
        ?>
        
        <div class="id-card">
            <?php 
            // Use background image path from controller if available
            if(isset($bg_image_path) && !empty($bg_image_path)){ 
                error_log('Using background image path from controller for multiple cards: ' . $bg_image_path);
            ?>
            <img class="id-card-background" src="<?php echo $bg_image_path; ?>" alt="Background" onerror="this.style.display='none'; console.log('Failed to load background image: ' + this.src);">
            <?php } else if(isset($idcard->background_image) && $idcard->background_image != ''){ 
                $bg_image_path = base_url('uploads/idcard/') . $idcard->background_image;
                error_log('Using calculated background image path for multiple cards: ' . $bg_image_path);
            ?>
            <img class="id-card-background" src="<?php echo $bg_image_path; ?>" alt="Background" onerror="this.style.display='none'; console.log('Failed to load background image: ' + this.src);">
            <?php } ?>
            
            <div class="id-card-header-section">
                <div class="id-card-header-left"><?php echo processPlaceholders($idcard->left_header, $student); ?></div>
                <div class="id-card-header-center"><?php echo processPlaceholders($idcard->center_header, $student); ?></div>
                <div class="id-card-header-right"><?php echo processPlaceholders($idcard->right_header, $student); ?></div>
            </div>
            
            <div class="id-card-content">
                <?php 
                // Display student photo if enabled
                if(isset($idcard->enable_student_image) && $idcard->enable_student_image == 1) { 
                    try {
                        // Get the image URL with error handling
                        $student_image = '';
                        $image_error = false;
                        
                        // 1. Try to use the preloaded image_url from the student object
                        if(!empty($student->image_url)) {
                            $student_image = $student->image_url;
                            error_log('Using preloaded student image URL for student ' . $student->id . ': ' . $student_image);
                        } 
                        // 2. Fallback to controller array if available
                        else if(isset($student_image_paths) && isset($student_image_paths[$student->id])) {
                            $student_image = $student_image_paths[$student->id];
                            error_log('Using student image path from controller array for student ' . $student->id . ': ' . $student_image);
                        } 
                        // 3. Final fallback to getStudentImagePath function
                        else {
                            $student_image = getStudentImagePath($student);
                            error_log('Using calculated student image path for student ' . $student->id . ': ' . $student_image);
                        }
                        
                        // Check if image is accessible
                        if(empty($student_image) || !filter_var($student_image, FILTER_VALIDATE_URL)) {
                            throw new Exception('Invalid image URL');
                        }
                        
                        // Add cache buster to prevent caching issues
                        $student_image .= (parse_url($student_image, PHP_URL_QUERY) ? '&' : '?') . 't=' . time();
                        
                        // Get image dimensions from template or use defaults
                        $image_width = isset($idcard->image_width) && !empty($idcard->image_width) ? $idcard->image_width : 100;
                        $image_height = isset($idcard->enable_image_height) && !empty($idcard->enable_image_height) ? $idcard->enable_image_height : 120;
                        $image_top = isset($idcard->image_top) && $idcard->image_top !== '' ? $idcard->image_top . 'px' : '20px';
                        $image_side = isset($idcard->image_left) && $idcard->image_left !== '' ? $idcard->image_left . 'px' : '20px';
                        
                        // Output the image with error handling
                        ?>
                        <div class="student-photo" style="position: absolute; top: <?php echo $image_top; ?>; left: <?php echo $image_side; ?>; width: <?php echo $image_width; ?>px; height: <?php echo $image_height; ?>px; overflow: hidden; border: 1px solid #ddd; background: #f9f9f9;">
                            <img src="<?php echo htmlspecialchars($student_image); ?>" 
                                 alt="Student Photo" 
                                 style="width: 100%; height: 100%; object-fit: cover;"
                                 onerror="this.onerror=null; this.src='<?php echo base_url('uploads/student_images/no_image.png'); ?>'; this.title='Image not found';"
                                 onload="this.style.display='block'; this.nextElementSibling.style.display='none';"
                                 loading="lazy">
                            <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); color: #999; font-size: 12px; text-align: center;">
                                Loading...
                            </div>
                        </div>
                        <?php
                        
                    } catch (Exception $e) {
                        error_log('Error loading student image for student ID ' . $student->id . ': ' . $e->getMessage());
                        // Fallback to default image
                        ?>
                        <div class="student-photo" style="position: absolute; top: <?php echo $image_top; ?>; left: <?php echo $image_side; ?>; width: <?php echo $image_width; ?>px; height: <?php echo $image_height; ?>px; display: flex; align-items: center; justify-content: center; background: #f5f5f5; border: 1px solid #ddd;">
                            <span style="color: #999; font-size: 12px;">No Photo</span>
                        </div>
                        <?php
                    }
                } ?>
                
                <?php 
                // QR Code rendering logic for multiple cards
                if(isset($idcard->enable_qr_code) && $idcard->enable_qr_code == 1){ 
                    // Set default values if not set
                    $qrSize = !empty($idcard->qr_size) ? $idcard->qr_size . 'px' : '100px';
                    $qrTop = !empty($idcard->qr_top) ? $idcard->qr_top . 'px' : '20px';
                    $qrSide = !empty($idcard->qr_side) ? $idcard->qr_side . 'px' : '20px';
                    
                    // Set position based on selected position
                    $qrPositionStyle = '';
                    $qrPosition = !empty($idcard->qr_position) ? $idcard->qr_position : 'top-left';
                    
                    switch($qrPosition) {
                        case 'top-right':
                            $qrPositionStyle = 'top: ' . $qrTop . '; right: ' . $qrSide . '; left: auto;';
                            break;
                        case 'bottom-left':
                            $qrPositionStyle = 'bottom: ' . $qrTop . '; left: ' . $qrSide . '; top: auto;';
                            break;
                        case 'bottom-right':
                            $qrPositionStyle = 'bottom: ' . $qrTop . '; right: ' . $qrSide . '; left: auto; top: auto;';
                            break;
                        default: // top-left
                            $qrPositionStyle = 'top: ' . $qrTop . '; left: ' . $qrSide . ';';
                    }
                    
                    // Get admission number from student data
                    $admissionNo = isset($student->admission_no) ? $student->admission_no : 'N/A';
                ?>
                <div class="qr-code" style="
                    position: absolute;
                    <?php echo $qrPositionStyle; ?>
                    width: <?php echo $qrSize; ?>;
                    height: <?php echo $qrSize; ?>;
                    border: 1px solid #ddd;
                    background: #fff;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    z-index: 15;">
                    <img src="https://api.qrserver.com/v1/create-qr-code/?size=<?php echo str_replace('px', '', $qrSize); ?>x<?php echo str_replace('px', '', $qrSize); ?>&data=<?php echo urlencode($admissionNo); ?>" 
                         style="width: 100%; height: 100%; object-fit: contain;" 
                         alt="QR Code for <?php echo htmlspecialchars($admissionNo); ?>"
                         onerror="this.style.display='none'; console.log('Failed to load QR code for <?php echo htmlspecialchars($admissionNo); ?>');">
                </div>
                <?php } ?>
                
                <div class="id-card-text">
                    <?php echo processPlaceholders($idcard->idcard_text, $student); ?>
                </div>
            </div>
            
            <div class="id-card-footer">
                <div class="id-card-footer-left"><?php echo processPlaceholders($idcard->left_footer, $student); ?></div>
                <div class="id-card-footer-center"><?php echo processPlaceholders($idcard->center_footer, $student); ?></div>
                <div class="id-card-footer-right"><?php echo processPlaceholders($idcard->right_footer, $student); ?></div>
            </div>
        </div>
        
        <?php 
                }
                echo '</div>';
            }
        } else {
            echo '<div class="alert alert-danger">No student data available</div>';
        }
        ?>
        
        </div>
    </div>
    
    <style type="text/css" media="print">
        @page {
            size: A4;
            margin: 5mm;
            size: 210mm 297mm;
        }
        
        body {
            margin: 0;
            padding: 0;
            background: white;
            width: 100%;
            height: 100%;
        }
        
        .action-buttons {
            display: none !important;
        }
        
        .id-card-container {
            width: 200mm !important;  
            min-height: 287mm !important;  
            margin: 0 auto !important;
            padding: 0 !important;
            box-shadow: none !important;
            page-break-after: always;
            page-break-inside: avoid;
        }
        
        .id-cards-grid {
            display: grid !important;
            grid-template-columns: repeat(3, 1fr) !important;
            grid-template-rows: repeat(3, 1fr) !important;
            gap: 2mm !important;
            width: 100% !important;
            height: 100% !important;
            padding: 0 !important;
            margin: 0 !important;
            box-sizing: border-box;
        }
        
        .id-card {
            width: 65mm !important;
            height: 90mm !important;
            margin: 0 auto !important;
            padding: 0 !important;
            page-break-inside: avoid !important;
            break-inside: avoid !important;
            box-sizing: border-box;
            position: relative;
            overflow: hidden;
        }
        
        .id-card-header, .debug-info, button {
            display: none !important;
        }
    </style>
    
    <!-- Debug info for troubleshooting (hidden when printing) -->
    <div class="debug-info">
        <h4>ID Card Template Size Values (Multiple Preview):</h4>
        <ul>
            <li>Card Width: <?php echo $idcard->card_width; ?>px</li>
            <li>Card Height: <?php echo $idcard->card_height; ?>px</li>
            <li>Header Height: <?php echo $idcard->header_height; ?>px</li>
            <li>Footer Height: <?php echo $idcard->footer_height; ?>px</li>
            <li>Content Height: <?php echo $idcard->content_height; ?>px</li>
            <li>Content Width: <?php echo $idcard->content_width; ?>px</li>
            <li>Image Height: <?php echo $idcard->enable_image_height; ?>px</li>
        </ul>
    </div>
    
    <script type="text/javascript">
    // Apply template sizes directly to each ID card using JavaScript
    document.addEventListener('DOMContentLoaded', function() {
        // Get all ID cards
        var idCards = document.querySelectorAll('.id-card');
        console.log('Found ' + idCards.length + ' ID cards to process');
        
        // Organize cards into pages (9 per page for A4 - 3x3 grid)
        var cardsPerPage = 9;
        var cards = Array.from(idCards);
        var pageCount = Math.ceil(cards.length / cardsPerPage);
        
        // Get the main container
        var mainContainer = document.querySelector('.id-card-container');
        mainContainer.innerHTML = '';
        
        // Create pages with cards
        for (var p = 0; p < pageCount; p++) {
            // Create page container
            var pageContainer = document.createElement('div');
            pageContainer.className = 'id-card-container';
            
            // Only add page break if it's not the last page
            if (p < pageCount - 1) {
                pageContainer.style.pageBreakAfter = 'always';
            } else {
                pageContainer.style.pageBreakAfter = 'auto';
            }
            
            // Create grid for this page (3x3)
            var grid = document.createElement('div');
            grid.className = 'id-cards-grid';
            
            // Add cards for this page (9 cards)
            var pageCards = cards.splice(0, cardsPerPage);
            pageCards.forEach(function(card) {
                // Create card wrapper for consistent sizing
                var cardWrapper = document.createElement('div');
                cardWrapper.style.width = '100%';
                cardWrapper.style.height = '100%';
                cardWrapper.style.display = 'flex';
                cardWrapper.style.justifyContent = 'center';
                cardWrapper.style.alignItems = 'center';
                
                // Apply card styles
                card.style.width = '65mm';
                card.style.height = '90mm';
                card.style.margin = '0';
                card.style.padding = '0';
                card.style.boxSizing = 'border-box';
                
                // Add card to wrapper
                cardWrapper.appendChild(card);
                
                // Add wrapper to grid
                grid.appendChild(cardWrapper);
            });
            
            // Add grid to page container
            pageContainer.appendChild(grid);
            
            // Add page container to main container
            mainContainer.appendChild(pageContainer);
        }
        
        // Template sizes from PHP
        var cardWidth = <?php echo $idcard->card_width; ?>;
        var cardHeight = <?php echo $idcard->card_height; ?>;
        var headerHeight = <?php echo $idcard->header_height; ?>;
        var contentHeight = <?php echo $idcard->content_height; ?>;
        var contentWidth = <?php echo $idcard->content_width; ?>;
        var footerHeight = <?php echo $idcard->footer_height; ?>;
        var imageHeight = <?php echo $idcard->enable_image_height; ?>;
        
        console.log('Template sizes:', {
            cardWidth: cardWidth,
            cardHeight: cardHeight,
            headerHeight: headerHeight,
            contentHeight: contentHeight,
            contentWidth: contentWidth,
            footerHeight: footerHeight,
            imageHeight: imageHeight
        });
        
        // Apply sizes to each ID card
        idCards.forEach(function(card, index) {
            console.log('Processing ID card #' + (index + 1));
            
            // Force card size with !important via style attribute
            card.setAttribute('style', 
                'width: ' + cardWidth + 'px !important; ' +
                'height: ' + cardHeight + 'px !important; ' +
                'min-width: ' + cardWidth + 'px !important; ' +
                'min-height: ' + cardHeight + 'px !important; ' +
                'max-width: ' + cardWidth + 'px !important; ' +
                'max-height: ' + cardHeight + 'px !important; ' +
                'box-sizing: border-box !important;'
            );
            
            // Force header size
            var header = card.querySelector('.id-card-header-section');
            if (header) {
                header.setAttribute('style',
                    'height: ' + headerHeight + 'px !important; ' +
                    'min-height: ' + headerHeight + 'px !important; ' +
                    'max-height: ' + headerHeight + 'px !important; ' +
                    'box-sizing: border-box !important;'
                );
            } else {
                console.log('Header section not found for card #' + (index + 1));
            }
            
            // Force content size
            var content = card.querySelector('.id-card-content');
            if (content) {
                content.setAttribute('style',
                    'height: ' + contentHeight + 'px !important; ' +
                    'min-height: ' + contentHeight + 'px !important; ' +
                    'max-height: ' + contentHeight + 'px !important; ' +
                    'width: ' + contentWidth + 'px !important; ' +
                    'min-width: ' + contentWidth + 'px !important; ' +
                    'max-width: ' + contentWidth + 'px !important; ' +
                    'box-sizing: border-box !important;'
                );
            } else {
                console.log('Content section not found for card #' + (index + 1));
            }
            
            // Force footer size
            var footer = card.querySelector('.id-card-footer');
            if (footer) {
                footer.setAttribute('style',
                    'height: ' + footerHeight + 'px !important; ' +
                    'min-height: ' + footerHeight + 'px !important; ' +
                    'max-height: ' + footerHeight + 'px !important; ' +
                    'box-sizing: border-box !important;'
                );
            } else {
                console.log('Footer section not found for card #' + (index + 1));
            }
            
            // Force image size
            var image = card.querySelector('.student-photo');
            if (image) {
                image.setAttribute('style',
                    'height: ' + imageHeight + 'px !important; ' +
                    'min-height: ' + imageHeight + 'px !important; ' +
                    'max-height: ' + imageHeight + 'px !important; ' +
                    'box-sizing: border-box !important;'
                );
            } else {
                console.log('Student photo not found for card #' + (index + 1));
            }
        });
        
        // Add a button to force refresh sizes
        var refreshButton = document.createElement('button');
        refreshButton.textContent = 'Force Refresh Card Sizes';
        refreshButton.style.margin = '10px';
        refreshButton.style.padding = '5px 10px';
        refreshButton.style.backgroundColor = '#4CAF50';
        refreshButton.style.color = 'white';
        refreshButton.style.border = 'none';
        refreshButton.style.borderRadius = '4px';
        refreshButton.style.cursor = 'pointer';
        refreshButton.onclick = function() {
            location.reload();
        };
        document.querySelector('.container').prepend(refreshButton);
        
        // Add Font Awesome for icons if not already loaded
        if (!document.querySelector('link[href*="font-awesome"]')) {
            var link = document.createElement('link');
            link.rel = 'stylesheet';
            link.href = 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css';
            document.head.appendChild(link);
        }
    });
    </script>
</body>
</html>

<?php
function processPlaceholders($text, $student) {
    if (empty($text)) {
        return '';
    }
    
    // Debug the input
    $debug = false;
    if ($debug) {
        error_log('Processing placeholders for text: ' . substr($text, 0, 500) . '...');
        error_log('Student data type: ' . gettype($student));
    }
    
    // Convert object to array if needed
    if (is_object($student)) {
        $student = (array) $student;
    } elseif (!is_array($student)) {
        error_log('Invalid student data provided to processPlaceholders');
        return $text;
    }
    
    if ($debug) {
        error_log('Student data keys: ' . implode(', ', array_keys($student)));
    }
    
    // Define all possible placeholders and their corresponding student data keys
    $placeholders = [
        // Basic student info
        '[name]' => ['firstname', 'lastname'],
        '[firstname]' => 'firstname',
        '[lastname]' => 'lastname',
        '[fullname]' => ['firstname', 'middlename', 'lastname'],
        
        // Academic info
        '[admission_no]' => 'admission_no',
        '[roll_no]' => 'roll_no',
        '[class]' => 'class',
        '[section]' => 'section',
        
        // Personal info
        '[dob]' => 'dob',
        '[gender]' => 'gender',
        '[blood_group]' => 'blood_group',
        
        // Contact info
        '[present_address]' => 'current_address',
        '[permanent_address]' => 'permanent_address',
        '[guardian]' => ['guardian_name', 'father_name', 'mother_name'],
        '[father_name]' => 'father_name',
        '[mother_name]' => 'mother_name',
        '[guardian_name]' => 'guardian_name',
        
        // Dates
        '[admission_date]' => 'admission_date',
        '[created_at]' => 'created_at',
        
        // Additional fields
        '[category]' => 'category',
        '[cast]' => 'cast',
        '[religion]' => 'religion',
        '[mobile_no]' => 'mobileno',
        '[email]' => 'email',
        
        // School info
        '[school_name]' => 'school_name',
        '[school_address]' => 'school_address',
        '[school_phone]' => 'school_phone',
        '[school_email]' => 'school_email',
        
        // Academic year
        '[academic_year]' => 'session_id', // This might need special handling
        
        // ID card specific
        '[id_card_number]' => 'id_card_no',
        '[valid_until]' => 'valid_until',
    ];
    
    // Add dynamic fields from student data that aren't already in the placeholders array
    foreach ($student as $key => $value) {
        $placeholder = '[' . $key . ']';
        if (!isset($placeholders[$placeholder]) && !empty($value)) {
            $placeholders[$placeholder] = $key;
        }
    }
    
    // Process each placeholder
    foreach ($placeholders as $placeholder => $keys) {
        if (strpos($text, $placeholder) === false) {
            continue; // Skip if placeholder not found in text
        }
        
        $value = '';
        
        // Handle multiple possible keys (fallback chain)
        $keyList = is_array($keys) ? $keys : [$keys];
        
        foreach ($keyList as $key) {
            if (isset($student[$key]) && !empty($student[$key])) {
                $value = $student[$key];
                break;
            }
        }
        
        // Special handling for specific placeholders
        switch ($placeholder) {
            case '[fullname]':
                $parts = [];
                if (!empty($student['firstname'])) $parts[] = $student['firstname'];
                if (!empty($student['middlename'])) $parts[] = $student['middlename'];
                if (!empty($student['lastname'])) $parts[] = $student['lastname'];
                $value = implode(' ', $parts);
                break;
                
            case '[name]':
                $parts = [];
                if (!empty($student['firstname'])) $parts[] = $student['firstname'];
                if (!empty($student['lastname'])) $parts[] = $student['lastname'];
                $value = implode(' ', $parts);
                break;
                
            case '[guardian]':
                // Try to find any available guardian name
                if (empty($value)) {
                    if (!empty($student['father_name'])) {
                        $value = 'Father: ' . $student['father_name'];
                    } elseif (!empty($student['mother_name'])) {
                        $value = 'Mother: ' . $student['mother_name'];
                    } elseif (!empty($student['guardian_name'])) {
                        $value = 'Guardian: ' . $student['guardian_name'];
                    }
                }
                break;
                
            case '[school_name]':
                if (empty($value) && defined('SCHOOL_NAME')) {
                    $value = SCHOOL_NAME;
                }
                break;
                
            case '[academic_year]':
                // This might need to be replaced with actual academic year logic
                if (empty($value)) {
                    $value = date('Y') . '-' . (date('Y') + 1);
                }
                break;
        }
        
        // If value is still empty, show a placeholder for debugging
        if (empty($value) && $debug) {
            $value = '[' . str_replace(['[', ']'], '', $placeholder) . '_NOT_FOUND]';
        }
        
        // Replace the placeholder with the actual value
        $text = str_replace($placeholder, $value, $text);
    }
    
    // Clean up any remaining placeholders
    $text = preg_replace('/\[.*?\]/', '', $text);
    
    // Trim any extra whitespace
    $text = preg_replace('/\s+/', ' ', $text);
    $text = trim($text);
    
    if ($debug) {
        error_log('Processed text: ' . $text);
    }
    
    return $text;
}

function getStudentImagePath($student) {
    // Enable error reporting for debugging
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    
    // Get CI instance
    $CI =& get_instance();
    $CI->load->helper('file');
    $CI->load->library('media_storage');
    
    // Convert object to array if needed
    $is_object = is_object($student);
    $student_data = $is_object ? get_object_vars($student) : (array)$student;
    $student_id = isset($student_data['id']) ? $student_data['id'] : 'unknown';
    
    // List of all possible image fields to check
    $image_fields = ['image', 'student_image', 'photo', 'picture', 'photo_thumb', 'image_thumb'];
    
    // Common image directories to check
    $image_dirs = [
        'uploads/student_images/',
        'uploads/student_images/student/',
        'uploads/students/',
        'uploads/student_photos/'
    ];
    
    // Common image extensions to try
    $image_extensions = ['', '.jpg', '.jpeg', '.png', '.gif', '.JPG', '.JPEG', '.PNG', '.GIF'];
    
    // Function to check if file exists and is readable
    $fileExists = function($path) {
        if (file_exists($path) && is_readable($path)) {
            error_log("✅ Found image: " . $path);
            return true;
        }
        return false;
    };
    
    // 1. First check all image fields in student data
    foreach ($image_fields as $field) {
        if (!empty($student_data[$field])) {
            $image_name = $student_data[$field];
            
            // Try direct path first
            foreach ($image_dirs as $dir) {
                foreach ($image_extensions as $ext) {
                    $path = FCPATH . $dir . $image_name . $ext;
                    if ($fileExists($path)) {
                        return base_url($dir . $image_name . $ext);
                    }
                }
            }
        }
    }
    
    // 2. Try with student ID or admission number
    $student_identifiers = [];
    if (!empty($student_data['id'])) $student_identifiers[] = $student_data['id'];
    if (!empty($student_data['admission_no'])) $student_identifiers[] = $student_data['admission_no'];
    if (!empty($student_data['roll_no'])) $student_identifiers[] = $student_data['roll_no'];
    
    // Add name-based patterns if name is available
    if (!empty($student_data['firstname']) && !empty($student_data['lastname'])) {
        $firstname = strtolower(preg_replace('/[^a-zA-Z0-9]/', '', $student_data['firstname']));
        $lastname = strtolower(preg_replace('/[^a-zA-Z0-9]/', '', $student_data['lastname']));
        $student_identifiers[] = $firstname . $lastname;
        $student_identifiers[] = $firstname . '_' . $lastname;
        $student_identifiers[] = $firstname . '-' . $lastname;
        $student_identifiers[] = $firstname[0] . $lastname; // First initial + last name
        $student_identifiers[] = $firstname . $lastname[0]; // First name + last initial
    }
    
    // 3. Try all possible identifier patterns in all directories
    $student_identifiers = array_unique($student_identifiers);
    
    foreach ($student_identifiers as $identifier) {
        foreach ($image_dirs as $dir) {
            foreach ($image_extensions as $ext) {
                $path = FCPATH . $dir . $identifier . $ext;
                if ($fileExists($path)) {
                    return base_url($dir . $identifier . $ext);
                }
                
                // Try with additional prefixes/suffixes
                $patterns = [
                    'student_', 'student-', 'std_', 'std-',
                    'STUDENT_', 'STUDENT-', 'STD_', 'STD-',
                    'img_', 'IMG_', 'photo_', 'PHOTO_'
                ];
                
                foreach ($patterns as $prefix) {
                    $prefixed_path = FCPATH . $dir . $prefix . $identifier . $ext;
                    if ($fileExists($prefixed_path)) {
                        return base_url($dir . $prefix . $identifier . $ext);
                    }
                }
            }
        }
    }
    
    // Try each possible image field
    foreach ($image_fields as $field) {
        if (!empty($student_data[$field])) {
            $image_name = $student_data[$field];
            error_log("\n🔍 Checking field '{$field}': " . $image_name);
            
            // Clean up the image name
            $image_name = trim($image_name);
            
            // 1. First try with media_storage
            $image_path = $CI->media_storage->getImageURL($image_name, 'uploads/student_images/');
            error_log("1. Media storage path: " . $image_path);
            
            if ($image_path && @getimagesize($image_path)) {
                error_log("✅ 1. Image found via media_storage: " . $image_path);
                return $image_path;
            } else if ($image_path) {
                error_log("❌ 1. Media storage file not accessible: " . $image_path);
                if ($error = error_get_last()) {
                    error_log("Error: " . $error['message']);
                }
            }
            
            // 2. Try direct path in uploads/student_images/
            $direct_path = FCPATH . 'uploads/student_images/' . $image_name;
            if (file_exists($direct_path) && is_readable($direct_path)) {
                $image_url = base_url('uploads/student_images/' . $image_name);
                error_log("✅ 2. Image found via direct path: " . $direct_path);
                error_log("   URL: " . $image_url);
                return $image_url;
            } else {
                error_log("❌ 2. Direct path not found or not readable: " . $direct_path);
                if (!is_dir(dirname($direct_path))) {
                    error_log("Directory does not exist: " . dirname($direct_path));
                } else {
                    error_log("Directory exists but file not found or not readable");
                    if (file_exists($direct_path)) {
                        error_log("File exists but is not readable. Permissions: " . substr(sprintf('%o', fileperms($direct_path)), -4));
                    }
                }
            }
            
            // 3. Try with different filename patterns
            $filename_patterns = [
                strtolower($image_name),
                strtoupper($image_name),
                ucfirst(strtolower($image_name)),
                str_replace(' ', '_', $image_name),
                str_replace('_', '-', $image_name),
                preg_replace('/[^a-zA-Z0-9._-]/', '', $image_name)
            ];
            
            foreach ($filename_patterns as $pattern) {
                if ($pattern === $image_name) continue; // Skip if same as original
                
                $pattern_path = FCPATH . 'uploads/student_images/' . $pattern;
                if (file_exists($pattern_path) && is_readable($pattern_path)) {
                    $image_url = base_url('uploads/student_images/' . $pattern);
                    error_log("✅ 3. Image found with pattern '{$pattern}': " . $pattern_path);
                    error_log("   URL: " . $image_url);
                    return $image_url;
                }
            }
            
            // 4. Try with student ID as filename
            if ($student_id !== 'unknown' && is_numeric($student_id)) {
                $student_id_path = FCPATH . 'uploads/student_images/' . $student_id . '.jpg';
                if (file_exists($student_id_path) && is_readable($student_id_path)) {
                    $image_url = base_url('uploads/student_images/' . $student_id . '.jpg');
                    error_log("✅ 4. Image found with student ID filename: " . $student_id_path);
                    error_log("   URL: " . $image_url);
                    return $image_url;
                }
                
                // Try with different extensions
                $extensions = ['.jpg', '.jpeg', '.png', '.gif', '.JPG', '.JPEG', '.PNG', '.GIF'];
                foreach ($extensions as $ext) {
                    $ext_path = FCPATH . 'uploads/student_images/' . $student_id . $ext;
                    if (file_exists($ext_path) && is_readable($ext_path)) {
                        $image_url = base_url('uploads/student_images/' . $student_id . $ext);
                        error_log("✅ 4.1 Image found with student ID and {$ext} extension: " . $ext_path);
                        error_log("   URL: " . $image_url);
                        return $image_url;
                    }
                }
            }
        } // End of if (!empty($student_data[$field]))
    } // End of foreach ($image_fields as $field)
    
    // 4. Try database lookup as last resort
    if ($student_id !== 'unknown' && is_numeric($student_id)) {
        try {
            $CI->load->database();
            $db_student = $CI->db->select(implode(',', $image_fields))
                               ->where('id', $student_id)
                               ->get('students')
                               ->row_array();
            
            if ($db_student) {
                // Check all image fields from database
                foreach ($image_fields as $field) {
                    if (!empty($db_student[$field])) {
                        $image_name = $db_student[$field];
                        
                        // Try media_storage first
                        $media_path = $CI->media_storage->getImageURL($image_name, 'uploads/student_images/');
                        if ($media_path && file_exists(FCPATH . str_replace(base_url(), '', $media_path))) {
                            return $media_path;
                        }
                        
                        // Try direct path
                        foreach ($image_dirs as $dir) {
                            $path = FCPATH . $dir . $image_name;
                            if ($fileExists($path)) {
                                return base_url($dir . $image_name);
                            }
                        }
                    }
                }
            }
        } catch (Exception $e) {
            error_log('Database error in getStudentImagePath: ' . $e->getMessage());
        }
        
        // Also try with admission number if available
        $id_patterns = [];
        if (!empty($student_data['admission_no'])) {
            $adm_no = $student_data['admission_no'];
            $id_patterns = [
                $adm_no . '.jpg',
                $adm_no . '.jpeg',
                $adm_no . '.png',
                'student_' . $adm_no . '.jpg',
                'student_' . $adm_no . '.jpeg',
                'student_' . $adm_no . '.png'
            ];
        }
        
        // Check all possible ID-based paths
        $possible_paths = [];
        $base_dirs = [
            'uploads/student_images/',
            'uploads/student_images/student/',
            'uploads/student_images/students/',
            'uploads/students/',
            'uploads/'
        ];
        
        foreach ($base_dirs as $dir) {
            foreach ($id_patterns as $pattern) {
                $possible_paths[] = FCPATH . $dir . $pattern;
            }
        }
        
        // Check all possible paths
        foreach ($possible_paths as $path) {
            $path = str_replace(['//', '\\'], '/', $path); // Normalize path
            if (file_exists($path) && is_readable($path)) {
                $relative_path = str_replace(FCPATH, '', $path);
                $image_url = base_url($relative_path);
                error_log("✅ Found image at path: " . $path);
                error_log("   URL: " . $image_url);
                return $image_url;
            } else {
                error_log("❌ Image not found or not readable at path: " . $path);
            }
        }
        
        // If we reach here, no image was found in the initial paths
        // Try additional paths based on student ID and image name
        $additional_paths = [
            FCPATH . 'uploads/student_images/' . $image_name,
            FCPATH . 'uploads/student_images/student/' . $image_name,
            FCPATH . 'uploads/student_images/student_' . $student_id . '.jpg',
            FCPATH . 'uploads/student_images/student_' . $student_id . '.jpeg',
            FCPATH . 'uploads/student_images/student_' . $student_id . '.png',
            FCPATH . 'uploads/student_images/' . $student_id . '.jpg',
            FCPATH . 'uploads/student_images/' . $student_id . '.jpeg',
            FCPATH . 'uploads/student_images/' . $student_id . '.png',
            FCPATH . 'uploads/student_images/student/' . $student_id . '.jpg',
            FCPATH . 'uploads/student_images/student/' . $student_id . '.jpeg',
            FCPATH . 'uploads/student_images/student/' . $student_id . '.png',
            FCPATH . 'uploads/student_images/student/student_' . $student_id . '.jpg',
            FCPATH . 'uploads/student_images/student/student_' . $student_id . '.jpeg',
            FCPATH . 'uploads/student_images/student/student_' . $student_id . '.png',
        ];
        
        // Also check with the admission number if available
        if (!empty($student_data['admission_no'])) {
            $adm_no = $student_data['admission_no'];
            $additional_paths = array_merge($additional_paths, [
                FCPATH . 'uploads/student_images/' . $adm_no . '.jpg',
                FCPATH . 'uploads/student_images/' . $adm_no . '.jpeg',
                FCPATH . 'uploads/student_images/' . $adm_no . '.png',
                FCPATH . 'uploads/student_images/student_' . $adm_no . '.jpg',
                FCPATH . 'uploads/student_images/student_' . $adm_no . '.jpeg',
                FCPATH . 'uploads/student_images/student_' . $adm_no . '.png'
            ]);
        }
        
        // Check additional paths
        foreach ($additional_paths as $path) {
            $path = str_replace(['//', '\\'], '/', $path); // Normalize path
            if (file_exists($path) && is_readable($path)) {
                $relative_path = str_replace(FCPATH, '', $path);
                $image_url = base_url($relative_path);
                error_log("✅ Found image in additional paths: " . $path);
                error_log("   URL: " . $image_url);
                return $image_url;
            } else {
                error_log("❌ Image not found in additional paths: " . $path);
            }
        }
    }
    
    // 5. Try one final time with all possible combinations
    if (!empty($student_data['firstname']) && !empty($student_data['lastname'])) {
        $firstname = strtolower($student_data['firstname']);
        $lastname = strtolower($student_data['lastname']);
        
        $name_combinations = [
            $firstname . $lastname,
            $firstname . '_' . $lastname,
            $firstname . '-' . $lastname,
            $firstname[0] . $lastname,
            $firstname . $lastname[0],
            str_replace(' ', '', $firstname . $lastname),
            str_replace(' ', '_', $firstname . ' ' . $lastname),
            str_replace(' ', '-', $firstname . ' ' . $lastname)
        ];
        
        foreach ($name_combinations as $name) {
            foreach ($image_dirs as $dir) {
                foreach ($image_extensions as $ext) {
                    $path = FCPATH . $dir . $name . $ext;
                    if ($fileExists($path)) {
                        return base_url($dir . $name . $ext);
                    }
                }
            }
        }
    }
    
    // 6. Try to use the default image
    $default_images = [
        'uploads/student_images/no_image.png',
        'uploads/student_images/default.png',
        'assets/images/default.png',
        'assets/img/default.png',
        'uploads/no_image.png',
        'uploads/default.png'
    ];
    
    foreach ($default_images as $img) {
        $path = FCPATH . $img;
        if (file_exists($path) && is_readable($path)) {
            return base_url($img);
        }
    }
    
    // 7. Final fallback to placeholder
    return 'https://via.placeholder.com/150?text=' . urlencode('No Image');
}
?>
