<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="theme-color" content="#424242" />
        <title>Forgot Password : <?php $app_name = $this->setting_model->get();
echo $app_name[0]['name'];
?></title>
        <link href="<?php echo base_url(); ?>uploads/school_content/admin_small_logo/<?php $this->setting_model->getAdminsmalllogo();?>" rel="shortcut icon" type="image/x-icon">
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:400,100,300,500">
        <link rel="stylesheet" href="<?php echo base_url(); ?>backend/usertemplate/assets/bootstrap/css/bootstrap.min.css">
        <link rel="stylesheet" href="<?php echo base_url(); ?>backend/usertemplate/assets/font-awesome/css/font-awesome.min.css">
        <style>
            @keyframes fadeInUp {
                from {
                    opacity: 0;
                    transform: translateY(20px);
                }
                to {
                    opacity: 1;
                    transform: translateY(0);
                }
            }

            @keyframes shake {
                0%, 100% { transform: translateX(0); }
                25% { transform: translateX(-5px); }
                75% { transform: translateX(5px); }
            }

            body {
                background: #00d2ff;
                font-family: 'Roboto', sans-serif;
                height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
            }
            .forgot-container {
                background: white;
                padding: 30px;
                border-radius: 8px;
                box-shadow: 0 0 20px rgba(0,0,0,0.1);
                width: 100%;
                max-width: 400px;
                animation: fadeInUp 0.8s ease-out;
            }
            .forgot-title {
                text-align: center;
                margin-bottom: 40px;
            }
            .forgot-title img {
                max-width: 150px;
                margin-bottom: 20px;
                height: auto;
                animation: fadeInUp 0.8s ease-out 0.2s both;
            }
            .forgot-title h3 {
                animation: fadeInUp 0.8s ease-out 0.4s both;
                color: #424242;
                font-weight: 500;
                margin: 0;
            }
            .forgot-title p {
                color: #666;
                margin-top: 10px;
                font-size: 14px;
                animation: fadeInUp 0.8s ease-out 0.5s both;
            }
            .form-group {
                animation: fadeInUp 0.8s ease-out 0.6s both;
                margin-bottom: 25px;
                position: relative;
            }
            .form-group i {
                position: absolute;
                left: 15px;
                top: 50%;
                transform: translateY(-50%);
                color: #666;
            }
            .form-control {
                height: 45px;
                border-radius: 4px;
                border: 1px solid #ddd;
                padding: 10px 15px 10px 40px;
                font-size: 14px;
                transition: all 0.3s ease;
                width: 100%;
            }
            .form-control:focus {
                border-color: #424242;
                box-shadow: 0 0 0 2px rgba(66,66,66,0.1);
                transform: translateY(-2px);
            }
            .form-control.input-error {
                border-color: #ff3e3e;
                animation: shake 0.5s ease-in-out;
            }
            .btn-submit {
                background: #424242;
                color: white;
                padding: 12px;
                border-radius: 4px;
                width: 100%;
                font-size: 16px;
                font-weight: 500;
                border: none;
                cursor: pointer;
                transition: all 0.3s ease;
                animation: fadeInUp 0.8s ease-out 0.8s both;
                margin-top: 10px;
            }
            .btn-submit:hover {
                background: #2d2d2d;
                transform: translateY(-2px);
                box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            }
            .alert {
                animation: fadeInUp 0.8s ease-out;
                margin-bottom: 20px;
                padding: 15px;
                border-radius: 4px;
            }
            .alert-success {
                background-color: #d4edda;
                border-color: #c3e6cb;
                color: #155724;
            }
            .alert-danger {
                background-color: #f8d7da;
                border-color: #f5c6cb;
                color: #721c24;
            }
            .back-to-login {
                text-align: center;
                margin-top: 20px;
                animation: fadeInUp 0.8s ease-out 0.9s both;
            }
            .back-to-login a {
                color: #424242;
                font-size: 14px;
                text-decoration: none;
                transition: all 0.3s ease;
            }
            .back-to-login a:hover {
                color: #000;
                text-decoration: underline;
            }
        </style>
    </head>
    <body>
        <div class="forgot-container">
            <div class="forgot-title">
                <?php 
                $admin_logo = $this->setting_model->getAdminlogo();
                $logo_url = base_url() . "uploads/school_content/admin_logo/" . $admin_logo;
                ?>
                <img src="<?php echo $logo_url; ?>" alt="<?php echo $app_name[0]['name']; ?> Logo">
                <h3>Forgot Password</h3>
                <p>Enter your email address to reset your password</p>
            </div>
            
            <?php
            if ($this->session->flashdata('success')) { ?>
                <div class="alert alert-success">
                    <?php echo $this->session->flashdata('success'); ?>
                </div>
            <?php }
            
            if ($this->session->flashdata('error_message')) { ?>
                <div class="alert alert-danger">
                    <?php echo $this->session->flashdata('error_message'); ?>
                </div>
            <?php }
            
            if (form_error('email')) { ?>
                <div class="alert alert-danger">
                    <?php echo form_error('email'); ?>
                </div>
            <?php } ?>
            
            <form action="<?php echo site_url('site/forgotpassword') ?>" method="post">
                <?php echo $this->customlib->getCSRF(); ?>
                <div class="form-group">
                    <i class="fa fa-envelope"></i>
                    <input type="email" name="email" placeholder="Email" class="form-control" value="<?php echo set_value('email'); ?>" required>
                </div>
                <button type="submit" class="btn-submit">Submit</button>
            </form>
            
            <div class="back-to-login">
                <a href="<?php echo site_url('site/login') ?>">Back to Login</a>
            </div>
        </div>

        <script src="<?php echo base_url(); ?>backend/usertemplate/assets/js/jquery.min.js"></script>
        <script src="<?php echo base_url(); ?>backend/usertemplate/assets/bootstrap/js/bootstrap.min.js"></script>
    </body>
</html>