<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Studentfee extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library('smsgateway');
        $this->load->library('mailsmsconf');
        $this->load->library('customlib');
        $this->load->library('media_storage');
        $this->load->model("module_model");
        $this->load->model("transportfee_model");
        $this->load->model("simple_receipt_model");
        $this->load->model("student_model");
        $this->load->model("income_model");
        $this->search_type        = $this->config->item('search_type');
        $this->sch_setting_detail = $this->setting_model->getSetting();
        $this->current_session = $this->setting_model->getCurrentSession();
    }

    public function index()
    {
        if (!$this->rbac->hasPrivilege('collect_fees', 'can_view')) {
            access_denied();
        }

        $this->session->set_userdata('top_menu', $this->lang->line('fees_collection'));
        $this->session->set_userdata('sub_menu', 'studentfee/index');
        $data['sch_setting'] = $this->sch_setting_detail;
        $data['title']       = 'student fees';
        $class               = $this->class_model->get();
        $data['classlist']   = $class;
        $this->load->view('layout/header', $data);
        $this->load->view('studentfee/studentfeeSearch', $data);
        $this->load->view('layout/footer', $data);
    }

    public function pdf()
    {
        $this->load->helper('pdf_helper');
    }

    public function search()
    {
        $search_type = $this->input->post('search_type');
        if ($search_type == "class_search") {
            $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'required|trim|xss_clean');
        } elseif ($search_type == "keyword_search") {
            $this->form_validation->set_rules('search_text', $this->lang->line('keyword'), 'required|trim|xss_clean');
            $data = array('search_text' => 'dummy');
            $this->form_validation->set_data($data);
        }
        if ($this->form_validation->run() == false) {
            $error = array();
            if ($search_type == "class_search") {
                $error['class_id'] = form_error('class_id');
            } elseif ($search_type == "keyword_search") {
                $error['search_text'] = form_error('search_text');
            }

            $array = array('status' => 0, 'error' => $error);
            echo json_encode($array);
        } else {
            $search_type = $this->input->post('search_type');
            $search_text = $this->input->post('search_text');
            $class_id    = $this->input->post('class_id');
            $section_id  = $this->input->post('section_id');
            $params      = array('class_id' => $class_id, 'section_id' => $section_id, 'search_type' => $search_type, 'search_text' => $search_text);
            $array       = array('status' => 1, 'error' => '', 'params' => $params);
            echo json_encode($array);
        }
    }

    public function ajaxSearch()
    {
        $class       = $this->input->post('class_id');
        $section     = $this->input->post('section_id');
        $search_text = $this->input->post('search_text');
        $search_type = $this->input->post('search_type');
        if ($search_type == "class_search") {
            $students = $this->student_model->getDatatableByClassSection($class, $section);
        } elseif ($search_type == "keyword_search") {
            $students = $this->student_model->getDatatableByFullTextSearch($search_text);
        }
        $sch_setting = $this->sch_setting_detail;
        $students    = json_decode($students);
        $dt_data     = array();
        if (!empty($students->data)) {
            foreach ($students->data as $student_key => $student) {
                $row         = array();
                $row[]       = $student->class;
                $row[]       = $student->section;
                $row[]       = $student->admission_no;
                $row[]       = "<a href='" . base_url() . "student/view/" . $student->id . "'>" . $this->customlib->getFullName($student->firstname, $student->middlename, $student->lastname, $sch_setting->middlename, $sch_setting->lastname) . "</a>";
                $sch_setting = $this->sch_setting_detail;
                if ($sch_setting->father_name) {
                    $row[] = $student->father_name;
                }
                $row[] = $this->customlib->dateformat($student->dob);
                $row[] = $student->mobileno;
                $row[] = "<a href=" . site_url('studentfee/addfee/' . $student->student_session_id) . "  class='btn btn-info btn-xs'>" . $this->lang->line('collect_fees') . "</a>";

                $dt_data[] = $row;
            }
        }
        $json_data = array(
            "draw"            => intval($students->draw),
            "recordsTotal"    => intval($students->recordsTotal),
            "recordsFiltered" => intval($students->recordsFiltered),
            "data"            => $dt_data,
        );
        echo json_encode($json_data);
    }

    public function feesearch()
    {
        if (!$this->rbac->hasPrivilege('search_due_fees', 'can_view')) {
            access_denied();
        }

        $this->session->set_userdata('top_menu', 'Fees Collection');
        $this->session->set_userdata('sub_menu', 'studentfee/feesearch');
        $data['title']       = $this->lang->line('student_fees');
        $class               = $this->class_model->get();
        $data['classlist']   = $class;
        $data['sch_setting'] = $this->sch_setting_detail;
        $feesessiongroup     = $this->feesessiongroup_model->getFeesByGroup();
        $module = $this->module_model->getPermissionByModulename('transport');

        $currentsessiontransportfee = $this->transportfee_model->getSessionFees($this->current_session);
        if (!empty($currentsessiontransportfee)) {
            $transportfesstype = [];
            if ($module['is_active']) {
                $month_list = $this->customlib->getMonthDropdown($this->sch_setting_detail->start_month);
                foreach ($month_list as $key => $value) {

                    $transportfesstype[] = $this->transportfee_model->transportfesstype($this->current_session, $key);
                }

                if (!empty($transportfesstype)) {

                    foreach ($transportfesstype as $trs_key => $trs_value) {
                        $transportfesstype[$trs_key]->type = $this->lang->line(strtolower($trs_value->type));
                        $transportfesstype[$trs_key]->code = $this->lang->line(strtolower($trs_value->code));
                    }
                }

                $feesessiongroup[count($feesessiongroup)] = (object)array('id' => 'Transport', 'group_name' => 'Transport Fees', 'is_system' => 0, 'feetypes' => $transportfesstype);
            }
        }


        $data['feesessiongrouplist'] = $feesessiongroup;
        $data['fees_group']          = "";
        if (isset($_POST['feegroup_id']) && $_POST['feegroup_id'] != '') {
            $data['fees_group'] = $_POST['feegroup_id'];
        }

        if (isset($_POST['select_all']) && $_POST['select_all'] != '') {
            $data['select_all'] = $_POST['select_all'];
        }

        $this->form_validation->set_rules('feegroup[]', $this->lang->line('fee_group'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('studentfee/studentSearchFee', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $feegroups = $this->input->post('feegroup');

            $fee_group_array          = array();
            $fee_groups_feetype_array = array();
            $transport_groups_feetype_array = array();
            foreach ($feegroups as $fee_grp_key => $fee_grp_value) {
                $feegroup                   = explode("-", $fee_grp_value);

                if ($feegroup[0] == "Transport") {
                    $transport_groups_feetype_array[] = $feegroup[1];
                } else {
                    $fee_group_array[]          = $feegroup[0];
                    $fee_groups_feetype_array[] = $feegroup[1];
                }
            }

            $fee_group_comma = implode(', ', array_map(function ($val) {
                return sprintf("'%s'", $val);
            }, array_unique($fee_group_array)));
            $fee_groups_feetype_comma = implode(', ', array_map(function ($val) {
                return sprintf("'%s'", $val);
            }, array_unique($fee_groups_feetype_array)));

            $data['student_due_fee'] = array();

            $class_id   = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');

            $student_due_fee = $this->studentfee_model->getMultipleDueFees($fee_group_comma, $fee_groups_feetype_comma, $transport_groups_feetype_array, $class_id, $section_id);
            $students = array();

            if (!empty($student_due_fee)) {
                foreach ($student_due_fee as $student_due_fee_key => $student_due_fee_value) {

                    $amt_due = ($student_due_fee_value['is_system']) ? $student_due_fee_value['fee_master_amount'] : $student_due_fee_value['amount'];

                    $a = json_decode($student_due_fee_value['amount_detail']);
                    if (!empty($a)) {
                        $amount          = 0;
                        $amount_discount = 0;
                        $amount_fine     = 0;

                        foreach ($a as $a_key => $a_value) {
                            $amount          = $amount + $a_value->amount;
                            $amount_discount = $amount_discount + $a_value->amount_discount;
                            $amount_fine     = $amount_fine + $a_value->amount_fine;
                        }
                        if ($amt_due <= ($amount + $amount_discount)) {
                            unset($student_due_fee[$student_due_fee_key]);
                        } else {

                            if (!array_key_exists($student_due_fee_value['student_session_id'], $students)) {

                                $students[$student_due_fee_value['student_session_id']] = $this->add_new_student($student_due_fee_value);
                            }

                            $students[$student_due_fee_value['student_session_id']]['fees'][] = array(
                                'is_system' => $student_due_fee_value['is_system'],
                                'amount'          => $amt_due,
                                'amount_deposite' => $amount,
                                'amount_discount' => $amount_discount,
                                'amount_fine'     => $amount_fine,
                                'fee_group'       => $student_due_fee_value['fee_group'],
                                'fee_type'        => $student_due_fee_value['fee_type'],
                                'fee_code'        => $student_due_fee_value['fee_code'],
                            );
                        }
                    } else {

                        if (!array_key_exists($student_due_fee_value['student_session_id'], $students)) {
                            $students[$student_due_fee_value['student_session_id']] = $this->add_new_student($student_due_fee_value);
                        }
                        $students[$student_due_fee_value['student_session_id']]['fees'][] = array(
                            'is_system' => $student_due_fee_value['is_system'],
                            'amount'          => $student_due_fee_value['amount'],
                            'amount_deposite' => 0,
                            'amount_discount' => 0,
                            'amount_fine'     => 0,
                            'fee_group'       => $student_due_fee_value['fee_group'],
                            'fee_type'        => $student_due_fee_value['fee_type'],
                            'fee_code'        => $student_due_fee_value['fee_code'],
                        );
                    }
                }
            }

            $data['student_remain_fees'] = $students;

            $this->load->view('layout/header', $data);
            $this->load->view('studentfee/studentSearchFee', $data);
            $this->load->view('layout/footer', $data);
        }
    }

    public function reportbyclass()
    {
        $data['title']     = 'student fees';
        $data['title']     = 'student fees';
        $class             = $this->class_model->get();
        $data['classlist'] = $class;
        if ($this->input->server('REQUEST_METHOD') == "GET") {
            $this->load->view('layout/header', $data);
            $this->load->view('studentfee/reportByClass', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $student_fees_array      = array();
            $class_id                = $this->input->post('class_id');
            $section_id              = $this->input->post('section_id');
            $student_result          = $this->student_model->searchByClassSection($class_id, $section_id);
            $data['student_due_fee'] = array();
            if (!empty($student_result)) {
                foreach ($student_result as $key => $student) {
                    $student_array                      = array();
                    $student_array['student_detail']    = $student;
                    $student_session_id                 = $student['student_session_id'];
                    $student_id                         = $student['id'];
                    $student_due_fee                    = $this->studentfee_model->getDueFeeBystudentSection($class_id, $section_id, $student_session_id);
                    $student_array['fee_detail']        = $student_due_fee;
                    $student_fees_array[$student['id']] = $student_array;
                }
            }
            $data['class_id']           = $class_id;
            $data['section_id']         = $section_id;
            $data['student_fees_array'] = $student_fees_array;
            $this->load->view('layout/header', $data);
            $this->load->view('studentfee/reportByClass', $data);
            $this->load->view('layout/footer', $data);
        }
    }

    public function view($id)
    {
        if (!$this->rbac->hasPrivilege('collect_fees', 'can_view')) {
            access_denied();
        }
        $data['title']      = 'studentfee List';
        $studentfee         = $this->studentfee_model->get($id);
        $data['studentfee'] = $studentfee;
        $this->load->view('layout/header', $data);
        $this->load->view('studentfee/studentfeeShow', $data);
        $this->load->view('layout/footer', $data);
    }

    public function deleteFee()
    {
        if (!$this->rbac->hasPrivilege('collect_fees', 'can_delete')) {
            access_denied();
        }
        $invoice_id  = $this->input->post('main_invoice');
        $sub_invoice = $this->input->post('sub_invoice');
        if (!empty($invoice_id)) {
            $this->studentfee_model->remove($invoice_id, $sub_invoice);
        }
        $array = array('status' => 'success', 'result' => 'success');
        echo json_encode($array);
    }

    public function deleteStudentDiscount()
    {
        $discount_id = $this->input->post('discount_id');
        if (!empty($discount_id)) {
            $data = array('id' => $discount_id, 'status' => 'assigned', 'payment_id' => "");
            $this->feediscount_model->updateStudentDiscount($data);
        }
        $array = array('status' => 'success', 'result' => 'success');
        echo json_encode($array);
    }

    public function getcollectfee()
    {
        $setting_result      = $this->setting_model->get();
        $data['settinglist'] = $setting_result;
        $record              = $this->input->post('data');
        $record_array        = json_decode($record);

        $fees_array = array();
        foreach ($record_array as $key => $value) {
            $fee_groups_feetype_id = $value->fee_groups_feetype_id;
            $fee_master_id         = $value->fee_master_id;
            $fee_session_group_id  = $value->fee_session_group_id;
            $fee_category          = $value->fee_category;
            $trans_fee_id          = $value->trans_fee_id;

            if ($fee_category == "transport") {
                $feeList               = $this->studentfeemaster_model->getTransportFeeByID($trans_fee_id);
                $feeList->fee_category = $fee_category;
            } else {
                $feeList               = $this->studentfeemaster_model->getDueFeeByFeeSessionGroupFeetype($fee_session_group_id, $fee_master_id, $fee_groups_feetype_id);
                $feeList->fee_category = $fee_category;
            }

            $fees_array[] = $feeList;
        }

        $data['feearray'] = $fees_array;
        $result           = array(
            'view' => $this->load->view('studentfee/getcollectfee', $data, true),
        );

        $this->output->set_output(json_encode($result));
    }

    public function addfee($id)
    {

        if (!$this->rbac->hasPrivilege('collect_fees', 'can_view')) {
            access_denied();
        }

        $data['sch_setting']   = $this->sch_setting_detail;
        $data['title']         = 'Student Detail';
        $student               = $this->student_model->getByStudentSession($id);
        $route_pickup_point_id = $student['route_pickup_point_id'];
        $student_session_id    = $student['student_session_id'];
        $transport_fees = [];

        $module = $this->module_model->getPermissionByModulename('transport');
        if ($module['is_active']) {

            $transport_fees        = $this->studentfeemaster_model->getStudentTransportFees($student_session_id, $route_pickup_point_id);
        }

        $data['student']       = $student;
        $student_due_fee       = $this->studentfeemaster_model->getStudentFees($id);
        $student_discount_fee  = $this->feediscount_model->getStudentFeesDiscount($id);

        $data['transport_fees']         = $transport_fees;
        $data['student_discount_fee']   = $student_discount_fee;
        $data['student_due_fee']        = $student_due_fee;
        $category                       = $this->category_model->get();
        $data['categorylist']           = $category;
        $class_section                  = $this->student_model->getClassSection($student["class_id"]);
        $data["class_section"]          = $class_section;
        $session                        = $this->setting_model->getCurrentSession();
        $studentlistbysection           = $this->student_model->getStudentClassSection($student["class_id"], $session);
        $data["studentlistbysection"]   = $studentlistbysection;
        $student_processing_fee         = $this->studentfeemaster_model->getStudentProcessingFees($id);
        $data['student_processing_fee'] = false;

        foreach ($student_processing_fee as $key => $processing_value) {
            if (!empty($processing_value->fees)) {
                $data['student_processing_fee'] = true;
            }
        }

        $this->load->view('layout/header', $data);
        $this->load->view('studentfee/studentAddfee', $data);
        $this->load->view('layout/footer', $data);
    }

    public function getProcessingfees($id)
    {
        if (!$this->rbac->hasPrivilege('collect_fees', 'can_add')) {
            access_denied();
        }

        $student               = $this->student_model->getByStudentSession($id);
        $route_pickup_point_id = $student['route_pickup_point_id'];
        $student_session_id    = $student['student_session_id'];

        $transport_fees        = $this->studentfeemaster_model->getProcessingTransportFees($student_session_id, $route_pickup_point_id);
        $data['student']       = $student;
        $student_due_fee       = $this->studentfeemaster_model->getStudentProcessingFees($id);
        $data['transport_fees']  = $transport_fees;
        $data['student_due_fee'] = $student_due_fee;
     
        $result = array(
            'view' => $this->load->view('user/student/getProcessingfees', $data, true),
        );
        $this->output->set_output(json_encode($result));
    }

    /**
     * Print transport fee receipt
     */
    private function print_transport_fee_receipt($student_session_id, $template_code, $fee_group, $paid_amount, $fee_code)
    {
        // Get student data
        $this->db->select('students.*, student_session.class_id, student_session.section_id, classes.class, sections.section');
        $this->db->from('student_session');
        $this->db->join('students', 'students.id = student_session.student_id');
        $this->db->join('classes', 'classes.id = student_session.class_id');
        $this->db->join('sections', 'sections.id = student_session.section_id');
        $this->db->where('student_session.id', $student_session_id);
        $query = $this->db->get();
        $student_data = $query->row();
        
        if (!$student_data) {
            show_error('Student not found!', 404);
        }

        // Get receipt template (same as regular receipts)
        $template = $this->simple_receipt_model->get_template_by_code($template_code);
        
        if (!$template || !$template->is_active) {
            // Fallback to default template
            $template = (object) array(
                'template_name' => 'Default Transport Receipt Template',
                'template_code' => 'default_receipt',
                'template_content' => $this->get_default_transport_template()
            );
        }
        
        $template_content = $template->template_content;

        // Replace variables in template
        $variables = array(
            '{{school_name}}' => $this->sch_setting_detail->name,
            '{{school_address}}' => $this->sch_setting_detail->address,
            '{{school_phone}}' => $this->sch_setting_detail->phone,
            '{{school_email}}' => $this->sch_setting_detail->email,
            '{{student_name}}' => $student_data->firstname . ' ' . $student_data->middlename . ' ' . $student_data->lastname,
            '{{admission_no}}' => $student_data->admission_no,
            '{{class_section}}' => $student_data->class . ' - ' . $student_data->section,
            '{{father_name}}' => $student_data->father_name,
            '{{fee_month}}' => $fee_code,
            '{{paid_amount}}' => $paid_amount,
            '{{currency_symbol}}' => $this->customlib->getSchoolCurrencyFormat(),
            '{{receipt_date}}' => date('d-m-Y'),
            '{{receipt_time}}' => date('h:i A'),
            '{{receipt_number}}' => 'TF-' . date('YmdHis'),
            '{{collected_by}}' => $this->session->userdata('username')
        );

        $receipt_content = str_replace(array_keys($variables), array_values($variables), $template_content);

        // Output receipt
        echo '<!DOCTYPE html>
        <html>
        <head>
            <title>Transport Fee Receipt</title>
            <style>
                body { font-family: Arial, sans-serif; margin: 20px; }
                @media print { .no-print { display: none; } }
            </style>
        </head>
        <body>
            ' . $receipt_content . '
            <div class="no-print" style="text-align: center; margin-top: 20px;">
                <button onclick="window.print()" style="background: #4CAF50; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; margin-right: 10px;">
                    Print Receipt
                </button>
                <button onclick="window.close()" style="background: #f44336; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer;">
                    Close
                </button>
            </div>
            <script>
                window.onload = function() {
                    setTimeout(function() { window.print(); }, 500);
                };
            </script>
        </body>
        </html>';
    }

    /**
     * Get default transport receipt template - Clean HTML block for template system
     */
    private function get_default_transport_template()
    {
        return '<div class="transport-receipt-container" style="max-width: 600px; margin: 0 auto; padding: 20px; font-family: Arial, sans-serif; border: 2px solid #333; background: #fff;">
    <!-- School Header -->
    <div class="receipt-header" style="text-align: center; border-bottom: 2px solid #333; padding-bottom: 20px; margin-bottom: 20px;">
        <h2 style="margin: 0; color: #333; font-size: 24px; font-weight: bold;">{{school_name}}</h2>
        <p style="margin: 5px 0; color: #666; font-size: 14px;">{{school_address}}</p>
        <p style="margin: 5px 0; color: #666; font-size: 14px;">Phone: {{school_phone}} | Email: {{school_email}}</p>
        <h3 style="margin: 15px 0 10px 0; color: #d32f2f; font-size: 18px; font-weight: bold; text-transform: uppercase;">🚌 Transport Fee Receipt</h3>
    </div>
    
    <!-- Receipt Details -->
    <div class="receipt-details" style="margin-bottom: 20px; background: #f9f9f9; padding: 15px; border-radius: 5px;">
        <div style="display: flex; justify-content: space-between; margin-bottom: 10px; flex-wrap: wrap;">
            <span style="font-weight: bold; color: #333;"><strong>Receipt No:</strong> {{receipt_number}}</span>
            <span style="font-weight: bold; color: #333;"><strong>Date:</strong> {{receipt_date}}</span>
        </div>
        <div style="display: flex; justify-content: space-between; margin-bottom: 10px; flex-wrap: wrap;">
            <span style="color: #333;"><strong>Student Name:</strong> {{student_name}}</span>
            <span style="color: #333;"><strong>Admission No:</strong> {{admission_no}}</span>
        </div>
        <div style="display: flex; justify-content: space-between; margin-bottom: 10px; flex-wrap: wrap;">
            <span style="color: #333;"><strong>Class:</strong> {{class_section}}</span>
            <span style="color: #333;"><strong>Father Name:</strong> {{father_name}}</span>
        </div>
    </div>
    
    <!-- Fee Details Table -->
    <table class="fee-table" style="width: 100%; border-collapse: collapse; margin-bottom: 20px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
        <thead>
            <tr style="background: linear-gradient(135deg, #4CAF50, #45a049); color: white;">
                <th style="border: 1px solid #333; padding: 12px; text-align: left; font-weight: bold;">Description</th>
                <th style="border: 1px solid #333; padding: 12px; text-align: center; font-weight: bold;">Month</th>
                <th style="border: 1px solid #333; padding: 12px; text-align: right; font-weight: bold;">Amount</th>
            </tr>
        </thead>
        <tbody>
            <tr style="background: #fff;">
                <td style="border: 1px solid #ddd; padding: 12px; color: #333;">🚌 Transport Fee</td>
                <td style="border: 1px solid #ddd; padding: 12px; text-align: center; color: #333; font-weight: bold;">{{fee_month}}</td>
                <td style="border: 1px solid #ddd; padding: 12px; text-align: right; color: #333; font-weight: bold;">{{currency_symbol}}{{paid_amount}}</td>
            </tr>
        </tbody>
        <tfoot>
            <tr style="background: linear-gradient(135deg, #f5f5f5, #e8e8e8); font-weight: bold;">
                <td colspan="2" style="border: 1px solid #333; padding: 12px; text-align: right; color: #333; font-size: 16px;">Total Paid:</td>
                <td style="border: 1px solid #333; padding: 12px; text-align: right; color: #d32f2f; font-size: 16px; font-weight: bold;">{{currency_symbol}}{{paid_amount}}</td>
            </tr>
        </tfoot>
    </table>
    
    <!-- Payment Information -->
    <div class="payment-info" style="margin-top: 30px; display: flex; justify-content: space-between; align-items: flex-start; flex-wrap: wrap;">
        <div class="payment-details" style="flex: 1; min-width: 200px;">
            <p style="margin: 0; color: #333; font-size: 14px;"><strong>💳 Payment Mode:</strong> Cash</p>
            <p style="margin: 8px 0; color: #333; font-size: 14px;"><strong>👤 Received By:</strong> {{collected_by}}</p>
            <p style="margin: 8px 0; color: #666; font-size: 12px;"><strong>🕒 Time:</strong> {{receipt_time}}</p>
        </div>
        <div class="signature-section" style="text-align: right; flex: 1; min-width: 200px;">
            <p style="margin: 0; border-bottom: 1px solid #333; width: 150px; margin-left: auto; padding-bottom: 2px;">&nbsp;</p>
            <p style="margin: 8px 0; color: #666; font-size: 12px; text-align: center;">Authorized Signature</p>
        </div>
    </div>
    
    <!-- Footer Message -->
    <div class="receipt-footer" style="text-align: center; margin-top: 30px; padding-top: 20px; border-top: 1px dashed #ccc;">
        <p style="margin: 0; color: #666; font-size: 12px; font-style: italic;">✅ Thank you for your payment. Keep this receipt for your records.</p>
        <p style="margin: 5px 0; color: #999; font-size: 10px;">This is a computer generated receipt and does not require signature.</p>
    </div>
</div>';
    }

    public function deleteTransportFee()
    {
        $id = $this->input->post('feeid');
        $this->studenttransportfee_model->remove($id);
        $array = array('status' => 'success', 'result' => 'success');
        echo json_encode($array);
    }

    public function delete($id)
    {
        $data['title'] = 'studentfee List';
        $this->studentfee_model->remove($id);
        redirect('studentfee/index');
    }

    public function printFeeReceipt($student_session_id = null, $student_fees_master_id = null, $template_code = 'default_receipt') {
        if (!$student_session_id || !$student_fees_master_id) {
            echo '<div class="alert alert-danger">Invalid receipt parameters!</div>';
            return;
        }

        // Simple receipt model is already loaded in constructor

        // Get student details
        $student_data = $this->student_model->getStudentByStudentSession($student_session_id);
        
        if (!$student_data) {
            echo '<div class="alert alert-danger">Student not found!</div>';
            return;
        }

        // Get fee details
        $fee_group = $this->input->get('fee_group') ?: 'Fee Payment';
        $paid_amount = $this->input->get('paid_amount') ?: '0.00';
        $fee_code = $this->input->get('fee_code') ?: '';

        // Get receipt template
        $template = $this->simple_receipt_model->get_template_by_code($template_code);
        
        if (!$template) {
            // Fallback to default template
            $template = $this->simple_receipt_model->get_template_by_code('default_receipt');
        }

        if (!$template) {
            echo '<div class="alert alert-danger">Receipt template not found!</div>';
            return;
        }

        // Prepare receipt data
        $receipt_data = array(
            'school_name' => $this->sch_setting_detail->name ?: 'Pm Digital School',
            'school_address' => $this->sch_setting_detail->address ?: '123 School Street, City, State',
            'school_phone' => $this->sch_setting_detail->phone ?: '+91 9876543210',
            'school_email' => $this->sch_setting_detail->email ?: 'info@pmdigitalschool.com',
            'student_name' => $student_data->firstname . ' ' . $student_data->lastname,
            'admission_no' => $student_data->admission_no,
            'class_name' => $student_data->class . ' (' . $student_data->section . ')',
            'fee_group' => $fee_group,
            'fee_code' => $fee_code,
            'fee_amount' => '₹' . number_format($paid_amount, 2),
            'payment_date' => date('d-m-Y'),
            'payment_mode' => 'Cash',
            'invoice_id' => 'INV' . date('Ymd') . '/' . $student_fees_master_id,
            'receipt_no' => 'RCP' . date('Ymd') . '/' . $student_fees_master_id
        );

        // Render template
        $receipt_html = $this->simple_receipt_model->render_template($template_code, $receipt_data);

        // Display receipt with print functionality
        echo '<!DOCTYPE html>
        <html>
        <head>
            <title>Fee Receipt - ' . $student_data->firstname . ' ' . $student_data->lastname . '</title>
            <meta charset="utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <style>
                body { 
                    font-family: Arial, sans-serif; 
                    margin: 20px; 
                    background: #f5f5f5;
                }
                @media print {
                    body { 
                        margin: 0; 
                        background: white;
                    }
                    .no-print { display: none !important; }
                    .receipt-container {
                        box-shadow: none !important;
                        border: none !important;
                    }
                }
                .receipt-container { 
                    max-width: 600px; 
                    margin: 0 auto; 
                    background: white;
                    box-shadow: 0 0 20px rgba(0,0,0,0.1);
                    border-radius: 8px;
                    overflow: hidden;
                }
                .receipt-header {
                    background: linear-gradient(135deg, #4CAF50, #45a049);
                    color: white;
                    padding: 20px;
                    text-align: center;
                }
                .receipt-info {
                    background: #e8f5e8;
                    padding: 15px;
                    margin-bottom: 20px;
                    border-radius: 5px;
                    border: 1px solid #4CAF50;
                }
                .print-controls {
                    text-align: center;
                    padding: 20px;
                    background: #f8f9fa;
                    border-bottom: 1px solid #dee2e6;
                }
                .btn {
                    padding: 10px 20px;
                    margin: 5px;
                    border: none;
                    border-radius: 5px;
                    cursor: pointer;
                    font-size: 14px;
                    text-decoration: none;
                    display: inline-block;
                }
                .btn-success { background: #4CAF50; color: white; }
                .btn-danger { background: #f44336; color: white; }
                .btn:hover { opacity: 0.9; }
                .template-info {
                    background: #fff3cd;
                    border: 1px solid #ffeaa7;
                    padding: 10px;
                    margin-bottom: 15px;
                    border-radius: 4px;
                    font-size: 12px;
                    color: #856404;
                }
            </style>
        </head>
        <body>
            <div class="no-print print-controls">
                <div class="receipt-header">
                    <h2>🧾 Fee Receipt Generated Successfully</h2>
                    <p>Student: ' . $student_data->firstname . ' ' . $student_data->lastname . ' | Admission No: ' . $student_data->admission_no . '</p>
                </div>
                
                <div class="receipt-info">
                    <div class="template-info">
                        <strong>📋 Template:</strong> ' . $template->template_name . ' (' . $template_code . ')
                    </div>
                    <div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
                        <span><strong>Fee Group:</strong></span>
                        <span>' . $fee_group . '</span>
                    </div>
                    <div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
                        <span><strong>Amount Paid:</strong></span>
                        <span style="color: #4CAF50; font-weight: bold;">₹' . number_format($paid_amount, 2) . '</span>
                    </div>
                    <div style="display: flex; justify-content: space-between;">
                        <span><strong>Receipt Date:</strong></span>
                        <span>' . date('d-m-Y H:i:s') . '</span>
                    </div>
                </div>
                
                <button onclick="window.print()" class="btn btn-success">
                    <i class="fa fa-print"></i> Print Receipt
                </button>
                <button onclick="window.close()" class="btn btn-danger">
                    <i class="fa fa-times"></i> Close Window
                </button>
            </div>
            
            <div class="receipt-container">
                ' . $receipt_html . '
            </div>

            <script>
                // Auto-focus for better UX
                window.focus();
                
                // Print shortcut
                document.addEventListener("keydown", function(e) {
                    if (e.ctrlKey && e.key === "p") {
                        e.preventDefault();
                        window.print();
                    }
                });
            </script>
        </body>
        </html>';
    }

    public function create()
    {
        if (!$this->rbac->hasPrivilege('collect_fees', 'can_view')) {
            access_denied();
        }
        $data['title'] = 'Add studentfee';
        $this->form_validation->set_rules('category', $this->lang->line('category'), 'trim|required|xss_clean');
        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('studentfee/studentfeeCreate', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $data = array(
                'category' => $this->input->post('category'),
            );
            $this->studentfee_model->add($data);
            $this->session->set_flashdata('msg', '<div studentfee="alert alert-success text-center">' . $this->lang->line('success_message') . '</div>');
            redirect('studentfee/index');
        }
    }

    public function edit($id)
    {
        if (!$this->rbac->hasPrivilege('collect_fees', 'can_edit')) {
            access_denied();
        }
        $data['title']      = 'Edit studentfees';
        $data['id']         = $id;
        $studentfee         = $this->studentfee_model->get($id);
        $data['studentfee'] = $studentfee;
        $this->form_validation->set_rules('category', $this->lang->line('category'), 'trim|required|xss_clean');
        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('studentfee/studentfeeEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $data = array(
                'id'       => $id,
                'category' => $this->input->post('category'),
            );
            $this->studentfee_model->add($data);
            $this->session->set_flashdata('msg', '<div studentfee="alert alert-success text-center">' . $this->lang->line('update_message') . '</div>');
            redirect('studentfee/index');
        }
    }

    public function addstudentfee()
    {
        $this->form_validation->set_rules('student_fees_master_id', $this->lang->line('fee_master'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('date', $this->lang->line('date'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('fee_groups_feetype_id', $this->lang->line('student'), 'required|trim|xss_clean');
        // Allow negative amounts for refunds
        $amount = $this->input->post('amount');
        if ($amount < 0) {
            // This is a refund - skip positive amount validation
            $this->form_validation->set_rules('amount', $this->lang->line('amount'), 'required|trim|xss_clean|numeric');
        } else {
            $this->form_validation->set_rules('amount', $this->lang->line('amount'), 'required|trim|xss_clean|numeric|callback_check_deposit');
        }
        $this->form_validation->set_rules('amount_discount', $this->lang->line('discount'), 'required|trim|numeric|xss_clean');
        $this->form_validation->set_rules('amount_fine', $this->lang->line('fine'), 'required|trim|numeric|xss_clean');
        $this->form_validation->set_rules('payment_mode', $this->lang->line('payment_mode'), 'required|trim|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'amount'                 => form_error('amount'),
                'student_fees_master_id' => form_error('student_fees_master_id'),
                'fee_groups_feetype_id'  => form_error('fee_groups_feetype_id'),
                'amount_discount'        => form_error('amount_discount'),
                'amount_fine'            => form_error('amount_fine'),
                'payment_mode'           => form_error('payment_mode'),
                'date'           => form_error('date'),
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        } else {

            $staff_record = $this->staff_model->get($this->customlib->getStaffID());

            $collected_by             = $this->customlib->getAdminSessionUserName() . "(" . $staff_record['employee_id'] . ")";
            $student_fees_discount_id = $this->input->post('student_fees_discount_id');
            $json_array               = array(
                'amount'          => convertCurrencyFormatToBaseAmount($this->input->post('amount')),
                'amount_discount' => convertCurrencyFormatToBaseAmount($this->input->post('amount_discount')),
                'amount_fine'     => convertCurrencyFormatToBaseAmount($this->input->post('amount_fine')),
                'date'            => date('Y-m-d', $this->customlib->datetostrtotime($this->input->post('date'))),
                'description'     => $this->input->post('description'),
                'collected_by'    => $collected_by,
                'payment_mode'    => $this->input->post('payment_mode'),
                'received_by'     => $staff_record['id'],
            );

            $student_fees_master_id = $this->input->post('student_fees_master_id');
            $fee_groups_feetype_id  = $this->input->post('fee_groups_feetype_id');
            $transport_fees_id      = $this->input->post('transport_fees_id');
            $fee_category           = $this->input->post('fee_category');

            $data = array(
                'fee_category'           => $fee_category,
                'student_fees_master_id' => $this->input->post('student_fees_master_id'),
                'fee_groups_feetype_id'  => $this->input->post('fee_groups_feetype_id'),
                'amount_detail'          => $json_array,
            );

            if ($transport_fees_id != 0 && $fee_category == "transport") {
                $mailsms_array                    = new stdClass();
                $data['student_fees_master_id']   = null;
                $data['fee_groups_feetype_id']    = null;
                $data['student_transport_fee_id'] = $transport_fees_id;

                $mailsms_array                 = $this->studenttransportfee_model->getTransportFeeMasterByStudentTransportID($transport_fees_id);
                $mailsms_array->fee_group_name = $this->lang->line("transport_fees");
                $mailsms_array->type           = $mailsms_array->month;
                $mailsms_array->code           = "";
            } else {

                $mailsms_array = $this->feegrouptype_model->getFeeGroupByIDAndStudentSessionID($this->input->post('fee_groups_feetype_id'), $this->input->post('student_session_id'));

                if ($mailsms_array->is_system) {
                    $mailsms_array->amount = $mailsms_array->balance_fee_master_amount;
                }
            }

            $action             = $this->input->post('action');
            $send_to            = $this->input->post('guardian_phone');
            $email              = $this->input->post('guardian_email');
            $parent_app_key     = $this->input->post('parent_app_key');
            $student_session_id = $this->input->post('student_session_id');
            $inserted_id        = $this->studentfeemaster_model->fee_deposit($data, $send_to, $student_fees_discount_id);

            // Create automatic income entry after successful fee deposit
            if ($inserted_id) {
                $this->createAutomaticIncome($inserted_id, $student_session_id, $json_array, $mailsms_array);
            }

            $print_record = array();
            if ($action == "print") {
                $receipt_data           = json_decode($inserted_id);
                $data['sch_setting']    = $this->sch_setting_detail;

                $student                = $this->studentsession_model->searchStudentsBySession($student_session_id);
                $data['student']        = $student;
                $data['sub_invoice_id'] = $receipt_data->sub_invoice_id;

                $setting_result         = $this->setting_model->get();
                $data['settinglist']    = $setting_result;

                if ($transport_fees_id != 0 && $fee_category == "transport") {

                    $fee_record = $this->studentfeemaster_model->getTransportFeeByInvoice($receipt_data->invoice_id, $receipt_data->sub_invoice_id);
                    $data['feeList']        = $fee_record;
                    $print_record = $this->load->view('print/printTransportFeesByName', $data, true);
                } else {

                    $fee_record             = $this->studentfeemaster_model->getFeeByInvoice($receipt_data->invoice_id, $receipt_data->sub_invoice_id);
                    $data['feeList']        = $fee_record;
                    $print_record = $this->load->view('print/printFeesByName', $data, true);
                }
            }

            $mailsms_array->invoice            = $inserted_id;
            $mailsms_array->student_session_id = $student_session_id;
            $mailsms_array->contact_no         = $send_to;
            $mailsms_array->email              = $email;
            $mailsms_array->parent_app_key     = $parent_app_key;
            $mailsms_array->fee_category       = $fee_category;

            $this->mailsmsconf->mailsms('fee_submission', $mailsms_array);

            $array = array('status' => 'success', 'error' => '', 'print' => $print_record);
            echo json_encode($array);
        }
    }

    public function printFeesByName()
    {
        $data                   = array('payment' => "0");
        $record                 = $this->input->post('data');
        $fee_category           = $this->input->post('fee_category');
        $invoice_id             = $this->input->post('main_invoice');
        $sub_invoice_id         = $this->input->post('sub_invoice');
        $student_session_id     = $this->input->post('student_session_id');
        $setting_result         = $this->setting_model->get();
        $data['settinglist']    = $setting_result;
        $student                = $this->studentsession_model->searchStudentsBySession($student_session_id);
        $data['student']        = $student;
        $data['sub_invoice_id'] = $sub_invoice_id;
        $data['sch_setting']    = $this->sch_setting_detail;

        $data['superadmin_rest'] = $this->customlib->superadmin_visible();

        if ($fee_category == "transport") {
            $fee_record      = $this->studentfeemaster_model->getTransportFeeByInvoice($invoice_id, $sub_invoice_id);
            $data['feeList'] = $fee_record;
            $page            = $this->load->view('print/printTransportFeesByName', $data, true);
        } else {
            $fee_record      = $this->studentfeemaster_model->getFeeByInvoice($invoice_id, $sub_invoice_id);
            $data['feeList'] = $fee_record;
            $page = $this->load->view('print/printFeesByName', $data, true);
        }

        echo json_encode(array('status' => 1, 'page' => $page));
    }

    public function printFeesByGroup()
    {
        $fee_category        = $this->input->post('fee_category');
        $trans_fee_id        = $this->input->post('trans_fee_id');
        $setting_result      = $this->setting_model->get();
        $data['settinglist'] = $setting_result;
        $data['sch_setting'] = $this->sch_setting_detail;

        if ($fee_category == "transport") {
            $data['feeList'] = $this->studentfeemaster_model->getTransportFeeByID($trans_fee_id);
            $page = $this->load->view('print/printTransportFeesByGroup', $data, true);
        } else {

            $fee_groups_feetype_id = $this->input->post('fee_groups_feetype_id');
            $fee_master_id         = $this->input->post('fee_master_id');
            $fee_session_group_id  = $this->input->post('fee_session_group_id');
            $this->load->model(array('student_model', 'feesessiongroup_model', 'feetype_model', 'feemaster_model', 'studentfeemaster_model', 'studentfee_model', 'feegrouptype_model', 'studentfeesessiondeposit_model'));
            $data['feeList']       = $this->studentfeemaster_model->getDueFeeByFeeSessionGroupFeetype($fee_session_group_id, $fee_master_id, $fee_groups_feetype_id);
            $page                  = $this->load->view('print/printFeesByGroup', $data, true);
        }

        echo json_encode(array('status' => 1, 'page' => $page));
    }

    public function printFeesByGroupArray()
    {
        $data['sch_setting'] = $this->sch_setting_detail;
        $record              = $this->input->post('data');
        $record_array        = json_decode($record);
        $fees_array          = array();
        foreach ($record_array as $key => $value) {
            $fee_groups_feetype_id = $value->fee_groups_feetype_id;
            $fee_master_id         = $value->fee_master_id;
            $fee_session_group_id  = $value->fee_session_group_id;
            $fee_category          = $value->fee_category;
            $trans_fee_id          = $value->trans_fee_id;

            if ($fee_category == "transport") {
                $feeList               = $this->studentfeemaster_model->getTransportFeeByID($trans_fee_id);
                $feeList->fee_category = $fee_category;
            } else {
                $feeList               = $this->studentfeemaster_model->getDueFeeByFeeSessionGroupFeetype($fee_session_group_id, $fee_master_id, $fee_groups_feetype_id);
                $feeList->fee_category = $fee_category;
            }

            $fees_array[] = $feeList;
        }

        $data['feearray'] = $fees_array;
        $this->load->view('print/printFeesByGroupArray', $data);
    }

    public function searchpayment()
    {
        if (!$this->rbac->hasPrivilege('search_fees_payment', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Fees Collection');
        $this->session->set_userdata('sub_menu', 'studentfee/searchpayment');
        $data['title'] = $this->lang->line('fees_collection');

        $this->form_validation->set_rules('paymentid', $this->lang->line('payment_id'), 'trim|required|xss_clean');
        if ($this->form_validation->run() == false) {
        } else {
            $paymentid = $this->input->post('paymentid');
            $invoice   = explode("/", $paymentid);

            if (array_key_exists(0, $invoice) && array_key_exists(1, $invoice)) {
                $invoice_id             = $invoice[0];
                $sub_invoice_id         = $invoice[1];
                $feeList                = $this->studentfeemaster_model->getFeeByInvoice($invoice_id, $sub_invoice_id);
               $current_session= $this->customlib->getCurrentSession();
                $data['current_session']        = $current_session;
                $data['feeList']        = $feeList;
                $data['sub_invoice_id'] = $sub_invoice_id;
            } else {
                $data['feeList'] = array();
            }
        }
        $data['sch_setting'] = $this->sch_setting_detail;

        $this->load->view('layout/header', $data);
        $this->load->view('studentfee/searchpayment', $data);
        $this->load->view('layout/footer', $data);
    }

    public function addfeegroup()
    {
        $this->form_validation->set_rules('fee_session_groups', $this->lang->line('fee_group'), 'required|trim|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'fee_session_groups' => form_error('fee_session_groups'),
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        } else {
            $student_session_id     = $this->input->post('student_session_id');
            $fee_session_groups     = $this->input->post('fee_session_groups');
            $student_sesssion_array = isset($student_session_id) ? $student_session_id : array();
            $student_ids            = $this->input->post('student_ids');
            $delete_student         = array_diff($student_ids, $student_sesssion_array);

            $preserve_record = array();
            if (!empty($student_sesssion_array)) {
                foreach ($student_sesssion_array as $key => $value) {
                    $insert_array = array(
                        'student_session_id'   => $value,
                        'fee_session_group_id' => $fee_session_groups,
                    );
                    $inserted_id = $this->studentfeemaster_model->add($insert_array);

                    $preserve_record[] = $inserted_id;
                }
            }
            if (!empty($delete_student)) {
                $this->studentfeemaster_model->delete($fee_session_groups, $delete_student);
            }

            $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('success_message'));
            echo json_encode($array);
        }
    }

    public function geBalanceFee()
    {
        $this->form_validation->set_rules('fee_groups_feetype_id', $this->lang->line('fee_groups_feetype_id'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('student_fees_master_id', $this->lang->line('student_fees_master_id'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('student_session_id', $this->lang->line('student_session_id'), 'required|trim|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'fee_groups_feetype_id'  => form_error('fee_groups_feetype_id'),
                'student_fees_master_id' => form_error('student_fees_master_id'),
                'student_session_id'     => form_error('student_session_id'),
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        } else {
            $data                 = array();
            $student_session_id   = $this->input->post('student_session_id');
            $discount_not_applied = $this->getNotAppliedDiscount($student_session_id);

            $fee_category = $this->input->post('fee_category');

            if ($fee_category == "transport") {
                $trans_fee_id         = $this->input->post('trans_fee_id');
                $remain_amount_object = $this->getStudentTransportFeetypeBalance($trans_fee_id);
                $remain_amount        = (float) json_decode($remain_amount_object)->balance;
                $remain_amount_fine   = json_decode($remain_amount_object)->fine_amount;
            } else {
                $fee_groups_feetype_id  = $this->input->post('fee_groups_feetype_id');
                $student_fees_master_id = $this->input->post('student_fees_master_id');
                $remain_amount_object   = $this->getStuFeetypeBalance($fee_groups_feetype_id, $student_fees_master_id);
                $remain_amount          = json_decode($remain_amount_object)->balance;
                $remain_amount_fine     = json_decode($remain_amount_object)->fine_amount;
            }

            $remain_amount = number_format($remain_amount, 2, ".", "");

            $array = array('status' => 'success', 'error' => '', 'balance' => convertBaseAmountCurrencyFormat($remain_amount), 'discount_not_applied' => $discount_not_applied, 'remain_amount_fine' => convertBaseAmountCurrencyFormat($remain_amount_fine), 'student_fees' => convertBaseAmountCurrencyFormat(json_decode($remain_amount_object)->student_fees));
            echo json_encode($array);
        }
    }

    public function getStudentTransportFeetypeBalance($trans_fee_id)
    {
        $data = array();

        $result          = $this->studentfeemaster_model->studentTransportDeposit($trans_fee_id);
        $amount_balance  = 0;
        $amount          = 0;
        $amount_fine     = 0;
        $amount_discount = 0;
        $fine_amount     = 0;
        $fee_fine_amount = 0;

        $due_amt = $result->fees;
        if (strtotime($result->due_date) < strtotime(date('Y-m-d'))) {
            $fee_fine_amount = is_null($result->fine_percentage) ? $result->fine_amount : percentageAmount($result->fees, $result->fine_percentage);
        }

        $amount_detail = json_decode($result->amount_detail);
        if (is_object($amount_detail)) {

            foreach ($amount_detail as $amount_detail_key => $amount_detail_value) {
                $amount          = $amount + $amount_detail_value->amount;
                $amount_discount = $amount_discount + $amount_detail_value->amount_discount;
                $amount_fine     = $amount_fine + $amount_detail_value->amount_fine;
            }
        }

        $amount_balance = $due_amt - ($amount + $amount_discount);
        $fine_amount    = abs($amount_fine - $fee_fine_amount);
        $array          = array('status' => 'success', 'error' => '', 'student_fees' => $due_amt, 'balance' => $amount_balance, 'fine_amount' => $fine_amount);
        return json_encode($array);
    }

    public function getStuFeetypeBalance($fee_groups_feetype_id, $student_fees_master_id)
    {
        $data                           = array();
        $data['fee_groups_feetype_id']  = $fee_groups_feetype_id;
        $data['student_fees_master_id'] = $student_fees_master_id;
        $result                         = $this->studentfeemaster_model->studentDeposit($data);

        $amount_balance  = 0;
        $amount          = 0;
        $amount_fine     = 0;
        $amount_discount = 0;
        $fine_amount     = 0;
        $fee_fine_amount = 0;
        $due_amt         = $result->amount;
        if ((!empty($result->due_date)) && strtotime($result->due_date) < strtotime(date('Y-m-d'))) {
            $fee_fine_amount = $result->fine_amount;
        }

        if ($result->is_system) {
            $due_amt = $result->student_fees_master_amount;
        }

        $amount_detail = json_decode($result->amount_detail);
        if (is_object($amount_detail)) {

            foreach ($amount_detail as $amount_detail_key => $amount_detail_value) {
                $amount          = $amount + $amount_detail_value->amount;
                $amount_discount = $amount_discount + $amount_detail_value->amount_discount;
                $amount_fine     = $amount_fine + $amount_detail_value->amount_fine;
            }
        }

        $amount_balance = $due_amt - ($amount + $amount_discount);
        $fine_amount    = ($fee_fine_amount > 0) ? ($fee_fine_amount - $amount_fine) : 0;

        $array          = array('status' => 'success', 'error' => '', 'student_fees' => $due_amt, 'balance' => $amount_balance, 'fine_amount' => $fine_amount);
        return json_encode($array);
    }

    public function check_deposit($amount)
    {
        if (is_numeric($this->input->post('amount')) && is_numeric($this->input->post('amount_discount'))) {
            if ($this->input->post('amount') != "" && $this->input->post('amount_discount') != "") {
                if ($this->input->post('amount') < 0) {
                    $this->form_validation->set_message('check_deposit', $this->lang->line('deposit_amount_can_not_be_less_than_zero'));
                    return false;
                } else {
                    $transport_fees_id      = $this->input->post('transport_fees_id');
                    $student_fees_master_id = $this->input->post('student_fees_master_id');
                    $fee_groups_feetype_id  = $this->input->post('fee_groups_feetype_id');
                    $deposit_amount         = $this->input->post('amount') + $this->input->post('amount_discount');
                    if ($transport_fees_id != 0) {
                        $remain_amount = $this->getStudentTransportFeetypeBalance($transport_fees_id);
                    } else {
                        $remain_amount = $this->getStuFeetypeBalance($fee_groups_feetype_id, $student_fees_master_id);
                    }
                    $remain_amount = json_decode($remain_amount)->balance;
                    if (convertBaseAmountCurrencyFormat($remain_amount) < $deposit_amount) {
                        $this->form_validation->set_message('check_deposit', $this->lang->line('deposit_amount_can_not_be_greater_than_remaining'));
                        return false;
                    } else {
                        return true;
                    }
                }
                return true;
            }
        } elseif (!is_numeric($this->input->post('amount'))) {
            $this->form_validation->set_message('check_deposit', $this->lang->line('amount_field_must_contain_only_numbers'));
            return false;
        } elseif (!is_numeric($this->input->post('amount_discount'))) {
            return true;
        }

        return true;
    }

    public function getNotAppliedDiscount($student_session_id)
    {
        $discounts_array = $this->feediscount_model->getDiscountNotApplied($student_session_id);
        foreach ($discounts_array as $discount_key => $discount_value) {
            $discounts_array[$discount_key]->{"amount"} = convertBaseAmountCurrencyFormat($discount_value->amount);
        }
        return $discounts_array;
    }

    public function addfeegrp()
    {
        $staff_record = $this->staff_model->get($this->customlib->getStaffID());
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('row_counter[]', $this->lang->line('fees_list'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('collected_date', $this->lang->line('date'), 'required|trim|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'row_counter'    => form_error('row_counter'),
                'collected_date' => form_error('collected_date'),
            );
            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } else {
            $collected_array = array();
            $staff_record    = $this->staff_model->get($this->customlib->getStaffID());
            $collected_by    = $this->customlib->getAdminSessionUserName() . "(" . $staff_record['employee_id'] . ")";

            $send_to            = $this->input->post('guardian_phone');
            $email              = $this->input->post('guardian_email');
            $parent_app_key     = $this->input->post('parent_app_key');
            $student_session_id = $this->input->post('student_session_id');
            $student = $this->student_model->getByStudentSession($student_session_id);
            $total_row          = $this->input->post('row_counter');
            foreach ($total_row as $total_row_key => $total_row_value) {

                $fee_category             = $this->input->post('fee_category_' . $total_row_value);
                $student_transport_fee_id = $this->input->post('trans_fee_id_' . $total_row_value);

                $json_array = array(
                    'amount'          => $this->input->post('fee_amount_' . $total_row_value),
                    'date'            => date('Y-m-d', $this->customlib->datetostrtotime($this->input->post('collected_date'))),
                    'description'     => $this->input->post('fee_gupcollected_note'),
                    'amount_discount' => 0,
                    'collected_by'    => $collected_by,
                    'amount_fine'     => $this->input->post('fee_groups_feetype_fine_amount_' . $total_row_value),
                    'payment_mode'    => $this->input->post('payment_mode_fee'),
                    'received_by'     => $staff_record['id'],
                );
                $collected_array[] = array(
                    'fee_category'             => $fee_category,
                    'student_transport_fee_id' => $student_transport_fee_id,
                    'student_fees_master_id'   => $this->input->post('student_fees_master_id_' . $total_row_value),
                    'fee_groups_feetype_id'    => $this->input->post('fee_groups_feetype_id_' . $total_row_value),
                    'amount_detail'            => $json_array,
                );
            }

            $deposited_fees = $this->studentfeemaster_model->fee_deposit_collections($collected_array);

            if ($deposited_fees && is_array($deposited_fees)) {
                foreach ($deposited_fees as $deposited_fees_key => $deposited_fees_value) {
                    $fee_category = $deposited_fees_value['fee_category'];
                    $invoice[]   = array(
                        'invoice_id'     => $deposited_fees_value['invoice_id'],
                        'sub_invoice_id' => $deposited_fees_value['sub_invoice_id'],
                        'fee_category' => $fee_category,
                    );


                    if ($deposited_fees_value['student_transport_fee_id'] != 0 && $deposited_fees_value['fee_category'] == "transport") {

                        $data['student_fees_master_id']   = null;
                        $data['fee_groups_feetype_id']    = null;
                        $data['student_transport_fee_id'] = $deposited_fees_value['student_transport_fee_id'];

                        $mailsms_array     = $this->studenttransportfee_model->getTransportFeeMasterByStudentTransportID($deposited_fees_value['student_transport_fee_id']);
                        $fee_group_name[]  = $this->lang->line("transport_fees");
                        $type[]            = $mailsms_array->month;
                        $code[]            = "-";
                        $fine_type[]       = $mailsms_array->fine_type;
                        $due_date[]        = $mailsms_array->due_date;
                        $fine_percentage[] = $mailsms_array->fine_percentage;
                        $fine_amount[]     = amountFormat($mailsms_array->fine_amount);
                        $amount[]          = amountFormat($mailsms_array->amount);
                    } else {

                        $mailsms_array = $this->feegrouptype_model->getFeeGroupByIDAndStudentSessionID($deposited_fees_value['fee_groups_feetype_id'], $student_session_id);

                        $fee_group_name[]  = $mailsms_array->fee_group_name;
                        $type[]            = $mailsms_array->type;
                        $code[]            = $mailsms_array->code;
                        $fine_type[]       = $mailsms_array->fine_type;
                        $due_date[]        = $mailsms_array->due_date;
                        $fine_percentage[] = $mailsms_array->fine_percentage;
                        $fine_amount[]     = amountFormat($mailsms_array->fine_amount);

                        if ($mailsms_array->is_system) {
                            $amount[] = amountFormat($mailsms_array->balance_fee_master_amount);
                        } else {
                            $amount[] = amountFormat($mailsms_array->amount);
                        }
                    }
                }
                $obj_mail                     = [];
                $obj_mail['student_id']  = $student['id'];
                $obj_mail['student_session_id'] = $student_session_id;

                $obj_mail['invoice']         = $invoice;
                $obj_mail['contact_no']      = $student['guardian_phone'];
                $obj_mail['email']           = $student['email'];
                $obj_mail['parent_app_key']  = $student['parent_app_key'];
                $obj_mail['amount']          = "(" . implode(',', $amount) . ")";
                $obj_mail['fine_type']       = "(" . implode(',', $fine_type) . ")";
                $obj_mail['due_date']        = "(" . implode(',', $due_date) . ")";
                $obj_mail['fine_percentage'] = "(" . implode(',', $fine_percentage) . ")";
                $obj_mail['fine_amount']     = "(" . implode(',', $fine_amount) . ")";
                $obj_mail['fee_group_name']  = "(" . implode(',', $fee_group_name) . ")";
                $obj_mail['type']            = "(" . implode(',', $type) . ")";
                $obj_mail['code']            = "(" . implode(',', $code) . ")";
                $obj_mail['fee_category']    = $fee_category;
                $obj_mail['send_type']    = 'group';


                $this->mailsmsconf->mailsms('fee_submission', $obj_mail);
            }


            $array = array('status' => 1, 'error' => '');
            echo json_encode($array);
        }
    }

    public function add_new_student($student)
    {
        $new_student = array(
            'id'                 => $student['id'],
            'student_session_id' => $student['student_session_id'],
            'class'              => $student['class'],
            'section_id'         => $student['section_id'],
            'section'            => $student['section'],
            'admission_no'       => $student['admission_no'],
            'roll_no'            => $student['roll_no'],
            'admission_date'     => $student['admission_date'],
            'firstname'          => $student['firstname'],
            'middlename'         => $student['middlename'],
            'lastname'           => $student['lastname'],
            'image'              => $student['image'],
            'mobileno'           => $student['mobileno'],
            'email'              => $student['email'],
            'state'              => $student['state'],
            'city'               => $student['city'],
            'pincode'            => $student['pincode'],
            'religion'           => $student['religion'],
            'dob'                => $student['dob'],
            'current_address'    => $student['current_address'],
            'permanent_address'  => $student['permanent_address'],
            'category_id'        => $student['category_id'],
            'category'           => $student['category'],
            'adhar_no'           => $student['adhar_no'],
            'samagra_id'         => $student['samagra_id'],
            'bank_account_no'    => $student['bank_account_no'],
            'bank_name'          => $student['bank_name'],
            'ifsc_code'          => $student['ifsc_code'],
            'guardian_name'      => $student['guardian_name'],
            'guardian_relation'  => $student['guardian_relation'],
            'guardian_phone'     => $student['guardian_phone'],
            'guardian_address'   => $student['guardian_address'],
            'is_active'          => $student['is_active'],
            'father_name'        => $student['father_name'],
            'rte'                => $student['rte'],
            'gender'             => $student['gender'],

        );
        return $new_student;
    }

    /**
     * Secure receipt printing with authentication
     */
    public function print_receipt($student_session_id = null, $student_fees_master_id = null)
    {
        // Check authentication and permissions
        if (!$this->rbac->hasPrivilege('collect_fees', 'can_view')) {
            access_denied();
        }

        // Allow transport fees with student_fees_master_id = 0
        if (!$student_session_id || (!$student_fees_master_id && $student_fees_master_id !== '0')) {
            show_error('Invalid receipt parameters!', 400);
        }

        // Get parameters from GET request
        $template_code = $this->input->get('template_code') ?: 'default_receipt';
        $fee_group = $this->input->get('fee_group') ?: 'Fee Payment';
        $paid_amount = $this->input->get('paid_amount') ?: '0.00';
        $fee_code = $this->input->get('fee_code') ?: '';
        $discount_amount = $this->input->get('discount_amount') ?: '0.00';
        $fine_amount = $this->input->get('fine_amount') ?: '0.00';
        $balance_amount = $this->input->get('balance_amount') ?: '0.00';
        $fee_type = $this->input->get('fee_type') ?: 'Regular Fee';
        $due_date = $this->input->get('due_date') ?: date('d-m-Y');

        // Check if this is transport fee receipt (student_fees_master_id = 0)
        if ($student_fees_master_id == '0' || $student_fees_master_id == 0) {
            // Handle transport fee receipt
            $this->print_transport_fee_receipt($student_session_id, $template_code, $fee_group, $paid_amount, $fee_code);
            return;
        }

        // Get student data using direct database query
        $this->db->select('students.*, student_session.class_id, student_session.section_id, classes.class, sections.section');
        $this->db->from('student_session');
        $this->db->join('students', 'students.id = student_session.student_id');
        $this->db->join('classes', 'classes.id = student_session.class_id');
        $this->db->join('sections', 'sections.id = student_session.section_id');
        $this->db->where('student_session.id', $student_session_id);
        $query = $this->db->get();
        $student_data = $query->row();
        
        if (!$student_data) {
            show_error('Student not found!', 404);
        }

        // Get receipt template from admin panel
        $template = $this->simple_receipt_model->get_template_by_code($template_code);
        
        if (!$template || !$template->is_active) {
            // Fallback to default template
            $template = (object) array(
                'template_name' => 'Default Receipt Template',
                'template_code' => 'default_receipt',
                'template_content' => $this->get_default_template()
            );
        }

        // Calculate amounts
        $fee_amount_num = floatval($paid_amount);
        $discount_num = floatval($discount_amount);
        $fine_num = floatval($fine_amount);
        $balance_num = floatval($balance_amount);
        $net_amount = $fee_amount_num - $discount_num + $fine_num;
        $payment_status = ($balance_num <= 0) ? 'Paid' : (($fee_amount_num > 0) ? 'Partial' : 'Unpaid');

        // Prepare receipt data
        $receipt_data = array(
            'school_name' => $this->sch_setting_detail->name ?: 'Digital School',
            'school_address' => $this->sch_setting_detail->address ?: '123 School Street, City, State',
            'school_phone' => $this->sch_setting_detail->phone ?: '+91 9876543210',
            'school_email' => $this->sch_setting_detail->email ?: 'info@digitalschool.com',
            'student_name' => $student_data->firstname . ' ' . $student_data->lastname,
            'admission_no' => $student_data->admission_no,
            'class_name' => $student_data->class . ' (' . $student_data->section . ')',
            'fee_group' => $fee_group,
            'fee_code' => $fee_code,
            'fee_type' => $fee_type,
            'due_date' => $due_date,
            'fee_amount' => '₹' . number_format($fee_amount_num, 2),
            'discount_amount' => '₹' . number_format($discount_num, 2),
            'fine_amount' => '₹' . number_format($fine_num, 2),
            'paid_amount' => '₹' . number_format($fee_amount_num, 2),
            'balance_amount' => '₹' . number_format($balance_num, 2),
            'net_amount' => '₹' . number_format($net_amount, 2),
            'payment_status' => $payment_status,
            'payment_date' => date('d-m-Y'),
            'payment_mode' => 'Cash',
            'invoice_id' => 'INV' . date('Ymd') . '/' . $student_fees_master_id,
            'receipt_no' => 'RCP' . date('Ymd') . '/' . $student_fees_master_id,
            
            // Individual fee group variables (for single group)
            'fee_group_name_1' => $fee_group,
            'fee_amount_1' => '₹' . number_format($fee_amount_num, 2),
            'discount_amount_1' => '₹' . number_format($discount_num, 2),
            'fine_amount_1' => '₹' . number_format($fine_num, 2),
            'paid_amount_1' => '₹' . number_format($fee_amount_num, 2),
            'balance_1' => '₹' . number_format($balance_num, 2),
            'net_amount_1' => '₹' . number_format($net_amount, 2),
            'payment_status_1' => $payment_status,
            'fee_type_1' => $fee_type,
            'fee_code_1' => $fee_code,
            'due_date_1' => $due_date,
            
            // Empty slots for groups 2-15
            'fee_group_name_2' => '',
            'fee_amount_2' => '',
            'discount_amount_2' => '',
            'fine_amount_2' => '',
            'paid_amount_2' => '',
            'balance_2' => '',
            'net_amount_2' => '',
            'payment_status_2' => '',
            'fee_type_2' => '',
            'fee_code_2' => '',
            'due_date_2' => '',
            
            'fee_group_name_3' => '',
            'fee_amount_3' => '',
            'discount_amount_3' => '',
            'fine_amount_3' => '',
            'paid_amount_3' => '',
            'balance_3' => '',
            'net_amount_3' => '',
            'payment_status_3' => '',
            'fee_type_3' => '',
            'fee_code_3' => '',
            'due_date_3' => ''
        );
        
        // Add empty slots for groups 4-15
        for ($i = 4; $i <= 15; $i++) {
            $receipt_data["fee_group_name_$i"] = '';
            $receipt_data["fee_amount_$i"] = '';
            $receipt_data["discount_amount_$i"] = '';
            $receipt_data["fine_amount_$i"] = '';
            $receipt_data["paid_amount_$i"] = '';
            $receipt_data["balance_$i"] = '';
            $receipt_data["net_amount_$i"] = '';
            $receipt_data["payment_status_$i"] = '';
            $receipt_data["fee_type_$i"] = '';
            $receipt_data["fee_code_$i"] = '';
            $receipt_data["due_date_$i"] = '';
        }
        
        // Add total variables
        $receipt_data = array_merge($receipt_data, array(
            // Total variables
            'total_fee_amount' => '₹' . number_format($fee_amount_num, 2),
            'total_discount_amount' => '₹' . number_format($discount_num, 2),
            'total_fine_amount' => '₹' . number_format($fine_num, 2),
            'total_paid_amount' => '₹' . number_format($fee_amount_num, 2),
            'total_balance' => '₹' . number_format($balance_num, 2),
            'grand_total' => '₹' . number_format($fee_amount_num, 2),
            
            // Fee groups table (single row for single receipt)
            'fee_groups_table' => '<tr>
                <td style="padding: 8px; border: 1px solid #ddd; text-align: center;">1</td>
                <td style="padding: 8px; border: 1px solid #ddd;">' . htmlspecialchars($fee_group) . '</td>
                <td style="padding: 8px; border: 1px solid #ddd; text-align: right;">₹' . number_format($fee_amount_num, 2) . '</td>
                <td style="padding: 8px; border: 1px solid #ddd; text-align: right;">₹' . number_format($discount_num, 2) . '</td>
                <td style="padding: 8px; border: 1px solid #ddd; text-align: right;">₹' . number_format($fine_num, 2) . '</td>
                <td style="padding: 8px; border: 1px solid #ddd; text-align: right;">₹' . number_format($fee_amount_num, 2) . '</td>
                <td style="padding: 8px; border: 1px solid #ddd; text-align: right;">₹' . number_format($balance_num, 2) . '</td>
                <td style="padding: 8px; border: 1px solid #ddd; text-align: center;"><span style="color: ' . ($payment_status == 'Paid' ? '#4CAF50' : ($payment_status == 'Partial' ? '#FF9800' : '#F44336')) . '; font-weight: bold;">' . $payment_status . '</span></td>
            </tr>'
        ));

        // Render template with data
        $receipt_html = $template->template_content;
        foreach ($receipt_data as $key => $value) {
            $receipt_html = str_replace('{{' . $key . '}}', $value, $receipt_html);
        }

        // Load receipt view
        $data = array(
            'receipt_html' => $receipt_html,
            'template' => $template,
            'student_data' => $student_data,
            'receipt_data' => $receipt_data
        );

        $this->load->view('receipt/print_receipt', $data);
    }

    /**
     * Multi-group receipt printing with authentication
     */
    public function print_multi_group_receipt($student_session_id = null)
    {
        // Enable error reporting for debugging
        error_reporting(E_ALL);
        ini_set('display_errors', 1);
        
        try {
            // Check authentication and permissions
            if (!$this->rbac->hasPrivilege('collect_fees', 'can_view')) {
                access_denied();
            }

            if (!$student_session_id) {
                show_error('Invalid receipt parameters!', 400);
            }
        } catch (Exception $e) {
            echo "Authentication Error: " . $e->getMessage();
            exit;
        }

        // Get parameters from GET request
        $template_code = $this->input->get('template_code') ?: 'default_receipt';
        $fee_groups = $this->input->get('fee_groups') ?: '';
        
        // Debug: Log received parameters
        error_log("DEBUG: Received template_code: '$template_code'");
        error_log("DEBUG: Received fee_groups: '$fee_groups'");

        // Get fee groups data from GET parameter
        $fee_groups_json = $this->input->get('fee_groups') ?: '[]';
        $fee_groups_data = json_decode($fee_groups_json, true);
        
        if (!is_array($fee_groups_data)) {
            $fee_groups_data = array();
        }
        
        // Debug: Log the fee groups data to check discount field
        error_log("DEBUG: Fee groups JSON: " . $fee_groups_json);
        error_log("DEBUG: Fee groups data: " . print_r($fee_groups_data, true));

        // Calculate total amount from fee groups data
        $total_amount = 0;
        foreach ($fee_groups_data as $group) {
            if (isset($group['amount'])) {
                $total_amount += floatval($group['amount']);
            }
        }

        // Try to get student data using multiple methods
        $student_data = null;
        
        // Method 1: Try the model method
        try {
            $student_data = $this->student_model->getByStudentSession($student_session_id, $this->current_session);
        } catch (Exception $e) {
            // Model method failed, continue to next method
        }
        
        // Method 2: Direct database query with proper joins
        if (!$student_data) {
            $query = $this->db->select('students.*, classes.class, sections.section')
                             ->from('students')
                             ->join('student_session', 'student_session.student_id = students.id')
                             ->join('classes', 'classes.id = student_session.class_id', 'left')
                             ->join('sections', 'sections.id = student_session.section_id', 'left')
                             ->where('student_session.id', $student_session_id)
                             ->where('student_session.session_id', $this->current_session)
                             ->get();
            
            if ($query && $query->num_rows() > 0) {
                $student_data = $query->row();
            }
        }
        
        // Method 3: Final fallback - try to get student data directly from student_session table
        if (!$student_data) {
            $query = $this->db->select('students.*, classes.class, sections.section, student_session.id as session_id')
                             ->from('student_session')
                             ->join('students', 'students.id = student_session.student_id')
                             ->join('classes', 'classes.id = student_session.class_id', 'left')
                             ->join('sections', 'sections.id = student_session.section_id', 'left')
                             ->where('student_session.id', $student_session_id)
                             ->get();
            
            if ($query && $query->num_rows() > 0) {
                $student_data = $query->row();
            }
        }
        
        // Add default class/section if missing - handle both object and array cases
        if ($student_data) {
            if (is_object($student_data)) {
                if (!isset($student_data->class)) $student_data->class = 'Unknown Class';
                if (!isset($student_data->section)) $student_data->section = 'Unknown Section';
            } elseif (is_array($student_data)) {
                if (!isset($student_data['class'])) $student_data['class'] = 'Unknown Class';
                if (!isset($student_data['section'])) $student_data['section'] = 'Unknown Section';
                // Convert array to object for consistency
                $student_data = (object) $student_data;
            }
        }
        
        // Final fallback - only if absolutely no data found
        if (!$student_data) {
            echo json_encode(array(
                'status' => 'error',
                'message' => 'Student data not found for ID: ' . $student_session_id
            ));
            return;
        }
        
        // Debug: Log what student data we found
        error_log("DEBUG: Student session ID received: " . $student_session_id);
        error_log("DEBUG: Current session: " . $this->current_session);
        error_log("DEBUG: Student data found: " . print_r($student_data, true));
        
        // Additional debug: Check if we have fee_groups_data
        error_log("DEBUG: Fee groups data: " . print_r($fee_groups_data, true));

        // Get receipt template with error handling
        $template = null;
        try {
            if (isset($this->simple_receipt_model)) {
                $template = $this->simple_receipt_model->get_template_by_code($template_code);
                error_log("DEBUG: Template retrieved for code '$template_code': " . print_r($template, true));
            } else {
                error_log("DEBUG: simple_receipt_model not loaded");
            }
        } catch (Exception $e) {
            error_log("DEBUG: Template retrieval error: " . $e->getMessage());
        }
        
        if (!$template) {
            // Fallback to default template
            $template = (object) array(
                'template_name' => 'Default Multi-Group Receipt Template',
                'template_code' => 'default_multi_receipt',
                'template_content' => $this->get_multi_group_default_template()
            );
        }

        // Get school settings safely
        $school_name = 'Digital School';
        $school_address = 'Badashapu Gurugram Haryana';
        $school_phone = '911169261568';
        $school_email = 'ProDigitalschool@singinn.in';
        
        try {
            if (isset($this->sch_setting_detail)) {
                $school_name = $this->sch_setting_detail->name ?: $school_name;
                $school_address = $this->sch_setting_detail->address ?: $school_address;
                $school_phone = $this->sch_setting_detail->phone ?: $school_phone;
                $school_email = $this->sch_setting_detail->email ?: $school_email;
            }
        } catch (Exception $e) {
            // Use fallback values
        }

        // Debug: Log the student name construction
        $firstname = isset($student_data->firstname) ? $student_data->firstname : '';
        $lastname = isset($student_data->lastname) ? $student_data->lastname : '';
        $full_name = trim($firstname . ' ' . $lastname);
        
        error_log("DEBUG: Student name parts - firstname: '$firstname', lastname: '$lastname', full_name: '$full_name'");
        
        // Prepare receipt data with all template variables (with null safety)
        $receipt_data = array(
            // School Information
            'school_name' => $school_name,
            'school_address' => $school_address,
            'school_phone' => $school_phone,
            'school_email' => $school_email,
            
            // Student Basic Information
            'student_name' => $full_name,
            'firstname' => isset($student_data->firstname) ? $student_data->firstname : 'N/A',
            'lastname' => isset($student_data->lastname) ? $student_data->lastname : 'N/A',
            'admission_no' => isset($student_data->admission_no) ? $student_data->admission_no : 'N/A',
            'roll_no' => isset($student_data->roll_no) ? $student_data->roll_no : 'N/A',
            'class_name' => (isset($student_data->class) ? $student_data->class : 'Unknown') . ' (' . (isset($student_data->section) ? $student_data->section : 'N/A') . ')',
            'class' => isset($student_data->class) ? $student_data->class : 'N/A',
            'section' => isset($student_data->section) ? $student_data->section : 'N/A',
            'student_image' => isset($student_data->image) && !empty($student_data->image) ? base_url() . 'uploads/student_images/' . $student_data->image : '',
            'student_photo_url' => isset($student_data->image) && !empty($student_data->image) ? base_url() . 'uploads/student_images/' . $student_data->image : '',
            
            // Parent Information
            'father_name' => isset($student_data->father_name) ? $student_data->father_name : 'N/A',
            'mother_name' => isset($student_data->mother_name) ? $student_data->mother_name : 'N/A',
            'guardian_name' => isset($student_data->guardian_name) ? $student_data->guardian_name : 'N/A',
            
            // Contact Information
            'mobile_no' => isset($student_data->mobileno) ? $student_data->mobileno : 'N/A',
            'father_phone' => isset($student_data->father_phone) ? $student_data->father_phone : 'N/A',
            'mother_phone' => isset($student_data->mother_phone) ? $student_data->mother_phone : 'N/A',
            'guardian_phone' => isset($student_data->guardian_phone) ? $student_data->guardian_phone : 'N/A',
            'email' => isset($student_data->email) ? $student_data->email : 'N/A',
            
            // Address Information
            'current_address' => isset($student_data->current_address) ? $student_data->current_address : 'N/A',
            'permanent_address' => isset($student_data->permanent_address) ? $student_data->permanent_address : 'N/A',
            
            // Fee Information
            'fee_group' => 'Multi-Group Payment',
            'fee_amount' => '₹' . number_format($total_amount, 2),
            'total_amount' => '₹' . number_format($total_amount, 2),
            'total_amount_words' => 'Rupees ' . number_format($total_amount, 2) . ' Only',
            'discount_amount' => '₹0.00', // Will be calculated from fee groups
            'amount_discount' => '₹0.00', // Will be calculated from fee groups
            'amount_fine' => '₹0.00', // Will be calculated from fee groups
            
            // Payment Status Information
            'payment_status' => 'PAID',
            'payment_status_text' => 'Paid',
            'payment_status_badge' => '<span class="badge badge-success">PAID</span>',
            'is_paid' => 'Yes',
            'is_unpaid' => 'No',
            'status_color' => '#28a745', // Green for paid
            'status_background' => 'background-color: #d4edda; color: #155724; padding: 5px 10px; border-radius: 4px;',
            
            // Payment Information
            'payment_date' => date('d-m-Y'),
            'payment_time' => date('H:i:s'),
            'payment_mode' => 'Cash',
            'collected_by' => isset($this->session->userdata['admin']['username']) ? $this->session->userdata['admin']['username'] : 'Admin',
            
            // Receipt Information
            'invoice_id' => 'INV' . date('Ymd') . '/' . $student_session_id,
            'receipt_no' => 'RCP' . date('Ymd') . '/' . $student_session_id,
            'receipt_date' => date('d-m-Y'),
            'academic_year' => isset($this->current_session) ? $this->current_session : date('Y'),
            
            // Additional Information
            'total_groups' => count($fee_groups_data),
            'currency_symbol' => '₹',
            'date_format' => date('d/m/Y'),
            'current_date' => date('d-m-Y'),
            'current_time' => date('H:i A')
        );

        // Generate fee groups table and populate individual variables (with null safety)
        $fee_groups_html = '';
        $sr_no = 1;
        $total_discount = 0;
        $total_fine = 0;
        $total_paid = 0;
        $total_balance = 0;
        
        foreach ($fee_groups_data as $index => $group) {
            // Extract individual group data
            $group_name = isset($group['fee_group']) ? $group['fee_group'] : 'N/A';
            $fee_code = isset($group['fee_code']) ? $group['fee_code'] : 'N/A';
            $fee_type = isset($group['fee_type']) ? $group['fee_type'] : 'N/A';
            $amount = isset($group['amount']) ? floatval($group['amount']) : 0;
            $discount = isset($group['discount']) ? floatval($group['discount']) : 0;
            $fine = isset($group['fine']) ? floatval($group['fine']) : 0;
            $paid = isset($group['paid']) ? floatval($group['paid']) : $amount;
            $balance = isset($group['balance']) ? floatval($group['balance']) : 0;
            $net_amount = $amount - $discount + $fine;
            $status = ($balance <= 0) ? 'Paid' : (($paid > 0) ? 'Partial' : 'Unpaid');
            $due_date = isset($group['due_date']) ? $group['due_date'] : date('d-m-Y');
            
            // Add to totals
            $total_discount += $discount;
            $total_fine += $fine;
            $total_paid += $paid;
            $total_balance += $balance;
            
            // Populate individual fee group variables (1-based indexing)
            $group_num = $index + 1;
            if ($group_num <= 15) { // Support up to 15 groups for Payment History Table (15 Groups)
                $receipt_data["fee_group_name_$group_num"] = $group_name;
                $receipt_data["fee_amount_$group_num"] = '₹' . number_format($amount, 2);
                $receipt_data["discount_amount_$group_num"] = '₹' . number_format($discount, 2);
                $receipt_data["fine_amount_$group_num"] = '₹' . number_format($fine, 2);
                $receipt_data["paid_amount_$group_num"] = '₹' . number_format($paid, 2);
                $receipt_data["balance_$group_num"] = '₹' . number_format($balance, 2);
                $receipt_data["net_amount_$group_num"] = '₹' . number_format($net_amount, 2);
                $receipt_data["payment_status_$group_num"] = $status;
                $receipt_data["fee_type_$group_num"] = $fee_type;
                $receipt_data["fee_code_$group_num"] = $fee_code;
                $receipt_data["due_date_$group_num"] = $due_date;
            }
            
            // Generate enhanced table row with dynamic columns support
            $row_style = ($index % 2 == 0) ? 'background: #f8f9fa;' : '';
            $status_color = ($status == 'Paid') ? '#4CAF50' : (($status == 'Partial') ? '#FF9800' : '#F44336');
            
            $fee_groups_html .= '<tr style="' . $row_style . '">';
            $fee_groups_html .= '<td style="padding: 12px 8px; border: 1px solid #ddd; text-align: center; font-weight: 500;">' . ($index + 1) . '</td>';
            $fee_groups_html .= '<td style="padding: 12px 8px; border: 1px solid #ddd;">
                <div style="font-weight: 600; color: #495057;">' . htmlspecialchars($group_name) . '</div>
                <small style="color: #6c757d; font-size: 11px;">' . htmlspecialchars($fee_code) . ' | ' . htmlspecialchars($fee_type) . '</small>
            </td>';
            $fee_groups_html .= '<td style="padding: 12px 8px; border: 1px solid #ddd; text-align: right; font-weight: 500;">₹' . number_format($amount, 2) . '</td>';
            $fee_groups_html .= '<td style="padding: 12px 8px; border: 1px solid #ddd; text-align: right; color: #28a745; font-weight: 500;">₹' . number_format($discount, 2) . '</td>';
            $fee_groups_html .= '<td style="padding: 12px 8px; border: 1px solid #ddd; text-align: right; color: #dc3545; font-weight: 500;">₹' . number_format($fine, 2) . '</td>';
            $fee_groups_html .= '<td style="padding: 12px 8px; border: 1px solid #ddd; text-align: right; font-weight: 500;">₹' . number_format($paid, 2) . '</td>';
            $fee_groups_html .= '<td style="padding: 12px 8px; border: 1px solid #ddd; text-align: right; font-weight: 500;">₹' . number_format($balance, 2) . '</td>';
            $fee_groups_html .= '<td style="padding: 12px 8px; border: 1px solid #ddd; text-align: center;">
                <span style="background: ' . $status_color . '; color: white; padding: 4px 8px; border-radius: 12px; font-size: 11px; font-weight: 600;">' . $status . '</span>
            </td>';
            
            // Add additional dynamic columns if specified
            $additional_columns = $this->input->get('additional_columns') ? explode(',', $this->input->get('additional_columns')) : [];
            foreach ($additional_columns as $col_name) {
                $col_value = isset($group[trim($col_name)]) ? $group[trim($col_name)] : '-';
                $fee_groups_html .= '<td style="padding: 12px 8px; border: 1px solid #ddd; text-align: center;">' . htmlspecialchars($col_value) . '</td>';
            }
            
            $fee_groups_html .= '</tr>';
            $sr_no++;
        }
        
        // Fill remaining empty slots (if less than 15 groups)
        for ($i = count($fee_groups_data) + 1; $i <= 15; $i++) {
            $receipt_data["fee_group_name_$i"] = '';
            $receipt_data["fee_amount_$i"] = '';
            $receipt_data["discount_amount_$i"] = '';
            $receipt_data["fine_amount_$i"] = '';
            $receipt_data["paid_amount_$i"] = '';
            $receipt_data["balance_$i"] = '';
            $receipt_data["net_amount_$i"] = '';
            $receipt_data["payment_status_$i"] = '';
            $receipt_data["fee_type_$i"] = '';
            $receipt_data["fee_code_$i"] = '';
            $receipt_data["due_date_$i"] = '';
        }
        
        // Add total variables
        $receipt_data['total_fee_amount'] = '₹' . number_format($total_amount, 2);
        $receipt_data['total_discount_amount'] = '₹' . number_format($total_discount, 2);
        $receipt_data['total_fine_amount'] = '₹' . number_format($total_fine, 2);
        $receipt_data['total_paid_amount'] = '₹' . number_format($total_paid, 2);
        $receipt_data['total_balance'] = '₹' . number_format($total_balance, 2);
        $receipt_data['grand_total'] = '₹' . number_format($total_paid, 2);
        
        // Update main discount amount variable
        $receipt_data['discount_amount'] = '₹' . number_format($total_discount, 2);
        $receipt_data['amount_discount'] = '₹' . number_format($total_discount, 2);
        $receipt_data['amount_fine'] = '₹' . number_format($total_fine, 2);

        $receipt_data['fee_groups_table'] = $fee_groups_html;

        // Render template with data
        $receipt_html = $template->template_content;
        foreach ($receipt_data as $key => $value) {
            $receipt_html = str_replace('{{' . $key . '}}', $value, $receipt_html);
        }
        
        // Clean up any remaining unreplaced placeholders
        $receipt_html = preg_replace('/\{\{[^}]+\}\}/', '', $receipt_html);

        // Load receipt view
        $data = array(
            'receipt_html' => $receipt_html,
            'template' => $template,
            'student_data' => $student_data,
            'receipt_data' => $receipt_data
        );

        $this->load->view('receipt/print_receipt', $data);
    }

    /**
     * Get multi-group default template content
     */
    private function get_multi_group_default_template()
    {
        return '
        <div style="text-align: center; border: 2px solid #333; padding: 30px; font-family: Arial, sans-serif;">
            <h2 style="margin: 0; color: #333;">{{school_name}}</h2>
            <p style="margin: 5px 0; color: #666;">{{school_address}}</p>
            <p style="margin: 5px 0; color: #666;">Phone: {{school_phone}} | Email: {{school_email}}</p>
            
            <hr style="border: 1px solid #333; margin: 20px 0;">
            
            <h3 style="margin: 15px 0; color: #333;">MULTI-GROUP FEE RECEIPT</h3>
            
            <div style="text-align: left; margin: 20px 0;">
                <table style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
                    <tr>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;"><strong>Receipt No:</strong></td>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;">{{receipt_no}}</td>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;"><strong>Date:</strong></td>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;">{{payment_date}}</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;"><strong>Student Name:</strong></td>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;">{{student_name}}</td>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;"><strong>Admission No:</strong></td>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;">{{admission_no}}</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;"><strong>Class:</strong></td>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;">{{class_name}}</td>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;"><strong>Payment Mode:</strong></td>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;">{{payment_mode}}</td>
                    </tr>
                </table>

                <h4 style="margin: 20px 0 10px 0; color: #333;">Fee Details:</h4>
                <table style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
                    <thead>
                        <tr style="background: #f8f9fa;">
                            <th style="padding: 8px; border: 1px solid #ddd; text-align: center;">Sr. No.</th>
                            <th style="padding: 8px; border: 1px solid #ddd; text-align: left;">Fee Group</th>
                            <th style="padding: 8px; border: 1px solid #ddd; text-align: right;">Amount</th>
                            <th style="padding: 8px; border: 1px solid #ddd; text-align: right;">Discount</th>
                            <th style="padding: 8px; border: 1px solid #ddd; text-align: right;">Fine</th>
                            <th style="padding: 8px; border: 1px solid #ddd; text-align: right;">Paid</th>
                            <th style="padding: 8px; border: 1px solid #ddd; text-align: right;">Balance</th>
                            <th style="padding: 8px; border: 1px solid #ddd; text-align: center;">Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        {{fee_groups_table}}
                        <tr style="background: #e8f5e8; font-weight: bold;">
                            <td colspan="2" style="padding: 8px; border: 1px solid #ddd; text-align: right;"><strong>TOTAL:</strong></td>
                            <td style="padding: 8px; border: 1px solid #ddd; text-align: right; font-weight: bold;">{{total_fee_amount}}</td>
                            <td style="padding: 8px; border: 1px solid #ddd; text-align: right; font-weight: bold;">{{total_discount_amount}}</td>
                            <td style="padding: 8px; border: 1px solid #ddd; text-align: right; font-weight: bold;">{{total_fine_amount}}</td>
                            <td style="padding: 8px; border: 1px solid #ddd; text-align: right; font-weight: bold; color: #4CAF50;">{{total_paid_amount}}</td>
                            <td style="padding: 8px; border: 1px solid #ddd; text-align: right; font-weight: bold;">{{total_balance}}</td>
                            <td style="padding: 8px; border: 1px solid #ddd; text-align: center; font-weight: bold;">-</td>
                        </tr>
                    </tbody>
                </table>
            </div>
            
            <hr style="border: 1px solid #333; margin: 20px 0;">
            
            <p style="margin: 10px 0; font-size: 12px; color: #666;">
                This is a computer generated receipt. No signature required.
            </p>
            
            <div style="margin-top: 30px; text-align: center;">
                <p style="margin: 5px 0; font-size: 12px;">Thank you for your payment!</p>
                <p style="margin: 5px 0; font-size: 10px; color: #999;">Generated on {{payment_date}}</p>
            </div>
        </div>';
    }

    /**
     * Get default template content
     */
    private function get_default_template()
    {
        return '
        <div style="text-align: center; border: 2px solid #333; padding: 30px; font-family: Arial, sans-serif;">
            <h2 style="margin: 0; color: #333;">{{school_name}}</h2>
            <p style="margin: 5px 0; color: #666;">{{school_address}}</p>
            <p style="margin: 5px 0; color: #666;">Phone: {{school_phone}} | Email: {{school_email}}</p>
            
            <hr style="border: 1px solid #333; margin: 20px 0;">
            
            <h3 style="margin: 15px 0; color: #333;">FEE RECEIPT</h3>
            
            <div style="text-align: left; margin: 20px 0;">
                <table style="width: 100%; border-collapse: collapse;">
                    <tr>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;"><strong>Receipt No:</strong></td>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;">{{receipt_no}}</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;"><strong>Student Name:</strong></td>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;">{{student_name}}</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;"><strong>Admission No:</strong></td>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;">{{admission_no}}</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;"><strong>Class:</strong></td>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;">{{class_name}}</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;"><strong>Fee Group:</strong></td>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;">{{fee_group}}</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;"><strong>Amount Paid:</strong></td>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd; color: #4CAF50; font-weight: bold;">{{fee_amount}}</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;"><strong>Payment Date:</strong></td>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;">{{payment_date}}</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;"><strong>Payment Mode:</strong></td>
                        <td style="padding: 8px; border-bottom: 1px solid #ddd;">{{payment_mode}}</td>
                    </tr>
                </table>
            </div>
            
            <hr style="border: 1px solid #333; margin: 20px 0;">
            
            <p style="margin: 10px 0; font-size: 12px; color: #666;">
                This is a computer generated receipt. No signature required.
            </p>
            
            <div style="margin-top: 30px; text-align: center;">
                <p style="margin: 5px 0; font-size: 12px;">Thank you for your payment!</p>
                <p style="margin: 5px 0; font-size: 10px; color: #999;">Generated on {{payment_date}}</p>
            </div>
        </div>';
    }

    /**
     * Create automatic income entry when fee is collected
     */
    private function createAutomaticIncome($inserted_id, $student_session_id, $json_array, $mailsms_array)
    {
        try {
            // Parse the inserted_id to get invoice details
            $receipt_data = json_decode($inserted_id);
            if (!$receipt_data) {
                log_message('error', 'Failed to parse receipt data for automatic income creation');
                return false;
            }

            // Get student details
            $student = $this->studentsession_model->searchStudentsBySession($student_session_id);
            if (!$student) {
                log_message('error', 'Student not found for automatic income creation');
                return false;
            }

            // Prepare fee data for income creation
            $fee_data = array(
                'student_name' => $student['firstname'] . ' ' . $student['lastname'],
                'admission_no' => $student['admission_no'],
                'class' => $student['class'],
                'section' => $student['section'],
                'fee_group' => isset($mailsms_array->fee_group_name) ? $mailsms_array->fee_group_name : 'Fee Collection',
                'date' => $json_array['date'],
                'amount' => $json_array['amount'],
                'payment_mode' => $json_array['payment_mode'],
                'collected_by' => $json_array['collected_by'],
                'invoice_id' => $receipt_data->invoice_id,
                'sub_invoice_id' => $receipt_data->sub_invoice_id
            );

            // Create income entry
            $income_id = $this->income_model->createFeeIncome($fee_data);
            
            if ($income_id) {
                log_message('info', 'Automatic income created successfully with ID: ' . $income_id);
                return $income_id;
            } else {
                log_message('error', 'Failed to create automatic income entry');
                return false;
            }

        } catch (Exception $e) {
            log_message('error', 'Exception in createAutomaticIncome: ' . $e->getMessage());
            return false;
        }
    }

    /**
     * Test method to verify automatic income creation
     * URL: /studentfee/test_income_creation
     */
    public function test_income_creation()
    {
        // Test data
        $test_fee_data = array(
            'student_name' => 'Test Student',
            'admission_no' => 'TEST001',
            'class' => 'Class X',
            'section' => 'A',
            'fee_group' => 'Tuition Fee',
            'date' => date('Y-m-d'),
            'amount' => 1000,
            'payment_mode' => 'Cash',
            'collected_by' => 'Admin (TEST)',
            'invoice_id' => 'TEST_' . time(),
            'sub_invoice_id' => '1'
        );

        // Test income creation
        $income_id = $this->income_model->createFeeIncome($test_fee_data);
        
        if ($income_id) {
            echo "<h2>✅ Success!</h2>";
            echo "<p>Test income entry created successfully with ID: <strong>" . $income_id . "</strong></p>";
            echo "<p>Check the income in: <a href='" . base_url() . "admin/income/incomesearch' target='_blank'>Income Search Page</a></p>";
            echo "<hr>";
            echo "<h3>Test Data Used:</h3>";
            echo "<pre>" . print_r($test_fee_data, true) . "</pre>";
        } else {
            echo "<h2>❌ Failed!</h2>";
            echo "<p>Failed to create test income entry. Check error logs.</p>";
        }
    }

    /**
     * Method to update UPI settings in school settings
     * URL: /studentfee/update_upi_settings
     */
    public function update_upi_settings()
    {
        // Check admin permission
        if (!$this->rbac->hasPrivilege('collect_fees', 'can_edit')) {
            access_denied();
        }

        if ($this->input->post()) {
            $upi_id = $this->input->post('upi_id');
            $upi_name = $this->input->post('upi_name');
            
            // Get current settings
            $current_settings = $this->setting_model->get();
            $setting_id = $current_settings[0]['id'];
            
            // Update data
            $update_data = array(
                'id' => $setting_id,
                'upi_id' => $upi_id,
                'upi_name' => $upi_name
            );
            
            // Update settings
            $result = $this->setting_model->add($update_data);
            
            if ($result) {
                $this->session->set_flashdata('msg', '<div class="alert alert-success">UPI Settings updated successfully!</div>');
            } else {
                $this->session->set_flashdata('msg', '<div class="alert alert-danger">Failed to update UPI settings!</div>');
            }
            
            redirect('studentfee/upi_settings');
        }
    }

    /**
     * UPI Settings page
     * URL: /studentfee/upi_settings
     */
    public function upi_settings()
    {
        // Check admin permission
        if (!$this->rbac->hasPrivilege('collect_fees', 'can_view')) {
            access_denied();
        }

        $data['sch_setting'] = $this->sch_setting_detail;
        $data['title'] = 'UPI Settings';
        
        echo "<h2>UPI Settings</h2>";
        echo "<p><strong>Current UPI ID:</strong> " . (!empty($this->sch_setting_detail->upi_id) ? $this->sch_setting_detail->upi_id : '<em>Not configured</em>') . "</p>";
        echo "<p><strong>Current UPI Name:</strong> " . (!empty($this->sch_setting_detail->upi_name) ? $this->sch_setting_detail->upi_name : '<em>School Fee Payment</em>') . "</p>";
        echo "<hr>";
        echo "<h3>Update UPI Settings</h3>";
        echo "<form method='post' action='" . site_url('studentfee/update_upi_settings') . "'>";
        echo "<p><label>UPI ID: <input type='text' name='upi_id' value='" . (!empty($this->sch_setting_detail->upi_id) ? $this->sch_setting_detail->upi_id : '') . "' placeholder='yourname@upi' required style='width: 300px; padding: 5px;'></label></p>";
        echo "<p><label>UPI Name: <input type='text' name='upi_name' value='" . (!empty($this->sch_setting_detail->upi_name) ? $this->sch_setting_detail->upi_name : 'School Fee Payment') . "' placeholder='School Fee Payment' style='width: 300px; padding: 5px;'></label></p>";
        echo "<p><button type='submit' style='background: #007bff; color: white; padding: 10px 20px; border: none; border-radius: 4px; cursor: pointer;'>Update UPI Settings</button></p>";
        echo "</form>";
        echo "<p><a href='" . base_url('studentfee') . "'>← Back to Fee Collection</a></p>";
    }
}
