<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Simple_receipt_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    // Get all templates
    public function get_all_templates() {
        $this->db->select('*');
        $this->db->from('receipt_templates');
        $this->db->order_by('id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    // Get active templates only
    public function get_active_templates() {
        $this->db->select('*');
        $this->db->from('receipt_templates');
        $this->db->where('is_active', 1);
        $this->db->order_by('id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    // Get template by ID
    public function get_template_by_id($id) {
        $this->db->select('*');
        $this->db->from('receipt_templates');
        $this->db->where('id', $id);
        $query = $this->db->get();
        return $query->row();
    }

    // Get template by code
    public function get_template_by_code($code) {
        $this->db->select('*');
        $this->db->from('receipt_templates');
        $this->db->where('template_code', $code);
        $this->db->where('is_active', 1);
        $query = $this->db->get();
        return $query->row();
    }

    // Create new template
    public function create_template($data) {
        $template_data = array(
            'template_name' => $data['template_name'],
            'template_code' => $data['template_code'],
            'template_content' => $data['template_content'],
            'is_active' => isset($data['is_active']) ? 1 : 0,
            'created_at' => date('Y-m-d H:i:s')
        );

        if ($this->db->insert('receipt_templates', $template_data)) {
            return $this->db->insert_id();
        }
        return false;
    }

    // Update template
    public function update_template($id, $data) {
        // Only update provided fields
        $template_data = array();
        
        if (isset($data['template_name'])) {
            $template_data['template_name'] = $data['template_name'];
        }
        
        if (isset($data['template_code'])) {
            $template_data['template_code'] = $data['template_code'];
        }
        
        if (isset($data['template_content'])) {
            $template_data['template_content'] = $data['template_content'];
        }
        
        if (isset($data['is_active'])) {
            $template_data['is_active'] = $data['is_active'];
        }

        $this->db->where('id', $id);
        return $this->db->update('receipt_templates', $template_data);
    }

    // Delete template
    public function delete_template($id) {
        $this->db->where('id', $id);
        return $this->db->delete('receipt_templates');
    }

    // Check if template code exists
    public function code_exists($code, $exclude_id = null) {
        $this->db->select('id');
        $this->db->from('receipt_templates');
        $this->db->where('template_code', $code);
        
        if ($exclude_id) {
            $this->db->where('id !=', $exclude_id);
        }
        
        $query = $this->db->get();
        return $query->num_rows() > 0;
    }

    // Render template with data
    public function render_template($template_code, $data) {
        $template = $this->get_template_by_code($template_code);
        
        if (!$template) {
            return false;
        }

        $content = $template->template_content;

        // Replace variables with actual data
        foreach ($data as $key => $value) {
            $content = str_replace('{{' . $key . '}}', $value, $content);
        }

        return $content;
    }
}
?>
