<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-gears"></i> <?php echo $this->lang->line('fees') . " " . $this->lang->line('reminder'); ?>
        </h1>
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <!-- left column -->
                <form id="form1" action="<?php echo site_url('admin/feereminder/setting') ?>"  id="feereminder" name="feereminder" method="post" accept-charset="utf-8">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title"> <?php echo $this->lang->line('fees_reminder'); ?></h3>
                        </div>
                        <div class="box-body">
                            <?php if ($this->session->flashdata('msg')) { ?>
                                <?php 
                                    echo $this->session->flashdata('msg');
                                    $this->session->unset_userdata('msg');
                                ?>
                            <?php } ?>
                            <!-- /.box-header -->
                            <!-- Button HTML (to Trigger Modal) -->
                            <div class="row" style="margin-bottom: 20px;">
                                <div class="col-md-12">
                                    <button type="button" class="btn btn-warning btn-sm" id="sendImmediateReminder">
                                        <i class="fa fa-paper-plane"></i> Send Immediate Reminder
                                    </button>
                                </div>
                            </div>
                            <table class="table table-hover ">
                                <thead>
                                    <th><?php echo $this->lang->line('action'); ?></th>
                                    <th><?php echo $this->lang->line('reminder_type'); ?></th>
                                    <th><?php echo $this->lang->line('days'); ?></th>
                                </thead>
                                <tbody>

                                    <?php
                                    $i = 1;
                                    $last_key = count($feereminderlist);
                                    foreach ($feereminderlist as $note_key => $note_value) {

                                        $hr = "";

                                        if ($i != $last_key) {
                                            $hr = "<hr>";
                                        }
                                        ?>

                                        <tr>
                                            <td width="15%">
                                                <label class="checkbox-inline">
                                                    <input type="checkbox" name="isactive_<?php echo $note_value->id; ?>" value="1" <?php echo set_checkbox('isactive_' . $note_value->id, 1, set_value('isactive_' . $note_value->id, $note_value->is_active) ? true : false); ?>> <?php echo $this->lang->line('active'); ?>
                                                </label>
                                            </td>
                                            <td width="15%">
                                                <input type="hidden" name="ids[]" value="<?php echo $note_value->id; ?>">
                                                <?php echo $this->lang->line($note_value->reminder_type); ?>
                                            </td>
                                            <td width="20%">
                                                <input type="number" name="days<?php echo $note_value->id; ?>" value="<?php echo set_value('days' . $note_value->id, $note_value->day) ?>" class="form-control">
                                            </td>
                                        </tr>
                                        <?php
                                        $i++;
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="box-footer">
                            <?php if ($this->rbac->hasPrivilege('fees_reminder', 'can_edit')) {
                                ?>
                                <button type="submit" class="btn btn-info pull-right"><?php echo $this->lang->line('save'); ?></button>
                            <?php }
                            ?>
                            <?php ?>
                        </div>
                    </form>
                </div>
            </div>
        </div><!--./wrapper-->
    </section><!-- /.content -->
</div>

<!-- Modal for Immediate Reminder -->
<div class="modal fade" id="immediateReminderModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-paper-plane"></i> Send Immediate Fee Reminder
                </h4>
            </div>
            <div class="modal-body">
                <div class="alert alert-info">
                    <i class="fa fa-info-circle"></i> 
                    This will send fee reminders to all students with pending fees immediately.
                </div>
                <div id="pendingFeesCount">
                    <i class="fa fa-spinner fa-spin"></i> Loading pending fees count...
                </div>
                <div class="form-group" style="margin-top: 15px;">
                    <label>Reminder Message:</label>
                    <textarea class="form-control" id="reminderMessage" rows="3" placeholder="Enter custom reminder message (optional)">Dear Parent, This is a reminder that your ward {student_name}'s fee payment of Rs.{pending_amount} is pending for class {class}. Please pay at your earliest convenience. Thank you.</textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-warning" id="confirmSendReminder">
                    <i class="fa fa-paper-plane"></i> Send Reminders
                </button>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Handle immediate reminder button click
    $('#sendImmediateReminder').click(function() {
        $('#immediateReminderModal').modal('show');
        loadPendingFeesCount();
    });
    
    // Load pending fees count
    function loadPendingFeesCount() {
        $('#pendingFeesCount').html('<div class="alert alert-info"><i class="fa fa-spinner fa-spin"></i> Loading...</div>');
        
        $.ajax({
            url: '<?php echo site_url("admin/feereminder/get_pending_count"); ?>',
            type: 'GET',
            dataType: 'json',
            timeout: 5000,
            success: function(response) {
                console.log('Response:', response);
                if(response && response.status === 'success') {
                    if(response.count > 0) {
                        $('#pendingFeesCount').html(
                            '<div class="alert alert-warning">' +
                            '<i class="fa fa-exclamation-triangle"></i> ' +
                            '<strong>' + response.count + '</strong> students have pending fees.' +
                            '</div>'
                        );
                        $('#confirmSendReminder').prop('disabled', false);
                    } else {
                        $('#pendingFeesCount').html(
                            '<div class="alert alert-success">' +
                            '<i class="fa fa-check-circle"></i> ' +
                            'No students have pending fees.' +
                            '</div>'
                        );
                        $('#confirmSendReminder').prop('disabled', true);
                    }
                } else {
                    $('#pendingFeesCount').html(
                        '<div class="alert alert-danger">' +
                        '<i class="fa fa-exclamation-circle"></i> ' +
                        'Error: ' + (response ? response.message : 'Invalid response') +
                        '</div>'
                    );
                }
            },
            error: function(xhr, status, error) {
                console.log('AJAX Error:', xhr.responseText);
                $('#pendingFeesCount').html(
                    '<div class="alert alert-danger">' +
                    '<i class="fa fa-exclamation-circle"></i> ' +
                    'Connection error. Please check if the server is running.' +
                    '</div>'
                );
            }
        });
    }
    
    // Handle send reminder confirmation
    $('#confirmSendReminder').click(function() {
        var button = $(this);
        var originalText = button.html();
        
        // Show loading state
        button.html('<i class="fa fa-spinner fa-spin"></i> Sending...').prop('disabled', true);
        
        var customMessage = $('#reminderMessage').val();
        
        $.ajax({
            url: '<?php echo site_url("admin/feereminder/send_immediate"); ?>',
            type: 'POST',
            dataType: 'json',
            data: {
                custom_message: customMessage
            },
            success: function(response) {
                button.html(originalText).prop('disabled', false);
                $('#immediateReminderModal').modal('hide');
                
                if(response.status === 'success') {
                    // Show detailed Hindi message
                    alert(response.message + '\n\nविवरण: ' + response.details);
                } else {
                    alert(response.message || 'Error sending reminders');
                }
            },
            error: function() {
                button.html(originalText).prop('disabled', false);
                alert('Error sending reminders. Please try again.');
            }
        });
    });
});
</script>