<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-plus"></i> Create Receipt Template
            <small>Create new receipt template</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/simple_receipt">Receipt Templates</a></li>
            <li class="active">Create</li>
        </ol>
    </section>

    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <?php if ($this->session->flashdata('msg')) { ?>
                    <?php echo $this->session->flashdata('msg'); ?>
                <?php } ?>

                <?php echo form_open('admin/simple_receipt/create', array('class' => 'form-horizontal')); ?>
                
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Template Information</h3>
                    </div>

                    <div class="box-body">
                        <?php if (validation_errors()) { ?>
                            <div class="alert alert-danger">
                                <?php echo validation_errors(); ?>
                            </div>
                        <?php } ?>

                        <div class="form-group">
                            <label for="template_name" class="col-sm-2 control-label">Template Name <span class="text-red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" class="form-control" name="template_name" id="template_name" 
                                       value="<?php echo set_value('template_name'); ?>" placeholder="Enter template name">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="template_code" class="col-sm-2 control-label">Template Code <span class="text-red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" class="form-control" name="template_code" id="template_code" 
                                       value="<?php echo set_value('template_code'); ?>" placeholder="Enter unique template code">
                                <small class="text-muted">Only letters, numbers, underscores and hyphens allowed</small>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="template_content" class="col-sm-2 control-label">Template Content <span class="text-red">*</span></label>
                            <div class="col-sm-10">
                                <!-- Editor Mode Selection -->
                                <div class="editor-mode-selection" style="margin-bottom: 15px;">
                                    <div class="btn-group" role="group">
                                        <button type="button" class="btn btn-primary btn-sm editor-mode-btn active" data-mode="visual">
                                            <i class="fa fa-paint-brush"></i> Visual Editor
                                        </button>
                                        <button type="button" class="btn btn-outline-primary btn-sm editor-mode-btn" data-mode="html">
                                            <i class="fa fa-code"></i> HTML Code Editor
                                        </button>
                                    </div>
                                </div>

                                <!-- Hidden textarea to store template content -->
                                <textarea name="template_content" id="template_content" style="display: none;"><?php echo set_value('template_content'); ?></textarea>
                                
                                <!-- Visual Editor Launch (Default) -->
                                <div id="visual-editor-section" class="template-editor-launch" style="border: 2px dashed #007bff; border-radius: 8px; padding: 40px; text-align: center; background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);">
                                    <div class="launch-content">
                                        <i class="fa fa-paint-brush" style="font-size: 48px; color: #007bff; margin-bottom: 15px;"></i>
                                        <h4 style="color: #333; margin-bottom: 10px;">Visual Template Designer</h4>
                                        <p style="color: #666; margin-bottom: 20px;">Create professional receipt templates with our drag-and-drop editor</p>
                                        <button type="button" id="open-editor-btn" class="btn btn-primary btn-lg" onclick="openEditor()">
                                            <i class="fa fa-edit"></i> Open Visual Editor
                                        </button>
                                        <div style="margin-top: 15px;">
                                            <button type="button" id="load-sample-quick" class="btn btn-outline-info btn-sm" onclick="loadQuickSample()">
                                                <i class="fa fa-magic"></i> Load Sample Template
                                            </button>
                                        </div>
                                    </div>
                                </div>

                                <!-- HTML Code Editor (Hidden by default) -->
                                <div id="html-editor-section" style="display: none;">
                                    <div class="html-editor-header" style="background: #f8f9fa; padding: 10px; border: 1px solid #ddd; border-bottom: none; border-radius: 5px 5px 0 0;">
                                        <div style="display: flex; justify-content: space-between; align-items: center;">
                                            <div>
                                                <strong><i class="fa fa-code text-primary"></i> HTML Template Editor</strong>
                                                <small class="text-muted">- Paste your HTML code below</small>
                                            </div>
                                            <div>
                                                <button type="button" class="btn btn-success btn-xs" onclick="loadTransportTemplate()">
                                                    <i class="fa fa-bus"></i> Load Transport Template
                                                </button>
                                                <button type="button" class="btn btn-info btn-xs" onclick="showVariables()">
                                                    <i class="fa fa-tags"></i> Show Variables
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                    <textarea id="html-code-editor" class="form-control" rows="20" 
                                              style="font-family: 'Courier New', monospace; font-size: 12px; border-radius: 0 0 5px 5px;"
                                              placeholder="Paste your HTML template code here...

Example:
<div style='max-width: 600px; margin: 0 auto; padding: 20px;'>
    <h2>{{school_name}}</h2>
    <p>Student: {{student_name}}</p>
    <p>Amount: {{currency_symbol}}{{paid_amount}}</p>
</div>"></textarea>
                                    
                                    <!-- Variables Help -->
                                    <div id="variables-help" style="display: none; margin-top: 10px; padding: 15px; background: #e8f5e9; border: 1px solid #c8e6c9; border-radius: 5px;">
                                        <h5><i class="fa fa-tags text-success"></i> Available Variables:</h5>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <strong>School Info:</strong><br>
                                                <code>{{school_name}}</code><br>
                                                <code>{{school_address}}</code><br>
                                                <code>{{school_phone}}</code><br>
                                                <code>{{school_email}}</code><br><br>
                                                
                                                <strong>Student Info:</strong><br>
                                                <code>{{student_name}}</code><br>
                                                <code>{{admission_no}}</code><br>
                                                <code>{{class_section}}</code><br>
                                                <code>{{father_name}}</code><br>
                                            </div>
                                            <div class="col-md-6">
                                                <strong>Fee Info:</strong><br>
                                                <code>{{fee_month}}</code><br>
                                                <code>{{paid_amount}}</code><br>
                                                <code>{{currency_symbol}}</code><br><br>
                                                
                                                <strong>Receipt Info:</strong><br>
                                                <code>{{receipt_date}}</code><br>
                                                <code>{{receipt_time}}</code><br>
                                                <code>{{receipt_number}}</code><br>
                                                <code>{{collected_by}}</code><br>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <small class="text-muted">Choose between Visual Editor (drag-and-drop) or HTML Code Editor (paste HTML code directly). Variables like {{school_name}}, {{student_name}}, {{paid_amount}} will be automatically replaced with actual data.</small>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label">Status</label>
                            <div class="col-sm-10">
                                <label class="checkbox-inline">
                                    <input type="checkbox" name="is_active" value="1" <?php echo set_checkbox('is_active', '1', true); ?>> 
                                    Active
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="box-footer">
                        <div class="row">
                            <div class="col-sm-offset-2 col-sm-10">
                                <button type="submit" name="submit" class="btn btn-primary">
                                    <i class="fa fa-save"></i> Create Template
                                </button>
                                <a href="<?php echo base_url(); ?>admin/simple_receipt" class="btn btn-default">
                                    <i class="fa fa-arrow-left"></i> Back
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                
                <?php echo form_close(); ?>
            </div>
        </div>
    </section>
</div>

<!-- Visual Editor Modal -->
<div class="modal fade" id="visual-editor-modal" tabindex="-1" role="dialog" style="z-index: 9999;">
    <div class="modal-dialog modal-fullscreen" role="document" style="width: 95%; max-width: none; height: 95%; margin: 2.5%;">
        <div class="modal-content" style="height: 100%; border-radius: 10px; box-shadow: 0 10px 30px rgba(0,0,0,0.3);">
            <div class="modal-header" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; border-radius: 10px 10px 0 0;">
                <h4 class="modal-title">
                    <i class="fa fa-paint-brush"></i> Visual Receipt Template Designer
                </h4>
                <div class="header-controls" style="display: flex; gap: 10px; align-items: center;">
                    <button type="button" id="save-and-close" class="btn btn-success btn-sm">
                        <i class="fa fa-save"></i> Save & Close
                    </button>
                    <button type="button" class="close" data-dismiss="modal" style="color: white; opacity: 0.8;">
                        <span>&times;</span>
                    </button>
                </div>
            </div>
            <div class="modal-body" style="padding: 0; height: calc(100% - 60px);">
                <!-- Editor Toolbar -->
                <div class="editor-toolbar" style="background: #f8f9fa; padding: 15px; border-bottom: 1px solid #ddd; display: flex; justify-content: space-between; align-items: center;">
                    <div class="toolbar-left">
                        <button type="button" id="load-sample-btn" class="btn btn-primary btn-sm">
                            <i class="fa fa-magic"></i> Load Sample
                        </button>
                        <button type="button" id="clear-canvas-btn" class="btn btn-warning btn-sm">
                            <i class="fa fa-trash"></i> Clear
                        </button>
                        <button type="button" id="preview-btn" class="btn btn-success btn-sm">
                            <i class="fa fa-eye"></i> Preview
                        </button>
                    </div>
                    <div class="toolbar-right">
                        <div class="btn-group btn-group-sm">
                            <button type="button" class="btn btn-outline-secondary device-btn active" data-device="Desktop">
                                <i class="fa fa-desktop"></i> Desktop
                            </button>
                            <button type="button" class="btn btn-outline-secondary device-btn" data-device="Tablet">
                                <i class="fa fa-tablet"></i> Tablet
                            </button>
                            <button type="button" class="btn btn-outline-secondary device-btn" data-device="Mobile">
                                <i class="fa fa-mobile"></i> Mobile
                            </button>
                        </div>
                    </div>
                </div>
                
                <!-- Main Editor Area -->
                <div class="editor-workspace" style="display: flex; height: calc(100% - 70px);">
                    <!-- Components Panel -->
                    <div class="components-panel" style="width: 280px; background: #f8f9fa; border-right: 1px solid #ddd; overflow-y: auto;">
                        <div class="panel-header" style="padding: 15px; border-bottom: 1px solid #ddd; background: white;">
                            <h5 style="margin: 0; color: #333; font-weight: 600;">
                                <i class="fa fa-cubes text-primary"></i> Components
                            </h5>
                        </div>
                        <div id="blocks" style="padding: 15px;"></div>
                    </div>
                    
                    <!-- Canvas Area -->
                    <div class="canvas-area" style="flex: 1; background: #e9ecef; position: relative;">
                        <div id="gjs" style="height: 100%;"></div>
                    </div>
                    
                    <!-- Properties Panel -->
                    <div class="properties-panel" style="width: 300px; background: #f8f9fa; border-left: 1px solid #ddd;">
                        <div class="panel-header" style="padding: 15px; border-bottom: 1px solid #ddd; background: white;">
                            <div class="btn-group" role="group">
                                <button type="button" class="btn btn-sm btn-outline-secondary panel-btn active" data-panel="blocks">
                                    <i class="fa fa-th-large"></i> Components
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-secondary panel-btn" data-panel="layers">
                                    <i class="fa fa-layer-group"></i> Layers
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-secondary panel-btn" data-panel="styles">
                                    <i class="fa fa-paint-brush"></i> Styles
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-secondary panel-btn" data-panel="traits">
                                    <i class="fa fa-cog"></i> Settings
                                </button>
                                <button type="button" class="btn btn-sm btn-info" id="variables-help-btn" title="Show Variables Help">
                                    <i class="fa fa-question-circle"></i> Variables
                                </button>
                            </div>
                        </div>
                        <div id="layers-container" style="padding: 15px; height: calc(100% - 80px); overflow-y: auto;"></div>
                        <div id="styles-container" style="padding: 15px; height: calc(100% - 80px); overflow-y: auto; display: none;"></div>
                        <div id="traits-container" style="padding: 15px; height: calc(100% - 80px); overflow-y: auto; display: none;"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- GrapesJS CSS -->
<link rel="stylesheet" href="https://unpkg.com/grapesjs/dist/css/grapes.min.css">

<!-- Custom Editor Styles -->
<style>
.gjs-block {
    border-radius: 6px !important;
    border: 1px solid #e9ecef !important;
    margin-bottom: 8px !important;
    transition: all 0.2s ease !important;
    background: white !important;
    box-shadow: 0 1px 3px rgba(0,0,0,0.1) !important;
}

.gjs-block:hover {
    border-color: #007bff !important;
    box-shadow: 0 2px 8px rgba(0,123,255,0.2) !important;
    transform: translateY(-1px) !important;
}

.gjs-block-receipt {
    border-left: 4px solid #007bff !important;
}

.gjs-block-student {
    border-left: 4px solid #28a745 !important;
}

.gjs-block-table {
    border-left: 4px solid #dc3545 !important;
}

.gjs-block-payment {
    border-left: 4px solid #ffc107 !important;
}

.gjs-block-footer {
    border-left: 4px solid #6c757d !important;
}

.gjs-block-variable {
    border-left: 4px solid #17a2b8 !important;
}

.gjs-block .gjs-block-label {
    font-size: 13px !important;
    font-weight: 500 !important;
    color: #495057 !important;
    padding: 8px 10px !important;
}

.modal-fullscreen {
    width: 95vw !important;
    height: 95vh !important;
    max-width: none !important;
    margin: 2.5vh auto !important;
}

.editor-toolbar {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%) !important;
    border-bottom: 2px solid #dee2e6 !important;
}

.components-panel, .properties-panel {
    background: linear-gradient(180deg, #f8f9fa 0%, #ffffff 100%) !important;
}

.panel-header {
    background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%) !important;
    border-bottom: 2px solid #dee2e6 !important;
}

.canvas-area {
    background: linear-gradient(45deg, #e9ecef 25%, transparent 25%, transparent 75%, #e9ecef 75%, #e9ecef),
                linear-gradient(45deg, #e9ecef 25%, transparent 25%, transparent 75%, #e9ecef 75%, #e9ecef) !important;
    background-size: 20px 20px !important;
    background-position: 0 0, 10px 10px !important;
}

.template-editor-launch {
    transition: all 0.3s ease !important;
    cursor: pointer !important;
}

.template-editor-launch:hover {
    border-color: #0056b3 !important;
    background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%) !important;
    transform: translateY(-2px) !important;
    box-shadow: 0 4px 12px rgba(0,123,255,0.2) !important;
}

.btn {
    transition: all 0.2s ease !important;
}

.btn:hover {
    transform: translateY(-1px) !important;
    box-shadow: 0 2px 6px rgba(0,0,0,0.15) !important;
}

#gjs {
    border-radius: 8px !important;
    overflow: hidden !important;
    box-shadow: inset 0 0 10px rgba(0,0,0,0.05) !important;
}
</style>

<!-- GrapesJS JS -->
<script src="https://unpkg.com/grapesjs"></script>

<script>
$(document).ready(function() {
    // Auto-generate template code from name
    $('#template_name').on('input', function() {
        var name = $(this).val();
        var code = name.toLowerCase()
                      .replace(/[^a-z0-9\s]/g, '')
                      .replace(/\s+/g, '_')
                      .substring(0, 50);
        $('#template_code').val(code);
    });

    var editor;
    
    // Open Visual Editor Modal
    $(document).on('click', '#open-editor-btn', function(e) {
        e.preventDefault();
        console.log('Open editor button clicked');
        $('#visual-editor-modal').modal('show');
        
        // Initialize GrapesJS Editor when modal opens
        setTimeout(function() {
            if (!editor) {
                console.log('Initializing GrapesJS editor');
                editor = grapesjs.init({
                    container: '#gjs',
                    height: '100%',
                    width: 'auto',
                    storageManager: false,
                    blockManager: {
                        appendTo: '#blocks'
                    },
                    layerManager: {
                        appendTo: '#layers-container'
                    },
                    styleManager: {
                        appendTo: '#styles-container'
                    },
                    traitManager: {
                        appendTo: '#traits-container'
                    },
                    canvas: {
                        styles: [
                            'https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css'
                        ]
                    },
                    deviceManager: {
                        devices: [
                            {
                                name: 'Desktop',
                                width: '',
                            },
                            {
                                name: 'Tablet',
                                width: '768px',
                                widthMedia: '992px',
                            },
                            {
                                name: 'Mobile',
                                width: '320px',
                                widthMedia: '768px',
                            }
                        ]
                    },
                    // Enable rich text editing
                    richTextEditor: {
                        actions: ['bold', 'italic', 'underline', 'strikethrough', 'link', 'wrap']
                    },
                    // Make components more user-friendly
                    domComponents: {
                        defaults: {
                            editable: true,
                            droppable: true,
                            resizable: true,
                            highlightable: true,
                            copyable: true,
                            removable: true
                        }
                    },
                    // Add custom CSS for better editing experience
                    cssComposer: {
                        rules: [
                            {
                                selectors: ['.gjs-selected'],
                                style: {
                                    'outline': '2px solid #007bff !important',
                                    'outline-offset': '2px'
                                }
                            }
                        ]
                    }
                });
                
                initializeEditorComponents();
                
                // Add custom commands for better user experience
                editor.Commands.add('show-variables', {
                    run: function(editor, sender) {
                        alert('Available Variables:\n\n' +
                            '{{school_name}} - School Name\n' +
                            '{{school_address}} - School Address\n' +
                            '{{school_phone}} - School Phone\n' +
                            '{{school_email}} - School Email\n' +
                            '{{school_logo}} - School Logo URL\n' +
                            '{{student_name}} - Student Name\n' +
                            '{{father_name}} - Father Name\n' +
                            '{{admission_no}} - Admission Number\n' +
                            '{{class_name}} - Class Name\n' +
                            '{{section_name}} - Section Name\n' +
                            '{{roll_no}} - Roll Number\n' +
                            '{{fee_group_name_1}} - Fee Group Name 1\n' +
                            '{{fee_type_code_1}} - Fee Type Code 1\n' +
                            '{{fee_amount_1}} - Fee Amount 1\n' +
                            '{{fee_group_name_2}} - Fee Group Name 2\n' +
                            '{{fee_type_code_2}} - Fee Type Code 2\n' +
                            '{{fee_amount_2}} - Fee Amount 2\n' +
                            '{{fee_group_name_3}} - Fee Group Name 3\n' +
                            '{{fee_type_code_3}} - Fee Type Code 3\n' +
                            '{{fee_amount_3}} - Fee Amount 3\n' +
                            '{{due_date_1}} - Due Date 1\n' +
                            '{{due_date_2}} - Due Date 2\n' +
                            '{{due_date_3}} - Due Date 3\n' +
                            '{{paid_amount_1}} - Paid Amount 1\n' +
                            '{{paid_amount_2}} - Paid Amount 2\n' +
                            '{{paid_amount_3}} - Paid Amount 3\n' +
                            '{{balance_1}} - Balance 1\n' +
                            '{{balance_2}} - Balance 2\n' +
                            '{{balance_3}} - Balance 3\n' +
                            '{{total_fee_amount}} - Total Fee Amount\n' +
                            '{{total_paid_amount}} - Total Paid Amount\n' +
                            '{{total_balance}} - Total Balance\n' +
                            '{{total_amount}} - Total Amount\n' +
                            '{{paid_amount}} - Paid Amount\n' +
                            '{{outstanding_balance}} - Outstanding Balance\n' +
                            '{{payment_mode}} - Payment Mode\n' +
                            '{{payment_date}} - Payment Date\n' +
                            '{{receipt_no}} - Receipt Number\n' +
                            '{{transaction_id}} - Transaction ID\n' +
                            '{{collected_by}} - Collected By\n' +
                            '{{current_date}} - Current Date');
                    }
                });
                
                // Add toolbar button for variables help
                editor.Panels.addButton('options', {
                    id: 'show-variables',
                    className: 'fa fa-question-circle',
                    command: 'show-variables',
                    attributes: { title: 'Show Available Variables' }
                });
                
                // Make text elements easily editable and add image editing functionality
                editor.on('component:selected', function(component) {
                    if (component.get('type') === 'text' || component.get('tagName') === 'span') {
                        component.set('editable', true);
                    }
                    
                    // Enable image editing
                    if (component.get('type') === 'image') {
                        component.set('resizable', true);
                        component.set('editable', false);
                        
                        // Add custom traits for image editing with upload interface
                        component.set('traits', [
                            {
                                type: 'button',
                                name: 'upload-image',
                                label: 'Upload New Image',
                                text: 'Choose File or Drag & Drop',
                                command: function(editor, component) {
                                    var input = document.createElement('input');
                                    input.type = 'file';
                                    input.accept = 'image/*';
                                    input.onchange = function(e) {
                                        var file = e.target.files[0];
                                        if (file) {
                                            var reader = new FileReader();
                                            reader.onload = function(event) {
                                                component.set('src', event.target.result);
                                                component.set('alt', file.name);
                                            };
                                            reader.readAsDataURL(file);
                                        }
                                    };
                                    input.click();
                                }
                            },
                            {
                                type: 'text',
                                name: 'alt',
                                label: 'Alt Text'
                            },
                            {
                                type: 'number',
                                name: 'width',
                                label: 'Width (px)',
                                min: 50,
                                max: 500
                            },
                            {
                                type: 'number',
                                name: 'height',
                                label: 'Height (px)',
                                min: 50,
                                max: 500
                            },
                            {
                                type: 'select',
                                name: 'border-radius',
                                label: 'Border Radius',
                                options: [
                                    { value: '0px', name: 'None' },
                                    { value: '4px', name: 'Small' },
                                    { value: '8px', name: 'Medium' },
                                    { value: '50%', name: 'Circle' }
                                ]
                            }
                        ]);
                    }
                });
                
                // Add drag and drop functionality to canvas
                var canvasEl = editor.Canvas.getElement();
                
                // Prevent default drag behaviors
                ['dragenter', 'dragover', 'dragleave', 'drop'].forEach(eventName => {
                    canvasEl.addEventListener(eventName, preventDefaults, false);
                    document.body.addEventListener(eventName, preventDefaults, false);
                });
                
                // Highlight drop area
                ['dragenter', 'dragover'].forEach(eventName => {
                    canvasEl.addEventListener(eventName, highlight, false);
                });
                
                ['dragleave', 'drop'].forEach(eventName => {
                    canvasEl.addEventListener(eventName, unhighlight, false);
                });
                
                // Handle dropped files
                canvasEl.addEventListener('drop', handleDrop, false);
                
                function preventDefaults(e) {
                    e.preventDefault();
                    e.stopPropagation();
                }
                
                function highlight(e) {
                    canvasEl.style.border = '3px dashed #007bff';
                    canvasEl.style.backgroundColor = 'rgba(0, 123, 255, 0.1)';
                }
                
                function unhighlight(e) {
                    canvasEl.style.border = '';
                    canvasEl.style.backgroundColor = '';
                }
                
                function handleDrop(e) {
                    var dt = e.dataTransfer;
                    var files = dt.files;
                    
                    handleFiles(files);
                }
                
                function handleFiles(files) {
                    ([...files]).forEach(uploadFile);
                }
                
                function uploadFile(file) {
                    if (file.type.startsWith('image/')) {
                        var reader = new FileReader();
                        reader.onload = function(event) {
                            // Add image at drop position
                            var rect = canvasEl.getBoundingClientRect();
                            var x = event.clientX ? (event.clientX - rect.left) : 50;
                            var y = event.clientY ? (event.clientY - rect.top) : 50;
                            
                            editor.addComponents({
                                type: 'image',
                                attributes: { 
                                    src: event.target.result,
                                    alt: file.name
                                },
                                style: { 
                                    'max-width': '200px', 
                                    'height': 'auto',
                                    'position': 'absolute',
                                    'left': x + 'px',
                                    'top': y + 'px'
                                }
                            });
                        };
                        reader.readAsDataURL(file);
                    }
                }

                // Add custom trait type for button with proper styling
                editor.TraitManager.addType('button', {
                    createInput: function(opts) {
                        var input = document.createElement('button');
                        input.className = 'btn btn-primary btn-sm';
                        input.style.cssText = `
                            width: 100%;
                            padding: 8px 12px;
                            margin: 5px 0;
                            background: #007bff;
                            color: white;
                            border: none;
                            border-radius: 4px;
                            cursor: pointer;
                            font-size: 12px;
                        `;
                        input.innerHTML = '<i class="fa fa-upload"></i> ' + (opts.text || 'Upload');
                        
                        var component = this.target;
                        input.onclick = function() {
                            var input = document.createElement('input');
                            input.type = 'file';
                            input.accept = 'image/*';
                            input.onchange = function(e) {
                                var file = e.target.files[0];
                                if (file) {
                                    var reader = new FileReader();
                                    reader.onload = function(event) {
                                        component.set('src', event.target.result);
                                        component.set('alt', file.name);
                                        // Trigger re-render
                                        component.view.render();
                                    };
                                    reader.readAsDataURL(file);
                                }
                            };
                            input.click();
                        };
                        return input;
                    }
                });

                // Add custom command for image upload
                editor.Commands.add('image-upload', {
                    run: function(editor, sender) {
                        var input = document.createElement('input');
                        input.type = 'file';
                        input.accept = 'image/*';
                        input.multiple = true;
                        input.onchange = function(e) {
                            handleFiles(e.target.files);
                        };
                        input.click();
                    }
                });
                
                // Add image upload button to toolbar
                editor.Panels.addButton('options', {
                    id: 'image-upload',
                    className: 'fa fa-upload',
                    command: 'image-upload',
                    attributes: { title: 'Upload Images (Click or Drag & Drop)' }
                });
                
                // Add visual indicator for drag and drop
                var dropZoneIndicator = document.createElement('div');
                dropZoneIndicator.id = 'drop-zone-indicator';
                dropZoneIndicator.innerHTML = `
                    <div style="
                        position: fixed;
                        top: 0;
                        left: 0;
                        width: 100%;
                        height: 100%;
                        background: rgba(0, 123, 255, 0.1);
                        border: 3px dashed #007bff;
                        z-index: 9999;
                        display: none;
                        justify-content: center;
                        align-items: center;
                        font-size: 24px;
                        color: #007bff;
                        font-weight: bold;
                    ">
                        <div style="
                            background: white;
                            padding: 30px;
                            border-radius: 10px;
                            box-shadow: 0 4px 20px rgba(0,0,0,0.2);
                            text-align: center;
                        ">
                            <i class="fa fa-cloud-upload" style="font-size: 48px; margin-bottom: 15px; display: block;"></i>
                            Drop Images Here
                            <div style="font-size: 14px; margin-top: 10px; color: #666;">
                                Supports JPG, PNG, GIF, SVG
                            </div>
                        </div>
                    </div>
                `;
                document.body.appendChild(dropZoneIndicator);
                
                // Enhanced drag and drop with visual feedback
                var dragCounter = 0;
                
                document.addEventListener('dragenter', function(e) {
                    e.preventDefault();
                    dragCounter++;
                    if (e.dataTransfer.types.includes('Files')) {
                        dropZoneIndicator.style.display = 'flex';
                    }
                });
                
                document.addEventListener('dragleave', function(e) {
                    e.preventDefault();
                    dragCounter--;
                    if (dragCounter === 0) {
                        dropZoneIndicator.style.display = 'none';
                    }
                });
                
                document.addEventListener('drop', function(e) {
                    e.preventDefault();
                    dragCounter = 0;
                    dropZoneIndicator.style.display = 'none';
                    
                    if (e.dataTransfer.files.length > 0) {
                        handleFiles(e.dataTransfer.files);
                    }
                });
            }
            
            // Load existing content if any
            var existingContent = $('#template_content').val();
            if (existingContent) {
                editor.setComponents(existingContent);
            }
        }, 300);
    });
    
    // Save and Close Modal
    $(document).on('click', '#save-and-close', function() {
        if (editor) {
            var htmlContent = editor.getHtml();
            var cssContent = editor.getCss();
            var fullTemplate = htmlContent + '<style>' + cssContent + '</style>';
            $('#template_content').val(fullTemplate);
        }
        $('#visual-editor-modal').modal('hide');
    });
    
    // Quick Load Sample
    $(document).on('click', '#load-sample-quick', function() {
        var sampleTemplate = getClassicTemplate();
        $('#template_content').val(sampleTemplate);
        $(this).text('Sample Loaded!').addClass('btn-success').removeClass('btn-outline-info');
        setTimeout(function() {
            $('#load-sample-quick').text('Load Sample Template').removeClass('btn-success').addClass('btn-outline-info');
        }, 2000);
    });
    
    function initializeEditorComponents() {

    // Add custom receipt blocks with improved styling and user-friendly editing
    editor.BlockManager.add('receipt-header', {
        label: '<i class="fa fa-header" style="margin-right: 5px; color: #007bff;"></i>Receipt Header',
        category: 'Receipt Components',
        attributes: { class: 'gjs-block-receipt' },
        content: {
            type: 'default',
            tagName: 'div',
            style: {
                'text-align': 'center',
                'padding': '20px',
                'background': 'linear-gradient(135deg, #007bff 0%, #0056b3 100%)',
                'color': 'white',
                'margin-bottom': '20px'
            },
            components: [
                {
                    type: 'text',
                    tagName: 'h2',
                    content: '{{school_name}}',
                    style: {
                        'margin': '0',
                        'font-size': '24px',
                        'font-weight': 'bold'
                    },
                    editable: true,
                    traits: [
                        {
                            type: 'text',
                            name: 'content',
                            label: 'School Name Variable'
                        }
                    ]
                },
                {
                    type: 'text',
                    tagName: 'p',
                    content: '{{school_address}}',
                    style: {
                        'margin': '5px 0',
                        'font-size': '14px'
                    },
                    editable: true
                },
                {
                    type: 'text',
                    tagName: 'p',
                    content: 'Phone: {{school_phone}} | Email: {{school_email}}',
                    style: {
                        'margin': '5px 0',
                        'font-size': '14px'
                    },
                    editable: true
                },
                {
                    type: 'text',
                    tagName: 'h3',
                    content: 'FEE RECEIPT',
                    style: {
                        'margin': '10px 0 0 0',
                        'font-size': '18px',
                        'background': 'rgba(255,255,255,0.2)',
                        'padding': '8px',
                        'border-radius': '4px'
                    },
                    editable: true
                }
            ],
            droppable: true,
            resizable: true
        }
    });

    // Enhanced Fee Table with detailed structure
    editor.BlockManager.add('detailed-fee-breakdown', {
        label: '<i class="fa fa-table" style="margin-right: 5px; color: #28a745;"></i>Detailed Fee Breakdown',
        category: 'Fee Components',
        attributes: { class: 'gjs-block-fee' },
        content: `
            <div style="margin: 20px 0; border: 1px solid #dee2e6; border-radius: 8px; overflow: hidden;">
                <div style="background: #28a745; color: white; padding: 12px; font-weight: bold; text-align: center;">
                    Fee Details - Academic Year {{academic_year}}
                </div>
                <table style="width: 100%; border-collapse: collapse; font-size: 14px;">
                    <thead style="background: #f8f9fa;">
                        <tr>
                            <th style="padding: 10px; border: 1px solid #dee2e6; text-align: left;">Fee Type</th>
                            <th style="padding: 10px; border: 1px solid #dee2e6; text-align: center;">Due Date</th>
                            <th style="padding: 10px; border: 1px solid #dee2e6; text-align: right;">Amount</th>
                            <th style="padding: 10px; border: 1px solid #dee2e6; text-align: right;">Paid</th>
                            <th style="padding: 10px; border: 1px solid #dee2e6; text-align: right;">Balance</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_1}} - {{fee_type_code_1}}</td>
                            <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{due_date_1}}</td>
                            <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_1}}</td>
                            <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_1}}</td>
                            <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_1}}</td>
                        </tr>
                        <tr>
                            <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_2}} - {{fee_type_code_2}}</td>
                            <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{due_date_2}}</td>
                            <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_2}}</td>
                            <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_2}}</td>
                            <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_2}}</td>
                        </tr>
                        <tr>
                            <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_3}} - {{fee_type_code_3}}</td>
                            <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{due_date_3}}</td>
                            <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_3}}</td>
                            <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_3}}</td>
                            <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_3}}</td>
                        </tr>
                        <tr style="background: #e9ecef; font-weight: bold;">
                            <td style="padding: 10px; border: 1px solid #dee2e6;" colspan="2">TOTAL</td>
                            <td style="padding: 10px; border: 1px solid #dee2e6; text-align: right;">{{total_fee_amount}}</td>
                            <td style="padding: 10px; border: 1px solid #dee2e6; text-align: right;">{{total_paid_amount}}</td>
                            <td style="padding: 10px; border: 1px solid #dee2e6; text-align: right;">{{total_balance}}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        `
    });

    // Monthly Fee Structure Component
    editor.BlockManager.add('monthly-fee-structure', {
        label: '<i class="fa fa-calendar" style="margin-right: 5px; color: #17a2b8;"></i>Monthly Fee Structure',
        category: 'Fee Components',
        attributes: { class: 'gjs-block-fee' },
        content: `
            <div style="margin: 20px 0; border: 1px solid #dee2e6; border-radius: 8px;">
                <div style="background: #17a2b8; color: white; padding: 12px; font-weight: bold; text-align: center;">
                    Monthly Fee Structure
                </div>
                <div style="padding: 15px;">
                    <div style="display: flex; justify-content: space-between; margin-bottom: 10px; padding: 8px; background: #f8f9fa; border-radius: 4px;">
                        <span style="font-weight: bold;">Tuition Fee:</span>
                        <span>{{tuition_fee}}</span>
                    </div>
                    <div style="display: flex; justify-content: space-between; margin-bottom: 10px; padding: 8px; background: #f8f9fa; border-radius: 4px;">
                        <span style="font-weight: bold;">Transport Fee:</span>
                        <span>{{transport_fee}}</span>
                    </div>
                    <div style="display: flex; justify-content: space-between; margin-bottom: 10px; padding: 8px; background: #f8f9fa; border-radius: 4px;">
                        <span style="font-weight: bold;">Library Fee:</span>
                        <span>{{library_fee}}</span>
                    </div>
                    <div style="display: flex; justify-content: space-between; margin-bottom: 10px; padding: 8px; background: #f8f9fa; border-radius: 4px;">
                        <span style="font-weight: bold;">Lab Fee:</span>
                        <span>{{lab_fee}}</span>
                    </div>
                    <div style="display: flex; justify-content: space-between; margin-bottom: 10px; padding: 8px; background: #f8f9fa; border-radius: 4px;">
                        <span style="font-weight: bold;">Sports Fee:</span>
                        <span>{{sports_fee}}</span>
                    </div>
                    <div style="display: flex; justify-content: space-between; margin-bottom: 10px; padding: 8px; background: #f8f9fa; border-radius: 4px;">
                        <span style="font-weight: bold;">Exam Fee:</span>
                        <span>{{exam_fee}}</span>
                    </div>
                    <hr style="margin: 15px 0;">
                    <div style="display: flex; justify-content: space-between; padding: 10px; background: #28a745; color: white; border-radius: 4px; font-weight: bold; font-size: 16px;">
                        <span>Monthly Total:</span>
                        <span>{{monthly_total}}</span>
                    </div>
                </div>
            </div>
        `
    });

    // Fee Payment History Component
    editor.BlockManager.add('fee-payment-history', {
        label: '<i class="fa fa-history" style="margin-right: 5px; color: #6f42c1;"></i>Payment History',
        category: 'Fee Components',
        attributes: { class: 'gjs-block-fee' },
        content: `
            <div style="margin: 20px 0; border: 1px solid #dee2e6; border-radius: 8px;">
                <div style="background: #6f42c1; color: white; padding: 12px; font-weight: bold; text-align: center;">
                    Payment History
                </div>
                <table style="width: 100%; border-collapse: collapse; font-size: 13px;">
                    <thead style="background: #f8f9fa;">
                        <tr>
                            <th style="padding: 8px; border: 1px solid #dee2e6; text-align: left;">Date</th>
                            <th style="padding: 8px; border: 1px solid #dee2e6; text-align: left;">Receipt No</th>
                            <th style="padding: 8px; border: 1px solid #dee2e6; text-align: left;">Payment Mode</th>
                            <th style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td style="padding: 6px; border: 1px solid #dee2e6;">{{payment_date_1}}</td>
                            <td style="padding: 6px; border: 1px solid #dee2e6;">{{receipt_no_1}}</td>
                            <td style="padding: 6px; border: 1px solid #dee2e6;">{{payment_mode_1}}</td>
                            <td style="padding: 6px; border: 1px solid #dee2e6; text-align: right;">{{payment_amount_1}}</td>
                        </tr>
                        <tr>
                            <td style="padding: 6px; border: 1px solid #dee2e6;">{{payment_date_2}}</td>
                            <td style="padding: 6px; border: 1px solid #dee2e6;">{{receipt_no_2}}</td>
                            <td style="padding: 6px; border: 1px solid #dee2e6;">{{payment_mode_2}}</td>
                            <td style="padding: 6px; border: 1px solid #dee2e6; text-align: right;">{{payment_amount_2}}</td>
                        </tr>
                        <tr>
                            <td style="padding: 6px; border: 1px solid #dee2e6;">{{payment_date_3}}</td>
                            <td style="padding: 6px; border: 1px solid #dee2e6;">{{receipt_no_3}}</td>
                            <td style="padding: 6px; border: 1px solid #dee2e6;">{{payment_mode_3}}</td>
                            <td style="padding: 6px; border: 1px solid #dee2e6; text-align: right;">{{payment_amount_3}}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        `
    });

    // Fee Summary Card Component
    editor.BlockManager.add('fee-summary-card', {
        label: '<i class="fa fa-credit-card" style="margin-right: 5px; color: #fd7e14;"></i>Fee Summary Card',
        category: 'Fee Components',
        attributes: { class: 'gjs-block-fee' },
        content: `
            <div style="margin: 20px 0; background: linear-gradient(135deg, #fd7e14 0%, #e55a00 100%); color: white; padding: 20px; border-radius: 12px; box-shadow: 0 4px 15px rgba(253, 126, 20, 0.3);">
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                    <h3 style="margin: 0; font-size: 18px;">Fee Summary</h3>
                    <div style="background: rgba(255,255,255,0.2); padding: 5px 10px; border-radius: 20px; font-size: 12px;">
                        {{current_month}} {{current_year}}
                    </div>
                </div>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                    <div style="background: rgba(255,255,255,0.1); padding: 15px; border-radius: 8px; text-align: center;">
                        <div style="font-size: 24px; font-weight: bold; margin-bottom: 5px;">{{total_due}}</div>
                        <div style="font-size: 12px; opacity: 0.9;">Total Due</div>
                    </div>
                    <div style="background: rgba(255,255,255,0.1); padding: 15px; border-radius: 8px; text-align: center;">
                        <div style="font-size: 24px; font-weight: bold; margin-bottom: 5px;">{{total_paid}}</div>
                        <div style="font-size: 12px; opacity: 0.9;">Total Paid</div>
                    </div>
                </div>
                <div style="margin-top: 15px; padding: 12px; background: rgba(255,255,255,0.1); border-radius: 8px; text-align: center;">
                    <div style="font-size: 14px; margin-bottom: 5px;">Outstanding Balance</div>
                    <div style="font-size: 28px; font-weight: bold;">{{outstanding_balance}}</div>
                </div>
            </div>
        `
    });

    editor.BlockManager.add('student-info', {
        label: '<i class="fa fa-user-graduate" style="margin-right: 8px; color: #28a745;"></i>Student Info',
        category: 'Receipt Components',
        attributes: { class: 'gjs-block-student' },
        content: `
            <div style="margin: 25px 0; padding: 20px; background: linear-gradient(135deg, #e8f5e8 0%, #d4edda 100%); border-left: 5px solid #28a745; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                <h4 style="margin: 0 0 15px 0; color: #155724; font-size: 18px; font-weight: 600;">Student Information</h4>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px; margin-bottom: 12px;">
                    <div style="padding: 8px; background: white; border-radius: 4px;"><strong style="color: #155724;">Student Name:</strong> <span style="color: #333;">{{student_name}}</span></div>
                    <div style="padding: 8px; background: white; border-radius: 4px;"><strong style="color: #155724;">Admission No:</strong> <span style="color: #333;">{{admission_no}}</span></div>
                </div>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px; margin-bottom: 12px;">
                    <div style="padding: 8px; background: white; border-radius: 4px;"><strong style="color: #155724;">Class:</strong> <span style="color: #333;">{{class_name}}</span></div>
                    <div style="padding: 8px; background: white; border-radius: 4px;"><strong style="color: #155724;">Section:</strong> <span style="color: #333;">{{section_name}}</span></div>
                </div>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                    <div style="padding: 8px; background: white; border-radius: 4px;"><strong style="color: #155724;">Father's Name:</strong> <span style="color: #333;">{{father_name}}</span></div>
                    <div style="padding: 8px; background: white; border-radius: 4px;"><strong style="color: #155724;">Receipt No:</strong> <span style="color: #333;">{{receipt_no}}</span></div>
                </div>
            </div>
        `
    });

    editor.BlockManager.add('fee-table', {
        label: '<i class="fa fa-table" style="margin-right: 8px; color: #dc3545;"></i>Fee Details',
        category: 'Receipt Components',
        attributes: { class: 'gjs-block-table' },
        content: `
            <div style="margin: 25px 0; box-shadow: 0 4px 6px rgba(0,0,0,0.1); border-radius: 8px; overflow: hidden;">
                <table style="width: 100%; border-collapse: collapse;">
                    <thead>
                        <tr style="background: linear-gradient(135deg, #007bff 0%, #0056b3 100%); color: white;">
                            <th style="padding: 15px; text-align: left; font-size: 16px; font-weight: 600;">Fee Type</th>
                            <th style="padding: 15px; text-align: right; font-size: 16px; font-weight: 600;">Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr style="background: white;">
                            <td style="padding: 12px 15px; border-bottom: 1px solid #e9ecef; color: #333;">{{fee_type}}</td>
                            <td style="padding: 12px 15px; border-bottom: 1px solid #e9ecef; text-align: right; color: #333; font-weight: 500;">₹{{fee_amount}}</td>
                        </tr>
                        <tr style="background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);">
                            <td style="padding: 15px; font-weight: 700; color: #495057; font-size: 16px;">Total Amount</td>
                            <td style="padding: 15px; text-align: right; font-weight: 700; color: #007bff; font-size: 18px;">₹{{total_amount}}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        `
    });

    editor.BlockManager.add('payment-info', {
        label: '<i class="fa fa-credit-card" style="margin-right: 8px; color: #ffc107;"></i>Payment Info',
        category: 'Receipt Components',
        attributes: { class: 'gjs-block-payment' },
        content: `
            <div style="margin: 25px 0; padding: 20px; background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%); border: 2px solid #ffc107; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                <h4 style="margin: 0 0 15px 0; color: #856404; font-size: 18px; font-weight: 600; display: flex; align-items: center;"><i class="fa fa-money-bill-wave" style="margin-right: 8px;"></i>Payment Details</h4>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px; margin-bottom: 12px;">
                    <div style="padding: 10px; background: white; border-radius: 6px; border-left: 4px solid #ffc107;"><strong style="color: #856404;">Payment Date:</strong> <span style="color: #333;">{{payment_date}}</span></div>
                    <div style="padding: 10px; background: white; border-radius: 6px; border-left: 4px solid #ffc107;"><strong style="color: #856404;">Payment Mode:</strong> <span style="color: #333;">{{payment_mode}}</span></div>
                </div>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                    <div style="padding: 10px; background: white; border-radius: 6px; border-left: 4px solid #ffc107;"><strong style="color: #856404;">Transaction ID:</strong> <span style="color: #333;">{{transaction_id}}</span></div>
                    <div style="padding: 10px; background: white; border-radius: 6px; border-left: 4px solid #ffc107;"><strong style="color: #856404;">Amount Paid:</strong> <span style="color: #28a745; font-weight: 600; font-size: 16px;">₹{{amount_paid}}</span></div>
                </div>
            </div>
        `
    });

    editor.BlockManager.add('receipt-footer', {
        label: '<i class="fa fa-file-signature" style="margin-right: 8px; color: #6c757d;"></i>Receipt Footer',
        category: 'Receipt Components',
        attributes: { class: 'gjs-block-footer' },
        content: `
            <div style="margin-top: 40px; padding: 25px; border-top: 3px solid #6c757d; background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%); border-radius: 0 0 8px 8px;">
                <div style="text-align: center; margin-bottom: 20px;">
                    <p style="margin: 8px 0; font-size: 13px; color: #6c757d; font-style: italic;">This is a computer generated receipt and does not require signature.</p>
                    <p style="margin: 8px 0; font-size: 13px; color: #6c757d;">For any queries, please contact the school office.</p>
                </div>
                <div style="display: flex; justify-content: space-between; align-items: end; margin-top: 25px;">
                    <div style="text-align: left;">
                        <p style="margin: 2px 0; font-size: 11px; color: #6c757d;">Generated on: {{current_date}}</p>
                        <p style="margin: 2px 0; font-size: 11px; color: #6c757d;">Generated by: {{generated_by}}</p>
                    </div>
                    <div style="text-align: right;">
                        <div style="border-top: 2px solid #6c757d; padding-top: 8px; min-width: 150px;">
                            <p style="margin: 0; font-size: 12px; color: #495057; font-weight: 500;">Authorized Signature</p>
                        </div>
                    </div>
                </div>
            </div>
        `
    });

    // Add enhanced variable blocks
    editor.BlockManager.add('school-name', {
        label: '<i class="fa fa-school" style="margin-right: 5px; color: #007bff;"></i>School Name',
        category: 'Variables',
        attributes: { class: 'gjs-block-variable' },
        content: {
            type: 'text',
            content: '{{school_name}}',
            style: {
                'background': 'linear-gradient(135deg, #cce5ff 0%, #99d6ff 100%)',
                'padding': '4px 8px',
                'border': '1px solid #007bff',
                'border-radius': '4px',
                'color': '#003d82',
                'font-weight': '500',
                'font-size': '14px',
                'display': 'inline-block'
            },
            editable: true
        }
    });

    editor.BlockManager.add('student-name', {
        label: '<i class="fa fa-user" style="margin-right: 5px; color: #28a745;"></i>Student Name',
        category: 'Variables',
        attributes: { class: 'gjs-block-variable' },
        content: {
            type: 'text',
            content: '{{student_name}}',
            style: {
                'background': 'linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%)',
                'padding': '4px 8px',
                'border': '1px solid #28a745',
                'border-radius': '4px',
                'color': '#155724',
                'font-weight': '500',
                'font-size': '14px',
                'display': 'inline-block'
            },
            editable: true
        }
    });

    editor.BlockManager.add('fee-amount', {
        label: '<i class="fa fa-money" style="margin-right: 5px; color: #28a745;"></i>Fee Amount',
        category: 'Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%); padding: 4px 8px; border: 1px solid #28a745; border-radius: 4px; color: #155724; font-weight: 500; font-size: 14px;">{{fee_amount}}</span>'
    });

    editor.BlockManager.add('academic-year', {
        label: '<i class="fa fa-calendar-alt" style="margin-right: 5px; color: #17a2b8;"></i>Academic Year',
        category: 'Fee Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #d1ecf1 0%, #bee5eb 100%); padding: 4px 8px; border: 1px solid #17a2b8; border-radius: 4px; color: #0c5460; font-weight: 500; font-size: 14px;">{{academic_year}}</span>'
    });

    // School Information Variables
    editor.BlockManager.add('school-address', {
        label: '<i class="fa fa-map-marker-alt" style="margin-right: 5px; color: #007bff;"></i>School Address',
        category: 'School Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #cce5ff 0%, #99d6ff 100%); padding: 4px 8px; border: 1px solid #007bff; border-radius: 4px; color: #003d82; font-weight: 500; font-size: 14px;">{{school_address}}</span>'
    });

    editor.BlockManager.add('school-phone', {
        label: '<i class="fa fa-phone" style="margin-right: 5px; color: #007bff;"></i>School Phone',
        category: 'School Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #cce5ff 0%, #99d6ff 100%); padding: 4px 8px; border: 1px solid #007bff; border-radius: 4px; color: #003d82; font-weight: 500; font-size: 14px;">{{school_phone}}</span>'
    });

    editor.BlockManager.add('school-email', {
        label: '<i class="fa fa-envelope" style="margin-right: 5px; color: #007bff;"></i>School Email',
        category: 'School Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #cce5ff 0%, #99d6ff 100%); padding: 4px 8px; border: 1px solid #007bff; border-radius: 4px; color: #003d82; font-weight: 500; font-size: 14px;">{{school_email}}</span>'
    });

    editor.BlockManager.add('school-website', {
        label: '<i class="fa fa-globe" style="margin-right: 5px; color: #007bff;"></i>School Website',
        category: 'School Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #cce5ff 0%, #99d6ff 100%); padding: 4px 8px; border: 1px solid #007bff; border-radius: 4px; color: #003d82; font-weight: 500; font-size: 14px;">{{school_website}}</span>'
    });

    // Student Information Variables
    editor.BlockManager.add('admission-no', {
        label: '<i class="fa fa-id-card" style="margin-right: 5px; color: #28a745;"></i>Admission No',
        category: 'Student Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%); padding: 4px 8px; border: 1px solid #28a745; border-radius: 4px; color: #155724; font-weight: 500; font-size: 14px;">{{admission_no}}</span>'
    });

    editor.BlockManager.add('class-name', {
        label: '<i class="fa fa-graduation-cap" style="margin-right: 5px; color: #28a745;"></i>Class Name',
        category: 'Student Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%); padding: 4px 8px; border: 1px solid #28a745; border-radius: 4px; color: #155724; font-weight: 500; font-size: 14px;">{{class_name}}</span>'
    });

    editor.BlockManager.add('section-name', {
        label: '<i class="fa fa-users" style="margin-right: 5px; color: #28a745;"></i>Section Name',
        category: 'Student Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%); padding: 4px 8px; border: 1px solid #28a745; border-radius: 4px; color: #155724; font-weight: 500; font-size: 14px;">{{section_name}}</span>'
    });

    editor.BlockManager.add('father-name', {
        label: '<i class="fa fa-male" style="margin-right: 5px; color: #28a745;"></i>Father Name',
        category: 'Student Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%); padding: 4px 8px; border: 1px solid #28a745; border-radius: 4px; color: #155724; font-weight: 500; font-size: 14px;">{{father_name}}</span>'
    });

    editor.BlockManager.add('mother-name', {
        label: '<i class="fa fa-female" style="margin-right: 5px; color: #28a745;"></i>Mother Name',
        category: 'Student Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%); padding: 4px 8px; border: 1px solid #28a745; border-radius: 4px; color: #155724; font-weight: 500; font-size: 14px;">{{mother_name}}</span>'
    });

    editor.BlockManager.add('student-mobile', {
        label: '<i class="fa fa-mobile-alt" style="margin-right: 5px; color: #28a745;"></i>Student Mobile',
        category: 'Student Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%); padding: 4px 8px; border: 1px solid #28a745; border-radius: 4px; color: #155724; font-weight: 500; font-size: 14px;">{{student_mobile}}</span>'
    });

    editor.BlockManager.add('roll-number', {
        label: '<i class="fa fa-hashtag" style="margin-right: 5px; color: #28a745;"></i>Roll Number',
        category: 'Student Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%); padding: 4px 8px; border: 1px solid #28a745; border-radius: 4px; color: #155724; font-weight: 500; font-size: 14px;">{{roll_number}}</span>'
    });

    editor.BlockManager.add('student-email', {
        label: '<i class="fa fa-envelope" style="margin-right: 5px; color: #28a745;"></i>Student Email',
        category: 'Student Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%); padding: 4px 8px; border: 1px solid #28a745; border-radius: 4px; color: #155724; font-weight: 500; font-size: 14px;">{{student_email}}</span>'
    });

    editor.BlockManager.add('student-address', {
        label: '<i class="fa fa-home" style="margin-right: 5px; color: #28a745;"></i>Student Address',
        category: 'Student Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%); padding: 4px 8px; border: 1px solid #28a745; border-radius: 4px; color: #155724; font-weight: 500; font-size: 14px;">{{student_address}}</span>'
    });

    editor.BlockManager.add('date-of-birth', {
        label: '<i class="fa fa-birthday-cake" style="margin-right: 5px; color: #28a745;"></i>Date of Birth',
        category: 'Student Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%); padding: 4px 8px; border: 1px solid #28a745; border-radius: 4px; color: #155724; font-weight: 500; font-size: 14px;">{{date_of_birth}}</span>'
    });

    editor.BlockManager.add('guardian-name', {
        label: '<i class="fa fa-user-shield" style="margin-right: 5px; color: #28a745;"></i>Guardian Name',
        category: 'Student Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%); padding: 4px 8px; border: 1px solid #28a745; border-radius: 4px; color: #155724; font-weight: 500; font-size: 14px;">{{guardian_name}}</span>'
    });

    editor.BlockManager.add('guardian-mobile', {
        label: '<i class="fa fa-phone" style="margin-right: 5px; color: #28a745;"></i>Guardian Mobile',
        category: 'Student Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%); padding: 4px 8px; border: 1px solid #28a745; border-radius: 4px; color: #155724; font-weight: 500; font-size: 14px;">{{guardian_mobile}}</span>'
    });

    // Fee Amount Variables
    editor.BlockManager.add('tuition-fee', {
        label: '<i class="fa fa-book" style="margin-right: 5px; color: #dc3545;"></i>Tuition Fee',
        category: 'Fee Amount Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%); padding: 4px 8px; border: 1px solid #dc3545; border-radius: 4px; color: #721c24; font-weight: 500; font-size: 14px;">{{tuition_fee}}</span>'
    });

    editor.BlockManager.add('transport-fee', {
        label: '<i class="fa fa-bus" style="margin-right: 5px; color: #dc3545;"></i>Transport Fee',
        category: 'Fee Amount Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%); padding: 4px 8px; border: 1px solid #dc3545; border-radius: 4px; color: #721c24; font-weight: 500; font-size: 14px;">{{transport_fee}}</span>'
    });

    editor.BlockManager.add('library-fee', {
        label: '<i class="fa fa-book-open" style="margin-right: 5px; color: #dc3545;"></i>Library Fee',
        category: 'Fee Amount Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%); padding: 4px 8px; border: 1px solid #dc3545; border-radius: 4px; color: #721c24; font-weight: 500; font-size: 14px;">{{library_fee}}</span>'
    });

    editor.BlockManager.add('lab-fee', {
        label: '<i class="fa fa-flask" style="margin-right: 5px; color: #dc3545;"></i>Lab Fee',
        category: 'Fee Amount Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%); padding: 4px 8px; border: 1px solid #dc3545; border-radius: 4px; color: #721c24; font-weight: 500; font-size: 14px;">{{lab_fee}}</span>'
    });

    editor.BlockManager.add('sports-fee', {
        label: '<i class="fa fa-futbol" style="margin-right: 5px; color: #dc3545;"></i>Sports Fee',
        category: 'Fee Amount Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%); padding: 4px 8px; border: 1px solid #dc3545; border-radius: 4px; color: #721c24; font-weight: 500; font-size: 14px;">{{sports_fee}}</span>'
    });

    editor.BlockManager.add('exam-fee', {
        label: '<i class="fa fa-clipboard-check" style="margin-right: 5px; color: #dc3545;"></i>Exam Fee',
        category: 'Fee Amount Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%); padding: 4px 8px; border: 1px solid #dc3545; border-radius: 4px; color: #721c24; font-weight: 500; font-size: 14px;">{{exam_fee}}</span>'
    });

    editor.BlockManager.add('admission-fee', {
        label: '<i class="fa fa-user-plus" style="margin-right: 5px; color: #dc3545;"></i>Admission Fee',
        category: 'Fee Amount Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%); padding: 4px 8px; border: 1px solid #dc3545; border-radius: 4px; color: #721c24; font-weight: 500; font-size: 14px;">{{admission_fee}}</span>'
    });

    editor.BlockManager.add('development-fee', {
        label: '<i class="fa fa-building" style="margin-right: 5px; color: #dc3545;"></i>Development Fee',
        category: 'Fee Amount Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%); padding: 4px 8px; border: 1px solid #dc3545; border-radius: 4px; color: #721c24; font-weight: 500; font-size: 14px;">{{development_fee}}</span>'
    });

    // Payment Information Variables
    editor.BlockManager.add('payment-date', {
        label: '<i class="fa fa-calendar" style="margin-right: 5px; color: #ffc107;"></i>Payment Date',
        category: 'Payment Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%); padding: 4px 8px; border: 1px solid #ffc107; border-radius: 4px; color: #856404; font-weight: 500; font-size: 14px;">{{payment_date}}</span>'
    });

    editor.BlockManager.add('payment-mode', {
        label: '<i class="fa fa-credit-card" style="margin-right: 5px; color: #ffc107;"></i>Payment Mode',
        category: 'Payment Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%); padding: 4px 8px; border: 1px solid #ffc107; border-radius: 4px; color: #856404; font-weight: 500; font-size: 14px;">{{payment_mode}}</span>'
    });

    editor.BlockManager.add('receipt-no', {
        label: '<i class="fa fa-receipt" style="margin-right: 5px; color: #ffc107;"></i>Receipt No',
        category: 'Payment Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%); padding: 4px 8px; border: 1px solid #ffc107; border-radius: 4px; color: #856404; font-weight: 500; font-size: 14px;">{{receipt_no}}</span>'
    });

    editor.BlockManager.add('transaction-id', {
        label: '<i class="fa fa-hashtag" style="margin-right: 5px; color: #ffc107;"></i>Transaction ID',
        category: 'Payment Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%); padding: 4px 8px; border: 1px solid #ffc107; border-radius: 4px; color: #856404; font-weight: 500; font-size: 14px;">{{transaction_id}}</span>'
    });

    editor.BlockManager.add('collected-by', {
        label: '<i class="fa fa-user-tie" style="margin-right: 5px; color: #ffc107;"></i>Collected By',
        category: 'Payment Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%); padding: 4px 8px; border: 1px solid #ffc107; border-radius: 4px; color: #856404; font-weight: 500; font-size: 14px;">{{collected_by}}</span>'
    });

    editor.BlockManager.add('bank-name', {
        label: '<i class="fa fa-university" style="margin-right: 5px; color: #ffc107;"></i>Bank Name',
        category: 'Payment Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%); padding: 4px 8px; border: 1px solid #ffc107; border-radius: 4px; color: #856404; font-weight: 500; font-size: 14px;">{{bank_name}}</span>'
    });

    // Total Amount Variables
    editor.BlockManager.add('total-amount', {
        label: '<i class="fa fa-calculator" style="margin-right: 5px; color: #6f42c1;"></i>Total Amount',
        category: 'Total Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #e2d9f3 0%, #d1c4e9 100%); padding: 4px 8px; border: 1px solid #6f42c1; border-radius: 4px; color: #4a148c; font-weight: 500; font-size: 14px;">{{total_amount}}</span>'
    });

    editor.BlockManager.add('paid-amount', {
        label: '<i class="fa fa-check-circle" style="margin-right: 5px; color: #6f42c1;"></i>Paid Amount',
        category: 'Total Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #e2d9f3 0%, #d1c4e9 100%); padding: 4px 8px; border: 1px solid #6f42c1; border-radius: 4px; color: #4a148c; font-weight: 500; font-size: 14px;">{{paid_amount}}</span>'
    });

    editor.BlockManager.add('balance-amount', {
        label: '<i class="fa fa-balance-scale" style="margin-right: 5px; color: #6f42c1;"></i>Balance Amount',
        category: 'Total Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #e2d9f3 0%, #d1c4e9 100%); padding: 4px 8px; border: 1px solid #6f42c1; border-radius: 4px; color: #4a148c; font-weight: 500; font-size: 14px;">{{balance_amount}}</span>'
    });

    editor.BlockManager.add('discount-amount', {
        label: '<i class="fa fa-percent" style="margin-right: 5px; color: #6f42c1;"></i>Discount Amount',
        category: 'Total Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #e2d9f3 0%, #d1c4e9 100%); padding: 4px 8px; border: 1px solid #6f42c1; border-radius: 4px; color: #4a148c; font-weight: 500; font-size: 14px;">{{discount_amount}}</span>'
    });

    // Date & Time Variables
    editor.BlockManager.add('current-date', {
        label: '<i class="fa fa-calendar-day" style="margin-right: 5px; color: #17a2b8;"></i>Current Date',
        category: 'Date & Time Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #d1ecf1 0%, #bee5eb 100%); padding: 4px 8px; border: 1px solid #17a2b8; border-radius: 4px; color: #0c5460; font-weight: 500; font-size: 14px;">{{current_date}}</span>'
    });

    editor.BlockManager.add('current-time', {
        label: '<i class="fa fa-clock" style="margin-right: 5px; color: #17a2b8;"></i>Current Time',
        category: 'Date & Time Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #d1ecf1 0%, #bee5eb 100%); padding: 4px 8px; border: 1px solid #17a2b8; border-radius: 4px; color: #0c5460; font-weight: 500; font-size: 14px;">{{current_time}}</span>'
    });

    editor.BlockManager.add('due-date', {
        label: '<i class="fa fa-exclamation-triangle" style="margin-right: 5px; color: #17a2b8;"></i>Due Date',
        category: 'Date & Time Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #d1ecf1 0%, #bee5eb 100%); padding: 4px 8px; border: 1px solid #17a2b8; border-radius: 4px; color: #0c5460; font-weight: 500; font-size: 14px;">{{due_date}}</span>'
    });

    editor.BlockManager.add('session-year', {
        label: '<i class="fa fa-calendar-alt" style="margin-right: 5px; color: #17a2b8;"></i>Session Year',
        category: 'Date & Time Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #d1ecf1 0%, #bee5eb 100%); padding: 4px 8px; border: 1px solid #17a2b8; border-radius: 4px; color: #0c5460; font-weight: 500; font-size: 14px;">{{session_year}}</span>'
    });

    // Table Variables for Invoice Creation
    editor.BlockManager.add('fee-group-name-1', {
        label: '<i class="fa fa-table" style="margin-right: 5px; color: #fd7e14;"></i>Fee Group 1',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{fee_group_name_1}}</span>'
    });

    editor.BlockManager.add('fee-group-name-2', {
        label: '<i class="fa fa-table" style="margin-right: 5px; color: #fd7e14;"></i>Fee Group 2',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{fee_group_name_2}}</span>'
    });

    editor.BlockManager.add('fee-group-name-3', {
        label: '<i class="fa fa-table" style="margin-right: 5px; color: #fd7e14;"></i>Fee Group 3',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{fee_group_name_3}}</span>'
    });

    editor.BlockManager.add('fee-amount-1', {
        label: '<i class="fa fa-rupee-sign" style="margin-right: 5px; color: #fd7e14;"></i>Fee Amount 1',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{fee_amount_1}}</span>'
    });

    editor.BlockManager.add('fee-amount-2', {
        label: '<i class="fa fa-rupee-sign" style="margin-right: 5px; color: #fd7e14;"></i>Fee Amount 2',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{fee_amount_2}}</span>'
    });

    editor.BlockManager.add('fee-amount-3', {
        label: '<i class="fa fa-rupee-sign" style="margin-right: 5px; color: #fd7e14;"></i>Fee Amount 3',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{fee_amount_3}}</span>'
    });

    editor.BlockManager.add('paid-amount-1', {
        label: '<i class="fa fa-check-circle" style="margin-right: 5px; color: #fd7e14;"></i>Paid Amount 1',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{paid_amount_1}}</span>'
    });

    editor.BlockManager.add('paid-amount-2', {
        label: '<i class="fa fa-check-circle" style="margin-right: 5px; color: #fd7e14;"></i>Paid Amount 2',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{paid_amount_2}}</span>'
    });

    editor.BlockManager.add('paid-amount-3', {
        label: '<i class="fa fa-check-circle" style="margin-right: 5px; color: #fd7e14;"></i>Paid Amount 3',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{paid_amount_3}}</span>'
    });

    editor.BlockManager.add('balance-1', {
        label: '<i class="fa fa-balance-scale" style="margin-right: 5px; color: #fd7e14;"></i>Balance 1',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{balance_1}}</span>'
    });

    editor.BlockManager.add('balance-2', {
        label: '<i class="fa fa-balance-scale" style="margin-right: 5px; color: #fd7e14;"></i>Balance 2',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{balance_2}}</span>'
    });

    editor.BlockManager.add('balance-3', {
        label: '<i class="fa fa-balance-scale" style="margin-right: 5px; color: #fd7e14;"></i>Balance 3',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{balance_3}}</span>'
    });

    editor.BlockManager.add('due-date-1', {
        label: '<i class="fa fa-calendar-times" style="margin-right: 5px; color: #fd7e14;"></i>Due Date 1',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{due_date_1}}</span>'
    });

    editor.BlockManager.add('due-date-2', {
        label: '<i class="fa fa-calendar-times" style="margin-right: 5px; color: #fd7e14;"></i>Due Date 2',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{due_date_2}}</span>'
    });

    editor.BlockManager.add('due-date-3', {
        label: '<i class="fa fa-calendar-times" style="margin-right: 5px; color: #fd7e14;"></i>Due Date 3',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{due_date_3}}</span>'
    });

    // Center/Alignment Components
    editor.BlockManager.add('center-text', {
        label: '<i class="fa fa-align-center" style="margin-right: 5px; color: #20c997;"></i>Center Text',
        category: 'Alignment Components',
        attributes: { class: 'gjs-block-alignment' },
        content: '<div style="text-align: center; padding: 10px; border: 1px dashed #20c997; border-radius: 4px; background: #f0fff4;">Center aligned content - Replace this text</div>'
    });

    editor.BlockManager.add('left-text', {
        label: '<i class="fa fa-align-left" style="margin-right: 5px; color: #20c997;"></i>Left Text',
        category: 'Alignment Components',
        attributes: { class: 'gjs-block-alignment' },
        content: '<div style="text-align: left; padding: 10px; border: 1px dashed #20c997; border-radius: 4px; background: #f0fff4;">Left aligned content - Replace this text</div>'
    });

    editor.BlockManager.add('right-text', {
        label: '<i class="fa fa-align-right" style="margin-right: 5px; color: #20c997;"></i>Right Text',
        category: 'Alignment Components',
        attributes: { class: 'gjs-block-alignment' },
        content: '<div style="text-align: right; padding: 10px; border: 1px dashed #20c997; border-radius: 4px; background: #f0fff4;">Right aligned content - Replace this text</div>'
    });

    editor.BlockManager.add('justify-text', {
        label: '<i class="fa fa-align-justify" style="margin-right: 5px; color: #20c997;"></i>Justify Text',
        category: 'Alignment Components',
        attributes: { class: 'gjs-block-alignment' },
        content: '<div style="text-align: justify; padding: 10px; border: 1px dashed #20c997; border-radius: 4px; background: #f0fff4;">Justified content - Replace this text with longer content to see the justify effect</div>'
    });

    // Total Amount Variables for Tables
    editor.BlockManager.add('total-fee-amount', {
        label: '<i class="fa fa-calculator" style="margin-right: 5px; color: #e83e8c;"></i>Total Fee Amount',
        category: 'Total Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #f8e6f0 0%, #f2d7e6 100%); padding: 4px 8px; border: 1px solid #e83e8c; border-radius: 4px; color: #7a1e48; font-weight: 500; font-size: 14px;">{{total_fee_amount}}</span>'
    });

    editor.BlockManager.add('total-paid-amount', {
        label: '<i class="fa fa-check-double" style="margin-right: 5px; color: #e83e8c;"></i>Total Paid Amount',
        category: 'Total Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #f8e6f0 0%, #f2d7e6 100%); padding: 4px 8px; border: 1px solid #e83e8c; border-radius: 4px; color: #7a1e48; font-weight: 500; font-size: 14px;">{{total_paid_amount}}</span>'
    });

    editor.BlockManager.add('total-balance', {
        label: '<i class="fa fa-balance-scale-right" style="margin-right: 5px; color: #e83e8c;"></i>Total Balance',
        category: 'Total Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #f8e6f0 0%, #f2d7e6 100%); padding: 4px 8px; border: 1px solid #e83e8c; border-radius: 4px; color: #7a1e48; font-weight: 500; font-size: 14px;">{{total_balance}}</span>'
    });

    // Dynamic Fee Groups Table with Column Management
    editor.BlockManager.add('fee-groups-table', {
        label: '<i class="fa fa-table" style="margin-right: 5px; color: #6f42c1;"></i>Fee Groups Table',
        category: 'Dynamic Tables',
        attributes: { class: 'gjs-block-table' },
        content: `
        <div class="fee-groups-table-container" style="margin: 20px 0; border: 1px solid #dee2e6; border-radius: 8px; overflow: hidden;">
            <div class="table-header" style="background: linear-gradient(135deg, #6f42c1 0%, #5a32a3 100%); color: white; padding: 12px; display: flex; justify-content: space-between; align-items: center;">
                <h4 style="margin: 0; font-size: 16px; font-weight: 600;">Fee Groups Details</h4>
                <div class="table-controls">
                    <button type="button" class="btn-add-column" onclick="addTableColumn()" style="background: rgba(255,255,255,0.2); border: 1px solid rgba(255,255,255,0.3); color: white; padding: 4px 8px; border-radius: 4px; font-size: 12px; margin-right: 5px; cursor: pointer;">
                        <i class="fa fa-plus"></i> Add Column
                    </button>
                    <button type="button" class="btn-remove-column" onclick="removeTableColumn()" style="background: rgba(255,255,255,0.2); border: 1px solid rgba(255,255,255,0.3); color: white; padding: 4px 8px; border-radius: 4px; font-size: 12px; cursor: pointer;">
                        <i class="fa fa-minus"></i> Remove Column
                    </button>
                </div>
            </div>
            <div class="table-content">
                {{fee_groups_table}}
            </div>
        </div>`
    });

    // Dynamic Column Management Functions
    window.addTableColumn = function() {
        const tableContainer = document.querySelector('.fee-groups-table-container');
        if (!tableContainer) return;
        
        const currentColumns = tableContainer.querySelectorAll('th').length;
        const maxColumns = 10; // Maximum allowed columns
        
        if (currentColumns >= maxColumns) {
            alert('Maximum ' + maxColumns + ' columns allowed');
            return;
        }
        
        // Add new column header
        const headerRow = tableContainer.querySelector('thead tr');
        if (headerRow) {
            const newHeader = document.createElement('th');
            newHeader.style.cssText = 'padding: 8px; border: 1px solid #ddd; background: #f8f9fa; text-align: center; font-weight: 600;';
            newHeader.textContent = 'Custom ' + (currentColumns + 1);
            newHeader.contentEditable = true;
            headerRow.appendChild(newHeader);
        }
        
        // Add new column cells to all data rows
        const dataRows = tableContainer.querySelectorAll('tbody tr');
        dataRows.forEach(row => {
            const newCell = document.createElement('td');
            newCell.style.cssText = 'padding: 8px; border: 1px solid #ddd; text-align: center;';
            newCell.textContent = '-';
            newCell.contentEditable = true;
            row.appendChild(newCell);
        });
        
        updateColumnCount();
    };
    
    window.removeTableColumn = function() {
        const tableContainer = document.querySelector('.fee-groups-table-container');
        if (!tableContainer) return;
        
        const currentColumns = tableContainer.querySelectorAll('th').length;
        const minColumns = 3; // Minimum required columns
        
        if (currentColumns <= minColumns) {
            alert('Minimum ' + minColumns + ' columns required');
            return;
        }
        
        // Remove last column header
        const headerRow = tableContainer.querySelector('thead tr');
        if (headerRow && headerRow.lastElementChild) {
            headerRow.removeChild(headerRow.lastElementChild);
        }
        
        // Remove last column cells from all data rows
        const dataRows = tableContainer.querySelectorAll('tbody tr');
        dataRows.forEach(row => {
            if (row.lastElementChild) {
                row.removeChild(row.lastElementChild);
            }
        });
        
        updateColumnCount();
    };
    
    window.updateColumnCount = function() {
        const tableContainer = document.querySelector('.fee-groups-table-container');
        if (!tableContainer) return;
        
        const columnCount = tableContainer.querySelectorAll('th').length;
        const countDisplay = tableContainer.querySelector('.column-count');
        if (countDisplay) {
            countDisplay.textContent = columnCount + ' Columns';
        }
    };

    // Enhanced Fee Groups Table Block
    editor.BlockManager.add('enhanced-fee-table', {
        label: '<i class="fa fa-table" style="margin-right: 5px; color: #28a745;"></i>Enhanced Fee Table',
        category: 'Dynamic Tables',
        attributes: { class: 'gjs-block-enhanced-table' },
        content: `
        <div class="enhanced-fee-table" style="margin: 20px 0; border: 1px solid #dee2e6; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
            <div class="table-header" style="background: linear-gradient(135deg, #28a745 0%, #20692e 100%); color: white; padding: 15px; display: flex; justify-content: space-between; align-items: center;">
                <div>
                    <h4 style="margin: 0; font-size: 18px; font-weight: 600;">Fee History & Payment Details</h4>
                    <small style="opacity: 0.9; font-size: 12px;">Manage columns dynamically</small>
                </div>
                <div class="table-controls" style="display: flex; gap: 8px; align-items: center;">
                    <span class="column-count" style="background: rgba(255,255,255,0.2); padding: 4px 8px; border-radius: 4px; font-size: 12px;">8 Columns</span>
                    <button type="button" class="btn-add-column" onclick="addTableColumn()" style="background: rgba(255,255,255,0.2); border: 1px solid rgba(255,255,255,0.3); color: white; padding: 6px 10px; border-radius: 4px; font-size: 12px; cursor: pointer; transition: all 0.3s;">
                        <i class="fa fa-plus"></i> Add
                    </button>
                    <button type="button" class="btn-remove-column" onclick="removeTableColumn()" style="background: rgba(255,255,255,0.2); border: 1px solid rgba(255,255,255,0.3); color: white; padding: 6px 10px; border-radius: 4px; font-size: 12px; cursor: pointer; transition: all 0.3s;">
                        <i class="fa fa-minus"></i> Remove
                    </button>
                </div>
            </div>
            <div class="table-content" style="overflow-x: auto;">
                <table style="width: 100%; border-collapse: collapse; font-size: 14px;">
                    <thead>
                        <tr style="background: #f8f9fa;">
                            <th style="padding: 12px 8px; border: 1px solid #ddd; text-align: center; font-weight: 600; min-width: 40px;">#</th>
                            <th style="padding: 12px 8px; border: 1px solid #ddd; text-align: left; font-weight: 600; min-width: 120px;">Fee Group</th>
                            <th style="padding: 12px 8px; border: 1px solid #ddd; text-align: right; font-weight: 600; min-width: 80px;">Amount</th>
                            <th style="padding: 12px 8px; border: 1px solid #ddd; text-align: right; font-weight: 600; min-width: 80px;">Discount</th>
                            <th style="padding: 12px 8px; border: 1px solid #ddd; text-align: right; font-weight: 600; min-width: 80px;">Fine</th>
                            <th style="padding: 12px 8px; border: 1px solid #ddd; text-align: right; font-weight: 600; min-width: 80px;">Paid</th>
                            <th style="padding: 12px 8px; border: 1px solid #ddd; text-align: right; font-weight: 600; min-width: 80px;">Balance</th>
                            <th style="padding: 12px 8px; border: 1px solid #ddd; text-align: center; font-weight: 600; min-width: 80px;">Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        {{fee_groups_table}}
                    </tbody>
                    <tfoot>
                        <tr style="background: #e9ecef; font-weight: 600;">
                            <td colspan="2" style="padding: 12px 8px; border: 1px solid #ddd; text-align: right;">Total:</td>
                            <td style="padding: 12px 8px; border: 1px solid #ddd; text-align: right;">{{total_fee_amount}}</td>
                            <td style="padding: 12px 8px; border: 1px solid #ddd; text-align: right;">{{total_discount_amount}}</td>
                            <td style="padding: 12px 8px; border: 1px solid #ddd; text-align: right;">{{total_fine_amount}}</td>
                            <td style="padding: 12px 8px; border: 1px solid #ddd; text-align: right;">{{total_paid_amount}}</td>
                            <td style="padding: 12px 8px; border: 1px solid #ddd; text-align: right;">{{total_balance}}</td>
                            <td style="padding: 12px 8px; border: 1px solid #ddd; text-align: center;">-</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>`
    });

    // Detailed Fee Group Payment Variables
    editor.BlockManager.add('discount-amount-1', {
        label: '<i class="fa fa-percent" style="margin-right: 5px; color: #fd7e14;"></i>Discount Amount 1',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{discount_amount_1}}</span>'
    });

    editor.BlockManager.add('discount-amount-2', {
        label: '<i class="fa fa-percent" style="margin-right: 5px; color: #fd7e14;"></i>Discount Amount 2',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{discount_amount_2}}</span>'
    });

    editor.BlockManager.add('discount-amount-3', {
        label: '<i class="fa fa-percent" style="margin-right: 5px; color: #fd7e14;"></i>Discount Amount 3',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{discount_amount_3}}</span>'
    });

    editor.BlockManager.add('fine-amount-1', {
        label: '<i class="fa fa-exclamation-circle" style="margin-right: 5px; color: #fd7e14;"></i>Fine Amount 1',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{fine_amount_1}}</span>'
    });

    editor.BlockManager.add('fine-amount-2', {
        label: '<i class="fa fa-exclamation-circle" style="margin-right: 5px; color: #fd7e14;"></i>Fine Amount 2',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{fine_amount_2}}</span>'
    });

    editor.BlockManager.add('fine-amount-3', {
        label: '<i class="fa fa-exclamation-circle" style="margin-right: 5px; color: #fd7e14;"></i>Fine Amount 3',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{fine_amount_3}}</span>'
    });

    editor.BlockManager.add('net-amount-1', {
        label: '<i class="fa fa-calculator" style="margin-right: 5px; color: #fd7e14;"></i>Net Amount 1',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{net_amount_1}}</span>'
    });

    editor.BlockManager.add('net-amount-2', {
        label: '<i class="fa fa-calculator" style="margin-right: 5px; color: #fd7e14;"></i>Net Amount 2',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{net_amount_2}}</span>'
    });

    editor.BlockManager.add('net-amount-3', {
        label: '<i class="fa fa-calculator" style="margin-right: 5px; color: #fd7e14;"></i>Net Amount 3',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{net_amount_3}}</span>'
    });

    // Payment Status Variables
    editor.BlockManager.add('payment-status-1', {
        label: '<i class="fa fa-info-circle" style="margin-right: 5px; color: #fd7e14;"></i>Payment Status 1',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{payment_status_1}}</span>'
    });

    editor.BlockManager.add('payment-status-2', {
        label: '<i class="fa fa-info-circle" style="margin-right: 5px; color: #fd7e14;"></i>Payment Status 2',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{payment_status_2}}</span>'
    });

    editor.BlockManager.add('payment-status-3', {
        label: '<i class="fa fa-info-circle" style="margin-right: 5px; color: #fd7e14;"></i>Payment Status 3',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{payment_status_3}}</span>'
    });

    // Fee Type Variables for detailed breakdown
    editor.BlockManager.add('fee-type-1', {
        label: '<i class="fa fa-tag" style="margin-right: 5px; color: #fd7e14;"></i>Fee Type 1',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{fee_type_1}}</span>'
    });

    editor.BlockManager.add('fee-type-2', {
        label: '<i class="fa fa-tag" style="margin-right: 5px; color: #fd7e14;"></i>Fee Type 2',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{fee_type_2}}</span>'
    });

    editor.BlockManager.add('fee-type-3', {
        label: '<i class="fa fa-tag" style="margin-right: 5px; color: #fd7e14;"></i>Fee Type 3',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{fee_type_3}}</span>'
    });

    // Fee Code Variables
    editor.BlockManager.add('fee-code-1', {
        label: '<i class="fa fa-barcode" style="margin-right: 5px; color: #fd7e14;"></i>Fee Code 1',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{fee_code_1}}</span>'
    });

    editor.BlockManager.add('fee-code-2', {
        label: '<i class="fa fa-barcode" style="margin-right: 5px; color: #fd7e14;"></i>Fee Code 2',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{fee_code_2}}</span>'
    });

    editor.BlockManager.add('fee-code-3', {
        label: '<i class="fa fa-barcode" style="margin-right: 5px; color: #fd7e14;"></i>Fee Code 3',
        category: 'Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{fee_code_3}}</span>'
    });

    // Payment History Variables for detailed tracking
    editor.BlockManager.add('payment-history-table', {
        label: '<i class="fa fa-history" style="margin-right: 5px; color: #28a745;"></i>Payment History Table',
        category: 'Payment History Variables',
        attributes: { class: 'gjs-block-table' },
        content: `<table style="width: 100%; border-collapse: collapse; margin: 10px 0; font-family: Arial, sans-serif;">
            <thead>
                <tr style="background-color: #f8f9fa; border: 1px solid #dee2e6;">
                    <th style="padding: 8px; border: 1px solid #dee2e6; text-align: left;">Fee Group</th>
                    <th style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">Amount</th>
                    <th style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">Discount</th>
                    <th style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">Fine</th>
                    <th style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">Paid</th>
                    <th style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">Balance</th>
                    <th style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">Status</th>
                </tr>
            </thead>
            <tbody>
                <tr style="border: 1px solid #dee2e6;">
                    <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_1}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_1}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{discount_amount_1}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fine_amount_1}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_1}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_1}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{payment_status_1}}</td>
                </tr>
                <tr style="border: 1px solid #dee2e6;">
                    <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_2}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_2}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{discount_amount_2}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fine_amount_2}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_2}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_2}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{payment_status_2}}</td>
                </tr>
                <tr style="border: 1px solid #dee2e6;">
                    <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_3}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_3}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{discount_amount_3}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fine_amount_3}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_3}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_3}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{payment_status_3}}</td>
                </tr>
                <tr style="background-color: #f8f9fa; border: 2px solid #007bff; font-weight: bold;">
                    <td style="padding: 8px; border: 1px solid #dee2e6;">TOTAL</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{total_fee_amount}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{total_discount_amount}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{total_fine_amount}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{total_paid_amount}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{total_balance}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">-</td>
                </tr>
            </tbody>
        </table>`
    });

    // Payment History Variables for 15 Groups
    editor.BlockManager.add('payment-history-table-15groups', {
        label: '<i class="fa fa-history" style="margin-right: 5px; color: #dc3545;"></i>Payment History Table (15 Groups)',
        category: 'Payment History Variables',
        attributes: { class: 'gjs-block-table' },
        content: `<table style="width: 100%; border-collapse: collapse; margin: 10px 0; font-family: Arial, sans-serif;">
            <thead>
                <tr style="background-color: #dc3545; color: white; border: 1px solid #dee2e6;">
                    <th style="padding: 8px; border: 1px solid #dee2e6; text-align: left;">Fee Group</th>
                    <th style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">Amount</th>
                    <th style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">Discount</th>
                    <th style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">Fine</th>
                    <th style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">Paid</th>
                    <th style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">Balance</th>
                    <th style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">Status</th>
                </tr>
            </thead>
            <tbody>
                <tr style="border: 1px solid #dee2e6;">
                    <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_1}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_1}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{discount_amount_1}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fine_amount_1}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_1}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_1}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{payment_status_1}}</td>
                </tr>
                <tr style="border: 1px solid #dee2e6;">
                    <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_2}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_2}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{discount_amount_2}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fine_amount_2}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_2}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_2}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{payment_status_2}}</td>
                </tr>
                <tr style="border: 1px solid #dee2e6;">
                    <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_3}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_3}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{discount_amount_3}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fine_amount_3}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_3}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_3}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{payment_status_3}}</td>
                </tr>
                <tr style="border: 1px solid #dee2e6;">
                    <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_4}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_4}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{discount_amount_4}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fine_amount_4}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_4}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_4}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{payment_status_4}}</td>
                </tr>
                <tr style="border: 1px solid #dee2e6;">
                    <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_5}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_5}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{discount_amount_5}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fine_amount_5}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_5}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_5}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{payment_status_5}}</td>
                </tr>
                <tr style="border: 1px solid #dee2e6;">
                    <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_6}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_6}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{discount_amount_6}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fine_amount_6}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_6}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_6}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{payment_status_6}}</td>
                </tr>
                <tr style="border: 1px solid #dee2e6;">
                    <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_7}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_7}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{discount_amount_7}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fine_amount_7}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_7}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_7}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{payment_status_7}}</td>
                </tr>
                <tr style="border: 1px solid #dee2e6;">
                    <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_8}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_8}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{discount_amount_8}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fine_amount_8}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_8}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_8}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{payment_status_8}}</td>
                </tr>
                <tr style="border: 1px solid #dee2e6;">
                    <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_9}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_9}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{discount_amount_9}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fine_amount_9}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_9}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_9}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{payment_status_9}}</td>
                </tr>
                <tr style="border: 1px solid #dee2e6;">
                    <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_10}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_10}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{discount_amount_10}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fine_amount_10}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_10}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_10}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{payment_status_10}}</td>
                </tr>
                <tr style="border: 1px solid #dee2e6;">
                    <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_11}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_11}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{discount_amount_11}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fine_amount_11}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_11}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_11}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{payment_status_11}}</td>
                </tr>
                <tr style="border: 1px solid #dee2e6;">
                    <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_12}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_12}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{discount_amount_12}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fine_amount_12}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_12}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_12}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{payment_status_12}}</td>
                </tr>
                <tr style="border: 1px solid #dee2e6;">
                    <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_13}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_13}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{discount_amount_13}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fine_amount_13}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_13}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_13}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{payment_status_13}}</td>
                </tr>
                <tr style="border: 1px solid #dee2e6;">
                    <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_14}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_14}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{discount_amount_14}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fine_amount_14}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_14}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_14}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{payment_status_14}}</td>
                </tr>
                <tr style="border: 1px solid #dee2e6;">
                    <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_15}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_15}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{discount_amount_15}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fine_amount_15}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_15}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_15}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{payment_status_15}}</td>
                </tr>
                <tr style="background-color: #dc3545; color: white; border: 2px solid #dc3545; font-weight: bold;">
                    <td style="padding: 8px; border: 1px solid #dee2e6;">TOTAL</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{total_fee_amount}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{total_discount_amount}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{total_fine_amount}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{total_paid_amount}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{total_balance}}</td>
                    <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">-</td>
                </tr>
            </tbody>
        </table>`
    });

    // Additional Total Variables for comprehensive breakdown
    editor.BlockManager.add('total-discount-amount', {
        label: '<i class="fa fa-percent" style="margin-right: 5px; color: #e83e8c;"></i>Total Discount Amount',
        category: 'Total Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #f8e6f0 0%, #f2d7e6 100%); padding: 4px 8px; border: 1px solid #e83e8c; border-radius: 4px; color: #7a1e48; font-weight: 500; font-size: 14px;">{{total_discount_amount}}</span>'
    });

    editor.BlockManager.add('total-fine-amount', {
        label: '<i class="fa fa-exclamation-triangle" style="margin-right: 5px; color: #e83e8c;"></i>Total Fine Amount',
        category: 'Total Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #f8e6f0 0%, #f2d7e6 100%); padding: 4px 8px; border: 1px solid #e83e8c; border-radius: 4px; color: #7a1e48; font-weight: 500; font-size: 14px;">{{total_fine_amount}}</span>'
    });

    editor.BlockManager.add('grand-total', {
        label: '<i class="fa fa-coins" style="margin-right: 5px; color: #e83e8c;"></i>Grand Total',
        category: 'Total Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #f8e6f0 0%, #f2d7e6 100%); padding: 4px 8px; border: 1px solid #e83e8c; border-radius: 4px; color: #7a1e48; font-weight: 500; font-size: 14px;">{{grand_total}}</span>'
    });

    editor.BlockManager.add('grand-total', {
        label: '<i class="fa fa-trophy" style="margin-right: 5px; color: #e83e8c;"></i>Grand Total',
        category: 'Total Table Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #f8e6f0 0%, #f2d7e6 100%); padding: 4px 8px; border: 1px solid #e83e8c; border-radius: 4px; color: #7a1e48; font-weight: 500; font-size: 14px;">{{grand_total}}</span>'
    });

    // Advanced Fee Components
    editor.BlockManager.add('fee-installment-plan', {
        label: '<i class="fa fa-list-ol" style="margin-right: 5px; color: #e83e8c;"></i>Fee Installment Plan',
        category: 'Advanced Fee Components',
        attributes: { class: 'gjs-block-advanced-fee' },
        content: `
            <div style="margin: 20px 0; border: 1px solid #dee2e6; border-radius: 10px; overflow: hidden; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
                <div style="background: linear-gradient(135deg, #e83e8c 0%, #c2185b 100%); color: white; padding: 15px; font-weight: bold; text-align: center;">
                    <i class="fa fa-calendar-check" style="margin-right: 8px;"></i>Fee Installment Plan - {{academic_year}}
                </div>
                <div style="padding: 20px;">
                    <div style="display: grid; grid-template-columns: 1fr 1fr 1fr 1fr; gap: 10px; margin-bottom: 15px; font-weight: bold; padding: 10px; background: #f8f9fa; border-radius: 5px;">
                        <div>Installment</div>
                        <div>Due Date</div>
                        <div>Amount</div>
                        <div>Status</div>
                    </div>
                    <div style="display: grid; grid-template-columns: 1fr 1fr 1fr 1fr; gap: 10px; margin-bottom: 10px; padding: 8px; border-bottom: 1px solid #eee;">
                        <div style="font-weight: 500;">1st Quarter</div>
                        <div>{{installment_1_due_date}}</div>
                        <div style="color: #28a745; font-weight: bold;">{{installment_1_amount}}</div>
                        <div><span style="background: #28a745; color: white; padding: 2px 8px; border-radius: 12px; font-size: 11px;">{{installment_1_status}}</span></div>
                    </div>
                    <div style="display: grid; grid-template-columns: 1fr 1fr 1fr 1fr; gap: 10px; margin-bottom: 10px; padding: 8px; border-bottom: 1px solid #eee;">
                        <div style="font-weight: 500;">2nd Quarter</div>
                        <div>{{installment_2_due_date}}</div>
                        <div style="color: #28a745; font-weight: bold;">{{installment_2_amount}}</div>
                        <div><span style="background: #ffc107; color: #212529; padding: 2px 8px; border-radius: 12px; font-size: 11px;">{{installment_2_status}}</span></div>
                    </div>
                    <div style="display: grid; grid-template-columns: 1fr 1fr 1fr 1fr; gap: 10px; margin-bottom: 10px; padding: 8px; border-bottom: 1px solid #eee;">
                        <div style="font-weight: 500;">3rd Quarter</div>
                        <div>{{installment_3_due_date}}</div>
                        <div style="color: #28a745; font-weight: bold;">{{installment_3_amount}}</div>
                        <div><span style="background: #dc3545; color: white; padding: 2px 8px; border-radius: 12px; font-size: 11px;">{{installment_3_status}}</span></div>
                    </div>
                    <div style="display: grid; grid-template-columns: 1fr 1fr 1fr 1fr; gap: 10px; margin-bottom: 15px; padding: 8px;">
                        <div style="font-weight: 500;">4th Quarter</div>
                        <div>{{installment_4_due_date}}</div>
                        <div style="color: #28a745; font-weight: bold;">{{installment_4_amount}}</div>
                        <div><span style="background: #6c757d; color: white; padding: 2px 8px; border-radius: 12px; font-size: 11px;">{{installment_4_status}}</span></div>
                    </div>
                    <div style="background: #e9ecef; padding: 12px; border-radius: 5px; display: flex; justify-content: space-between; font-weight: bold;">
                        <span>Total Annual Fee:</span>
                        <span style="color: #28a745;">{{total_annual_fee}}</span>
                    </div>
                </div>
            </div>
        `
    });

    // Fee Discount & Concession Component
    editor.BlockManager.add('fee-discount-details', {
        label: '<i class="fa fa-percent" style="margin-right: 5px; color: #20c997;"></i>Discount & Concession',
        category: 'Advanced Fee Components',
        attributes: { class: 'gjs-block-advanced-fee' },
        content: `
            <div style="margin: 20px 0; border: 1px solid #dee2e6; border-radius: 8px; overflow: hidden;">
                <div style="background: linear-gradient(135deg, #20c997 0%, #17a085 100%); color: white; padding: 12px; font-weight: bold; text-align: center;">
                    <i class="fa fa-tags" style="margin-right: 8px;"></i>Fee Discounts & Concessions
                </div>
                <div style="padding: 15px;">
                    <div style="margin-bottom: 12px; padding: 10px; background: #f8f9fa; border-radius: 5px; border-left: 4px solid #20c997;">
                        <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                            <span style="font-weight: bold;">Merit Scholarship:</span>
                            <span style="color: #20c997; font-weight: bold;">-{{merit_discount}}</span>
                        </div>
                        <div style="font-size: 12px; color: #6c757d;">Academic Excellence Discount</div>
                    </div>
                    <div style="margin-bottom: 12px; padding: 10px; background: #f8f9fa; border-radius: 5px; border-left: 4px solid #17a2b8;">
                        <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                            <span style="font-weight: bold;">Sibling Discount:</span>
                            <span style="color: #17a2b8; font-weight: bold;">-{{sibling_discount}}</span>
                        </div>
                        <div style="font-size: 12px; color: #6c757d;">Family Concession</div>
                    </div>
                    <div style="margin-bottom: 12px; padding: 10px; background: #f8f9fa; border-radius: 5px; border-left: 4px solid #ffc107;">
                        <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                            <span style="font-weight: bold;">Early Payment Discount:</span>
                            <span style="color: #ffc107; font-weight: bold;">-{{early_payment_discount}}</span>
                        </div>
                        <div style="font-size: 12px; color: #6c757d;">Paid before due date</div>
                    </div>
                    <div style="margin-bottom: 15px; padding: 10px; background: #f8f9fa; border-radius: 5px; border-left: 4px solid #6f42c1;">
                        <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                            <span style="font-weight: bold;">Special Concession:</span>
                            <span style="color: #6f42c1; font-weight: bold;">-{{special_concession}}</span>
                        </div>
                        <div style="font-size: 12px; color: #6c757d;">{{concession_reason}}</div>
                    </div>
                    <hr style="margin: 15px 0;">
                    <div style="display: flex; justify-content: space-between; padding: 10px; background: #28a745; color: white; border-radius: 5px; font-weight: bold;">
                        <span>Total Discount Applied:</span>
                        <span>-{{total_discount}}</span>
                    </div>
                </div>
            </div>
        `
    });

    // Late Fee & Penalty Component
    editor.BlockManager.add('late-fee-penalty', {
        label: '<i class="fa fa-exclamation-circle" style="margin-right: 5px; color: #dc3545;"></i>Late Fee & Penalty',
        category: 'Advanced Fee Components',
        attributes: { class: 'gjs-block-advanced-fee' },
        content: `
            <div style="margin: 20px 0; border: 1px solid #dc3545; border-radius: 8px; overflow: hidden; background: #fff5f5;">
                <div style="background: linear-gradient(135deg, #dc3545 0%, #c82333 100%); color: white; padding: 12px; font-weight: bold; text-align: center;">
                    <i class="fa fa-clock" style="margin-right: 8px;"></i>Late Fee & Penalty Details
                </div>
                <div style="padding: 15px;">
                    <div style="margin-bottom: 12px; padding: 10px; background: #f8d7da; border-radius: 5px; border-left: 4px solid #dc3545;">
                        <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                            <span style="font-weight: bold;">Late Fee ({{days_overdue}} days):</span>
                            <span style="color: #dc3545; font-weight: bold;">+{{late_fee_amount}}</span>
                        </div>
                        <div style="font-size: 12px; color: #721c24;">Payment overdue since {{overdue_date}}</div>
                    </div>
                    <div style="margin-bottom: 12px; padding: 10px; background: #fff3cd; border-radius: 5px; border-left: 4px solid #ffc107;">
                        <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                            <span style="font-weight: bold;">Processing Fee:</span>
                            <span style="color: #856404; font-weight: bold;">+{{processing_fee}}</span>
                        </div>
                        <div style="font-size: 12px; color: #856404;">Administrative charges</div>
                    </div>
                    <div style="margin-bottom: 15px; padding: 10px; background: #d1ecf1; border-radius: 5px; border-left: 4px solid #17a2b8;">
                        <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                            <span style="font-weight: bold;">Interest Charges:</span>
                            <span style="color: #0c5460; font-weight: bold;">+{{interest_charges}}</span>
                        </div>
                        <div style="font-size: 12px; color: #0c5460;">{{interest_rate}}% per month on overdue amount</div>
                    </div>
                    <hr style="margin: 15px 0;">
                    <div style="display: flex; justify-content: space-between; padding: 10px; background: #dc3545; color: white; border-radius: 5px; font-weight: bold;">
                        <span>Total Additional Charges:</span>
                        <span>+{{total_additional_charges}}</span>
                    </div>
                </div>
            </div>
        `
    });

    // Fee Receipt Footer with Terms
    editor.BlockManager.add('detailed-receipt-footer', {
        label: '<i class="fa fa-file-contract" style="margin-right: 5px; color: #495057;"></i>Detailed Receipt Footer',
        category: 'Advanced Fee Components',
        attributes: { class: 'gjs-block-advanced-fee' },
        content: `
            <div style="margin: 30px 0 0 0; padding: 20px; background: #f8f9fa; border-top: 3px solid #6c757d; border-radius: 0 0 8px 8px;">
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 20px;">
                    <div>
                        <h4 style="margin: 0 0 10px 0; color: #495057; font-size: 14px; border-bottom: 1px solid #dee2e6; padding-bottom: 5px;">Payment Information</h4>
                        <p style="margin: 5px 0; font-size: 12px;"><strong>Payment Mode:</strong> {{payment_mode}}</p>
                        <p style="margin: 5px 0; font-size: 12px;"><strong>Transaction ID:</strong> {{transaction_id}}</p>
                        <p style="margin: 5px 0; font-size: 12px;"><strong>Bank Reference:</strong> {{bank_reference}}</p>
                        <p style="margin: 5px 0; font-size: 12px;"><strong>Collected By:</strong> {{collected_by}}</p>
                    </div>
                    <div>
                        <h4 style="margin: 0 0 10px 0; color: #495057; font-size: 14px; border-bottom: 1px solid #dee2e6; padding-bottom: 5px;">Next Payment Due</h4>
                        <p style="margin: 5px 0; font-size: 12px;"><strong>Next Due Date:</strong> {{next_due_date}}</p>
                        <p style="margin: 5px 0; font-size: 12px;"><strong>Next Amount:</strong> {{next_due_amount}}</p>
                        <p style="margin: 5px 0; font-size: 12px;"><strong>Fee Type:</strong> {{next_fee_type}}</p>
                        <p style="margin: 5px 0; font-size: 12px; color: #dc3545;"><strong>Late Fee After:</strong> {{late_fee_date}}</p>
                    </div>
                </div>
                <div style="border-top: 1px solid #dee2e6; padding-top: 15px;">
                    <h4 style="margin: 0 0 10px 0; color: #495057; font-size: 14px;">Important Terms & Conditions</h4>
                    <ul style="margin: 0; padding-left: 20px; font-size: 11px; color: #6c757d; line-height: 1.4;">
                        <li>This receipt is valid only when payment is realized by the bank.</li>
                        <li>Late fee will be charged after the due date as per school policy.</li>
                        <li>Fee once paid is non-refundable except in special circumstances.</li>
                        <li>Please preserve this receipt for future reference and admission purposes.</li>
                        <li>For any queries, contact the accounts department during office hours.</li>
                    </ul>
                </div>
                <div style="text-align: center; margin-top: 15px; padding-top: 10px; border-top: 1px dashed #6c757d;">
                    <p style="margin: 0; font-size: 10px; color: #6c757d;">This is a computer generated receipt. Generated on {{current_date}} at {{current_time}}</p>
                    <p style="margin: 5px 0 0 0; font-size: 10px; color: #6c757d;">*** Thank you for your payment ***</p>
                </div>
            </div>
        `
    });

    // Add Student Info Component
    editor.BlockManager.add('student-info', {
        label: '<i class="fa fa-user-graduate" style="margin-right: 8px; color: #28a745;"></i>Student Info',
        category: 'Receipt Components',
        attributes: { class: 'gjs-block-student' },
        content: `
            <div style="margin: 25px 0; padding: 20px; background: linear-gradient(135deg, #e8f5e8 0%, #d4edda 100%); border-left: 5px solid #28a745; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                <h4 style="margin: 0 0 15px 0; color: #28a745; font-size: 18px; font-weight: 600; border-bottom: 1px solid #28a745; padding-bottom: 8px;">Student Information</h4>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                    <div>
                        <p style="margin: 8px 0; color: #333;"><strong>Name:</strong> {{student_name}}</p>
                        <p style="margin: 8px 0; color: #333;"><strong>Father's Name:</strong> {{father_name}}</p>
                        <p style="margin: 8px 0; color: #333;"><strong>Class:</strong> {{class_name}} - {{section_name}}</p>
                    </div>
                    <div>
                        <p style="margin: 8px 0; color: #333;"><strong>Admission No:</strong> {{admission_no}}</p>
                        <p style="margin: 8px 0; color: #333;"><strong>Roll No:</strong> {{roll_no}}</p>
                        <p style="margin: 8px 0; color: #333;"><strong>Session:</strong> {{academic_year}}</p>
                    </div>
                </div>
            </div>
        `
    });

    // Add Fee Table Component
    editor.BlockManager.add('fee-table', {
        label: '<i class="fa fa-table" style="margin-right: 8px; color: #007bff;"></i>Fee Table',
        category: 'Receipt Components',
        attributes: { class: 'gjs-block-fee-table' },
        content: `
            <div style="margin: 25px 0; border: 1px solid #dee2e6; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                <table style="width: 100%; border-collapse: collapse;">
                    <thead>
                        <tr style="background: linear-gradient(135deg, #007bff 0%, #0056b3 100%); color: white;">
                            <th style="padding: 12px; text-align: left; font-weight: 600;">Fee Type</th>
                            <th style="padding: 12px; text-align: right; font-weight: 600;">Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr style="background: white;">
                            <td style="padding: 10px 12px; border-bottom: 1px solid #e9ecef;">Tuition Fee</td>
                            <td style="padding: 10px 12px; border-bottom: 1px solid #e9ecef; text-align: right;">₹{{tuition_fee}}</td>
                        </tr>
                        <tr style="background: #f8f9fa;">
                            <td style="padding: 10px 12px; border-bottom: 1px solid #e9ecef;">Transport Fee</td>
                            <td style="padding: 10px 12px; border-bottom: 1px solid #e9ecef; text-align: right;">₹{{transport_fee}}</td>
                        </tr>
                        <tr style="background: white;">
                            <td style="padding: 10px 12px; border-bottom: 1px solid #e9ecef;">Library Fee</td>
                            <td style="padding: 10px 12px; border-bottom: 1px solid #e9ecef; text-align: right;">₹{{library_fee}}</td>
                        </tr>
                        <tr style="background: linear-gradient(135deg, #28a745 0%, #20c997 100%); color: white;">
                            <td style="padding: 12px; font-weight: 700;">Total Amount</td>
                            <td style="padding: 12px; text-align: right; font-weight: 700;">₹{{total_amount}}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        `
    });

    // Add Payment Info Component
    editor.BlockManager.add('payment-info', {
        label: '<i class="fa fa-credit-card" style="margin-right: 8px; color: #ffc107;"></i>Payment Info',
        category: 'Receipt Components',
        attributes: { class: 'gjs-block-payment' },
        content: `
            <div style="margin: 25px 0; padding: 20px; background: linear-gradient(135deg, #fff8e1 0%, #ffecb3 100%); border: 1px solid #ffc107; border-radius: 8px;">
                <h4 style="margin: 0 0 15px 0; color: #f57c00; font-size: 16px; font-weight: 600;">Payment Details</h4>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                    <div>
                        <p style="margin: 5px 0; color: #333;"><strong>Payment Mode:</strong> {{payment_mode}}</p>
                        <p style="margin: 5px 0; color: #333;"><strong>Payment Date:</strong> {{payment_date}}</p>
                    </div>
                    <div>
                        <p style="margin: 5px 0; color: #333;"><strong>Receipt No:</strong> {{receipt_no}}</p>
                        <p style="margin: 5px 0; color: #333;"><strong>Collected By:</strong> {{collected_by}}</p>
                    </div>
                </div>
                <div style="margin-top: 15px; padding: 10px; background: rgba(255,193,7,0.2); border-radius: 4px;">
                    <p style="margin: 0; color: #333; font-weight: 500;">Amount in Words: {{total_amount_words}}</p>
                </div>
            </div>
        `
    });

    // Add Receipt Footer Component
    editor.BlockManager.add('receipt-footer', {
        label: '<i class="fa fa-file-signature" style="margin-right: 8px; color: #6c757d;"></i>Receipt Footer',
        category: 'Receipt Components',
        attributes: { class: 'gjs-block-footer' },
        content: `
            <div style="margin: 30px 0 0 0; padding: 20px; background: #f8f9fa; border-top: 2px solid #6c757d; text-align: center;">
                <p style="margin: 10px 0; font-size: 12px; color: #666;">This is a computer generated receipt.</p>
                <p style="margin: 10px 0; font-size: 12px; color: #666;">Generated on: {{current_date}} at {{current_time}}</p>
                <div style="margin-top: 20px; display: flex; justify-content: space-between;">
                    <div style="text-align: left;">
                        <p style="margin: 0; font-size: 12px; color: #666;">Student Signature</p>
                        <div style="border-top: 1px solid #666; width: 150px; margin-top: 30px;"></div>
                    </div>
                    <div style="text-align: right;">
                        <p style="margin: 0; font-size: 12px; color: #666;">Authorized Signature</p>
                        <div style="border-top: 1px solid #666; width: 150px; margin-top: 30px;"></div>
                    </div>
                </div>
            </div>
        `
    });

    // Add Invoice Components
    editor.BlockManager.add('invoice-header', {
        label: '<i class="fa fa-file-invoice" style="margin-right: 8px; color: #6f42c1;"></i>Invoice Header',
        category: 'Invoice Components',
        attributes: { class: 'gjs-block-invoice' },
        content: `
            <div style="display: flex; justify-content: space-between; align-items: start; padding: 25px; border-bottom: 3px solid #6f42c1; margin-bottom: 25px; background: linear-gradient(135deg, #f8f6ff 0%, #e9ecef 100%);">
                <div>
                    <h2 style="margin: 0; color: #333; font-size: 28px; font-weight: 700;">{{school_name}}</h2>
                    <p style="margin: 8px 0; font-size: 15px; color: #666;">{{school_address}}</p>
                    <p style="margin: 8px 0; font-size: 14px; color: #666;">Phone: {{school_phone}} | Email: {{school_email}}</p>
                </div>
                <div style="text-align: right;">
                    <h3 style="color: #6f42c1; margin: 0; font-size: 24px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px;">INVOICE</h3>
                    <p style="margin: 8px 0; font-size: 16px; color: #333;"><strong>Invoice #:</strong> {{invoice_no}}</p>
                    <p style="margin: 8px 0; font-size: 14px; color: #666;">Date: {{invoice_date}}</p>
                    <p style="margin: 8px 0; font-size: 14px; color: #666;">Due Date: {{due_date}}</p>
                </div>
            </div>
        `
    });

    editor.BlockManager.add('billing-info', {
        label: '<i class="fa fa-address-card" style="margin-right: 8px; color: #e83e8c;"></i>Billing Info',
        category: 'Invoice Components',
        attributes: { class: 'gjs-block-billing' },
        content: `
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 30px; margin: 25px 0; padding: 20px; background: linear-gradient(135deg, #fff5f8 0%, #f8f9fa 100%); border-radius: 8px; border: 1px solid #e83e8c;">
                <div>
                    <h4 style="margin: 0 0 15px 0; color: #e83e8c; font-size: 18px; font-weight: 600; border-bottom: 2px solid #e83e8c; padding-bottom: 5px;">Bill To:</h4>
                    <p style="margin: 5px 0; color: #333; font-weight: 600;">{{student_name}}</p>
                    <p style="margin: 5px 0; color: #666;">{{father_name}}</p>
                    <p style="margin: 5px 0; color: #666;">{{student_address}}</p>
                    <p style="margin: 5px 0; color: #666;">Phone: {{parent_phone}}</p>
                </div>
                <div>
                    <h4 style="margin: 0 0 15px 0; color: #e83e8c; font-size: 18px; font-weight: 600; border-bottom: 2px solid #e83e8c; padding-bottom: 5px;">Student Details:</h4>
                    <p style="margin: 5px 0; color: #333;"><strong>Admission No:</strong> {{admission_no}}</p>
                    <p style="margin: 5px 0; color: #333;"><strong>Class:</strong> {{class_name}} - {{section_name}}</p>
                    <p style="margin: 5px 0; color: #333;"><strong>Roll No:</strong> {{roll_no}}</p>
                    <p style="margin: 5px 0; color: #333;"><strong>Session:</strong> {{academic_year}}</p>
                </div>
            </div>
        `
    });

    editor.BlockManager.add('detailed-fee-table', {
        label: '<i class="fa fa-table" style="margin-right: 8px; color: #fd7e14;"></i>Detailed Fee Table',
        category: 'Invoice Components',
        attributes: { class: 'gjs-block-detailed-table' },
        content: `
            <div style="margin: 25px 0; box-shadow: 0 4px 6px rgba(0,0,0,0.1); border-radius: 8px; overflow: hidden;">
                <table style="width: 100%; border-collapse: collapse;">
                    <thead>
                        <tr style="background: linear-gradient(135deg, #fd7e14 0%, #e55a00 100%); color: white;">
                            <th style="padding: 15px; text-align: left; font-size: 16px; font-weight: 600;">Description</th>
                            <th style="padding: 15px; text-align: center; font-size: 16px; font-weight: 600;">Period</th>
                            <th style="padding: 15px; text-align: right; font-size: 16px; font-weight: 600;">Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr style="background: white;">
                            <td style="padding: 12px 15px; border-bottom: 1px solid #e9ecef; color: #333;">Tuition Fee</td>
                            <td style="padding: 12px 15px; border-bottom: 1px solid #e9ecef; text-align: center; color: #666;">{{fee_month}}</td>
                            <td style="padding: 12px 15px; border-bottom: 1px solid #e9ecef; text-align: right; color: #333; font-weight: 500;">₹{{tuition_fee}}</td>
                        </tr>
                        <tr style="background: #f8f9fa;">
                            <td style="padding: 12px 15px; border-bottom: 1px solid #e9ecef; color: #333;">Transport Fee</td>
                            <td style="padding: 12px 15px; border-bottom: 1px solid #e9ecef; text-align: center; color: #666;">{{fee_month}}</td>
                            <td style="padding: 12px 15px; border-bottom: 1px solid #e9ecef; text-align: right; color: #333; font-weight: 500;">₹{{transport_fee}}</td>
                        </tr>
                        <tr style="background: white;">
                            <td style="padding: 12px 15px; border-bottom: 1px solid #e9ecef; color: #333;">Library Fee</td>
                            <td style="padding: 12px 15px; border-bottom: 1px solid #e9ecef; text-align: center; color: #666;">{{fee_month}}</td>
                            <td style="padding: 12px 15px; border-bottom: 1px solid #e9ecef; text-align: right; color: #333; font-weight: 500;">₹{{library_fee}}</td>
                        </tr>
                        <tr style="background: #f8f9fa;">
                            <td style="padding: 12px 15px; border-bottom: 1px solid #e9ecef; color: #333;">Activity Fee</td>
                            <td style="padding: 12px 15px; border-bottom: 1px solid #e9ecef; text-align: center; color: #666;">{{fee_month}}</td>
                            <td style="padding: 12px 15px; border-bottom: 1px solid #e9ecef; text-align: right; color: #333; font-weight: 500;">₹{{activity_fee}}</td>
                        </tr>
                        <tr style="background: linear-gradient(135deg, #28a745 0%, #20c997 100%); color: white;">
                            <td style="padding: 15px; font-weight: 700; font-size: 16px;" colspan="2">Total Amount</td>
                            <td style="padding: 15px; text-align: right; font-weight: 700; font-size: 18px;">₹{{total_amount}}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        `
    });

    // Add Additional Components with editable images
    editor.BlockManager.add('school-logo', {
        label: '<i class="fa fa-image" style="margin-right: 8px; color: #17a2b8;"></i>School Logo',
        category: 'Additional Components',
        attributes: { class: 'gjs-block-logo' },
        content: {
            type: 'default',
            tagName: 'div',
            style: {
                'text-align': 'center',
                'margin': '20px 0',
                'padding': '15px',
                'background': '#f8f9fa',
                'border': '2px dashed #17a2b8',
                'border-radius': '8px'
            },
            components: [
                {
                    type: 'image',
                    attributes: {
                        src: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTIwIiBoZWlnaHQ9IjEyMCIgdmlld0JveD0iMCAwIDEyMCAxMjAiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+CjxyZWN0IHdpZHRoPSIxMjAiIGhlaWdodD0iMTIwIiBmaWxsPSIjZTllY2VmIi8+CjxwYXRoIGQ9Ik00MCA0MEg4MFY4MEg0MFY0MFoiIGZpbGw9IiM2Yzc1N2QiLz4KPHN2Zz4K',
                        alt: 'School Logo'
                    },
                    style: {
                        'max-width': '120px',
                        'max-height': '120px',
                        'border-radius': '8px',
                        'box-shadow': '0 2px 4px rgba(0,0,0,0.1)',
                        'cursor': 'pointer'
                    },
                    traits: [
                        {
                            type: 'button',
                            name: 'upload-logo',
                            label: 'Upload School Logo',
                            text: 'Choose File',
                            command: function(editor, component) {
                                var input = document.createElement('input');
                                input.type = 'file';
                                input.accept = 'image/*';
                                input.onchange = function(e) {
                                    var file = e.target.files[0];
                                    if (file) {
                                        var reader = new FileReader();
                                        reader.onload = function(event) {
                                            component.set('src', event.target.result);
                                            component.set('alt', file.name);
                                        };
                                        reader.readAsDataURL(file);
                                    }
                                };
                                input.click();
                            }
                        },
                        {
                            type: 'text',
                            name: 'alt',
                            label: 'Alt Text'
                        },
                        {
                            type: 'number',
                            name: 'width',
                            label: 'Width (px)',
                            min: 50,
                            max: 300
                        },
                        {
                            type: 'number',
                            name: 'height',
                            label: 'Height (px)',
                            min: 50,
                            max: 300
                        }
                    ],
                    resizable: true,
                    editable: false
                },
                {
                    type: 'text',
                    tagName: 'p',
                    content: 'School Logo',
                    style: {
                        'margin': '10px 0 0 0',
                        'font-size': '12px',
                        'color': '#6c757d'
                    },
                    editable: true
                }
            ],
            droppable: false,
            resizable: true
        }
    });

    editor.BlockManager.add('qr-code', {
        label: '<i class="fa fa-qrcode" style="margin-right: 8px; color: #6f42c1;"></i>QR Code',
        category: 'Additional Components',
        attributes: { class: 'gjs-block-qr' },
        content: {
            type: 'default',
            tagName: 'div',
            style: {
                'text-align': 'center',
                'margin': '20px 0',
                'padding': '15px',
                'background': '#f8f6ff',
                'border': '2px dashed #6f42c1',
                'border-radius': '8px'
            },
            components: [
                {
                    type: 'image',
                    attributes: {
                        src: 'https://api.qrserver.com/v1/create-qr-code/?size=100x100&data={{receipt_no}}',
                        alt: 'QR Code for {{receipt_no}}'
                    },
                    style: {
                        'width': '100px',
                        'height': '100px',
                        'margin': '0 auto',
                        'border-radius': '4px',
                        'cursor': 'pointer'
                    },
                    traits: [
                        {
                            type: 'text',
                            name: 'src',
                            label: 'QR Code URL',
                            placeholder: 'Enter QR code URL or use API'
                        },
                        {
                            type: 'select',
                            name: 'qr-size',
                            label: 'QR Code Size',
                            options: [
                                { value: '80x80', name: 'Small (80x80)' },
                                { value: '100x100', name: 'Medium (100x100)' },
                                { value: '150x150', name: 'Large (150x150)' },
                                { value: '200x200', name: 'Extra Large (200x200)' }
                            ],
                            changeProp: 1
                        },
                        {
                            type: 'text',
                            name: 'qr-data',
                            label: 'QR Code Data',
                            placeholder: 'Enter data to encode (e.g., {{receipt_no}})'
                        }
                    ],
                    resizable: true,
                    editable: false
                },
                {
                    type: 'text',
                    tagName: 'p',
                    content: 'Scan for verification',
                    style: {
                        'margin': '10px 0 0 0',
                        'font-size': '12px',
                        'color': '#6c757d'
                    },
                    editable: true
                }
            ],
            droppable: false,
            resizable: true
        }
    });

    editor.BlockManager.add('terms-conditions', {
        label: '<i class="fa fa-file-contract" style="margin-right: 8px; color: #6f42c1;"></i>Terms & Conditions',
        category: 'Additional Components',
        attributes: { class: 'gjs-block-terms' },
        content: `
            <div style="margin: 30px 0; padding: 20px; background: linear-gradient(135deg, #f8f6ff 0%, #e9ecef 100%); border-left: 5px solid #6f42c1; border-radius: 0 8px 8px 0;">
                <h5 style="margin: 0 0 15px 0; color: #6f42c1; font-size: 16px; font-weight: 600;">Terms & Conditions:</h5>
                <ul style="margin: 0; padding-left: 20px; color: #495057; font-size: 12px; line-height: 1.6;">
                    <li style="margin-bottom: 5px;">Fee once paid is non-refundable.</li>
                    <li style="margin-bottom: 5px;">Late fee charges will apply after due date.</li>
                    <li style="margin-bottom: 5px;">Please keep this receipt for future reference.</li>
                    <li style="margin-bottom: 5px;">For any queries, contact the accounts department.</li>
                </ul>
            </div>
        `
    });

    editor.BlockManager.add('bank-details', {
        label: '<i class="fa fa-university" style="margin-right: 8px; color: #20c997;"></i>Bank Details',
        category: 'Additional Components',
        attributes: { class: 'gjs-block-bank' },
        content: `
            <div style="margin: 25px 0; padding: 20px; background: linear-gradient(135deg, #d1f2eb 0%, #a3e4d7 100%); border: 2px solid #20c997; border-radius: 8px;">
                <h5 style="margin: 0 0 15px 0; color: #20c997; font-size: 16px; font-weight: 600; display: flex; align-items: center;"><i class="fa fa-university" style="margin-right: 8px;"></i>Bank Details for Online Payment</h5>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                    <div style="padding: 10px; background: white; border-radius: 6px; border-left: 4px solid #20c997;">
                        <strong style="color: #20c997;">Bank Name:</strong><br>
                        <span style="color: #333;">{{bank_name}}</span>
                    </div>
                    <div style="padding: 10px; background: white; border-radius: 6px; border-left: 4px solid #20c997;">
                        <strong style="color: #20c997;">Account Number:</strong><br>
                        <span style="color: #333;">{{account_number}}</span>
                    </div>
                    <div style="padding: 10px; background: white; border-radius: 6px; border-left: 4px solid #20c997;">
                        <strong style="color: #20c997;">IFSC Code:</strong><br>
                        <span style="color: #333;">{{ifsc_code}}</span>
                    </div>
                    <div style="padding: 10px; background: white; border-radius: 6px; border-left: 4px solid #20c997;">
                        <strong style="color: #20c997;">Branch:</strong><br>
                        <span style="color: #333;">{{branch_name}}</span>
                    </div>
                </div>
            </div>
        `
    });

    editor.BlockManager.add('signature-section', {
        label: '<i class="fa fa-signature" style="margin-right: 8px; color: #fd7e14;"></i>Signature Section',
        category: 'Additional Components',
        attributes: { class: 'gjs-block-signature' },
        content: `
            <div style="margin: 40px 0 20px 0; display: flex; justify-content: space-between; align-items: end;">
                <div style="text-align: left; width: 200px;">
                    <div style="border-top: 2px solid #fd7e14; padding-top: 8px; margin-top: 50px;">
                        <p style="margin: 0; font-size: 12px; color: #495057; font-weight: 500;">Student/Parent Signature</p>
                        <p style="margin: 2px 0 0 0; font-size: 10px; color: #6c757d;">Date: ___________</p>
                    </div>
                </div>
                <div style="text-align: center; width: 200px;">
                    <div style="border-top: 2px solid #fd7e14; padding-top: 8px; margin-top: 50px;">
                        <p style="margin: 0; font-size: 12px; color: #495057; font-weight: 500;">Cashier Signature</p>
                        <p style="margin: 2px 0 0 0; font-size: 10px; color: #6c757d;">{{cashier_name}}</p>
                    </div>
                </div>
                <div style="text-align: right; width: 200px;">
                    <div style="border-top: 2px solid #fd7e14; padding-top: 8px; margin-top: 50px;">
                        <p style="margin: 0; font-size: 12px; color: #495057; font-weight: 500;">Principal Signature</p>
                        <p style="margin: 2px 0 0 0; font-size: 10px; color: #6c757d;">{{principal_name}}</p>
                    </div>
                </div>
            </div>
        `
    });

    // Add more variables
    editor.BlockManager.add('admission-no', {
        label: '<i class="fa fa-id-card" style="margin-right: 5px; color: #e83e8c;"></i>Admission No',
        category: 'Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #f8d7da 0%, #f1b0b7 100%); padding: 4px 8px; border: 1px solid #e83e8c; border-radius: 4px; color: #721c24; font-weight: 500; font-size: 14px;">{{admission_no}}</span>'
    });

    editor.BlockManager.add('class-section', {
        label: '<i class="fa fa-chalkboard" style="margin-right: 5px; color: #6f42c1;"></i>Class & Section',
        category: 'Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #e2d9f3 0%, #d1c4e9 100%); padding: 4px 8px; border: 1px solid #6f42c1; border-radius: 4px; color: #4a148c; font-weight: 500; font-size: 14px;">{{class_name}} - {{section_name}}</span>'
    });

    editor.BlockManager.add('receipt-no', {
        label: '<i class="fa fa-receipt" style="margin-right: 5px; color: #20c997;"></i>Receipt Number',
        category: 'Variables',
        attributes: { class: 'gjs-block-variable' },
        content: '<span style="background: linear-gradient(135deg, #d1f2eb 0%, #a3e4d7 100%); padding: 4px 8px; border: 1px solid #20c997; border-radius: 4px; color: #0d5142; font-weight: 500; font-size: 14px;">{{receipt_no}}</span>'
    });
    
    }

    // Panel switching functionality
    $(document).on('click', '.panel-btn', function() {
        var panel = $(this).data('panel');
        $('.panel-btn').removeClass('active');
        $(this).addClass('active');
        
        $('#layers-container, #styles-container, #traits-container, #blocks').hide();
        if (panel === 'blocks') {
            $('#blocks').show();
        } else {
            $('#' + panel + '-container').show();
        }
    });

    // Variables help button
    $(document).on('click', '#variables-help-btn', function() {
        var variablesModal = `
            <div class="modal fade" id="variables-help-modal" tabindex="-1">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title"><i class="fa fa-question-circle"></i> Available Variables Guide</h4>
                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h5><i class="fa fa-school text-primary"></i> School Information</h5>
                                    <ul class="list-unstyled">
                                        <li><code>{{school_name}}</code> - School Name</li>
                                        <li><code>{{school_address}}</code> - School Address</li>
                                        <li><code>{{school_phone}}</code> - School Phone</li>
                                        <li><code>{{school_email}}</code> - School Email</li>
                                        <li><code>{{school_logo_url}}</code> - School Logo</li>
                                    </ul>
                                    
                                    <h5><i class="fa fa-user-graduate text-success"></i> Student Information</h5>
                                    <ul class="list-unstyled">
                                        <li><code>{{student_name}}</code> - Student Name</li>
                                        <li><code>{{father_name}}</code> - Father Name</li>
                                        <li><code>{{admission_no}}</code> - Admission Number</li>
                                        <li><code>{{class_name}}</code> - Class Name</li>
                                        <li><code>{{section_name}}</code> - Section Name</li>
                                        <li><code>{{roll_no}}</code> - Roll Number</li>
                                    </ul>
                                </div>
                                <div class="col-md-6">
                                    <h5><i class="fa fa-money text-warning"></i> Fee Information</h5>
                                    <ul class="list-unstyled">
                                        <li><code>{{fee_group_name_1}}</code> - Fee Group Name 1</li>
                                        <li><code>{{fee_type_code_1}}</code> - Fee Type Code 1</li>
                                        <li><code>{{fee_amount_1}}</code> - Fee Amount 1</li>
                                        <li><code>{{fee_group_name_2}}</code> - Fee Group Name 2</li>
                                        <li><code>{{fee_type_code_2}}</code> - Fee Type Code 2</li>
                                        <li><code>{{fee_amount_2}}</code> - Fee Amount 2</li>
                                        <li><code>{{fee_group_name_3}}</code> - Fee Group Name 3</li>
                                        <li><code>{{fee_type_code_3}}</code> - Fee Type Code 3</li>
                                        <li><code>{{fee_amount_3}}</code> - Fee Amount 3</li>
                                        <li><code>{{total_amount}}</code> - Total Amount</li>
                                        <li><code>{{paid_amount}}</code> - Paid Amount</li>
                                        <li><code>{{outstanding_balance}}</code> - Outstanding Balance</li>
                                    </ul>
                                    
                                    <h5><i class="fa fa-credit-card text-info"></i> Payment Details</h5>
                                    <ul class="list-unstyled">
                                        <li><code>{{payment_mode}}</code> - Payment Mode</li>
                                        <li><code>{{payment_date}}</code> - Payment Date</li>
                                        <li><code>{{receipt_no}}</code> - Receipt Number</li>
                                        <li><code>{{transaction_id}}</code> - Transaction ID</li>
                                        <li><code>{{collected_by}}</code> - Collected By</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="alert alert-info mt-3">
                                <i class="fa fa-lightbulb"></i> <strong>Tip:</strong> Double-click on any text in the editor to edit it directly. You can replace static text with variables or customize the content as needed.
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-info" id="preview-template-btn">Preview with Data</button>
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            <button type="button" class="btn btn-primary" id="save-template-btn">Save Template</button>
                        </div>
                    </div>
                </div>
            </div>
        `;
        
        if (!$('#variables-help-modal').length) {
            $('body').append(variablesModal);
        }
        $('#variables-help-modal').modal('show');
    });

    // Device switching functionality
    $(document).on('click', '.device-btn', function() {
        var device = $(this).data('device');
        $('.device-btn').removeClass('active');
        $(this).addClass('active');
        
        if (editor) {
            editor.setDevice(device);
        }
    });

    // Load sample template with multiple options
    $(document).on('click', '#load-sample-btn', function() {
        // Show template selection modal
        var templateModal = `
            <div class="modal fade" id="template-selection-modal" tabindex="-1" style="z-index: 99999;">
                <div class="modal-dialog" style="z-index: 100000;">
                    <div class="modal-content" style="z-index: 100001;">
                        <div class="modal-header">
                            <h4 class="modal-title">Choose Template</h4>
                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="template-option" data-template="3" style="border: 2px solid #ff6b6b; padding: 15px; margin: 10px 0; cursor: pointer; border-radius: 8px; background: linear-gradient(135deg, #fff5f5, #ffe6e6);">
                                        <h5 style="color: #ff6b6b; margin-bottom: 8px;"><i class="fa fa-magic"></i> Modern Dark</h5>
                                        <p style="margin: 0; color: #666; font-size: 13px;">Stylish dark theme with vibrant colors</p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="template-option" data-template="4" style="border: 2px solid #28a745; padding: 15px; margin: 10px 0; cursor: pointer; border-radius: 8px; background: linear-gradient(135deg, #f8fff8, #e6ffe6);">
                                        <h5 style="color: #28a745; margin-bottom: 8px;"><i class="fa fa-leaf"></i> Green Corporate</h5>
                                        <p style="margin: 0; color: #666; font-size: 13px;">Professional green theme with corporate styling</p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="template-option" data-template="5" style="border: 2px solid #fd7e14; padding: 15px; margin: 10px 0; cursor: pointer; border-radius: 8px; background: linear-gradient(135deg, #fff8f0, #ffe6cc);">
                                        <h5 style="color: #fd7e14; margin-bottom: 8px;"><i class="fa fa-fire"></i> Orange Modern</h5>
                                        <p style="margin: 0; color: #666; font-size: 13px;">Vibrant orange design with modern layout</p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="template-option" data-template="6" style="border: 2px solid #20c997; padding: 15px; margin: 10px 0; cursor: pointer; border-radius: 8px; background: linear-gradient(135deg, #f0fff4, #ccffe6);">
                                        <h5 style="color: #20c997; margin-bottom: 8px;"><i class="fa fa-gem"></i> Teal Premium</h5>
                                        <p style="margin: 0; color: #666; font-size: 13px;">Elegant teal theme with premium features</p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="template-option" data-template="7" style="border: 2px solid #e83e8c; padding: 15px; margin: 10px 0; cursor: pointer; border-radius: 8px; background: linear-gradient(135deg, #fff0f6, #ffe0ec);">
                                        <h5 style="color: #e83e8c; margin-bottom: 8px;"><i class="fa fa-heart"></i> Pink Elegant</h5>
                                        <p style="margin: 0; color: #666; font-size: 13px;">Sophisticated pink design for special occasions</p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="template-option" data-template="8" style="border: 2px solid #17a2b8; padding: 15px; margin: 10px 0; cursor: pointer; border-radius: 8px; background: linear-gradient(135deg, #e6f7ff, #b3ecff);">
                                        <h5 style="color: #17a2b8; margin-bottom: 8px;"><i class="fa fa-certificate"></i> Complete Bill</h5>
                                        <p style="margin: 0; color: #666; font-size: 13px;">Full billing template with all components</p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="template-option" data-template="9" style="border: 2px solid #6610f2; padding: 15px; margin: 10px 0; cursor: pointer; border-radius: 8px; background: linear-gradient(135deg, #f3e5f5, #e1bee7);">
                                        <h5 style="color: #6610f2; margin-bottom: 8px;"><i class="fa fa-star-o"></i> Premium Complete</h5>
                                        <p style="margin: 0; color: #666; font-size: 13px;">Luxury complete billing with all features</p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="template-option" data-template="10" style="border: 2px solid #343a40; padding: 15px; margin: 10px 0; cursor: pointer; border-radius: 8px; background: linear-gradient(135deg, #f8f9fa, #e9ecef);">
                                        <h5 style="color: #343a40; margin-bottom: 8px;"><i class="fa fa-file-text-o"></i> School Fee Receipt</h5>
                                        <p style="margin: 0; color: #666; font-size: 13px;">Traditional school fee receipt with detailed breakdown</p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="template-option" data-template="11" style="border: 2px solid #007bff; padding: 15px; margin: 10px 0; cursor: pointer; border-radius: 8px; background: linear-gradient(135deg, #e3f2fd, #bbdefb);">
                                        <h5 style="color: #007bff; margin-bottom: 8px;"><i class="fa fa-table"></i> Bhagyoday Public School</h5>
                                        <p style="margin: 0; color: #666; font-size: 13px;">Professional tabular receipt with installment tracking</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        `;
        
        if (!$('#template-selection-modal').length) {
            $('body').append(templateModal);
        }
        
        // Add CSS to ensure modal appears above editor
        if (!$('#modal-z-index-fix').length) {
            $('head').append(`
                <style id="modal-z-index-fix">
                    #template-selection-modal {
                        z-index: 99999 !important;
                    }
                    #template-selection-modal .modal-backdrop {
                        z-index: 99998 !important;
                    }
                    #template-selection-modal .modal-dialog {
                        z-index: 100000 !important;
                    }
                    #template-selection-modal .modal-content {
                        z-index: 100001 !important;
                        position: relative;
                    }
                    .modal-backdrop.show {
                        z-index: 99998 !important;
                    }
                    .gjs-editor {
                        z-index: 1000 !important;
                    }
                    .gjs-cv-canvas {
                        z-index: 1001 !important;
                    }
                    .gjs-pn-panel {
                        z-index: 1002 !important;
                    }
                </style>
            `);
        }
        
        $('#template-selection-modal').modal('show');
    });
    
    // Handle template selection
    $(document).on('click', '.template-option', function() {
        var templateNum = $(this).data('template');
        var sampleTemplate = getSampleTemplate(templateNum);
        
        if (editor) {
            editor.setComponents(sampleTemplate);
        }
        $('#template-selection-modal').modal('hide');
    });
    
    function getSampleTemplate(num) {
        var templates = {
            1: getClassicTemplate(),
            2: getModernInvoice(),
            3: getDetailedReceipt(),
            4: getGreenCorporate(),
            5: getOrangeModern(),
            6: getTealPremium(),
            7: getPinkElegant(),
            8: getCompleteBill(),
            9: getPremiumComplete(),
            10: getSchoolFeeReceipt(),
            11: getBhagyodayTemplate()
        };
        return templates[num] || templates[1];
    }
    
    function getBhagyodayTemplate() {
        return `<div style="max-width: 800px; margin: 0 auto; padding: 20px; font-family: Arial, sans-serif; border: 2px solid #000; background: #fff;">
            <!-- Header Section -->
            <div style="text-align: center; padding: 15px; border-bottom: 2px solid #000; margin-bottom: 15px;">
                <div style="display: flex; align-items: center; justify-content: center; gap: 15px;">
                    <img src="{{school_logo}}" alt="School Logo" style="width: 60px; height: 60px; border-radius: 50%;">
                    <div>
                        <h2 style="margin: 0; color: #000; font-size: 22px; font-weight: bold;">{{school_name}}</h2>
                        <p style="margin: 2px 0; font-size: 12px; color: #333;">{{school_address}}</p>
                        <p style="margin: 2px 0; font-size: 12px; color: #333;">{{school_phone}}, {{school_email}}</p>
                        <p style="margin: 2px 0; font-size: 12px; color: #333;">Website: {{school_website}}</p>
                    </div>
                </div>
            </div>
            
            <!-- Receipt Info -->
            <div style="text-align: center; margin-bottom: 15px;">
                <h3 style="margin: 0; padding: 8px; background: #f0f0f0; border: 1px solid #000; font-size: 16px;">Student Copy</h3>
            </div>
            
            <!-- Student Details Table -->
            <table style="width: 100%; border-collapse: collapse; margin-bottom: 15px; font-size: 12px;">
                <tr>
                    <td style="border: 1px solid #000; padding: 6px; background: #f8f8f8; font-weight: bold; width: 15%;">Receipt No :</td>
                    <td style="border: 1px solid #000; padding: 6px; width: 35%;">{{receipt_no}}</td>
                    <td style="border: 1px solid #000; padding: 6px; background: #f8f8f8; font-weight: bold; width: 15%;">Date :</td>
                    <td style="border: 1px solid #000; padding: 6px; width: 35%;">{{payment_date}}</td>
                </tr>
                <tr>
                    <td style="border: 1px solid #000; padding: 6px; background: #f8f8f8; font-weight: bold;">Name :</td>
                    <td style="border: 1px solid #000; padding: 6px;">{{student_name}}</td>
                    <td style="border: 1px solid #000; padding: 6px; background: #f8f8f8; font-weight: bold;">Class :</td>
                    <td style="border: 1px solid #000; padding: 6px;">{{class_name}}</td>
                </tr>
                <tr>
                    <td style="border: 1px solid #000; padding: 6px; background: #f8f8f8; font-weight: bold;">F. Name :</td>
                    <td style="border: 1px solid #000; padding: 6px;">{{father_name}}</td>
                    <td style="border: 1px solid #000; padding: 6px; background: #f8f8f8; font-weight: bold;">Scholar No. :</td>
                    <td style="border: 1px solid #000; padding: 6px;">{{admission_no}}</td>
                </tr>
            </table>
            
            <!-- Fee Details Table -->
            <table style="width: 100%; border-collapse: collapse; margin-bottom: 15px; font-size: 12px;">
                <thead>
                    <tr style="background: #f0f0f0;">
                        <th style="border: 1px solid #000; padding: 8px; text-align: center; font-weight: bold;">S.No.</th>
                        <th style="border: 1px solid #000; padding: 8px; text-align: left; font-weight: bold;">Deposit In</th>
                        <th style="border: 1px solid #000; padding: 8px; text-align: left; font-weight: bold;">Particulars</th>
                        <th style="border: 1px solid #000; padding: 8px; text-align: right; font-weight: bold;">Amount</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td style="border: 1px solid #000; padding: 8px; text-align: center;">1</td>
                        <td style="border: 1px solid #000; padding: 8px;">PREV YEAR DUE</td>
                        <td style="border: 1px solid #000; padding: 8px;">{{fee_group_name_1}} - {{fee_type_code_1}}</td>
                        <td style="border: 1px solid #000; padding: 8px; text-align: right;">{{fee_amount_1}}</td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #000; padding: 8px; text-align: center;">2</td>
                        <td style="border: 1px solid #000; padding: 8px;">1ST INSTALLMENT</td>
                        <td style="border: 1px solid #000; padding: 8px;">{{fee_group_name_2}} - {{fee_type_code_2}}</td>
                        <td style="border: 1px solid #000; padding: 8px; text-align: right;">{{fee_amount_2}}</td>
                    </tr>
                    <tr>
                        <td style="border: 1px solid #000; padding: 8px; text-align: center;">3</td>
                        <td style="border: 1px solid #000; padding: 8px;">2ND INSTALLMENT</td>
                        <td style="border: 1px solid #000; padding: 8px;">{{fee_group_name_3}} - {{fee_type_code_3}}</td>
                        <td style="border: 1px solid #000; padding: 8px; text-align: right;">{{fee_amount_3}}</td>
                    </tr>
                    <!-- Empty rows for spacing -->
                    <tr style="height: 40px;">
                        <td style="border: 1px solid #000; padding: 8px;">&nbsp;</td>
                        <td style="border: 1px solid #000; padding: 8px;">&nbsp;</td>
                        <td style="border: 1px solid #000; padding: 8px;">&nbsp;</td>
                        <td style="border: 1px solid #000; padding: 8px;">&nbsp;</td>
                    </tr>
                    <tr style="height: 40px;">
                        <td style="border: 1px solid #000; padding: 8px;">&nbsp;</td>
                        <td style="border: 1px solid #000; padding: 8px;">&nbsp;</td>
                        <td style="border: 1px solid #000; padding: 8px;">&nbsp;</td>
                        <td style="border: 1px solid #000; padding: 8px;">&nbsp;</td>
                    </tr>
                    <tr style="height: 40px;">
                        <td style="border: 1px solid #000; padding: 8px;">&nbsp;</td>
                        <td style="border: 1px solid #000; padding: 8px;">&nbsp;</td>
                        <td style="border: 1px solid #000; padding: 8px;">&nbsp;</td>
                        <td style="border: 1px solid #000; padding: 8px;">&nbsp;</td>
                    </tr>
                    <tr style="height: 40px;">
                        <td style="border: 1px solid #000; padding: 8px;">&nbsp;</td>
                        <td style="border: 1px solid #000; padding: 8px;">&nbsp;</td>
                        <td style="border: 1px solid #000; padding: 8px;">&nbsp;</td>
                        <td style="border: 1px solid #000; padding: 8px;">&nbsp;</td>
                    </tr>
                    <tr style="height: 40px;">
                        <td style="border: 1px solid #000; padding: 8px;">&nbsp;</td>
                        <td style="border: 1px solid #000; padding: 8px;">&nbsp;</td>
                        <td style="border: 1px solid #000; padding: 8px;">&nbsp;</td>
                        <td style="border: 1px solid #000; padding: 8px;">&nbsp;</td>
                    </tr>
                </tbody>
            </table>
            
            <!-- Total Section -->
            <table style="width: 100%; border-collapse: collapse; margin-bottom: 15px; font-size: 12px;">
                <tr>
                    <td style="border: 1px solid #000; padding: 8px; background: #f8f8f8; font-weight: bold; width: 70%;">Late Fee :</td>
                    <td style="border: 1px solid #000; padding: 8px; text-align: right; width: 30%;">0.00</td>
                    <td style="border: 1px solid #000; padding: 8px; background: #f8f8f8; font-weight: bold; width: 70%;">Total Fees</td>
                    <td style="border: 1px solid #000; padding: 8px; text-align: right; width: 30%; font-weight: bold;">{{total_amount}}</td>
                </tr>
                <tr>
                    <td style="border: 1px solid #000; padding: 8px; background: #f8f8f8; font-weight: bold;">Advance Paid :</td>
                    <td style="border: 1px solid #000; padding: 8px; text-align: right;">0.00</td>
                    <td style="border: 1px solid #000; padding: 8px; background: #f8f8f8; font-weight: bold;">Cash Amount</td>
                    <td style="border: 1px solid #000; padding: 8px; text-align: right; font-weight: bold;">{{paid_amount}}</td>
                </tr>
                <tr>
                    <td style="border: 1px solid #000; padding: 8px; background: #f8f8f8; font-weight: bold;">Total Due :</td>
                    <td style="border: 1px solid #000; padding: 8px; text-align: right;">{{outstanding_balance}}</td>
                    <td style="border: 1px solid #000; padding: 8px; background: #f8f8f8; font-weight: bold;">Net Fee</td>
                    <td style="border: 1px solid #000; padding: 8px; text-align: right; font-weight: bold; font-size: 14px;">{{paid_amount}}</td>
                </tr>
                <tr>
                    <td style="border: 1px solid #000; padding: 8px; background: #f8f8f8; font-weight: bold;">Total Chq Amount :</td>
                    <td style="border: 1px solid #000; padding: 8px; text-align: right;">0.00</td>
                    <td style="border: 1px solid #000; padding: 8px;">&nbsp;</td>
                    <td style="border: 1px solid #000; padding: 8px;">&nbsp;</td>
                </tr>
            </table>
            
            <!-- Payment Details -->
            <table style="width: 100%; border-collapse: collapse; margin-bottom: 15px; font-size: 12px;">
                <tr>
                    <td style="border: 1px solid #000; padding: 8px; background: #f8f8f8; font-weight: bold; width: 25%;">Bank Name</td>
                    <td style="border: 1px solid #000; padding: 8px; width: 25%;">-</td>
                    <td style="border: 1px solid #000; padding: 8px; background: #f8f8f8; font-weight: bold; width: 25%;">Cheque No.</td>
                    <td style="border: 1px solid #000; padding: 8px; width: 25%;">-</td>
                </tr>
                <tr>
                    <td style="border: 1px solid #000; padding: 8px; background: #f8f8f8; font-weight: bold;">Cheque Date</td>
                    <td style="border: 1px solid #000; padding: 8px;">-</td>
                    <td style="border: 1px solid #000; padding: 8px; background: #f8f8f8; font-weight: bold;">Cheque Amount</td>
                    <td style="border: 1px solid #000; padding: 8px;">0.00</td>
                </tr>
            </table>
            
            <!-- Terms and Footer -->
            <div style="border: 1px solid #000; padding: 10px; margin-bottom: 15px; font-size: 11px;">
                <p style="margin: 0; font-weight: bold;">Terms & Conditions :</p>
                <p style="margin: 5px 0;">1. Thank you for the fee deposit, please keep this receipt safely. 2. Fee do not considered fee deposit without verify receipt. Fee Once Paid Are Non Refundable.</p>
            </div>
            
            <!-- Amount in Words and Signature -->
            <table style="width: 100%; border-collapse: collapse; font-size: 12px;">
                <tr>
                    <td style="border: 1px solid #000; padding: 8px; background: #f8f8f8; font-weight: bold; width: 20%;">Amount in words:</td>
                    <td style="border: 1px solid #000; padding: 8px; width: 50%;">Ten Thousand Only</td>
                    <td style="border: 1px solid #000; padding: 8px; width: 30%; text-align: center;">
                        <div style="height: 40px; display: flex; align-items: end; justify-content: center;">
                            <strong>Authorised Signature</strong>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td style="border: 1px solid #000; padding: 8px; background: #f8f8f8; font-weight: bold;">Remark :</td>
                    <td style="border: 1px solid #000; padding: 8px;">{{payment_mode}}</td>
                    <td style="border: 1px solid #000; padding: 8px; text-align: center; font-size: 10px;">Page 1 of 1</td>
                </tr>
            </table>
            
            <!-- Footer -->
            <div style="text-align: center; margin-top: 10px; font-size: 10px; color: #666;">
                <p style="margin: 0;">{{school_name}} - {{receipt_no}} - {{current_date}}</p>
            </div>
        </div>`;
    }
    
    function getClassicTemplate() {
        return `<div style="max-width: 700px; margin: 0 auto; padding: 30px; font-family: Arial, sans-serif; border: 2px solid #333;">
            <div style="text-align: center; padding: 20px; border-bottom: 2px solid #333; margin-bottom: 20px;">
                <h2 style="margin: 0; color: #333; font-size: 24px;">{{school_name}}</h2>
                <p style="margin: 5px 0; font-size: 14px;">{{school_address}}</p>
                <p style="margin: 5px 0; font-size: 14px;">Phone: {{school_phone}} | Email: {{school_email}}</p>
                <h3 style="color: #007bff; margin: 15px 0; font-size: 20px;">FEE RECEIPT</h3>
            </div>
            
            <div style="margin: 20px 0; padding: 15px; background: #f8f9fa; border-left: 4px solid #007bff;">
                <div style="display: flex; justify-content: space-between; margin-bottom: 10px;">
                    <div><strong>Student Name:</strong> {{student_name}}</div>
                    <div><strong>Admission No:</strong> {{admission_no}}</div>
                </div>
                <div style="display: flex; justify-content: space-between;">
                    <div><strong>Class:</strong> {{class_name}}</div>
                    <div><strong>Receipt No:</strong> {{receipt_no}}</div>
                </div>
            </div>
            
            <table style="width: 100%; border-collapse: collapse; margin: 20px 0;">
                <thead>
                    <tr style="background: #007bff; color: white;">
                        <th style="padding: 12px; text-align: left;">Fee Type</th>
                        <th style="padding: 12px; text-align: right;">Amount</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td style="padding: 10px; border: 1px solid #ddd;">{{fee_type}}</td>
                        <td style="padding: 10px; border: 1px solid #ddd; text-align: right;">₹{{fee_amount}}</td>
                    </tr>
                    <tr style="background: #f8f9fa;">
                        <td style="padding: 10px; border: 1px solid #ddd;"><strong>Total Amount</strong></td>
                        <td style="padding: 10px; border: 1px solid #ddd; text-align: right;"><strong>₹{{total_amount}}</strong></td>
                    </tr>
                </tbody>
            </table>
            
            <div style="margin: 20px 0; padding: 15px; background: #e8f5e8; border: 1px solid #28a745; border-radius: 5px;">
                <div style="display: flex; justify-content: space-between;">
                    <div><strong>Payment Date:</strong> {{payment_date}}</div>
                    <div><strong>Amount Paid:</strong> ₹{{amount_paid}}</div>
                </div>
            </div>
        </div>`;
    }
    
    function getGreenCorporate() {
        return `<div style="max-width: 750px; margin: 0 auto; padding: 0; font-family: 'Arial', sans-serif; background: white; box-shadow: 0 4px 15px rgba(0,0,0,0.1);">
            <div style="background: linear-gradient(135deg, #28a745 0%, #20c997 100%); color: white; padding: 30px; text-align: center;">
                <h1 style="margin: 0; font-size: 28px; font-weight: 700;">{{school_name}}</h1>
                <p style="margin: 10px 0; font-size: 16px; opacity: 0.9;">{{school_address}}</p>
                <div style="background: rgba(255,255,255,0.2); padding: 15px; border-radius: 8px; margin-top: 20px;">
                    <h2 style="margin: 0; font-size: 24px; letter-spacing: 1px;">FEE RECEIPT</h2>
                </div>
            </div>
            
            <div style="padding: 30px;">
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 30px;">
                    <div style="background: #f8fff8; padding: 20px; border-radius: 8px; border-left: 4px solid #28a745;">
                        <h4 style="margin: 0 0 10px 0; color: #28a745;">Student Details</h4>
                        <p style="margin: 5px 0;"><strong>Name:</strong> {{student_name}}</p>
                        <p style="margin: 5px 0;"><strong>Class:</strong> {{class_name}}</p>
                        <p style="margin: 5px 0;"><strong>Admission No:</strong> {{admission_no}}</p>
                    </div>
                    <div style="background: #f0fff4; padding: 20px; border-radius: 8px; border-left: 4px solid #20c997;">
                        <h4 style="margin: 0 0 10px 0; color: #20c997;">Payment Details</h4>
                        <p style="margin: 5px 0;"><strong>Receipt No:</strong> {{receipt_no}}</p>
                        <p style="margin: 5px 0;"><strong>Date:</strong> {{payment_date}}</p>
                        <p style="margin: 5px 0;"><strong>Mode:</strong> {{payment_mode}}</p>
                    </div>
                </div>
                
                <table style="width: 100%; border-collapse: collapse; margin: 20px 0; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
                    <thead>
                        <tr style="background: linear-gradient(135deg, #28a745 0%, #20c997 100%); color: white;">
                            <th style="padding: 15px; text-align: left; font-size: 16px;">Fee Description</th>
                            <th style="padding: 15px; text-align: right; font-size: 16px;">Amount (₹)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr style="background: #f8fff8;">
                            <td style="padding: 15px; border-bottom: 1px solid #e9ecef;">{{fee_type}}</td>
                            <td style="padding: 15px; text-align: right; border-bottom: 1px solid #e9ecef;">{{fee_amount}}</td>
                        </tr>
                        <tr style="background: linear-gradient(135deg, #28a745 0%, #20c997 100%); color: white;">
                            <td style="padding: 15px; font-weight: 700; font-size: 18px;">Total Amount</td>
                            <td style="padding: 15px; text-align: right; font-weight: 700; font-size: 18px;">₹{{total_amount}}</td>
                        </tr>
                    </tbody>
                </table>
                
                <div style="text-align: center; margin-top: 30px; padding: 20px; background: linear-gradient(135deg, #f8fff8 0%, #e6ffe6 100%); border-radius: 8px;">
                    <p style="margin: 0; color: #28a745; font-size: 16px; font-weight: 600;">Thank you for your payment!</p>
                    <p style="margin: 5px 0 0 0; color: #666; font-size: 14px;">This is a computer generated receipt.</p>
                </div>
            </div>
        </div>`;
    }
    
    function getOrangeModern() {
        return `<div style="max-width: 800px; margin: 0 auto; padding: 0; font-family: 'Segoe UI', sans-serif; background: white; border-radius: 12px; overflow: hidden; box-shadow: 0 8px 25px rgba(0,0,0,0.15);">
            <div style="background: linear-gradient(45deg, #fd7e14, #ff6b35); color: white; padding: 40px; position: relative;">
                <div style="position: absolute; top: 0; right: 0; width: 100px; height: 100px; background: rgba(255,255,255,0.1); border-radius: 50%; transform: translate(30px, -30px);"></div>
                <div style="position: relative; z-index: 2;">
                    <h1 style="margin: 0; font-size: 32px; font-weight: 300; letter-spacing: 2px;">{{school_name}}</h1>
                    <p style="margin: 15px 0; font-size: 16px; opacity: 0.9;">{{school_address}}</p>
                    <div style="display: flex; justify-content: space-between; align-items: center; margin-top: 25px;">
                        <h2 style="margin: 0; font-size: 24px; font-weight: 700;">PAYMENT RECEIPT</h2>
                        <div style="background: rgba(255,255,255,0.2); padding: 10px 20px; border-radius: 25px;">
                            <span style="font-size: 14px; font-weight: 600;">{{receipt_no}}</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <div style="padding: 40px;">
                <div style="display: grid; grid-template-columns: 2fr 1fr; gap: 30px; margin-bottom: 30px;">
                    <div>
                        <h3 style="margin: 0 0 20px 0; color: #fd7e14; font-size: 20px; border-bottom: 2px solid #ffe6cc; padding-bottom: 10px;">Student Information</h3>
                        <div style="background: #fff8f0; padding: 25px; border-radius: 10px; border: 1px solid #ffe6cc;">
                            <div style="margin-bottom: 15px;">
                                <label style="color: #666; font-size: 12px; text-transform: uppercase; letter-spacing: 1px;">Student Name</label>
                                <p style="margin: 5px 0 0 0; font-size: 16px; font-weight: 600; color: #333;">{{student_name}}</p>
                            </div>
                            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                                <div>
                                    <label style="color: #666; font-size: 12px; text-transform: uppercase; letter-spacing: 1px;">Class</label>
                                    <p style="margin: 5px 0 0 0; font-size: 14px; font-weight: 600;">{{class_name}}</p>
                                </div>
                                <div>
                                    <label style="color: #666; font-size: 12px; text-transform: uppercase; letter-spacing: 1px;">Admission No</label>
                                    <p style="margin: 5px 0 0 0; font-size: 14px; font-weight: 600;">{{admission_no}}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div>
                        <h3 style="margin: 0 0 20px 0; color: #fd7e14; font-size: 20px; border-bottom: 2px solid #ffe6cc; padding-bottom: 10px;">Payment Info</h3>
                        <div style="background: linear-gradient(135deg, #fff8f0 0%, #ffe6cc 100%); padding: 25px; border-radius: 10px;">
                            <div style="margin-bottom: 15px;">
                                <label style="color: #666; font-size: 12px; text-transform: uppercase; letter-spacing: 1px;">Date</label>
                                <p style="margin: 5px 0 0 0; font-size: 14px; font-weight: 600;">{{payment_date}}</p>
                            </div>
                            <div>
                                <label style="color: #666; font-size: 12px; text-transform: uppercase; letter-spacing: 1px;">Amount</label>
                                <p style="margin: 5px 0 0 0; font-size: 20px; font-weight: 700; color: #fd7e14;">₹{{total_amount}}</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div style="background: linear-gradient(135deg, #fd7e14 0%, #ff6b35 100%); color: white; padding: 25px; border-radius: 10px; text-align: center;">
                    <h3 style="margin: 0 0 10px 0; font-size: 18px;">Payment Successful</h3>
                    <p style="margin: 0; opacity: 0.9; font-size: 14px;">Thank you for your payment. Keep this receipt for your records.</p>
                </div>
            </div>
        </div>`;
    }
    
    function getTealPremium() {
        return `<div style="max-width: 750px; margin: 0 auto; padding: 0; font-family: 'Georgia', serif; background: white; border: 3px solid #20c997; border-radius: 15px; overflow: hidden;">
            <div style="background: linear-gradient(135deg, #20c997 0%, #17a2b8 100%); color: white; padding: 35px; text-align: center; position: relative;">
                <div style="position: absolute; top: -20px; right: -20px; width: 80px; height: 80px; background: rgba(255,255,255,0.1); border-radius: 50%;"></div>
                <div style="position: absolute; bottom: -30px; left: -30px; width: 120px; height: 120px; background: rgba(255,255,255,0.05); border-radius: 50%;"></div>
                <div style="position: relative; z-index: 2;">
                    <div style="background: rgba(255,255,255,0.2); display: inline-block; padding: 8px 20px; border-radius: 20px; margin-bottom: 15px;">
                        <span style="font-size: 12px; font-weight: 600; letter-spacing: 2px;">PREMIUM RECEIPT</span>
                    </div>
                    <h1 style="margin: 0; font-size: 30px; font-weight: 400; font-style: italic;">{{school_name}}</h1>
                    <p style="margin: 15px 0; font-size: 16px; opacity: 0.9;">{{school_address}}</p>
                    <div style="border-top: 1px solid rgba(255,255,255,0.3); padding-top: 15px; margin-top: 20px;">
                        <span style="font-size: 14px; opacity: 0.8;">{{school_phone}} • {{school_email}}</span>
                    </div>
                </div>
            </div>
            
            <div style="padding: 40px;">
                <div style="text-align: center; margin-bottom: 30px;">
                    <h2 style="margin: 0; color: #20c997; font-size: 24px; font-weight: 300; letter-spacing: 1px;">Fee Payment Receipt</h2>
                    <div style="width: 60px; height: 3px; background: linear-gradient(135deg, #20c997 0%, #17a2b8 100%); margin: 10px auto;"></div>
                </div>
                
                <div style="background: linear-gradient(135deg, #f0fff4 0%, #ccffe6 100%); padding: 30px; border-radius: 12px; margin-bottom: 30px; border: 1px solid #20c997;">
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 25px;">
                        <div>
                            <h4 style="margin: 0 0 15px 0; color: #20c997; font-size: 16px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px;">Student Details</h4>
                            <div style="space-y: 8px;">
                                <p style="margin: 8px 0; font-size: 14px;"><span style="color: #666; font-weight: 600;">Name:</span> {{student_name}}</p>
                                <p style="margin: 8px 0; font-size: 14px;"><span style="color: #666; font-weight: 600;">Class:</span> {{class_name}}</p>
                                <p style="margin: 8px 0; font-size: 14px;"><span style="color: #666; font-weight: 600;">Admission No:</span> {{admission_no}}</p>
                            </div>
                        </div>
                        <div>
                            <h4 style="margin: 0 0 15px 0; color: #17a2b8; font-size: 16px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px;">Payment Details</h4>
                            <div>
                                <p style="margin: 8px 0; font-size: 14px;"><span style="color: #666; font-weight: 600;">Receipt No:</span> {{receipt_no}}</p>
                                <p style="margin: 8px 0; font-size: 14px;"><span style="color: #666; font-weight: 600;">Date:</span> {{payment_date}}</p>
                                <p style="margin: 8px 0; font-size: 14px;"><span style="color: #666; font-weight: 600;">Mode:</span> {{payment_mode}}</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div style="background: white; border: 2px solid #20c997; border-radius: 10px; overflow: hidden; margin-bottom: 30px;">
                    <div style="background: linear-gradient(135deg, #20c997 0%, #17a2b8 100%); color: white; padding: 15px; text-align: center;">
                        <h3 style="margin: 0; font-size: 18px; font-weight: 600;">Fee Breakdown</h3>
                    </div>
                    <div style="padding: 25px;">
                        <div style="display: flex; justify-content: space-between; align-items: center; padding: 15px 0; border-bottom: 1px solid #e9ecef;">
                            <span style="font-size: 16px; color: #333;">{{fee_type}}</span>
                            <span style="font-size: 16px; font-weight: 600; color: #20c997;">₹{{fee_amount}}</span>
                        </div>
                        <div style="display: flex; justify-content: space-between; align-items: center; padding: 20px 0; background: linear-gradient(135deg, #f0fff4 0%, #ccffe6 100%); margin: 15px -25px -25px -25px; padding-left: 25px; padding-right: 25px;">
                            <span style="font-size: 20px; font-weight: 700; color: #20c997;">Total Amount</span>
                            <span style="font-size: 24px; font-weight: 700; color: #20c997;">₹{{total_amount}}</span>
                        </div>
                    </div>
                </div>
                
                <div style="text-align: center; padding: 20px; background: linear-gradient(135deg, #20c997 0%, #17a2b8 100%); color: white; border-radius: 10px;">
                    <p style="margin: 0; font-size: 16px; font-style: italic;">Thank you for choosing our institution</p>
                    <p style="margin: 5px 0 0 0; font-size: 12px; opacity: 0.8;">This receipt is digitally generated and valid without signature</p>
                </div>
            </div>
        </div>`;
    }
    
    function getPinkElegant() {
        return `<div style="max-width: 700px; margin: 0 auto; padding: 0; font-family: 'Palatino', serif; background: white; border-radius: 20px; overflow: hidden; box-shadow: 0 10px 30px rgba(232, 62, 140, 0.2);">
            <div style="background: linear-gradient(135deg, #e83e8c 0%, #d63384 100%); color: white; padding: 40px; text-align: center; position: relative;">
                <div style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: url('data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 100 100\"><circle cx=\"20\" cy=\"20\" r=\"2\" fill=\"rgba(255,255,255,0.1)\"/><circle cx=\"80\" cy=\"40\" r=\"1.5\" fill=\"rgba(255,255,255,0.1)\"/><circle cx=\"40\" cy=\"80\" r=\"1\" fill=\"rgba(255,255,255,0.1)\"/></svg>'); background-size: 100px 100px;"></div>
                <div style="position: relative; z-index: 2;">
                    <div style="background: rgba(255,255,255,0.2); display: inline-block; padding: 10px 25px; border-radius: 25px; margin-bottom: 20px; border: 1px solid rgba(255,255,255,0.3);">
                        <span style="font-size: 14px; font-weight: 600; letter-spacing: 3px;">ELEGANT RECEIPT</span>
                    </div>
                    <h1 style="margin: 0; font-size: 28px; font-weight: 300; font-style: italic; letter-spacing: 1px;">{{school_name}}</h1>
                    <p style="margin: 15px 0; font-size: 16px; opacity: 0.9; font-style: italic;">{{school_address}}</p>
                    <div style="margin-top: 25px; padding-top: 20px; border-top: 1px solid rgba(255,255,255,0.3);">
                        <h2 style="margin: 0; font-size: 22px; font-weight: 400; letter-spacing: 2px;">Fee Payment Receipt</h2>
                    </div>
                </div>
            </div>
            
            <div style="padding: 40px;">
                <div style="text-align: center; margin-bottom: 35px;">
                    <div style="display: inline-block; background: linear-gradient(135deg, #fff0f6 0%, #ffe0ec 100%); padding: 15px 30px; border-radius: 30px; border: 2px solid #e83e8c;">
                        <span style="color: #e83e8c; font-size: 16px; font-weight: 600; letter-spacing: 1px;">Receipt No: {{receipt_no}}</span>
                    </div>
                </div>
                
                <div style="background: linear-gradient(135deg, #fff0f6 0%, #ffe0ec 100%); padding: 35px; border-radius: 15px; margin-bottom: 30px; border: 1px solid #f8d7da;">
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 30px;">
                        <div style="text-align: center;">
                            <div style="background: white; padding: 25px; border-radius: 12px; box-shadow: 0 4px 15px rgba(232, 62, 140, 0.1);">
                                <h4 style="margin: 0 0 20px 0; color: #e83e8c; font-size: 16px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px;">Student Information</h4>
                                <div style="text-align: left;">
                                    <p style="margin: 12px 0; font-size: 14px; color: #333;"><span style="color: #e83e8c; font-weight: 600;">Name:</span> {{student_name}}</p>
                                    <p style="margin: 12px 0; font-size: 14px; color: #333;"><span style="color: #e83e8c; font-weight: 600;">Class:</span> {{class_name}}</p>
                                    <p style="margin: 12px 0; font-size: 14px; color: #333;"><span style="color: #e83e8c; font-weight: 600;">Admission:</span> {{admission_no}}</p>
                                </div>
                            </div>
                        </div>
                        <div style="text-align: center;">
                            <div style="background: white; padding: 25px; border-radius: 12px; box-shadow: 0 4px 15px rgba(232, 62, 140, 0.1);">
                                <h4 style="margin: 0 0 20px 0; color: #d63384; font-size: 16px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px;">Payment Details</h4>
                                <div style="text-align: left;">
                                    <p style="margin: 12px 0; font-size: 14px; color: #333;"><span style="color: #d63384; font-weight: 600;">Date:</span> {{payment_date}}</p>
                                    <p style="margin: 12px 0; font-size: 14px; color: #333;"><span style="color: #d63384; font-weight: 600;">Mode:</span> {{payment_mode}}</p>
                                    <p style="margin: 12px 0; font-size: 14px; color: #333;"><span style="color: #d63384; font-weight: 600;">Status:</span> Paid</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div style="background: white; border: 3px solid #e83e8c; border-radius: 15px; overflow: hidden; margin-bottom: 30px;">
                    <div style="background: linear-gradient(135deg, #e83e8c 0%, #d63384 100%); color: white; padding: 20px; text-align: center;">
                        <h3 style="margin: 0; font-size: 20px; font-weight: 400; letter-spacing: 1px;">Payment Summary</h3>
                    </div>
                    <div style="padding: 30px;">
                        <div style="display: flex; justify-content: space-between; align-items: center; padding: 20px 0; border-bottom: 2px dashed #f8d7da;">
                            <span style="font-size: 18px; color: #333; font-style: italic;">{{fee_type}}</span>
                            <span style="font-size: 18px; font-weight: 600; color: #e83e8c;">₹{{fee_amount}}</span>
                        </div>
                        <div style="display: flex; justify-content: space-between; align-items: center; padding: 25px 0; background: linear-gradient(135deg, #fff0f6 0%, #ffe0ec 100%); margin: 20px -30px -30px -30px; padding-left: 30px; padding-right: 30px;">
                            <span style="font-size: 22px; font-weight: 700; color: #e83e8c; font-style: italic;">Total Amount</span>
                            <span style="font-size: 26px; font-weight: 700; color: #e83e8c;">₹{{total_amount}}</span>
                        </div>
                    </div>
                </div>
                
                <div style="text-align: center; padding: 25px; background: linear-gradient(135deg, #e83e8c 0%, #d63384 100%); color: white; border-radius: 15px;">
                    <p style="margin: 0; font-size: 18px; font-style: italic; font-weight: 300;">With Gratitude & Best Wishes</p>
                    <p style="margin: 10px 0 0 0; font-size: 12px; opacity: 0.8; letter-spacing: 1px;">DIGITALLY GENERATED • NO SIGNATURE REQUIRED</p>
                </div>
            </div>
        </div>`;
    }
    
    function getCompleteBill() {
        return `<div style="max-width: 850px; margin: 0 auto; padding: 0; font-family: Arial, sans-serif; background: white; box-shadow: 0 8px 32px rgba(0,0,0,0.12); border-radius: 16px; overflow: hidden;">
            <div style="background: linear-gradient(135deg, #17a2b8 0%, #138496 100%); color: white; padding: 40px;">
                <div style="display: flex; justify-content: space-between; align-items: start;">
                    <div style="flex: 1;">
                        <div style="background: rgba(255,255,255,0.2); width: 80px; height: 80px; border-radius: 12px; display: flex; align-items: center; justify-content: center; margin-bottom: 20px;">
                            <i class="fa fa-graduation-cap" style="font-size: 32px;"></i>
                        </div>
                        <h1 style="margin: 0; font-size: 28px; font-weight: 700;">{{school_name}}</h1>
                        <p style="margin: 8px 0; font-size: 16px; opacity: 0.9;">{{school_address}}</p>
                        <p style="margin: 8px 0; font-size: 14px; opacity: 0.8;">{{school_phone}} | {{school_email}}</p>
                    </div>
                    <div style="text-align: right;">
                        <div style="background: rgba(255,255,255,0.2); padding: 15px 25px; border-radius: 25px;">
                            <h2 style="margin: 0; font-size: 24px;">FEE RECEIPT</h2>
                        </div>
                    </div>
                </div>
            </div>
            
            <div style="padding: 40px;">
                <div style="display: grid; grid-template-columns: 2fr 1fr; gap: 30px; margin-bottom: 40px;">
                    <div style="background: #e6f7ff; padding: 30px; border-radius: 16px; border: 2px solid #17a2b8;">
                        <h4 style="margin: 0 0 20px 0; color: #17a2b8;">STUDENT DETAILS</h4>
                        <p style="margin: 10px 0;"><strong>Name:</strong> {{student_name}}</p>
                        <p style="margin: 10px 0;"><strong>Class:</strong> {{class_name}}</p>
                        <p style="margin: 10px 0;"><strong>Admission No:</strong> {{admission_no}}</p>
                        <p style="margin: 10px 0;"><strong>Father's Name:</strong> {{father_name}}</p>
                    </div>
                    
                    <div style="background: #fff8e1; padding: 30px; border-radius: 16px; border: 2px solid #ffc107;">
                        <h4 style="margin: 0 0 20px 0; color: #ffc107;">PAYMENT INFO</h4>
                        <p style="margin: 10px 0;"><strong>Date:</strong> {{payment_date}}</p>
                        <p style="margin: 10px 0;"><strong>Mode:</strong> {{payment_mode}}</p>
                        <p style="margin: 10px 0;"><strong>Receipt:</strong> {{receipt_no}}</p>
                        <div style="background: rgba(255,193,7,0.2); padding: 15px; border-radius: 12px; text-align: center; margin-top: 20px;">
                            <p style="margin: 0; font-size: 24px; font-weight: 700; color: #ffc107;">₹{{total_amount}}</p>
                        </div>
                    </div>
                </div>
                
                <table style="width: 100%; border-collapse: collapse; margin: 20px 0; border-radius: 16px; overflow: hidden; box-shadow: 0 4px 20px rgba(23,162,184,0.1);">
                    <thead>
                        <tr style="background: linear-gradient(135deg, #17a2b8 0%, #138496 100%); color: white;">
                            <th style="padding: 20px; text-align: left;">Fee Description</th>
                            <th style="padding: 20px; text-align: right;">Amount (₹)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr style="border-bottom: 1px solid #e9ecef;">
                            <td style="padding: 20px;">{{fee_type}}</td>
                            <td style="padding: 20px; text-align: right; font-weight: 600;">{{fee_amount}}</td>
                        </tr>
                        <tr style="background: linear-gradient(135deg, #17a2b8 0%, #138496 100%); color: white;">
                            <td style="padding: 25px; font-size: 18px; font-weight: 700;">TOTAL AMOUNT</td>
                            <td style="padding: 25px; text-align: right; font-size: 20px; font-weight: 700;">₹{{total_amount}}</td>
                        </tr>
                    </tbody>
                </table>
                
                <div style="display: grid; grid-template-columns: 1fr 2fr; gap: 30px; margin: 30px 0;">
                    <div style="text-align: center; background: #f8f9fa; padding: 25px; border-radius: 16px; border: 2px dashed #6c757d;">
                        <div style="background: white; width: 120px; height: 120px; margin: 0 auto 15px; border-radius: 12px; display: flex; align-items: center; justify-content: center;">
                            <i class="fa fa-qrcode" style="font-size: 48px; color: #6c757d;"></i>
                        </div>
                        <p style="margin: 0; font-size: 14px; color: #6c757d;">Scan for Verification</p>
                    </div>
                    
                    <div style="background: #fff8e1; padding: 25px; border-radius: 16px; border-left: 5px solid #ffc107;">
                        <h4 style="margin: 0 0 15px 0; color: #ffc107;">Terms & Conditions</h4>
                        <ul style="margin: 0; padding-left: 20px; color: #666; font-size: 13px; line-height: 1.6;">
                            <li>Fees once paid are non-refundable</li>
                            <li>Late fee will be charged after due date</li>
                            <li>Keep this receipt for future reference</li>
                            <li>Contact accounts for any queries</li>
                        </ul>
                    </div>
                </div>
                
                <div style="text-align: center; padding: 30px; background: linear-gradient(135deg, #17a2b8 0%, #138496 100%); color: white; border-radius: 16px;">
                    <p style="margin: 0; font-size: 18px; font-weight: 600;">Payment Successful!</p>
                    <p style="margin: 8px 0 0 0; font-size: 14px; opacity: 0.9;">Thank you for your payment. This is a computer generated receipt.</p>
                </div>
            </div>
        </div>`;
    }
    
    function getPremiumComplete() {
        return `<div style="max-width: 900px; margin: 0 auto; padding: 0; font-family: Georgia, serif; background: white; border-radius: 20px; overflow: hidden; box-shadow: 0 12px 40px rgba(102, 16, 242, 0.15);">
            <div style="background: linear-gradient(135deg, #6610f2 0%, #6f42c1 50%, #e83e8c 100%); color: white; padding: 50px; text-align: center;">
                <div style="background: rgba(255,255,255,0.2); width: 100px; height: 100px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 25px;">
                    <i class="fa fa-university" style="font-size: 40px;"></i>
                </div>
                <h1 style="margin: 0; font-size: 36px; font-weight: 300; font-style: italic;">{{school_name}}</h1>
                <p style="margin: 15px 0; font-size: 18px; opacity: 0.9;">{{school_address}}</p>
                <div style="margin-top: 30px; padding-top: 25px; border-top: 1px solid rgba(255,255,255,0.3);">
                    <h2 style="margin: 0; font-size: 24px; letter-spacing: 2px;">PREMIUM RECEIPT</h2>
                </div>
            </div>
            
            <div style="padding: 50px;">
                <div style="background: linear-gradient(135deg, #f8f6ff 0%, #f3e5f5 100%); padding: 40px; border-radius: 20px; margin-bottom: 40px; border: 3px solid #6610f2;">
                    <h3 style="margin: 0 0 30px 0; color: #6610f2; text-align: center;">STUDENT INFORMATION</h3>
                    <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 30px;">
                        <div style="background: white; padding: 25px; border-radius: 15px;">
                            <label style="color: #6610f2; font-size: 12px; text-transform: uppercase;">Student Name</label>
                            <p style="margin: 8px 0 0 0; font-size: 18px; font-weight: 600;">{{student_name}}</p>
                        </div>
                        <div style="background: white; padding: 25px; border-radius: 15px;">
                            <label style="color: #6610f2; font-size: 12px; text-transform: uppercase;">Class</label>
                            <p style="margin: 8px 0 0 0; font-size: 18px; font-weight: 600;">{{class_name}}</p>
                        </div>
                        <div style="background: white; padding: 25px; border-radius: 15px;">
                            <label style="color: #6610f2; font-size: 12px; text-transform: uppercase;">Admission No</label>
                            <p style="margin: 8px 0 0 0; font-size: 18px; font-weight: 600;">{{admission_no}}</p>
                        </div>
                    </div>
                </div>
                
                <div style="display: grid; grid-template-columns: 2fr 1fr; gap: 40px; margin-bottom: 40px;">
                    <div style="background: white; border: 4px solid #6f42c1; border-radius: 20px; overflow: hidden;">
                        <div style="background: linear-gradient(135deg, #6f42c1 0%, #6610f2 100%); color: white; padding: 25px; text-align: center;">
                            <h3 style="margin: 0; font-size: 22px;">PAYMENT BREAKDOWN</h3>
                        </div>
                        <div style="padding: 30px;">
                            <div style="display: flex; justify-content: space-between; padding: 20px 0; border-bottom: 2px solid #f8f6ff;">
                                <span style="font-size: 16px;">{{fee_type}}</span>
                                <span style="font-size: 18px; font-weight: 600; color: #6610f2;">₹{{fee_amount}}</span>
                            </div>
                            <div style="display: flex; justify-content: space-between; padding: 25px 0; background: linear-gradient(135deg, #6610f2 0%, #6f42c1 100%); color: white; margin: 20px -30px -30px; padding-left: 30px; padding-right: 30px;">
                                <span style="font-size: 20px; font-weight: 700;">TOTAL AMOUNT</span>
                                <span style="font-size: 24px; font-weight: 700;">₹{{total_amount}}</span>
                            </div>
                        </div>
                    </div>
                    
                    <div style="background: linear-gradient(135deg, #fff8e1 0%, #ffecb3 100%); padding: 30px; border-radius: 20px; border: 3px solid #ffc107;">
                        <h4 style="margin: 0 0 20px 0; color: #ffc107; text-align: center;">PAYMENT INFO</h4>
                        <p style="margin: 15px 0;"><strong>Date:</strong> {{payment_date}}</p>
                        <p style="margin: 15px 0;"><strong>Mode:</strong> {{payment_mode}}</p>
                        <p style="margin: 15px 0;"><strong>Receipt:</strong> {{receipt_no}}</p>
                        <div style="background: rgba(255,193,7,0.3); padding: 20px; border-radius: 15px; text-align: center; margin-top: 20px;">
                            <p style="margin: 0; font-size: 18px; font-weight: 700; color: #28a745;">✅ PAID</p>
                        </div>
                    </div>
                </div>
                
                <div style="text-align: center; padding: 40px; background: linear-gradient(135deg, #6610f2 0%, #6f42c1 100%); color: white; border-radius: 20px;">
                    <h3 style="margin: 0 0 15px 0; font-size: 24px; font-style: italic;">Thank You for Your Payment</h3>
                    <p style="margin: 0; font-size: 16px; opacity: 0.9;">This is a premium digitally generated receipt</p>
                </div>
            </div>
        </div>`;
    }
    
    function getSchoolFeeReceipt() {
        return `<div style="max-width: 900px; margin: 0 auto; padding: 0; font-family: Arial, sans-serif; background: white; border: 3px solid #000;">
            <!-- Header Section -->
            <div style="display: flex; justify-content: space-between; align-items: start; padding: 15px; border-bottom: 2px solid #000;">
                <!-- Left Side - Logo and School Info -->
                <div style="display: flex; align-items: start; gap: 15px;">
                    <div style="width: 60px; height: 60px; border: 2px solid #000; border-radius: 50%; display: flex; align-items: center; justify-content: center; background: #f8f9fa;">
                        <i class="fa fa-graduation-cap" style="font-size: 24px; color: #000;"></i>
                    </div>
                    <div>
                        <h2 style="margin: 0; font-size: 20px; font-weight: bold; color: #000;">{{school_name}}</h2>
                        <p style="margin: 2px 0; font-size: 12px; color: #000;">{{school_address}}</p>
                        <p style="margin: 2px 0; font-size: 12px; color: #000;">Mob. :- {{school_phone}}</p>
                        <p style="margin: 2px 0; font-size: 12px; color: #000;">SESSION : (2025-26)</p>
                    </div>
                </div>
                
                <!-- Right Side - Photo Section -->
                <div style="text-align: center;">
                    <div style="width: 80px; height: 80px; border: 2px solid #000; background: #e9ecef; display: flex; align-items: center; justify-content: center; margin-bottom: 5px;">
                        <span style="font-size: 10px; color: #666;">PHOTO NOT AVAILABLE</span>
                    </div>
                </div>
            </div>
            
            <!-- Receipt Title and Details -->
            <div style="text-align: center; padding: 10px; border-bottom: 2px solid #000;">
                <div style="display: inline-block; border: 2px solid #000; padding: 8px 20px; background: #f8f9fa;">
                    <h3 style="margin: 0; font-size: 18px; font-weight: bold; color: #000;">FEES RECEIPT</h3>
                </div>
            </div>
            
            <!-- Student Information -->
            <div style="display: flex; justify-content: space-between; padding: 10px; border-bottom: 1px solid #000;">
                <div style="flex: 1;">
                    <p style="margin: 3px 0; font-size: 12px; color: #000;"><strong>Rcpt. No. :</strong> {{receipt_no}}</p>
                    <p style="margin: 3px 0; font-size: 12px; color: #000;"><strong>Name :</strong> {{student_name}}</p>
                    <p style="margin: 3px 0; font-size: 12px; color: #000;"><strong>Father :</strong> {{father_name}}</p>
                    <p style="margin: 3px 0; font-size: 12px; color: #000;"><strong>Mother :</strong> {{mother_name}}</p>
                    <p style="margin: 3px 0; font-size: 12px; color: #000;"><strong>Mobile :</strong> {{parent_phone}}</p>
                    <p style="margin: 3px 0; font-size: 12px; color: #000;"><strong>Address :</strong> {{student_address}}</p>
                </div>
                <div style="flex: 1; text-align: right;">
                    <p style="margin: 3px 0; font-size: 12px; color: #000;"><strong>DATE :</strong> {{payment_date}}</p>
                    <p style="margin: 3px 0; font-size: 12px; color: #000;"><strong>Roll No. :</strong> {{roll_no}} | <strong>SR No. :</strong> {{sr_no}}</p>
                    <p style="margin: 3px 0; font-size: 12px; color: #000;"><strong>Class :</strong> {{class_name}}</p>
                    <p style="margin: 3px 0; font-size: 12px; color: #000;"><strong>Admsn No. :</strong> {{admission_no}} | <strong>DOB :</strong> {{dob}}</p>
                    <p style="margin: 3px 0; font-size: 12px; color: #000;"><strong>Category :</strong> {{category}} | <strong>Gender :</strong> {{gender}}</p>
                </div>
            </div>
            
            <!-- Payment Month -->
            <div style="display: flex; justify-content: space-between; padding: 8px; border-bottom: 1px solid #000;">
                <div>
                    <p style="margin: 0; font-size: 12px; color: #000;"><strong>Paid For Month :</strong> {{fee_month}}</p>
                </div>
                <div style="text-align: right;">
                    <p style="margin: 0; font-size: 12px; color: #000;"><strong>Old Bal</strong></p>
                    <p style="margin: 0; font-size: 12px; color: #000;">0.00</p>
                </div>
            </div>
            
            <!-- Fee Details Table -->
            <div style="border-bottom: 2px solid #000;">
                <table style="width: 100%; border-collapse: collapse;">
                    <thead>
                        <tr style="background: #f8f9fa;">
                            <th style="padding: 8px; text-align: left; border: 1px solid #000; font-size: 14px; font-weight: bold;">FEES DETAILS</th>
                            <th style="padding: 8px; text-align: right; border: 1px solid #000; font-size: 14px; font-weight: bold;">AMOUNT</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td style="padding: 5px 8px; border: 1px solid #000; font-size: 12px;">● Admission Fees</td>
                            <td style="padding: 5px 8px; border: 1px solid #000; font-size: 12px; text-align: right;">800.00</td>
                        </tr>
                        <tr>
                            <td style="padding: 5px 8px; border: 1px solid #000; font-size: 12px;">● Annual Charge</td>
                            <td style="padding: 5px 8px; border: 1px solid #000; font-size: 12px; text-align: right;">500.00</td>
                        </tr>
                        <tr>
                            <td style="padding: 5px 8px; border: 1px solid #000; font-size: 12px;">● Caution Money</td>
                            <td style="padding: 5px 8px; border: 1px solid #000; font-size: 12px; text-align: right;">1000.00</td>
                        </tr>
                        <tr>
                            <td style="padding: 5px 8px; border: 1px solid #000; font-size: 12px;">● Development Charge</td>
                            <td style="padding: 5px 8px; border: 1px solid #000; font-size: 12px; text-align: right;">500.00</td>
                        </tr>
                        <tr>
                            <td style="padding: 5px 8px; border: 1px solid #000; font-size: 12px;">● Misc.Exp.(monthly)</td>
                            <td style="padding: 5px 8px; border: 1px solid #000; font-size: 12px; text-align: right;">100.00</td>
                        </tr>
                        <tr>
                            <td style="padding: 5px 8px; border: 1px solid #000; font-size: 12px;">● Registration And prospectus.</td>
                            <td style="padding: 5px 8px; border: 1px solid #000; font-size: 12px; text-align: right;">300.00</td>
                        </tr>
                        <tr>
                            <td style="padding: 5px 8px; border: 1px solid #000; font-size: 12px;">● Stationary Charge</td>
                            <td style="padding: 5px 8px; border: 1px solid #000; font-size: 12px; text-align: right;">300.00</td>
                        </tr>
                        <tr>
                            <td style="padding: 5px 8px; border: 1px solid #000; font-size: 12px;">● Tuition Fees</td>
                            <td style="padding: 5px 8px; border: 1px solid #000; font-size: 12px; text-align: right;">900.00</td>
                        </tr>
                        <tr>
                            <td style="padding: 5px 8px; border: 2px solid #000; font-size: 12px;">● Transport : Route</td>
                            <td style="padding: 5px 8px; border: 2px solid #000; font-size: 12px; text-align: right; font-weight: bold;">4400.00</td>
                        </tr>
                    </tbody>
                </table>
            </div>
            
            <!-- Transport and Total Section -->
            <div style="display: flex; padding: 8px;">
                <div style="flex: 1; border-right: 1px solid #000; padding-right: 10px;">
                    <p style="margin: 3px 0; font-size: 12px; color: #000;"><strong>Month :</strong></p>
                    <div style="height: 40px; border: 1px solid #000; margin: 5px 0;"></div>
                    <p style="margin: 3px 0; font-size: 12px; color: #000;"><strong>Amount :</strong></p>
                </div>
                <div style="flex: 1; padding-left: 10px;">
                    <table style="width: 100%; border-collapse: collapse;">
                        <tr>
                            <td style="padding: 3px; font-size: 12px; font-weight: bold; border: 1px solid #000;">Total</td>
                            <td style="padding: 3px; font-size: 12px; text-align: right; border: 1px solid #000;">4400.00</td>
                        </tr>
                        <tr>
                            <td style="padding: 3px; font-size: 12px; font-weight: bold; border: 1px solid #000;">Consession</td>
                            <td style="padding: 3px; font-size: 12px; text-align: right; border: 1px solid #000;">400.00</td>
                        </tr>
                        <tr>
                            <td style="padding: 3px; font-size: 12px; font-weight: bold; border: 1px solid #000;">Other Charge</td>
                            <td style="padding: 3px; font-size: 12px; text-align: right; border: 1px solid #000;">0.00</td>
                        </tr>
                        <tr>
                            <td style="padding: 3px; font-size: 12px; font-weight: bold; border: 1px solid #000;">Remain</td>
                            <td style="padding: 3px; font-size: 12px; text-align: right; border: 1px solid #000;">0.00</td>
                        </tr>
                    </table>
                </div>
            </div>
            
            <!-- Received Amount Section -->
            <div style="display: flex; justify-content: space-between; align-items: center; padding: 10px; border-top: 2px solid #000;">
                <div style="display: flex; align-items: center; gap: 10px;">
                    <div style="border: 2px solid #000; padding: 5px 10px; background: #f8f9fa;">
                        <p style="margin: 0; font-size: 12px; font-weight: bold; color: #000;">RECEIVED AMOUNT</p>
                    </div>
                    <div style="border: 2px solid #000; padding: 10px 20px; background: #fff;">
                        <p style="margin: 0; font-size: 20px; font-weight: bold; color: #000;">₹ {{total_amount}}</p>
                    </div>
                </div>
                <div style="text-align: right;">
                    <p style="margin: 0; font-size: 12px; color: #000;">Cash May 7 2025 10:27AM -Admin</p>
                </div>
            </div>
            
            <!-- Amount in Words -->
            <div style="padding: 8px; border-top: 1px solid #000;">
                <p style="margin: 0; font-size: 12px; color: #000; text-align: center;"><strong>Amount Received : Four Thousand Rupees only</strong></p>
            </div>
            
            <!-- Footer -->
            <div style="display: flex; justify-content: space-between; padding: 10px; border-top: 1px solid #000;">
                <div>
                    <p style="margin: 2px 0; font-size: 10px; color: #000;">* Payment once paid not refundable.</p>
                    <p style="margin: 2px 0; font-size: 10px; color: #000;">* Cheques are subject to clearance.</p>
                    <p style="margin: 2px 0; font-size: 10px; color: #000;">* One month notice must be given prior to the withdrawal</p>
                </div>
                <div style="text-align: right;">
                    <p style="margin: 0; font-size: 12px; color: #000;"><strong>Received by</strong></p>
                    <div style="border-bottom: 1px dotted #000; width: 150px; margin: 20px 0;"></div>
                </div>
            </div>
        </div>`;
    }
    
    function getModernInvoice() {
        return `<div style="max-width: 800px; margin: 0 auto; padding: 0; font-family: 'Segoe UI', Arial, sans-serif; box-shadow: 0 0 20px rgba(0,0,0,0.1);">
            <div style="display: flex; justify-content: space-between; align-items: start; padding: 30px; background: linear-gradient(135deg, #6f42c1 0%, #764ba2 100%); color: white;">
                <div>
                    <h1 style="margin: 0; font-size: 32px; font-weight: 700;">{{school_name}}</h1>
                    <p style="margin: 8px 0; font-size: 16px; opacity: 0.9;">{{school_address}}</p>
                    <p style="margin: 8px 0; font-size: 14px; opacity: 0.8;">{{school_phone}} | {{school_email}}</p>
                </div>
                <div style="text-align: right;">
                    <h2 style="margin: 0; font-size: 28px; letter-spacing: 2px;">INVOICE</h2>
                    <p style="margin: 8px 0; font-size: 18px;"><strong>INV-{{invoice_no}}</strong></p>
                    <p style="margin: 8px 0; font-size: 14px;">Date: {{invoice_date}}</p>
                </div>
            </div>
            
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 30px; padding: 30px; background: white;">
                <div style="padding: 20px; background: #f8f6ff; border-radius: 8px; border-left: 5px solid #6f42c1;">
                    <h4 style="margin: 0 0 15px 0; color: #6f42c1; font-size: 18px;">Bill To:</h4>
                    <p style="margin: 5px 0; font-weight: 600; color: #333;">{{student_name}}</p>
                    <p style="margin: 5px 0; color: #666;">Class: {{class_name}} - {{section_name}}</p>
                    <p style="margin: 5px 0; color: #666;">Admission No: {{admission_no}}</p>
                </div>
                <div style="padding: 20px; background: #f0f9ff; border-radius: 8px; border-left: 5px solid #0ea5e9;">
                    <h4 style="margin: 0 0 15px 0; color: #0ea5e9; font-size: 18px;">Payment Details:</h4>
                    <p style="margin: 5px 0; color: #333;"><strong>Amount:</strong> ₹{{total_amount}}</p>
                    <p style="margin: 5px 0; color: #333;"><strong>Due Date:</strong> {{due_date}}</p>
                    <p style="margin: 5px 0; color: #333;"><strong>Status:</strong> <span style="color: #059669; font-weight: 600;">Paid</span></p>
                </div>
            </div>
        </div>`;
    }
    
    function getDetailedReceipt() {
        return `<div style="max-width: 750px; margin: 0 auto; padding: 25px; font-family: 'Arial', sans-serif; border: 3px solid #dc3545; border-radius: 12px; background: white;">
            <div style="text-align: center; padding: 25px; background: linear-gradient(135deg, #dc3545 0%, #c82333 100%); color: white; border-radius: 8px; margin-bottom: 25px;">
                <h2 style="margin: 0; font-size: 26px; font-weight: 700;">{{school_name}}</h2>
                <p style="margin: 8px 0; font-size: 15px; opacity: 0.9;">{{school_address}}</p>
                <h3 style="margin: 15px 0; font-size: 22px; letter-spacing: 1px;">DETAILED FEE RECEIPT</h3>
            </div>
            
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin: 25px 0; padding: 20px; background: #fff5f5; border-radius: 8px;">
                <div><strong style="color: #dc3545;">Student:</strong> {{student_name}}</div>
                <div><strong style="color: #dc3545;">Admission No:</strong> {{admission_no}}</div>
                <div><strong style="color: #dc3545;">Class:</strong> {{class_name}} - {{section_name}}</div>
                <div><strong style="color: #dc3545;">Receipt No:</strong> {{receipt_no}}</div>
            </div>
            
            <table style="width: 100%; border-collapse: collapse; margin: 25px 0; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
                <thead>
                    <tr style="background: linear-gradient(135deg, #dc3545 0%, #c82333 100%); color: white;">
                        <th style="padding: 15px; text-align: left; font-size: 16px;">Fee Description</th>
                        <th style="padding: 15px; text-align: center; font-size: 16px;">Period</th>
                        <th style="padding: 15px; text-align: right; font-size: 16px;">Amount</th>
                    </tr>
                </thead>
                <tbody>
                    <tr style="background: white;">
                        <td style="padding: 12px 15px; border-bottom: 1px solid #e9ecef;">Tuition Fee</td>
                        <td style="padding: 12px 15px; border-bottom: 1px solid #e9ecef; text-align: center;">{{fee_month}}</td>
                        <td style="padding: 12px 15px; border-bottom: 1px solid #e9ecef; text-align: right;">₹{{tuition_fee}}</td>
                    </tr>
                    <tr style="background: #f8f9fa;">
                        <td style="padding: 12px 15px; border-bottom: 1px solid #e9ecef;">Transport Fee</td>
                        <td style="padding: 12px 15px; border-bottom: 1px solid #e9ecef; text-align: center;">{{fee_month}}</td>
                        <td style="padding: 12px 15px; border-bottom: 1px solid #e9ecef; text-align: right;">₹{{transport_fee}}</td>
                    </tr>
                    <tr style="background: linear-gradient(135deg, #28a745 0%, #20c997 100%); color: white;">
                        <td style="padding: 15px; font-weight: 700; font-size: 16px;" colspan="2">TOTAL AMOUNT</td>
                        <td style="padding: 15px; text-align: right; font-weight: 700; font-size: 18px;">₹{{total_amount}}</td>
                    </tr>
                </tbody>
            </table>
        </div>`;
    }
    
    function getCompactReceipt() {
        return `<div style="max-width: 500px; margin: 0 auto; padding: 20px; font-family: 'Courier New', monospace; border: 2px dashed #ffc107; background: #fffbf0;">
            <div style="text-align: center; border-bottom: 2px dashed #ffc107; padding-bottom: 15px; margin-bottom: 15px;">
                <h3 style="margin: 0; color: #856404; font-size: 20px;">{{school_name}}</h3>
                <p style="margin: 5px 0; font-size: 12px; color: #6c757d;">{{school_address}}</p>
                <h4 style="margin: 10px 0; color: #ffc107; font-size: 16px;">*** FEE RECEIPT ***</h4>
            </div>
            
            <div style="margin: 15px 0; font-size: 13px; line-height: 1.6;">
                <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                    <span>Student:</span><span>{{student_name}}</span>
                </div>
                <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                    <span>Class:</span><span>{{class_name}}-{{section_name}}</span>
                </div>
                <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                    <span>Receipt:</span><span>{{receipt_no}}</span>
                </div>
                <div style="border-top: 1px dashed #ffc107; margin: 10px 0; padding-top: 10px;">
                    <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                        <span>{{fee_type}}:</span><span>₹{{fee_amount}}</span>
                    </div>
                    <div style="display: flex; justify-content: space-between; font-weight: bold; border-top: 1px dashed #ffc107; padding-top: 5px;">
                        <span>TOTAL:</span><span>₹{{total_amount}}</span>
                    </div>
                </div>
            </div>
            
            <div style="text-align: center; margin-top: 15px; padding-top: 10px; border-top: 2px dashed #ffc107; font-size: 10px; color: #6c757d;">
                <p style="margin: 2px 0;">Payment Date: {{payment_date}}</p>
                <p style="margin: 2px 0;">*** THANK YOU ***</p>
            </div>
        </div>`;
    }

    // Clear canvas
    $(document).on('click', '#clear-canvas-btn', function() {
        if (confirm('Are you sure you want to clear the canvas?')) {
            if (editor) {
                editor.setComponents('');
            }
        }
    });

    // Preview functionality with actual data
    $(document).on('click', '#preview-btn', function() {
        if (window.editor) {
            var htmlContent = window.editor.getHtml();
            var cssContent = window.editor.getCss();
            
            // Send AJAX request to get preview with actual data
            $.ajax({
                url: '<?php echo base_url(); ?>admin/simple_receipt/ajax_preview',
                type: 'POST',
                data: {
                    template_content: htmlContent
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        // Create preview window with rendered content
                        var previewWindow = window.open('', 'preview', 'width=800,height=600,scrollbars=yes');
                        previewWindow.document.write(`
                            <!DOCTYPE html>
                            <html>
                            <head>
                                <title>Template Preview with Sample Data</title>
                                <style>
                                    body { font-family: Arial, sans-serif; margin: 20px; }
                                    .preview-header { 
                                        background: #f8f9fa; 
                                        padding: 15px; 
                                        border: 1px solid #dee2e6; 
                                        border-radius: 5px; 
                                        margin-bottom: 20px; 
                                        text-align: center;
                                    }
                                    .preview-content { 
                                        border: 1px solid #dee2e6; 
                                        padding: 20px; 
                                        border-radius: 5px; 
                                    }
                                    ${cssContent}
                                </style>
                            </head>
                            <body>
                                <div class="preview-header">
                                    <h3><i class="fa fa-eye"></i> Template Preview with Sample Data</h3>
                                    <p><small>This preview shows how your template will look with actual data</small></p>
                                </div>
                                <div class="preview-content">
                                    ${response.content}
                                </div>
                            </body>
                            </html>
                        `);
                        previewWindow.document.close();
                    } else {
                        alert('Preview failed: ' + response.message);
                    }
                },
                error: function() {
                    // Fallback to basic preview
                    var previewWindow = window.open('', 'preview', 'width=800,height=600,scrollbars=yes');
                    previewWindow.document.write(`
                        <!DOCTYPE html>
                        <html>
                        <head>
                            <title>Template Preview</title>
                            <style>
                                body { font-family: Arial, sans-serif; margin: 20px; }
                                ${cssContent}
                            </style>
                        </head>
                        <body>
                            ${htmlContent}
                        </body>
                        </html>
                    `);
                    previewWindow.document.close();
                }
            });
        }
    });

    // Save template content when form is submitted
    $('form').on('submit', function(e) {
        var htmlContent = editor.getHtml();
        var cssContent = editor.getCss();
        var fullTemplate = htmlContent + '<style>' + cssContent + '</style>';
        $('#template_content').val(fullTemplate);
    });
});
</script>

<style>
.gjs-editor-wrapper {
    font-family: Arial, sans-serif;
}

.gjs-blocks-container h5 {
    color: #333;
    font-weight: bold;
}

.panel-btn {
    border: 1px solid #ddd !important;
    background: #fff !important;
    color: #333 !important;
}

.panel-btn.active {
    background: #007bff !important;
    color: white !important;
    border-color: #007bff !important;
}

.gjs-block {
    background: white;
    border: 1px solid #ddd;
    border-radius: 3px;
    margin: 5px 0;
    padding: 10px;
    cursor: pointer;
    transition: all 0.2s;
}

.gjs-block:hover {
    border-color: #007bff;
    background: #f8f9fa;
}

.gjs-block-label {
    font-size: 12px;
    font-weight: bold;
    color: #333;
}

.gjs-frame {
    background: white;
    border: 1px solid #ddd;
}

.gjs-cv-canvas {
    background: #f5f5f5;
}

#gjs {
    border: 0;
}

.gjs-toolbar button {
    margin-right: 5px;
}
</style>

<script>
// Add global functions for onclick handlers
window.openEditor = function() {
    console.log('Opening editor...');
    $('#visual-editor-modal').modal('show');
    
    setTimeout(function() {
        if (!window.editor) {
            console.log('Initializing GrapesJS editor');
            window.editor = grapesjs.init({
                container: '#gjs',
                height: '100%',
                width: 'auto',
                storageManager: false,
                blockManager: {
                    appendTo: '#blocks'
                },
                layerManager: {
                    appendTo: '#layers-container'
                },
                styleManager: {
                    appendTo: '#styles-container'
                },
                traitManager: {
                    appendTo: '#traits-container'
                },
                canvas: {
                    styles: [
                        'https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css'
                    ]
                },
                deviceManager: {
                    devices: [
                        {
                            name: 'Desktop',
                            width: '',
                        },
                        {
                            name: 'Tablet',
                            width: '768px',
                            widthMedia: '992px',
                        },
                        {
                            name: 'Mobile',
                            width: '320px',
                            widthMedia: '768px',
                        }
                    ]
                }
            });
            
            // Add components after editor initialization
            initializeEditorComponents();
        }
        
        var existingContent = $('#template_content').val();
        if (existingContent) {
            window.editor.setComponents(existingContent);
        }
    }, 300);
};

window.loadQuickSample = function() {
    var sampleTemplate = getClassicTemplate();
    $('#template_content').val(sampleTemplate);
    $('#load-sample-quick').text('Sample Loaded!').addClass('btn-success').removeClass('btn-outline-info');
    setTimeout(function() {
        $('#load-sample-quick').text('Load Sample Template').removeClass('btn-success').addClass('btn-outline-info');
    }, 2000);
};

// Editor Mode Switching
$(document).ready(function() {
    // Editor mode button click
    $('.editor-mode-btn').click(function() {
        var mode = $(this).data('mode');
        
        // Update button states
        $('.editor-mode-btn').removeClass('active btn-primary').addClass('btn-outline-primary');
        $(this).removeClass('btn-outline-primary').addClass('btn-primary active');
        
        if (mode === 'visual') {
            // Show visual editor, hide HTML editor
            $('#visual-editor-section').show();
            $('#html-editor-section').hide();
        } else if (mode === 'html') {
            // Show HTML editor, hide visual editor
            $('#visual-editor-section').hide();
            $('#html-editor-section').show();
            
            // Sync content from visual editor to HTML editor if exists
            if (window.editor) {
                var htmlContent = window.editor.getHtml();
                var cssContent = window.editor.getCss();
                var fullTemplate = htmlContent + (cssContent ? '<style>' + cssContent + '</style>' : '');
                $('#html-code-editor').val(fullTemplate);
            }
        }
    });
    
    // Sync HTML editor content to hidden field
    $('#html-code-editor').on('input', function() {
        $('#template_content').val($(this).val());
    });
    
    // Form submission handler
    $('form').on('submit', function(e) {
        var activeMode = $('.editor-mode-btn.active').data('mode');
        
        if (activeMode === 'html') {
            // Use HTML editor content
            $('#template_content').val($('#html-code-editor').val());
        } else if (window.editor) {
            // Use visual editor content
            var htmlContent = window.editor.getHtml();
            var cssContent = window.editor.getCss();
            var fullTemplate = htmlContent + (cssContent ? '<style>' + cssContent + '</style>' : '');
            $('#template_content').val(fullTemplate);
        }
    });
});

// Load Transport Template Function
window.loadTransportTemplate = function() {
    var transportTemplate = `<div class="transport-receipt-container" style="max-width: 600px; margin: 0 auto; padding: 20px; font-family: Arial, sans-serif; border: 2px solid #333; background: #fff;">
    <!-- School Header -->
    <div class="receipt-header" style="text-align: center; border-bottom: 2px solid #333; padding-bottom: 20px; margin-bottom: 20px;">
        <h2 style="margin: 0; color: #333; font-size: 24px; font-weight: bold;">{{school_name}}</h2>
        <p style="margin: 5px 0; color: #666; font-size: 14px;">{{school_address}}</p>
        <p style="margin: 5px 0; color: #666; font-size: 14px;">Phone: {{school_phone}} | Email: {{school_email}}</p>
        <h3 style="margin: 15px 0 10px 0; color: #d32f2f; font-size: 18px; font-weight: bold; text-transform: uppercase;">🚌 Transport Fee Receipt</h3>
    </div>
    
    <!-- Receipt Details -->
    <div class="receipt-details" style="margin-bottom: 20px; background: #f9f9f9; padding: 15px; border-radius: 5px;">
        <div style="display: flex; justify-content: space-between; margin-bottom: 10px; flex-wrap: wrap;">
            <span style="font-weight: bold; color: #333;"><strong>Receipt No:</strong> {{receipt_number}}</span>
            <span style="font-weight: bold; color: #333;"><strong>Date:</strong> {{receipt_date}}</span>
        </div>
        <div style="display: flex; justify-content: space-between; margin-bottom: 10px; flex-wrap: wrap;">
            <span style="color: #333;"><strong>Student Name:</strong> {{student_name}}</span>
            <span style="color: #333;"><strong>Admission No:</strong> {{admission_no}}</span>
        </div>
        <div style="display: flex; justify-content: space-between; margin-bottom: 10px; flex-wrap: wrap;">
            <span style="color: #333;"><strong>Class:</strong> {{class_section}}</span>
            <span style="color: #333;"><strong>Father Name:</strong> {{father_name}}</span>
        </div>
    </div>
    
    <!-- Fee Details Table -->
    <table class="fee-table" style="width: 100%; border-collapse: collapse; margin-bottom: 20px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
        <thead>
            <tr style="background: linear-gradient(135deg, #4CAF50, #45a049); color: white;">
                <th style="border: 1px solid #333; padding: 12px; text-align: left; font-weight: bold;">Description</th>
                <th style="border: 1px solid #333; padding: 12px; text-align: center; font-weight: bold;">Month</th>
                <th style="border: 1px solid #333; padding: 12px; text-align: right; font-weight: bold;">Amount</th>
            </tr>
        </thead>
        <tbody>
            <tr style="background: #fff;">
                <td style="border: 1px solid #ddd; padding: 12px; color: #333;">🚌 Transport Fee</td>
                <td style="border: 1px solid #ddd; padding: 12px; text-align: center; color: #333; font-weight: bold;">{{fee_month}}</td>
                <td style="border: 1px solid #ddd; padding: 12px; text-align: right; color: #333; font-weight: bold;">{{currency_symbol}}{{paid_amount}}</td>
            </tr>
        </tbody>
        <tfoot>
            <tr style="background: linear-gradient(135deg, #f5f5f5, #e8e8e8); font-weight: bold;">
                <td colspan="2" style="border: 1px solid #333; padding: 12px; text-align: right; color: #333; font-size: 16px;">Total Paid:</td>
                <td style="border: 1px solid #333; padding: 12px; text-align: right; color: #d32f2f; font-size: 16px; font-weight: bold;">{{currency_symbol}}{{paid_amount}}</td>
            </tr>
        </tfoot>
    </table>
    
    <!-- Payment Information -->
    <div class="payment-info" style="margin-top: 30px; display: flex; justify-content: space-between; align-items: flex-start; flex-wrap: wrap;">
        <div class="payment-details" style="flex: 1; min-width: 200px;">
            <p style="margin: 0; color: #333; font-size: 14px;"><strong>💳 Payment Mode:</strong> Cash</p>
            <p style="margin: 8px 0; color: #333; font-size: 14px;"><strong>👤 Received By:</strong> {{collected_by}}</p>
            <p style="margin: 8px 0; color: #666; font-size: 12px;"><strong>🕒 Time:</strong> {{receipt_time}}</p>
        </div>
        <div class="signature-section" style="text-align: right; flex: 1; min-width: 200px;">
            <p style="margin: 0; border-bottom: 1px solid #333; width: 150px; margin-left: auto; padding-bottom: 2px;">&nbsp;</p>
            <p style="margin: 8px 0; color: #666; font-size: 12px; text-align: center;">Authorized Signature</p>
        </div>
    </div>
    
    <!-- Footer Message -->
    <div class="receipt-footer" style="text-align: center; margin-top: 30px; padding-top: 20px; border-top: 1px dashed #ccc;">
        <p style="margin: 0; color: #666; font-size: 12px; font-style: italic;">✅ Thank you for your payment. Keep this receipt for your records.</p>
        <p style="margin: 5px 0; color: #999; font-size: 10px;">This is a computer generated receipt and does not require signature.</p>
    </div>
</div>`;
    
    $('#html-code-editor').val(transportTemplate);
    $('#template_content').val(transportTemplate);
    
    // Show success message
    $(this).text('Loaded!').removeClass('btn-success').addClass('btn-info');
    setTimeout(function() {
        $('[onclick="loadTransportTemplate()"]').text('Load Transport Template').removeClass('btn-info').addClass('btn-success');
    }, 2000);
};

// Show Variables Function
window.showVariables = function() {
    $('#variables-help').toggle();
    var btn = $('[onclick="showVariables()"]');
    if ($('#variables-help').is(':visible')) {
        btn.text('Hide Variables').removeClass('btn-info').addClass('btn-warning');
    } else {
        btn.text('Show Variables').removeClass('btn-warning').addClass('btn-info');
    }
};
</script>
