<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-edit"></i> Edit Receipt Template
            <small>Edit receipt template</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/simple_receipt">Receipt Templates</a></li>
            <li class="active">Edit</li>
        </ol>
    </section>

    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <?php if ($this->session->flashdata('msg')) { ?>
                    <?php echo $this->session->flashdata('msg'); ?>
                <?php } ?>

                <?php echo form_open('admin/simple_receipt/edit/' . $template->id, array('class' => 'form-horizontal')); ?>
                
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Template Information</h3>
                    </div>

                    <div class="box-body">
                        <?php if (validation_errors()) { ?>
                            <div class="alert alert-danger">
                                <?php echo validation_errors(); ?>
                            </div>
                        <?php } ?>

                        <div class="form-group">
                            <label for="template_name" class="col-sm-2 control-label">Template Name <span class="text-red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" class="form-control" name="template_name" id="template_name" 
                                       value="<?php echo set_value('template_name', $template->template_name); ?>" placeholder="Enter template name">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="template_code" class="col-sm-2 control-label">Template Code <span class="text-red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" class="form-control" name="template_code" id="template_code" 
                                       value="<?php echo set_value('template_code', $template->template_code); ?>" placeholder="Enter unique template code">
                                <small class="text-muted">Only letters, numbers, underscores and hyphens allowed</small>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="template_content" class="col-sm-2 control-label">Template Content <span class="text-red">*</span></label>
                            <div class="col-sm-10">
                                <!-- Editor Mode Selection -->
                                <div class="editor-mode-selection" style="margin-bottom: 15px;">
                                    <div class="btn-group" role="group">
                                        <button type="button" class="btn btn-primary btn-sm editor-mode-btn active" data-mode="visual">
                                            <i class="fa fa-paint-brush"></i> Visual Editor
                                        </button>
                                        <button type="button" class="btn btn-outline-primary btn-sm editor-mode-btn" data-mode="html">
                                            <i class="fa fa-code"></i> HTML Code Editor
                                        </button>
                                    </div>
                                </div>

                                <!-- Hidden textarea to store template content -->
                                <textarea name="template_content" id="template_content" style="display: none;"><?php echo set_value('template_content', $template->template_content); ?></textarea>
                                
                                <!-- Visual Editor Launch (Default) -->
                                <div id="visual-editor-section" class="template-editor-launch" style="border: 2px dashed #007bff; border-radius: 8px; padding: 40px; text-align: center; background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);">
                                    <div class="launch-content">
                                        <i class="fa fa-paint-brush" style="font-size: 48px; color: #007bff; margin-bottom: 15px;"></i>
                                        <h4 style="color: #333; margin-bottom: 10px;">Visual Template Designer</h4>
                                        <p style="color: #666; margin-bottom: 20px;">Edit your receipt template with our drag-and-drop editor</p>
                                        <button type="button" id="open-editor-btn" class="btn btn-primary btn-lg" onclick="openEditor()">
                                            <i class="fa fa-edit"></i> Open Visual Editor
                                        </button>
                                        <div style="margin-top: 15px;">
                                            <button type="button" id="load-sample-quick" class="btn btn-outline-info btn-sm" onclick="loadQuickSample()">
                                                <i class="fa fa-magic"></i> Load Sample Template
                                            </button>
                                        </div>
                                    </div>
                                </div>

                                <!-- HTML Code Editor (Hidden by default) -->
                                <div id="html-editor-section" style="display: none;">
                                    <div class="html-editor-header" style="background: #f8f9fa; padding: 10px; border: 1px solid #ddd; border-bottom: none; border-radius: 5px 5px 0 0;">
                                        <div style="display: flex; justify-content: space-between; align-items: center;">
                                            <div>
                                                <strong><i class="fa fa-code text-primary"></i> HTML Template Editor</strong>
                                                <small class="text-muted">- Edit your HTML code below</small>
                                            </div>
                                            <div>
                                                <button type="button" class="btn btn-success btn-xs" onclick="loadTransportTemplate()">
                                                    <i class="fa fa-bus"></i> Load Transport Template
                                                </button>
                                                <button type="button" class="btn btn-info btn-xs" onclick="showVariables()">
                                                    <i class="fa fa-tags"></i> Show Variables
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                    <textarea id="html-code-editor" class="form-control" rows="20" 
                                              style="font-family: 'Courier New', monospace; font-size: 12px; border-radius: 0 0 5px 5px;"
                                              placeholder="Edit your HTML template code here..."><?php echo htmlspecialchars($template->template_content); ?></textarea>
                                    
                                    <!-- Variables Help -->
                                    <div id="variables-help" style="display: none; margin-top: 10px; padding: 15px; background: #e8f5e9; border: 1px solid #c8e6c9; border-radius: 5px;">
                                        <h5><i class="fa fa-tags text-success"></i> Available Variables:</h5>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <strong>School Info:</strong><br>
                                                <code>{{school_name}}</code><br>
                                                <code>{{school_address}}</code><br>
                                                <code>{{school_phone}}</code><br>
                                                <code>{{school_email}}</code><br><br>
                                                
                                                <strong>Student Info:</strong><br>
                                                <code>{{student_name}}</code><br>
                                                <code>{{admission_no}}</code><br>
                                                <code>{{class_section}}</code><br>
                                                <code>{{father_name}}</code><br>
                                            </div>
                                            <div class="col-md-6">
                                                <strong>Fee Info:</strong><br>
                                                <code>{{fee_month}}</code><br>
                                                <code>{{paid_amount}}</code><br>
                                                <code>{{currency_symbol}}</code><br><br>
                                                
                                                <strong>Receipt Info:</strong><br>
                                                <code>{{receipt_date}}</code><br>
                                                <code>{{receipt_time}}</code><br>
                                                <code>{{receipt_number}}</code><br>
                                                <code>{{collected_by}}</code><br>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <small class="text-muted">Choose between Visual Editor (drag-and-drop) or HTML Code Editor (edit HTML code directly). Variables like {{school_name}}, {{student_name}}, {{paid_amount}} will be automatically replaced with actual data.</small>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label">Status</label>
                            <div class="col-sm-10">
                                <label class="checkbox-inline">
                                    <input type="checkbox" name="is_active" value="1" <?php echo set_checkbox('is_active', '1', $template->is_active); ?>> 
                                    Active
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="box-footer">
                        <div class="row">
                            <div class="col-sm-offset-2 col-sm-10">
                                <button type="submit" name="submit" class="btn btn-primary">
                                    <i class="fa fa-save"></i> Update Template
                                </button>
                                <a href="<?php echo base_url(); ?>admin/simple_receipt" class="btn btn-default">
                                    <i class="fa fa-arrow-left"></i> Back
                                </a>
                                <a href="<?php echo base_url(); ?>admin/simple_receipt/preview/<?php echo $template->id; ?>" 
                                   class="btn btn-info" target="_blank">
                                    <i class="fa fa-eye"></i> Preview
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                
                <?php echo form_close(); ?>
            </div>
        </div>

        <!-- Available Variables Info -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title">Available Variables</h3>
                    </div>
                    <div class="box-body">
                        <p>You can use these variables in your template content:</p>
                        <div class="row">
                            <div class="col-md-4">
                                <h5 style="color: #007bff; font-weight: bold;">School Information</h5>
                                <ul>
                                    <li><code style="color: #d63384;">{{school_name}}</code> - School Name</li>
                                    <li><code style="color: #d63384;">{{school_address}}</code> - School Address</li>
                                    <li><code style="color: #d63384;">{{school_phone}}</code> - School Phone</li>
                                    <li><code style="color: #d63384;">{{school_email}}</code> - School Email</li>
                                </ul>
                                
                                <h5 style="color: #28a745; font-weight: bold;">Student Information</h5>
                                <ul>
                                    <li><code style="color: #d63384;">{{student_name}}</code> - Student Name</li>
                                    <li><code style="color: #d63384;">{{firstname}}</code> - First Name</li>
                                    <li><code style="color: #d63384;">{{lastname}}</code> - Last Name</li>
                                    <li><code style="color: #d63384;">{{admission_no}}</code> - Admission Number</li>
                                    <li><code style="color: #d63384;">{{roll_no}}</code> - Roll Number</li>
                                    <li><code style="color: #d63384;">{{class_name}}</code> - Class Name</li>
                                    <li><code style="color: #d63384;">{{class}}</code> - Class</li>
                                    <li><code style="color: #d63384;">{{section}}</code> - Section</li>
                                    <li><code style="color: #e83e8c;">{{student_image}}</code> - Student Photo URL</li>
                                    <li><code style="color: #e83e8c;">{{student_photo_url}}</code> - Student Photo URL (Alternative)</li>
                                </ul>
                            </div>
                            <div class="col-md-4">
                                <h5 style="color: #ffc107; font-weight: bold;">Parent Information</h5>
                                <ul>
                                    <li><code style="color: #d63384;">{{father_name}}</code> - Father Name</li>
                                    <li><code style="color: #d63384;">{{mother_name}}</code> - Mother Name</li>
                                    <li><code style="color: #d63384;">{{guardian_name}}</code> - Guardian Name</li>
                                </ul>
                                
                                <h5 style="color: #17a2b8; font-weight: bold;">Contact Information</h5>
                                <ul>
                                    <li><code style="color: #d63384;">{{mobile_no}}</code> - Mobile Number</li>
                                    <li><code style="color: #d63384;">{{father_phone}}</code> - Father Phone</li>
                                    <li><code style="color: #d63384;">{{mother_phone}}</code> - Mother Phone</li>
                                    <li><code style="color: #d63384;">{{guardian_phone}}</code> - Guardian Phone</li>
                                    <li><code style="color: #d63384;">{{email}}</code> - Email Address</li>
                                    <li><code style="color: #d63384;">{{current_address}}</code> - Current Address</li>
                                    <li><code style="color: #d63384;">{{permanent_address}}</code> - Permanent Address</li>
                                </ul>
                            </div>
                            <div class="col-md-4">
                                <h5 style="color: #dc3545; font-weight: bold;">Fee Information</h5>
                                <ul>
                                    <li><code style="color: #d63384;">{{fee_group}}</code> - Fee Group</li>
                                    <li><code style="color: #d63384;">{{fee_amount}}</code> - Fee Amount</li>
                                    <li><code style="color: #d63384;">{{total_amount}}</code> - Total Amount</li>
                                    <li><code style="color: #d63384;">{{total_amount_words}}</code> - Amount in Words</li>
                                    <li><code style="color: #d63384;">{{amount_discount}}</code> - Discount Amount</li>
                                    <li><code style="color: #d63384;">{{amount_fine}}</code> - Fine Amount</li>
                                </ul>
                                
                                <h5 style="color: #fd7e14; font-weight: bold;">Payment Status</h5>
                                <ul>
                                    <li><code style="color: #fd7e14;">{{payment_status}}</code> - Payment Status (PAID/UNPAID)</li>
                                    <li><code style="color: #fd7e14;">{{payment_status_text}}</code> - Payment Status Text</li>
                                    <li><code style="color: #fd7e14;">{{payment_status_badge}}</code> - Payment Status Badge (HTML)</li>
                                    <li><code style="color: #fd7e14;">{{is_paid}}</code> - Is Paid (Yes/No)</li>
                                    <li><code style="color: #fd7e14;">{{is_unpaid}}</code> - Is Unpaid (Yes/No)</li>
                                    <li><code style="color: #fd7e14;">{{status_color}}</code> - Status Color Code</li>
                                    <li><code style="color: #fd7e14;">{{status_background}}</code> - Status Background CSS</li>
                                </ul>
                                
                                <h5 style="color: #6f42c1; font-weight: bold;">Payment & Receipt Info</h5>
                                <ul>
                                    <li><code style="color: #d63384;">{{payment_date}}</code> - Payment Date</li>
                                    <li><code style="color: #d63384;">{{payment_time}}</code> - Payment Time</li>
                                    <li><code style="color: #d63384;">{{payment_mode}}</code> - Payment Mode</li>
                                    <li><code style="color: #d63384;">{{collected_by}}</code> - Collected By</li>
                                    <li><code style="color: #d63384;">{{invoice_id}}</code> - Invoice ID</li>
                                    <li><code style="color: #d63384;">{{receipt_no}}</code> - Receipt Number</li>
                                    <li><code style="color: #d63384;">{{receipt_date}}</code> - Receipt Date</li>
                                    <li><code style="color: #d63384;">{{academic_year}}</code> - Academic Year</li>
                                    <li><code style="color: #d63384;">{{total_groups}}</code> - Total Groups</li>
                                    <li><code style="color: #d63384;">{{currency_symbol}}</code> - Currency Symbol</li>
                                    <li><code style="color: #d63384;">{{current_date}}</code> - Current Date</li>
                                    <li><code style="color: #d63384;">{{current_time}}</code> - Current Time</li>
                                    <li><code style="color: #d63384;">{{fee_groups_table}}</code> - Fee Groups Table</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Visual Editor Modal -->
<div class="modal fade" id="visual-editor-modal" tabindex="-1" role="dialog" style="z-index: 9999;">
    <div class="modal-dialog modal-fullscreen" role="document" style="width: 95%; max-width: none; height: 95%; margin: 2.5%;">
        <div class="modal-content" style="height: 100%; border-radius: 10px; box-shadow: 0 10px 30px rgba(0,0,0,0.3);">
            <div class="modal-header" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; border-radius: 10px 10px 0 0;">
                <h4 class="modal-title">
                    <i class="fa fa-paint-brush"></i> Visual Receipt Template Designer
                </h4>
                <div class="header-controls" style="display: flex; gap: 10px; align-items: center;">
                    <button type="button" id="save-and-close" class="btn btn-success btn-sm">
                        <i class="fa fa-save"></i> Save & Close
                    </button>
                    <button type="button" class="close" data-dismiss="modal" style="color: white; opacity: 0.8;">
                        <span>&times;</span>
                    </button>
                </div>
            </div>
            <div class="modal-body" style="padding: 0; height: calc(100% - 60px);">
                <!-- Editor Toolbar -->
                <div class="editor-toolbar" style="background: #f8f9fa; padding: 15px; border-bottom: 1px solid #ddd; display: flex; justify-content: space-between; align-items: center;">
                    <div class="toolbar-left">
                        <button type="button" id="load-sample-btn" class="btn btn-primary btn-sm">
                            <i class="fa fa-magic"></i> Load Sample
                        </button>
                        <button type="button" id="clear-canvas-btn" class="btn btn-warning btn-sm">
                            <i class="fa fa-trash"></i> Clear
                        </button>
                        <button type="button" id="preview-btn" class="btn btn-success btn-sm">
                            <i class="fa fa-eye"></i> Preview
                        </button>
                    </div>
                    <div class="toolbar-right">
                        <div class="btn-group btn-group-sm">
                            <button type="button" class="btn btn-outline-secondary device-btn active" data-device="Desktop">
                                <i class="fa fa-desktop"></i> Desktop
                            </button>
                            <button type="button" class="btn btn-outline-secondary device-btn" data-device="Tablet">
                                <i class="fa fa-tablet"></i> Tablet
                            </button>
                            <button type="button" class="btn btn-outline-secondary device-btn" data-device="Mobile">
                                <i class="fa fa-mobile"></i> Mobile
                            </button>
                        </div>
                    </div>
                </div>
                
                <!-- Main Editor Area -->
                <div class="editor-workspace" style="display: flex; height: calc(100% - 70px);">
                    <!-- Components Panel -->
                    <div class="components-panel" style="width: 280px; background: #f8f9fa; border-right: 1px solid #ddd; overflow-y: auto;">
                        <div class="panel-header" style="padding: 15px; border-bottom: 1px solid #ddd; background: white;">
                            <h5 style="margin: 0; color: #333; font-weight: 600;">
                                <i class="fa fa-cubes text-primary"></i> Components
                            </h5>
                        </div>
                        <div id="blocks" style="padding: 15px;"></div>
                    </div>
                    
                    <!-- Canvas Area -->
                    <div class="canvas-area" style="flex: 1; background: #e9ecef; position: relative;">
                        <div id="gjs" style="height: 100%;"></div>
                    </div>
                    
                    <!-- Properties Panel -->
                    <div class="properties-panel" style="width: 300px; background: #f8f9fa; border-left: 1px solid #ddd;">
                        <div class="panel-header" style="padding: 15px; border-bottom: 1px solid #ddd; background: white;">
                            <div class="btn-group" role="group">
                                <button type="button" class="btn btn-sm btn-outline-secondary panel-btn active" data-panel="blocks">
                                    <i class="fa fa-th-large"></i> Components
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-secondary panel-btn" data-panel="layers">
                                    <i class="fa fa-layer-group"></i> Layers
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-secondary panel-btn" data-panel="styles">
                                    <i class="fa fa-paint-brush"></i> Styles
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-secondary panel-btn" data-panel="traits">
                                    <i class="fa fa-cog"></i> Settings
                                </button>
                                <button type="button" class="btn btn-sm btn-info" id="variables-help-btn" title="Show Variables Help">
                                    <i class="fa fa-question-circle"></i> Variables
                                </button>
                            </div>
                        </div>
                        <div id="layers-container" style="padding: 15px; height: calc(100% - 80px); overflow-y: auto;"></div>
                        <div id="styles-container" style="padding: 15px; height: calc(100% - 80px); overflow-y: auto; display: none;"></div>
                        <div id="traits-container" style="padding: 15px; height: calc(100% - 80px); overflow-y: auto; display: none;"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- GrapesJS CSS -->
<link rel="stylesheet" href="https://unpkg.com/grapesjs/dist/css/grapes.min.css">

<!-- Custom Editor Styles -->
<style>
.gjs-block {
    border-radius: 6px !important;
    border: 1px solid #e9ecef !important;
    margin-bottom: 8px !important;
    transition: all 0.2s ease !important;
    background: white !important;
    box-shadow: 0 1px 3px rgba(0,0,0,0.1) !important;
}

.gjs-block:hover {
    border-color: #007bff !important;
    box-shadow: 0 2px 8px rgba(0,123,255,0.2) !important;
    transform: translateY(-1px) !important;
}

.gjs-block-receipt {
    border-left: 4px solid #007bff !important;
}

.gjs-block-student {
    border-left: 4px solid #28a745 !important;
}

.gjs-block-table {
    border-left: 4px solid #dc3545 !important;
}

.gjs-block-payment {
    border-left: 4px solid #ffc107 !important;
}

.gjs-block-footer {
    border-left: 4px solid #6c757d !important;
}

.gjs-block-variable {
    border-left: 4px solid #17a2b8 !important;
}

.gjs-block .gjs-block-label {
    font-size: 13px !important;
    font-weight: 500 !important;
    color: #495057 !important;
    padding: 8px 10px !important;
}

.modal-fullscreen {
    width: 95vw !important;
    height: 95vh !important;
    max-width: none !important;
    margin: 2.5vh auto !important;
}

.editor-toolbar {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%) !important;
    border-bottom: 2px solid #dee2e6 !important;
}

.components-panel, .properties-panel {
    background: linear-gradient(180deg, #f8f9fa 0%, #ffffff 100%) !important;
}

.panel-header {
    background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%) !important;
    border-bottom: 2px solid #dee2e6 !important;
}

.canvas-area {
    background: linear-gradient(45deg, #e9ecef 25%, transparent 25%, transparent 75%, #e9ecef 75%, #e9ecef),
                linear-gradient(45deg, #e9ecef 25%, transparent 25%, transparent 75%, #e9ecef 75%, #e9ecef) !important;
    background-size: 20px 20px !important;
    background-position: 0 0, 10px 10px !important;
}

.template-editor-launch {
    transition: all 0.3s ease !important;
    cursor: pointer !important;
}

.template-editor-launch:hover {
    border-color: #0056b3 !important;
    background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%) !important;
    transform: translateY(-2px) !important;
    box-shadow: 0 4px 12px rgba(0,123,255,0.2) !important;
}

.btn {
    transition: all 0.2s ease !important;
}

.btn:hover {
    transform: translateY(-1px) !important;
    box-shadow: 0 2px 6px rgba(0,0,0,0.15) !important;
}

#gjs {
    border-radius: 8px !important;
    overflow: hidden !important;
    box-shadow: inset 0 0 10px rgba(0,0,0,0.05) !important;
}
</style>

<!-- GrapesJS JS -->
<script src="https://unpkg.com/grapesjs"></script>

<script>
$(document).ready(function() {
    // Auto-generate template code from name
    $('#template_name').on('input', function() {
        var name = $(this).val();
        var code = name.toLowerCase()
                      .replace(/[^a-z0-9\s]/g, '')
                      .replace(/\s+/g, '_')
                      .substring(0, 50);
        $('#template_code').val(code);
    });

    var editor;
    
    // Open Visual Editor Modal
    window.openEditor = function() {
        $('#visual-editor-modal').modal('show');
        
        // Initialize GrapesJS Editor when modal opens
        setTimeout(function() {
            if (!editor) {
                console.log('Initializing GrapesJS editor');
                editor = grapesjs.init({
                    container: '#gjs',
                    height: '100%',
                    width: 'auto',
                    storageManager: false,
                    blockManager: {
                        appendTo: '#blocks'
                    },
                    layerManager: {
                        appendTo: '#layers-container'
                    },
                    styleManager: {
                        appendTo: '#styles-container'
                    },
                    traitManager: {
                        appendTo: '#traits-container'
                    },
                    canvas: {
                        styles: [
                            'https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css'
                        ]
                    },
                    deviceManager: {
                        devices: [
                            {
                                name: 'Desktop',
                                width: '',
                            },
                            {
                                name: 'Tablet',
                                width: '768px',
                                widthMedia: '992px',
                            },
                            {
                                name: 'Mobile',
                                width: '320px',
                                widthMedia: '768px',
                            }
                        ]
                    },
                    richTextEditor: {
                        actions: ['bold', 'italic', 'underline', 'strikethrough', 'link', 'wrap']
                    },
                    domComponents: {
                        defaults: {
                            editable: true,
                            droppable: true,
                            resizable: true,
                            highlightable: true,
                            copyable: true,
                            removable: true
                        }
                    },
                    cssComposer: {
                        rules: [
                            {
                                selectors: ['.gjs-selected'],
                                style: {
                                    'outline': '2px solid #007bff !important',
                                    'outline-offset': '2px'
                                }
                            }
                        ]
                    }
                });
                
                initializeEditorComponents();
            }
            
            // Load existing content if any
            var existingContent = $('#template_content').val();
            if (existingContent) {
                editor.setComponents(existingContent);
            }
        }, 300);
    };
    
    // Save and Close Modal
    $(document).on('click', '#save-and-close', function() {
        if (editor) {
            var htmlContent = editor.getHtml();
            var cssContent = editor.getCss();
            var fullTemplate = htmlContent + '<style>' + cssContent + '</style>';
            $('#template_content').val(fullTemplate);
        }
        $('#visual-editor-modal').modal('hide');
    });
    
    // Quick Load Sample
    window.loadQuickSample = function() {
        var sampleTemplate = getClassicTemplate();
        $('#template_content').val(sampleTemplate);
        $('#load-sample-quick').text('Sample Loaded!').addClass('btn-success').removeClass('btn-outline-info');
        setTimeout(function() {
            $('#load-sample-quick').text('Load Sample Template').removeClass('btn-success').addClass('btn-outline-info');
        }, 2000);
    };
    
    function initializeEditorComponents() {
        // Add all the same components as create page
        addReceiptComponents();
        addStudentComponents();
        addFeeComponents();
        addPaymentComponents();
        addVariableComponents();
        addTableVariables();
        addAlignmentComponents();
        addPaymentHistoryComponents();
        addFooterComponents();
    }
    
    function addTableVariables() {
        // Table Variables for Invoice Creation
        editor.BlockManager.add('fee-group-name-1', {
            label: '<i class="fa fa-table" style="margin-right: 5px; color: #fd7e14;"></i>Fee Group 1',
            category: 'Table Variables',
            attributes: { class: 'gjs-block-variable' },
            content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{fee_group_name_1}}</span>'
        });

        editor.BlockManager.add('fee-group-name-2', {
            label: '<i class="fa fa-table" style="margin-right: 5px; color: #fd7e14;"></i>Fee Group 2',
            category: 'Table Variables',
            attributes: { class: 'gjs-block-variable' },
            content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{fee_group_name_2}}</span>'
        });

        editor.BlockManager.add('fee-group-name-3', {
            label: '<i class="fa fa-table" style="margin-right: 5px; color: #fd7e14;"></i>Fee Group 3',
            category: 'Table Variables',
            attributes: { class: 'gjs-block-variable' },
            content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{fee_group_name_3}}</span>'
        });

        editor.BlockManager.add('fee-amount-1', {
            label: '<i class="fa fa-rupee-sign" style="margin-right: 5px; color: #fd7e14;"></i>Fee Amount 1',
            category: 'Table Variables',
            attributes: { class: 'gjs-block-variable' },
            content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{fee_amount_1}}</span>'
        });

        editor.BlockManager.add('fee-amount-2', {
            label: '<i class="fa fa-rupee-sign" style="margin-right: 5px; color: #fd7e14;"></i>Fee Amount 2',
            category: 'Table Variables',
            attributes: { class: 'gjs-block-variable' },
            content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{fee_amount_2}}</span>'
        });

        editor.BlockManager.add('fee-amount-3', {
            label: '<i class="fa fa-rupee-sign" style="margin-right: 5px; color: #fd7e14;"></i>Fee Amount 3',
            category: 'Table Variables',
            attributes: { class: 'gjs-block-variable' },
            content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{fee_amount_3}}</span>'
        });

        editor.BlockManager.add('paid-amount-1', {
            label: '<i class="fa fa-check-circle" style="margin-right: 5px; color: #fd7e14;"></i>Paid Amount 1',
            category: 'Table Variables',
            attributes: { class: 'gjs-block-variable' },
            content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{paid_amount_1}}</span>'
        });

        editor.BlockManager.add('paid-amount-2', {
            label: '<i class="fa fa-check-circle" style="margin-right: 5px; color: #fd7e14;"></i>Paid Amount 2',
            category: 'Table Variables',
            attributes: { class: 'gjs-block-variable' },
            content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{paid_amount_2}}</span>'
        });

        editor.BlockManager.add('paid-amount-3', {
            label: '<i class="fa fa-check-circle" style="margin-right: 5px; color: #fd7e14;"></i>Paid Amount 3',
            category: 'Table Variables',
            attributes: { class: 'gjs-block-variable' },
            content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{paid_amount_3}}</span>'
        });

        editor.BlockManager.add('balance-1', {
            label: '<i class="fa fa-balance-scale" style="margin-right: 5px; color: #fd7e14;"></i>Balance 1',
            category: 'Table Variables',
            attributes: { class: 'gjs-block-variable' },
            content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{balance_1}}</span>'
        });

        editor.BlockManager.add('balance-2', {
            label: '<i class="fa fa-balance-scale" style="margin-right: 5px; color: #fd7e14;"></i>Balance 2',
            category: 'Table Variables',
            attributes: { class: 'gjs-block-variable' },
            content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{balance_2}}</span>'
        });

        editor.BlockManager.add('balance-3', {
            label: '<i class="fa fa-balance-scale" style="margin-right: 5px; color: #fd7e14;"></i>Balance 3',
            category: 'Table Variables',
            attributes: { class: 'gjs-block-variable' },
            content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{balance_3}}</span>'
        });

        editor.BlockManager.add('due-date-1', {
            label: '<i class="fa fa-calendar-times" style="margin-right: 5px; color: #fd7e14;"></i>Due Date 1',
            category: 'Table Variables',
            attributes: { class: 'gjs-block-variable' },
            content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{due_date_1}}</span>'
        });

        editor.BlockManager.add('due-date-2', {
            label: '<i class="fa fa-calendar-times" style="margin-right: 5px; color: #fd7e14;"></i>Due Date 2',
            category: 'Table Variables',
            attributes: { class: 'gjs-block-variable' },
            content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{due_date_2}}</span>'
        });

        editor.BlockManager.add('due-date-3', {
            label: '<i class="fa fa-calendar-times" style="margin-right: 5px; color: #fd7e14;"></i>Due Date 3',
            category: 'Table Variables',
            attributes: { class: 'gjs-block-variable' },
            content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{due_date_3}}</span>'
        });

        // Discount Amount Variables
        editor.BlockManager.add('discount-amount-1', {
            label: '<i class="fa fa-percent" style="margin-right: 5px; color: #fd7e14;"></i>Discount Amount 1',
            category: 'Table Variables',
            attributes: { class: 'gjs-block-variable' },
            content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{discount_amount_1}}</span>'
        });

        editor.BlockManager.add('discount-amount-2', {
            label: '<i class="fa fa-percent" style="margin-right: 5px; color: #fd7e14;"></i>Discount Amount 2',
            category: 'Table Variables',
            attributes: { class: 'gjs-block-variable' },
            content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{discount_amount_2}}</span>'
        });

        editor.BlockManager.add('discount-amount-3', {
            label: '<i class="fa fa-percent" style="margin-right: 5px; color: #fd7e14;"></i>Discount Amount 3',
            category: 'Table Variables',
            attributes: { class: 'gjs-block-variable' },
            content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{discount_amount_3}}</span>'
        });

        // Fine Amount Variables
        editor.BlockManager.add('fine-amount-1', {
            label: '<i class="fa fa-exclamation-circle" style="margin-right: 5px; color: #fd7e14;"></i>Fine Amount 1',
            category: 'Table Variables',
            attributes: { class: 'gjs-block-variable' },
            content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{fine_amount_1}}</span>'
        });

        editor.BlockManager.add('fine-amount-2', {
            label: '<i class="fa fa-exclamation-circle" style="margin-right: 5px; color: #fd7e14;"></i>Fine Amount 2',
            category: 'Table Variables',
            attributes: { class: 'gjs-block-variable' },
            content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{fine_amount_2}}</span>'
        });

        editor.BlockManager.add('fine-amount-3', {
            label: '<i class="fa fa-exclamation-circle" style="margin-right: 5px; color: #fd7e14;"></i>Fine Amount 3',
            category: 'Table Variables',
            attributes: { class: 'gjs-block-variable' },
            content: '<span style="background: linear-gradient(135deg, #fff4e6 0%, #ffe8cc 100%); padding: 4px 8px; border: 1px solid #fd7e14; border-radius: 4px; color: #8a4412; font-weight: 500; font-size: 14px;">{{fine_amount_3}}</span>'
        });

        // Total Amount Variables for Tables
        editor.BlockManager.add('total-fee-amount', {
            label: '<i class="fa fa-calculator" style="margin-right: 5px; color: #e83e8c;"></i>Total Fee Amount',
            category: 'Total Table Variables',
            attributes: { class: 'gjs-block-variable' },
            content: '<span style="background: linear-gradient(135deg, #f8e6f0 0%, #f2d7e6 100%); padding: 4px 8px; border: 1px solid #e83e8c; border-radius: 4px; color: #7a1e48; font-weight: 500; font-size: 14px;">{{total_fee_amount}}</span>'
        });

        editor.BlockManager.add('total-paid-amount', {
            label: '<i class="fa fa-check-double" style="margin-right: 5px; color: #e83e8c;"></i>Total Paid Amount',
            category: 'Total Table Variables',
            attributes: { class: 'gjs-block-variable' },
            content: '<span style="background: linear-gradient(135deg, #f8e6f0 0%, #f2d7e6 100%); padding: 4px 8px; border: 1px solid #e83e8c; border-radius: 4px; color: #7a1e48; font-weight: 500; font-size: 14px;">{{total_paid_amount}}</span>'
        });

        editor.BlockManager.add('total-balance', {
            label: '<i class="fa fa-balance-scale-right" style="margin-right: 5px; color: #e83e8c;"></i>Total Balance',
            category: 'Total Table Variables',
            attributes: { class: 'gjs-block-variable' },
            content: '<span style="background: linear-gradient(135deg, #f8e6f0 0%, #f2d7e6 100%); padding: 4px 8px; border: 1px solid #e83e8c; border-radius: 4px; color: #7a1e48; font-weight: 500; font-size: 14px;">{{total_balance}}</span>'
        });

        editor.BlockManager.add('total-discount-amount', {
            label: '<i class="fa fa-percent" style="margin-right: 5px; color: #e83e8c;"></i>Total Discount Amount',
            category: 'Total Table Variables',
            attributes: { class: 'gjs-block-variable' },
            content: '<span style="background: linear-gradient(135deg, #f8e6f0 0%, #f2d7e6 100%); padding: 4px 8px; border: 1px solid #e83e8c; border-radius: 4px; color: #7a1e48; font-weight: 500; font-size: 14px;">{{total_discount_amount}}</span>'
        });
    }
    
    function addAlignmentComponents() {
        // Center/Alignment Components
        editor.BlockManager.add('center-text', {
            label: '<i class="fa fa-align-center" style="margin-right: 5px; color: #20c997;"></i>Center Text',
            category: 'Alignment Components',
            attributes: { class: 'gjs-block-alignment' },
            content: '<div style="text-align: center; padding: 10px; border: 1px dashed #20c997; border-radius: 4px; background: #f0fff4;">Center aligned content - Replace this text</div>'
        });

        editor.BlockManager.add('left-text', {
            label: '<i class="fa fa-align-left" style="margin-right: 5px; color: #20c997;"></i>Left Text',
            category: 'Alignment Components',
            attributes: { class: 'gjs-block-alignment' },
            content: '<div style="text-align: left; padding: 10px; border: 1px dashed #20c997; border-radius: 4px; background: #f0fff4;">Left aligned content - Replace this text</div>'
        });

        editor.BlockManager.add('right-text', {
            label: '<i class="fa fa-align-right" style="margin-right: 5px; color: #20c997;"></i>Right Text',
            category: 'Alignment Components',
            attributes: { class: 'gjs-block-alignment' },
            content: '<div style="text-align: right; padding: 10px; border: 1px dashed #20c997; border-radius: 4px; background: #f0fff4;">Right aligned content - Replace this text</div>'
        });

        editor.BlockManager.add('justify-text', {
            label: '<i class="fa fa-align-justify" style="margin-right: 5px; color: #20c997;"></i>Justify Text',
            category: 'Alignment Components',
            attributes: { class: 'gjs-block-alignment' },
            content: '<div style="text-align: justify; padding: 10px; border: 1px dashed #20c997; border-radius: 4px; background: #f0fff4;">Justified content - Replace this text with longer content to see the justify effect</div>'
        });
    }
    
    function addReceiptComponents() {
        editor.BlockManager.add('receipt-header', {
            label: '<i class="fa fa-header" style="margin-right: 5px; color: #007bff;"></i>Receipt Header',
            label: '<i class="fa fa-header" style="margin-right: 5px; color: #007bff;"></i>Receipt Header',
            category: 'Receipt Components',
            attributes: { class: 'gjs-block-receipt' },
            content: {
                type: 'default',
                tagName: 'div',
                style: {
                    'text-align': 'center',
                    'padding': '20px',
                    'background': 'linear-gradient(135deg, #007bff 0%, #0056b3 100%)',
                    'color': 'white',
                    'margin-bottom': '20px'
                },
                components: [
                    {
                        type: 'text',
                        tagName: 'h2',
                        content: '{{school_name}}',
                        style: {
                            'margin': '0',
                            'font-size': '24px',
                            'font-weight': 'bold'
                        },
                        editable: true
                    },
                    {
                        type: 'text',
                        tagName: 'p',
                        content: '{{school_address}}',
                        style: {
                            'margin': '5px 0',
                            'font-size': '14px'
                        },
                        editable: true
                    },
                    {
                        type: 'text',
                        tagName: 'p',
                        content: 'Phone: {{school_phone}} | Email: {{school_email}}',
                        style: {
                            'margin': '5px 0',
                            'font-size': '14px'
                        },
                        editable: true
                    },
                    {
                        type: 'text',
                        tagName: 'h3',
                        content: 'FEE RECEIPT',
                        style: {
                            'margin': '10px 0 0 0',
                            'font-size': '18px',
                            'background': 'rgba(255,255,255,0.2)',
                            'padding': '8px',
                            'border-radius': '4px'
                        },
                        editable: true
                    }
                ],
                droppable: true,
                resizable: true
            }
        });
    }
    
    function addStudentComponents() {
        // Fee Summary Card
        editor.BlockManager.add('fee-summary-card', {
            label: '<i class="fa fa-credit-card" style="margin-right: 5px; color: #fd7e14;"></i>Fee Summary Card',
            category: 'Fee Components',
            attributes: { class: 'gjs-block-fee' },
            content: `
                <div style="margin: 20px 0; background: linear-gradient(135deg, #fd7e14 0%, #e55a00 100%); color: white; padding: 20px; border-radius: 12px; box-shadow: 0 4px 15px rgba(253, 126, 20, 0.3);">
                    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                        <h3 style="margin: 0; font-size: 18px;">Fee Summary</h3>
                        <div style="background: rgba(255,255,255,0.2); padding: 5px 10px; border-radius: 20px; font-size: 12px;">
                            {{current_month}} {{current_year}}
                        </div>
                    </div>
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                        <div style="background: rgba(255,255,255,0.1); padding: 15px; border-radius: 8px; text-align: center;">
                            <div style="font-size: 24px; font-weight: bold; margin-bottom: 5px;">{{total_due}}</div>
                            <div style="font-size: 12px; opacity: 0.9;">Total Due</div>
                        </div>
                        <div style="background: rgba(255,255,255,0.1); padding: 15px; border-radius: 8px; text-align: center;">
                            <div style="font-size: 24px; font-weight: bold; margin-bottom: 5px;">{{total_paid}}</div>
                            <div style="font-size: 12px; opacity: 0.9;">Total Paid</div>
                        </div>
                    </div>
                    <div style="margin-top: 15px; padding: 12px; background: rgba(255,255,255,0.1); border-radius: 8px; text-align: center;">
                        <div style="font-size: 14px; margin-bottom: 5px;">Outstanding Balance</div>
                        <div style="font-size: 28px; font-weight: bold;">{{outstanding_balance}}</div>
                    </div>
                </div>
            `
        });

        editor.BlockManager.add('student-info', {
            label: '<i class="fa fa-user-graduate" style="margin-right: 8px; color: #28a745;"></i>Student Info',
            category: 'Receipt Components',
            attributes: { class: 'gjs-block-student' },
            content: `
                <div style="margin: 25px 0; padding: 20px; background: linear-gradient(135deg, #e8f5e8 0%, #d4edda 100%); border-left: 5px solid #28a745; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                    <h4 style="margin: 0 0 15px 0; color: #155724; font-size: 18px; font-weight: 600;">Student Information</h4>
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px; margin-bottom: 12px;">
                        <div style="padding: 8px; background: white; border-radius: 4px;"><strong style="color: #155724;">Student Name:</strong> <span style="color: #333;">{{student_name}}</span></div>
                        <div style="padding: 8px; background: white; border-radius: 4px;"><strong style="color: #155724;">Admission No:</strong> <span style="color: #333;">{{admission_no}}</span></div>
                    </div>
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px; margin-bottom: 12px;">
                        <div style="padding: 8px; background: white; border-radius: 4px;"><strong style="color: #155724;">Class:</strong> <span style="color: #333;">{{class_name}}</span></div>
                        <div style="padding: 8px; background: white; border-radius: 4px;"><strong style="color: #155724;">Section:</strong> <span style="color: #333;">{{section_name}}</span></div>
                    </div>
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                        <div style="padding: 8px; background: white; border-radius: 4px;"><strong style="color: #155724;">Father's Name:</strong> <span style="color: #333;">{{father_name}}</span></div>
                        <div style="padding: 8px; background: white; border-radius: 4px;"><strong style="color: #155724;">Receipt No:</strong> <span style="color: #333;">{{receipt_no}}</span></div>
                    </div>
                </div>
            `
        });
    }
    
    function addFeeComponents() {
        editor.BlockManager.add('fee-table', {
            label: '<i class="fa fa-table" style="margin-right: 8px; color: #dc3545;"></i>Fee Details',
            category: 'Receipt Components',
            attributes: { class: 'gjs-block-table' },
            content: `
                <div style="margin: 25px 0; box-shadow: 0 4px 6px rgba(0,0,0,0.1); border-radius: 8px; overflow: hidden;">
                    <table style="width: 100%; border-collapse: collapse;">
                        <thead>
                            <tr style="background: linear-gradient(135deg, #007bff 0%, #0056b3 100%); color: white;">
                                <th style="padding: 15px; text-align: left; font-size: 16px; font-weight: 600;">Fee Type</th>
                                <th style="padding: 15px; text-align: right; font-size: 16px; font-weight: 600;">Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr style="background: white;">
                                <td style="padding: 12px 15px; border-bottom: 1px solid #e9ecef; color: #333;">{{fee_type}}</td>
                                <td style="padding: 12px 15px; border-bottom: 1px solid #e9ecef; text-align: right; color: #333; font-weight: 500;">₹{{fee_amount}}</td>
                            </tr>
                            <tr style="background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);">
                                <td style="padding: 15px; font-weight: 700; color: #495057; font-size: 16px;">Total Amount</td>
                                <td style="padding: 15px; text-align: right; font-weight: 700; color: #007bff; font-size: 18px;">₹{{total_amount}}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            `
        });

        editor.BlockManager.add('detailed-fee-breakdown', {
            label: '<i class="fa fa-table" style="margin-right: 5px; color: #28a745;"></i>Detailed Fee Breakdown',
            category: 'Fee Components',
            attributes: { class: 'gjs-block-table' },
            content: `
                <div style="margin: 20px 0; border: 1px solid #dee2e6; border-radius: 8px; overflow: hidden;">
                    <div style="background: #28a745; color: white; padding: 12px; font-weight: bold; text-align: center;">
                        Fee Details - Academic Year {{academic_year}}
                    </div>
                    <table style="width: 100%; border-collapse: collapse; font-size: 14px;">
                        <thead style="background: #f8f9fa;">
                            <tr>
                                <th style="padding: 10px; border: 1px solid #dee2e6; text-align: left;">Fee Type</th>
                                <th style="padding: 10px; border: 1px solid #dee2e6; text-align: center;">Due Date</th>
                                <th style="padding: 10px; border: 1px solid #dee2e6; text-align: right;">Amount</th>
                                <th style="padding: 10px; border: 1px solid #dee2e6; text-align: right;">Discount</th>
                                <th style="padding: 10px; border: 1px solid #dee2e6; text-align: right;">Paid</th>
                                <th style="padding: 10px; border: 1px solid #dee2e6; text-align: right;">Balance</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_1}} - {{fee_type_code_1}}</td>
                                <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{due_date_1}}</td>
                                <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_1}}</td>
                                <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{discount_amount_1}}</td>
                                <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_1}}</td>
                                <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_1}}</td>
                            </tr>
                            <tr>
                                <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_2}} - {{fee_type_code_2}}</td>
                                <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{due_date_2}}</td>
                                <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_2}}</td>
                                <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{discount_amount_2}}</td>
                                <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_2}}</td>
                                <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_2}}</td>
                            </tr>
                            <tr>
                                <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_3}} - {{fee_type_code_3}}</td>
                                <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{due_date_3}}</td>
                                <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_3}}</td>
                                <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{discount_amount_3}}</td>
                                <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_3}}</td>
                                <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_3}}</td>
                            </tr>
                            <tr style="background: #e9ecef; font-weight: bold;">
                                <td style="padding: 10px; border: 1px solid #dee2e6;" colspan="2">TOTAL</td>
                                <td style="padding: 10px; border: 1px solid #dee2e6; text-align: right;">{{total_fee_amount}}</td>
                                <td style="padding: 10px; border: 1px solid #dee2e6; text-align: right;">{{total_discount_amount}}</td>
                                <td style="padding: 10px; border: 1px solid #dee2e6; text-align: right;">{{total_paid_amount}}</td>
                                <td style="padding: 10px; border: 1px solid #dee2e6; text-align: right;">{{total_balance}}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            `
        });
    }
    
    function addPaymentComponents() {
        editor.BlockManager.add('payment-info', {
            label: '<i class="fa fa-credit-card" style="margin-right: 8px; color: #ffc107;"></i>Payment Info',
            category: 'Receipt Components',
            attributes: { class: 'gjs-block-payment' },
            content: `
                <div style="margin: 25px 0; padding: 20px; background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%); border: 2px solid #ffc107; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                    <h4 style="margin: 0 0 15px 0; color: #856404; font-size: 18px; font-weight: 600; display: flex; align-items: center;"><i class="fa fa-money-bill-wave" style="margin-right: 8px;"></i>Payment Details</h4>
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px; margin-bottom: 12px;">
                        <div style="padding: 10px; background: white; border-radius: 6px; border-left: 4px solid #ffc107;"><strong style="color: #856404;">Payment Date:</strong> <span style="color: #333;">{{payment_date}}</span></div>
                        <div style="padding: 10px; background: white; border-radius: 6px; border-left: 4px solid #ffc107;"><strong style="color: #856404;">Payment Mode:</strong> <span style="color: #333;">{{payment_mode}}</span></div>
                    </div>
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                        <div style="padding: 10px; background: white; border-radius: 6px; border-left: 4px solid #ffc107;"><strong style="color: #856404;">Transaction ID:</strong> <span style="color: #333;">{{transaction_id}}</span></div>
                        <div style="padding: 10px; background: white; border-radius: 6px; border-left: 4px solid #ffc107;"><strong style="color: #856404;">Amount Paid:</strong> <span style="color: #28a745; font-weight: 600; font-size: 16px;">₹{{amount_paid}}</span></div>
                    </div>
                </div>
            `
        });

        editor.BlockManager.add('receipt-footer', {
            label: '<i class="fa fa-file-signature" style="margin-right: 8px; color: #6c757d;"></i>Receipt Footer',
            category: 'Receipt Components',
            attributes: { class: 'gjs-block-footer' },
            content: `
                <div style="margin-top: 40px; padding: 25px; border-top: 3px solid #6c757d; background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%); border-radius: 0 0 8px 8px;">
                    <div style="text-align: center; margin-bottom: 20px;">
                        <p style="margin: 8px 0; font-size: 13px; color: #6c757d; font-style: italic;">This is a computer generated receipt and does not require signature.</p>
                        <p style="margin: 8px 0; font-size: 13px; color: #6c757d;">For any queries, please contact the school office.</p>
                    </div>
                    <div style="display: flex; justify-content: space-between; align-items: end; margin-top: 25px;">
                        <div style="text-align: left;">
                            <p style="margin: 2px 0; font-size: 11px; color: #6c757d;">Generated on: {{current_date}}</p>
                            <p style="margin: 2px 0; font-size: 11px; color: #6c757d;">Generated by: {{generated_by}}</p>
                        </div>
                        <div style="text-align: right;">
                            <div style="border-top: 2px solid #6c757d; padding-top: 8px; min-width: 150px;">
                                <p style="margin: 0; font-size: 12px; color: #495057; font-weight: 500;">Authorized Signature</p>
                            </div>
                        </div>
                    </div>
                </div>
            `
        });

        editor.BlockManager.add('payment-summary', {
            label: '<i class="fa fa-credit-card" style="margin-right: 5px; color: #ffc107;"></i>Payment Summary',
            category: 'Payment Information',
            attributes: { class: 'gjs-block-payment' },
            content: `
                <div style="margin: 20px 0; padding: 20px; border: 2px solid #ffc107; border-radius: 8px; background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%);">
                    <h4 style="margin: 0 0 15px 0; color: #856404; text-align: center;">Payment Summary</h4>
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px; font-size: 14px;">
                        <div style="padding: 10px; background: white; border-radius: 4px; border-left: 4px solid #ffc107;">
                            <strong>Receipt No:</strong><br>{{receipt_no}}
                        </div>
                        <div style="padding: 10px; background: white; border-radius: 4px; border-left: 4px solid #ffc107;">
                            <strong>Payment Date:</strong><br>{{payment_date}}
                        </div>
                        <div style="padding: 10px; background: white; border-radius: 4px; border-left: 4px solid #ffc107;">
                            <strong>Payment Mode:</strong><br>{{payment_mode}}
                        </div>
                        <div style="padding: 10px; background: white; border-radius: 4px; border-left: 4px solid #ffc107;">
                            <strong>Collected By:</strong><br>{{collected_by}}
                        </div>
                    </div>
                    <div style="margin-top: 15px; padding: 15px; background: #28a745; color: white; border-radius: 4px; text-align: center; font-size: 18px; font-weight: bold;">
                        Total Amount Paid: {{total_amount}}
                    </div>
                </div>
            `
        });
    }
    
    function addFooterComponents() {
        editor.BlockManager.add('receipt-footer', {
            label: '<i class="fa fa-file-text" style="margin-right: 5px; color: #6c757d;"></i>Receipt Footer',
            category: 'Footer Components',
            attributes: { class: 'gjs-block-footer' },
            content: `
                <div style="margin-top: 30px; padding: 20px; border-top: 2px solid #dee2e6; text-align: center; font-size: 12px; color: #6c757d;">
                    <p style="margin: 5px 0;"><strong>Thank you for your payment!</strong></p>
                    <p style="margin: 5px 0;">This is a computer generated receipt and does not require signature.</p>
                    <p style="margin: 5px 0;">For any queries, please contact the accounts department.</p>
                    <p style="margin: 10px 0 0 0; font-weight: bold;">Generated on: {{current_date}} at {{current_time}}</p>
                </div>
            `
        });
    }
    
    function addVariableComponents() {
        editor.BlockManager.add('variable-text', {
            label: '<i class="fa fa-code" style="margin-right: 5px; color: #17a2b8;"></i>Variable Text',
            category: 'Variables',
            attributes: { class: 'gjs-block-variable' },
            content: {
                type: 'text',
                content: '{{variable_name}}',
                style: {
                    'padding': '5px',
                    'border': '1px dashed #17a2b8',
                    'background': '#e3f2fd'
                },
                editable: true
            }
        });
    }
    
    function addPaymentHistoryComponents() {
        editor.BlockManager.add('payment-history-table-15groups', {
            label: '<i class="fa fa-history" style="margin-right: 5px; color: #dc3545;"></i>Payment History Table (15 Groups)',
            category: 'Payment History Variables',
            attributes: { class: 'gjs-block-table' },
            content: `<table style="width: 100%; border-collapse: collapse; margin: 10px 0; font-family: Arial, sans-serif;">
                <thead>
                    <tr style="background-color: #dc3545; color: white; border: 1px solid #dee2e6;">
                        <th style="padding: 8px; border: 1px solid #dee2e6; text-align: left;">Fee Group</th>
                        <th style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">Amount</th>
                        <th style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">Discount</th>
                        <th style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">Fine</th>
                        <th style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">Paid</th>
                        <th style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">Balance</th>
                        <th style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">Status</th>
                    </tr>
                </thead>
                <tbody>
                    <tr style="border: 1px solid #dee2e6;">
                        <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_1}}</td>
                        <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_1}}</td>
                        <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{discount_amount_1}}</td>
                        <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fine_amount_1}}</td>
                        <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_1}}</td>
                        <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_1}}</td>
                        <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{payment_status_1}}</td>
                    </tr>
                    <tr style="border: 1px solid #dee2e6;">
                        <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_2}}</td>
                        <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_2}}</td>
                        <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{discount_amount_2}}</td>
                        <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fine_amount_2}}</td>
                        <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_2}}</td>
                        <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_2}}</td>
                        <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{payment_status_2}}</td>
                    </tr>
                    <tr style="border: 1px solid #dee2e6;">
                        <td style="padding: 8px; border: 1px solid #dee2e6;">{{fee_group_name_3}}</td>
                        <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fee_amount_3}}</td>
                        <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{discount_amount_3}}</td>
                        <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{fine_amount_3}}</td>
                        <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{paid_amount_3}}</td>
                        <td style="padding: 8px; border: 1px solid #dee2e6; text-align: right;">{{balance_3}}</td>
                        <td style="padding: 8px; border: 1px solid #dee2e6; text-align: center;">{{payment_status_3}}</td>
                    </tr>
                </tbody>
            </table>`
        });
    }
    
    function getClassicTemplate() {
        return `<div style="max-width: 800px; margin: 0 auto; padding: 20px; font-family: Arial, sans-serif; background: white;">
            <div style="text-align: center; padding: 20px; background: linear-gradient(135deg, #007bff 0%, #0056b3 100%); color: white; margin-bottom: 20px;">
                <h2 style="margin: 0; font-size: 24px; font-weight: bold;">{{school_name}}</h2>
                <p style="margin: 5px 0; font-size: 14px;">{{school_address}}</p>
                <p style="margin: 5px 0; font-size: 14px;">Phone: {{school_phone}} | Email: {{school_email}}</p>
                <h3 style="margin: 10px 0 0 0; font-size: 18px; background: rgba(255,255,255,0.2); padding: 8px; border-radius: 4px;">FEE RECEIPT</h3>
            </div>
            <div style="margin: 20px 0; padding: 15px; border: 1px solid #dee2e6; border-radius: 8px; background: #f8f9fa;">
                <h4 style="margin: 0 0 15px 0; color: #28a745; border-bottom: 2px solid #28a745; padding-bottom: 5px;">Student Details</h4>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 10px; font-size: 14px;">
                    <div><strong>Name:</strong> {{student_name}}</div>
                    <div><strong>Admission No:</strong> {{admission_no}}</div>
                    <div><strong>Class:</strong> {{class_name}}</div>
                    <div><strong>Section:</strong> {{section}}</div>
                    <div><strong>Roll No:</strong> {{roll_no}}</div>
                    <div><strong>Father's Name:</strong> {{father_name}}</div>
                </div>
            </div>
            <div style="margin: 20px 0; padding: 20px; border: 2px solid #ffc107; border-radius: 8px; background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%);">
                <h4 style="margin: 0 0 15px 0; color: #856404; text-align: center;">Payment Summary</h4>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px; font-size: 14px;">
                    <div style="padding: 10px; background: white; border-radius: 4px; border-left: 4px solid #ffc107;">
                        <strong>Receipt No:</strong><br>{{receipt_no}}
                    </div>
                    <div style="padding: 10px; background: white; border-radius: 4px; border-left: 4px solid #ffc107;">
                        <strong>Payment Date:</strong><br>{{payment_date}}
                    </div>
                    <div style="padding: 10px; background: white; border-radius: 4px; border-left: 4px solid #ffc107;">
                        <strong>Payment Mode:</strong><br>{{payment_mode}}
                    </div>
                    <div style="padding: 10px; background: white; border-radius: 4px; border-left: 4px solid #ffc107;">
                        <strong>Collected By:</strong><br>{{collected_by}}
                    </div>
                </div>
                <div style="margin-top: 15px; padding: 15px; background: #28a745; color: white; border-radius: 4px; text-align: center; font-size: 18px; font-weight: bold;">
                    Total Amount Paid: {{total_amount}}
                </div>
            </div>
            <div style="margin-top: 30px; padding: 20px; border-top: 2px solid #dee2e6; text-align: center; font-size: 12px; color: #6c757d;">
                <p style="margin: 5px 0;"><strong>Thank you for your payment!</strong></p>
                <p style="margin: 5px 0;">This is a computer generated receipt and does not require signature.</p>
                <p style="margin: 5px 0;">For any queries, please contact the accounts department.</p>
                <p style="margin: 10px 0 0 0; font-weight: bold;">Generated on: {{current_date}} at {{current_time}}</p>
            </div>
        </div>`;
    }

    // Editor Mode Switching for Edit Page
    $('.editor-mode-btn').click(function() {
        var mode = $(this).data('mode');
        
        // Update button states
        $('.editor-mode-btn').removeClass('active btn-primary').addClass('btn-outline-primary');
        $(this).removeClass('btn-outline-primary').addClass('btn-primary active');
        
        if (mode === 'visual') {
            // Show visual editor, hide HTML editor
            $('#visual-editor-section').show();
            $('#html-editor-section').hide();
        } else if (mode === 'html') {
            // Show HTML editor, hide visual editor
            $('#visual-editor-section').hide();
            $('#html-editor-section').show();
            
            // Sync content from visual editor to HTML editor if exists
            if (window.editor) {
                var htmlContent = window.editor.getHtml();
                var cssContent = window.editor.getCss();
                var fullTemplate = htmlContent + (cssContent ? '<style>' + cssContent + '</style>' : '');
                $('#html-code-editor').val(fullTemplate);
            }
        }
    });
    
    // Sync HTML editor content to hidden field
    $('#html-code-editor').on('input', function() {
        $('#template_content').val($(this).val());
    });
    
    // Form submission handler for edit page
    $('form').on('submit', function(e) {
        var activeMode = $('.editor-mode-btn.active').data('mode');
        
        if (activeMode === 'html') {
            // Use HTML editor content
            $('#template_content').val($('#html-code-editor').val());
        } else if (window.editor) {
            // Use visual editor content
            var htmlContent = window.editor.getHtml();
            var cssContent = window.editor.getCss();
            var fullTemplate = htmlContent + (cssContent ? '<style>' + cssContent + '</style>' : '');
            $('#template_content').val(fullTemplate);
        }
    });

    // Load Transport Template Function for Edit Page
    window.loadTransportTemplate = function() {
        var transportTemplate = `<div class="transport-receipt-container" style="max-width: 600px; margin: 0 auto; padding: 20px; font-family: Arial, sans-serif; border: 2px solid #333; background: #fff;">
    <!-- School Header -->
    <div class="receipt-header" style="text-align: center; border-bottom: 2px solid #333; padding-bottom: 20px; margin-bottom: 20px;">
        <h2 style="margin: 0; color: #333; font-size: 24px; font-weight: bold;">{{school_name}}</h2>
        <p style="margin: 5px 0; color: #666; font-size: 14px;">{{school_address}}</p>
        <p style="margin: 5px 0; color: #666; font-size: 14px;">Phone: {{school_phone}} | Email: {{school_email}}</p>
        <h3 style="margin: 15px 0 10px 0; color: #d32f2f; font-size: 18px; font-weight: bold; text-transform: uppercase;">🚌 Transport Fee Receipt</h3>
    </div>
    
    <!-- Receipt Details -->
    <div class="receipt-details" style="margin-bottom: 20px; background: #f9f9f9; padding: 15px; border-radius: 5px;">
        <div style="display: flex; justify-content: space-between; margin-bottom: 10px; flex-wrap: wrap;">
            <span style="font-weight: bold; color: #333;"><strong>Receipt No:</strong> {{receipt_number}}</span>
            <span style="font-weight: bold; color: #333;"><strong>Date:</strong> {{receipt_date}}</span>
        </div>
        <div style="display: flex; justify-content: space-between; margin-bottom: 10px; flex-wrap: wrap;">
            <span style="color: #333;"><strong>Student Name:</strong> {{student_name}}</span>
            <span style="color: #333;"><strong>Admission No:</strong> {{admission_no}}</span>
        </div>
        <div style="display: flex; justify-content: space-between; margin-bottom: 10px; flex-wrap: wrap;">
            <span style="color: #333;"><strong>Class:</strong> {{class_section}}</span>
            <span style="color: #333;"><strong>Father Name:</strong> {{father_name}}</span>
        </div>
    </div>
    
    <!-- Fee Details Table -->
    <table class="fee-table" style="width: 100%; border-collapse: collapse; margin-bottom: 20px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
        <thead>
            <tr style="background: linear-gradient(135deg, #4CAF50, #45a049); color: white;">
                <th style="border: 1px solid #333; padding: 12px; text-align: left; font-weight: bold;">Description</th>
                <th style="border: 1px solid #333; padding: 12px; text-align: center; font-weight: bold;">Month</th>
                <th style="border: 1px solid #333; padding: 12px; text-align: right; font-weight: bold;">Amount</th>
            </tr>
        </thead>
        <tbody>
            <tr style="background: #fff;">
                <td style="border: 1px solid #ddd; padding: 12px; color: #333;">🚌 Transport Fee</td>
                <td style="border: 1px solid #ddd; padding: 12px; text-align: center; color: #333; font-weight: bold;">{{fee_month}}</td>
                <td style="border: 1px solid #ddd; padding: 12px; text-align: right; color: #333; font-weight: bold;">{{currency_symbol}}{{paid_amount}}</td>
            </tr>
        </tbody>
        <tfoot>
            <tr style="background: linear-gradient(135deg, #f5f5f5, #e8e8e8); font-weight: bold;">
                <td colspan="2" style="border: 1px solid #333; padding: 12px; text-align: right; color: #333; font-size: 16px;">Total Paid:</td>
                <td style="border: 1px solid #333; padding: 12px; text-align: right; color: #d32f2f; font-size: 16px; font-weight: bold;">{{currency_symbol}}{{paid_amount}}</td>
            </tr>
        </tfoot>
    </table>
    
    <!-- Payment Information -->
    <div class="payment-info" style="margin-top: 30px; display: flex; justify-content: space-between; align-items: flex-start; flex-wrap: wrap;">
        <div class="payment-details" style="flex: 1; min-width: 200px;">
            <p style="margin: 0; color: #333; font-size: 14px;"><strong>💳 Payment Mode:</strong> Cash</p>
            <p style="margin: 8px 0; color: #333; font-size: 14px;"><strong>👤 Received By:</strong> {{collected_by}}</p>
            <p style="margin: 8px 0; color: #666; font-size: 12px;"><strong>🕒 Time:</strong> {{receipt_time}}</p>
        </div>
        <div class="signature-section" style="text-align: right; flex: 1; min-width: 200px;">
            <p style="margin: 0; border-bottom: 1px solid #333; width: 150px; margin-left: auto; padding-bottom: 2px;">&nbsp;</p>
            <p style="margin: 8px 0; color: #666; font-size: 12px; text-align: center;">Authorized Signature</p>
        </div>
    </div>
    
    <!-- Footer Message -->
    <div class="receipt-footer" style="text-align: center; margin-top: 30px; padding-top: 20px; border-top: 1px dashed #ccc;">
        <p style="margin: 0; color: #666; font-size: 12px; font-style: italic;">✅ Thank you for your payment. Keep this receipt for your records.</p>
        <p style="margin: 5px 0; color: #999; font-size: 10px;">This is a computer generated receipt and does not require signature.</p>
    </div>
</div>`;
        
        $('#html-code-editor').val(transportTemplate);
        $('#template_content').val(transportTemplate);
        
        // Show success message
        $(this).text('Loaded!').removeClass('btn-success').addClass('btn-info');
        setTimeout(function() {
            $('[onclick="loadTransportTemplate()"]').text('Load Transport Template').removeClass('btn-info').addClass('btn-success');
        }, 2000);
    };

    // Show Variables Function for Edit Page
    window.showVariables = function() {
        $('#variables-help').toggle();
        var btn = $('[onclick="showVariables()"]');
        if ($('#variables-help').is(':visible')) {
            btn.text('Hide Variables').removeClass('btn-info').addClass('btn-warning');
        } else {
            btn.text('Show Variables').removeClass('btn-warning').addClass('btn-info');
        }
    };
});
</script>
